/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeOutputGridEvent;
import kd.bos.print.core.plugin.event.BeforeOutputWidgetEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.print.core.plugin.event.bo.PWGridCellBo;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.report.FlexPrintFormatter;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryReportDatasetBuilder;

public class AccountBalanceRptPrintNew
extends AbstractPrintPlugin {
    private static final Log log = LogFactory.getLog(AccountBalanceRptPrintNew.class);
    private static final String ACCOUNTBALANCE_PRINT_PAGEID_CACHE = "accountBalancePrintPageIdCache";
    private List<String> assgrpColFields;
    private boolean showcomassist = false;
    private static final String BOS_ORG = "bos_org";
    private static final String[] rowDataStringFieldKeys = new String[]{"fseq", "number.number", "name", "currencylocalid.name", "curfor.name", "currencyrptid.name", "orgid.name", "measureunit.name"};
    private static final String[] rowDataFlexFieldKeys = new String[]{"assgrp"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"yearbdebitlocal", "begindebitlocal", "debitlocal", "yeardebitlocal", "enddebitlocal", "yearbcreditlocal", "begincreditlocal", "creditlocal", "yearcreditlocal", "endcreditlocal"};
    private static final String[] rowDataAmountForFieldKeys = new String[]{"yearbdebitfor", "begindebitfor", "debitfor", "yeardebitfor", "enddebitfor", "yearbcreditfor", "begincreditfor", "creditfor", "yearcreditfor", "endcreditfor"};
    private static final String[] rowDataAmountRptFieldKeys = new String[]{"yearbdebitrpt", "begindebitrpt", "debitrpt", "yeardebitrpt", "enddebitrpt", "yearbcreditrpt", "begincreditrpt", "creditrpt", "yearcreditrpt", "endcreditrpt"};
    private static final String[] rowDataQtyFieldKeys = new String[]{"yearbdebitqty", "begindebitqty", "debitqty", "yeardebitqty", "enddebitqty", "yearbcreditqty", "begincreditqty", "creditqty", "yearcreditqty", "endcreditqty"};
    private static final String[] headBaseDataFieldKeys = new String[]{"orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String CURRENCY_LOCAL = "currencylocalid";
    private static final String CURRENCY_FOR = "curfor";
    private static final String CURRENCY_RPT = "currencyrptid";
    private static final String MEASUREUNITFIELD = "measureunit";
    private static final String CURRENCYID = "currencyid";
    private static final String PARENT_ORG = "parentorg";
    private Date nameCtrlDate;
    private Long parentOrgId;
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
    private Format timeFormat = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(this.fobj);
    private FlexPrintFormatter flexPrintFormatter = null;
    private final Boolean enableBOSFormatter = Boolean.parseBoolean(System.getProperty("fi.gl.report.print.enablebosflexformatter", Boolean.TRUE.toString()));

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel listModel = this.getListModel(pageId);
        if (listModel == null) {
            return;
        }
        ReportQueryParam reportQueryParam = listModel.getReportQueryParam();
        FilterInfo filter = reportQueryParam.getFilter();
        if ("reporthead".equals(dataSource.getDsName())) {
            List queryField = dataSource.getQueryField();
            List printRowDataList = evt.getCustomDataRows();
            DynamicObjectType customDT = new DynamicObjectType();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(queryField, headBaseDataFieldKeys);
            ReportPrintHelper.registerStringProperty(customDT, headBaseDataFields);
            ReportPrintHelper.registerStringProperty(customDT, CURRENCY_HEAD, PARENT_ORG);
            DataRowSet printDyn = new DataRowSet();
            ReportPrintHelper.handleBaseDataFilterInfo(filter, printDyn, headBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filter, printDyn, CURRENCY_HEAD);
            ReportPrintHelper.handleMulCur(filter, printDyn, queryField);
            this.getParentOrgName(filter, printDyn, PARENT_ORG);
            printRowDataList.add(printDyn);
        } else if ("reportlist".equals(dataSource.getDsName())) {
            int rowCount = listModel.getRowCount();
            DynamicObjectCollection ds = listModel.getRowData(0, rowCount);
            if (ds == null || ds.isEmpty()) {
                return;
            }
            if (this.enableBOSFormatter.booleanValue()) {
                this.flexPrintFormatter = new FlexPrintFormatter(listModel, ds);
            }
            DynamicObjectType customDt = new DynamicObjectType("reportlist");
            List queryField = evt.getDataSource().getQueryField();
            String[] rowDataStringFields = ReportPrintHelper.getExistFileds(queryField, rowDataStringFieldKeys);
            String[] rowDataFlexFields = ReportPrintHelper.getExistFileds(queryField, rowDataFlexFieldKeys);
            String[] rowDataAmountForFields = ReportPrintHelper.getExistFileds(queryField, rowDataAmountForFieldKeys);
            String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(queryField, rowDataAmountLocalFieldKeys);
            String[] rowDataAmountRptFields = ReportPrintHelper.getExistFileds(queryField, rowDataAmountRptFieldKeys);
            String[] rowDataQtyFields = ReportPrintHelper.getExistFileds(queryField, rowDataQtyFieldKeys);
            ReportPrintHelper.registerStringProperty(customDt, new String[][]{rowDataAmountLocalFields, rowDataAmountForFields, rowDataAmountRptFields, rowDataStringFields, rowDataFlexFields, rowDataQtyFields});
            if (Objects.nonNull(this.assgrpColFields)) {
                queryField.addAll(this.assgrpColFields);
            }
            boolean isShowAssgrp = filter.getBoolean("showassist");
            boolean showrpt = filter.getBoolean("showrpt");
            boolean showqty = filter.getBoolean("showqty");
            HashSet<String> hgValueSet = new HashSet<String>(ds.size());
            List dataRows = evt.getCustomDataRows();
            HashMap<String, Tuple2<String, String>> flexProp = new HashMap<String, Tuple2<String, String>>(1);
            for (DynamicObject rowData : ds) {
                DataRowSet printRow = new DataRowSet();
                ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                if (rowData.getInt("fseq") == rowCount) {
                    printRow.add("name", (Field)new TextField(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AccBalanceRptPrint_0", (String)"fi-gl-formplugin", (Object[])new Object[0])));
                }
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_LOCAL, (boolean)Boolean.FALSE, rowDataAmountLocalFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_FOR, (boolean)Boolean.FALSE, rowDataAmountForFields);
                if (showrpt) {
                    ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_RPT, (boolean)Boolean.FALSE, rowDataAmountRptFields);
                }
                if (showqty) {
                    ReportPrintHelper.handleQtyFields(rowData, printRow, (boolean)Boolean.FALSE, MEASUREUNITFIELD, this.fobj, rowDataQtyFields);
                }
                if (isShowAssgrp) {
                    ReportPrintHelper.handleFlexFields(rowData, printRow, hgValueSet, rowDataFlexFields);
                }
                this.assgrpFieldHandler(printRow, rowData, flexProp);
                if (this.flexPrintFormatter != null) {
                    printRow.put("assgrp", (Field)new TextField(this.flexPrintFormatter.getFlexString(rowData)));
                }
                dataRows.add(printRow);
            }
            if (isShowAssgrp) {
                HashMap<Date, Set<String>> bookedDateHgMap = new HashMap<Date, Set<String>>(64);
                bookedDateHgMap.put(this.nameCtrlDate, hgValueSet);
                if (!this.enableBOSFormatter.booleanValue()) {
                    ReportPrintHelper.handleFlexIntoToStrNew(this.parentOrgId, dataRows, this.timeFormat, bookedDateHgMap, rowDataFlexFields);
                }
            }
        }
    }

    private void assgrpFieldHandler(DataRowSet printRow, DynamicObject row, Map<String, Tuple2<String, String>> flexProp) {
        if (this.assgrpColFields != null) {
            for (String field : this.assgrpColFields) {
                DynamicObject assgrp = row.getDynamicObject(field);
                if (assgrp == null) continue;
                Tuple2 tuple2 = flexProp.get(field);
                if (tuple2 == null) {
                    BasedataEntityType entityType = (BasedataEntityType)assgrp.getDataEntityType();
                    String name = entityType.getNameProperty();
                    String number = entityType.getNumberProperty();
                    tuple2 = new Tuple2((Object)name, (Object)number);
                    flexProp.put(field, (Tuple2<String, String>)tuple2);
                }
                printRow.add(field, (Field)new TextField(assgrp.getString((String)tuple2.t1)));
            }
        }
    }

    private ReportListModel getListModel(String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null || !(view instanceof ReportView)) {
            return null;
        }
        ReportView reportView = (ReportView)view;
        ReportList list = reportView.getReportList();
        ReportListModel listModel = (ReportListModel)list.getReportModel();
        return listModel;
    }

    private void getParentOrgName(FilterInfo filterInfo, DataRowSet printDyn, String parentOrg) {
        this.parentOrgId = Long.valueOf(filterInfo.getCommFilter("parentOrg").getValue().toString());
        Long endperiod = filterInfo.getLong("endperiod");
        Map periodMap = SubsidiaryReportDatasetBuilder.initPeriodMap((Long)endperiod, (Long)endperiod);
        this.nameCtrlDate = ((SubsidiaryPeriod)periodMap.get(endperiod)).getEnddate();
        String orgName = (String)ThreadCache.get((Object)("AccBalanceRptPrint-getParentOrg-" + this.parentOrgId), () -> {
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(this.parentOrgId.toString()));
            DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_ORG, (String)"name", (QFilter[])idFilter.toArray());
            if (orgDyn != null) {
                return orgDyn.getString("name");
            }
            return "";
        });
        printDyn.add(parentOrg, (Field)new TextField(orgName));
    }

    public void beforeLoadData(BeforeLoadDataEvent evt) {
        super.beforeLoadData(evt);
        PrtDataSource dataSource = evt.getDataSource();
        if (dataSource instanceof MainDataSource) {
            String pageId = ((MainDataSource)dataSource).getPageId();
            ReportListModel model = this.getListModel(pageId);
            if (model == null) {
                return;
            }
            ThreadCache.put((Object)ACCOUNTBALANCE_PRINT_PAGEID_CACHE, (Object)pageId);
            FilterInfo filterInfo = model.getReportQueryParam().getFilter();
            this.showcomassist = filterInfo.getBoolean("showcomassist");
        }
    }

    public void beforeOutputWidget(BeforeOutputWidgetEvent e) {
        super.beforeOutputWidget(e);
        if (e.getWidgetKey().equals("DataGrid")) {
            String pageId = (String)ThreadCache.get((Object)ACCOUNTBALANCE_PRINT_PAGEID_CACHE);
            if (this.showcomassist) {
                this.createAssgrpColumns((BeforeOutputGridEvent)e, pageId);
            }
        }
    }

    private void createAssgrpColumns(BeforeOutputGridEvent e, String pageId) {
        ReportListModel model = this.getListModel(pageId);
        if (model == null) {
            return;
        }
        int rowCount = model.getRowCount();
        DynamicObjectCollection rows = model.getRowData(0, rowCount);
        this.addAssgrpFieldPropertys(rows);
        List columns = model.getColumns();
        HashMap<String, String> colFieldAndNameMap = new HashMap<String, String>(1);
        ArrayList<String> assgrpFields = new ArrayList<String>(2);
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn;
            if (!(column instanceof ReportColumn) || !(reportColumn = (ReportColumn)column).getFieldKey().startsWith("comassist") || !"basedata".equals(reportColumn.getFieldType())) continue;
            assgrpFields.add(reportColumn.getFieldKey());
            colFieldAndNameMap.put(reportColumn.getFieldKey(), reportColumn.getCaption().getLocaleValue());
        }
        int curColIndex = 4;
        int totalWidth = e.getRightSpace();
        int width = totalWidth / assgrpFields.size();
        for (String assgrpField : assgrpFields) {
            String itemName = (String)colFieldAndNameMap.get(assgrpField);
            this.createDynamicColumn(e, curColIndex, assgrpField, itemName, width);
            ++curColIndex;
        }
    }

    private void addAssgrpFieldPropertys(DynamicObjectCollection ds) {
        this.assgrpColFields = new ArrayList<String>(2);
        DataEntityPropertyCollection propertyCollection = ds.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            String fieldKey = property.getName();
            if (!fieldKey.startsWith("comassist") || !(property instanceof BasedataProp)) continue;
            this.assgrpColFields.add(fieldKey);
        }
    }

    private void createDynamicColumn(BeforeOutputGridEvent e, int colIndex, String assgrpField, String colTitle, int width) {
        List pwGridCellBos = e.insertColumn(colIndex, width, true);
        int i = 0;
        for (PWGridCellBo po : pwGridCellBos) {
            if (i == 0) {
                po.setCellValue(colTitle);
            }
            if (i == 2) {
                po.setCellValue("reportlist", assgrpField);
            }
            ++i;
        }
        MergeBlock mb = MergeBlock.create((int)colIndex, (int)colIndex, (int)0, (int)1);
        e.addMerge(mb);
    }
}

