/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.ext.fi.gl.flexplugin.AbstractCustomFlexFilter;
import kd.bos.ext.fi.gl.flexplugin.FilterArgs;
import kd.bos.ext.fi.gl.flexplugin.FilterInfo;
import kd.bos.ext.fi.gl.flexplugin.SourceType;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SystemParamHelper;

public class AccountReportFilterPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private Log LOGGER = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit periodEdit = (BasedataEdit)this.getControl("value");
        periodEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        BasedataEdit edit = (BasedataEdit)event.getSource();
        IFormView view = edit.getView();
        String entityId = view.getEntityId();
        IDataModel model = view.getModel();
        if (model == null) {
            return;
        }
        String basedataId = "";
        if ("gl_multcol_scheme".equals(entityId)) {
            BasedataProp prop = (BasedataProp)event.getProperty();
            basedataId = prop.getBaseEntityId();
        } else {
            MulBasedataProp prop = (MulBasedataProp)event.getProperty();
            basedataId = prop.getBaseEntityId();
            long orgId = (Long)this.getModel().getValue("org_id");
            HashSet<Long> parents = new HashSet<Long>();
            parents.add(orgId);
            boolean adminOrg = this.isAdminOrg(orgId);
            boolean valueSource = false;
            if (basedataId.equalsIgnoreCase("bos_adminorg")) {
                valueSource = true;
            }
            boolean currOrgParam = SystemParamHelper.getBooleanParam((String)"currorg", (long)orgId, (boolean)false);
            if (adminOrg && valueSource && currOrgParam) {
                long iOrgViewId = Long.parseLong("01");
                Set childOrgId = AccSysUtil.getChildOrgId(null, (Long)iOrgViewId, parents, (boolean)true);
                ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
                List qFilters = listShowParameter.getListFilterParameter().getQFilters();
                qFilters.add(new QFilter("id", "in", (Object)childOrgId));
            }
        }
        this.setFilterWithCur(event, model, basedataId, entityId);
    }

    private boolean isAdminOrg(long orgId) {
        QFilter filterOrgId = new QFilter("org.id", "=", (Object)orgId);
        QFilter filterTreeType = new QFilter("view.treetype", "=", (Object)"01");
        QFilter filterDefault = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filterOrgId, filterTreeType, filterDefault};
        return QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])filters);
    }

    private void setFilterWithCur(BeforeF7SelectEvent e, IDataModel model, String basedataId, String entityId) {
        if (basedataId.equals("bd_accountbanks") || basedataId.equals("am_accountbank") || basedataId.equals("cas_accountcash")) {
            List<Long> curIds = this.getCurrencyId(model);
            ArrayList<Long> orgIds = null;
            if ("gl_rpt_assistbalance".equals(entityId) || "t_rpt_aux_subledger".equals(entityId)) {
                DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("orgs");
                orgIds = new ArrayList<Long>(orgs.size());
                for (DynamicObject dyn : orgs) {
                    Long orgId = ((DynamicObject)dyn.get(1)).getLong("id");
                    if (!AccSysUtil.isBizUnit((long)orgId)) {
                        Set set = BDUtil.getAllChildrenOrgIds((long)orgId, (boolean)true);
                        orgIds.addAll(set);
                        continue;
                    }
                    orgIds.add(orgId);
                }
            } else {
                DynamicObject dyn = (DynamicObject)model.getValue("org");
                orgIds = new ArrayList(1);
                Long orgId = dyn.getLong("id");
                if (!AccSysUtil.isBizUnit((long)orgId)) {
                    Set set = BDUtil.getAllChildrenOrgIds((long)orgId, (boolean)true);
                    orgIds.addAll(set);
                } else {
                    orgIds.add(orgId);
                }
            }
            Long bookTypeId = (Long)model.getValue("booktype_id");
            this.setBankFilter(e, curIds, basedataId, orgIds, bookTypeId);
        }
    }

    private List<Long> getCurrencyId(IDataModel model) {
        String currency = model.getValue("currency").toString();
        if ("basecurrency".equals(currency) || "allcurrency".equals(currency)) {
            return null;
        }
        Long curId = Long.parseLong(currency);
        ArrayList<Long> list = new ArrayList<Long>(1);
        list.add(curId);
        return list;
    }

    private void setBankFilter(BeforeF7SelectEvent e, List<Long> curIds, String basedataId, List<Long> orgIds, Long bookTypeId) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"gl_flexplugin", (String)"plugin", (QFilter[])new QFilter("entity", "=", (Object)basedataId).toArray());
        if (obj != null) {
            try {
                ListShowParameter list = (ListShowParameter)e.getFormShowParameter();
                List qFilters = list.getListFilterParameter().getQFilters();
                AbstractCustomFlexFilter plugin = (AbstractCustomFlexFilter)Class.forName(obj.getString("plugin")).newInstance();
                Set<Long> bankOrgIds = this.getBankOrg(orgIds, bookTypeId);
                FilterArgs args = new FilterArgs();
                args.setOrgId(orgIds.get(0));
                bankOrgIds.addAll(orgIds);
                HashSet<Long> finalBankOrgSet = new HashSet<Long>(16);
                finalBankOrgSet.addAll(bankOrgIds);
                for (Long org : bankOrgIds) {
                    List unitOrgs3 = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"08", (Long)org);
                    finalBankOrgSet.addAll(unitOrgs3);
                }
                args.setSourceType(SourceType.report);
                args.setBankOrgIds(finalBankOrgSet);
                if (curIds != null) {
                    args.setCurIds(curIds);
                }
                FilterInfo info = plugin.getCustomFilter(args);
                qFilters.clear();
                qFilters.add(info.getFilter());
            }
            catch (Exception ex) {
                this.LOGGER.error("getCustomFilter error." + GLUtil.printError((Throwable)ex));
            }
        }
    }

    private Set<Long> getBankOrg(List<Long> orgIds, long bookTypeId) {
        HashSet<Long> orgIdSet = new HashSet<Long>();
        for (Long orgId : orgIds) {
            AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
            if (book == null) continue;
            Long accountingSysId = book.getAccountingsysId();
            DynamicObject accountingsys = BusinessDataServiceHelper.loadSingleFromCache((Object)accountingSysId, (String)"bd_accountingsys", (String)"bizorgentry.bizacctorg,bizorgentry.bizorg");
            DynamicObjectCollection bizOrgEntry = accountingsys.getDynamicObjectCollection("bizorgentry");
            for (DynamicObject bizOrgRow : bizOrgEntry) {
                if (orgId == null || !orgId.equals(bizOrgRow.getLong("bizacctorg.id"))) continue;
                orgIdSet.add(bizOrgRow.getLong("bizorg.id"));
            }
        }
        return orgIdSet;
    }
}

