/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.report.ReportPrintHelper;

public class AccountSumPrintNew
extends AbstractPrintPlugin {
    private static final String[] rowDataStringFieldKeys = new String[]{"number.number", "number.name", "curfor.name", "curlocal", "currencyid.name", "currencyid"};
    private static final String[] rowDataAmountFieldKeys = new String[]{"debit", "credit"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"debitlocal", "creditlocal"};
    private static final String[] rowDataAmountOriFieldKeys = new String[]{"debitfor", "creditfor"};
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "booktype", "startperiod", "endperiod"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String ATTACHNUM = "attachnum";
    private static final String VOUCHERNUM = "vouchernum";
    private static final String SHOWBILLNO = "showbillno";
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));

    public void afterLoadData(AfterLoadDataEvent e) {
        super.afterLoadData(e);
        PrtDataSource dataSource = e.getDataSource();
        if (dataSource instanceof MainDataSource) {
            String pageId = ((MainDataSource)dataSource).getPageId();
            ReportListModel listModel = this.getListModel(pageId);
            if (listModel == null) {
                return;
            }
            DataRowSet dsRow = new DataRowSet();
            dsRow.put("id", (Field)new TextField("1"));
            ArrayList<DataRowSet> dataRowSets = new ArrayList<DataRowSet>(1);
            dataRowSets.add(dsRow);
            e.setDataRowSets(dataRowSets);
        }
    }

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel listModel = this.getListModel(pageId);
        if (listModel == null) {
            return;
        }
        ReportQueryParam param = listModel.getReportQueryParam();
        if ("head".equals(dataSource.getDsName())) {
            FilterInfo filterInfo = param.getFilter();
            List queryField = dataSource.getQueryField();
            List printRows = evt.getCustomDataRows();
            DataRowSet printRow = new DataRowSet();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(queryField, headBaseDataFieldKeys);
            ReportPrintHelper.handleBaseDataFilterInfo(filterInfo, printRow, headBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filterInfo, printRow, CURRENCY_HEAD);
            String id = RequestContext.get().getUserId();
            String vouchernum = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "VoucherSummaryQueryRpt_count", id));
            String attachnum = new DistributeCache(CacheModule.report).get(String.format("%s_%s", "VoucherSummaryQueryRpt_attachNum", id));
            String showbillno = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\uff1a%s", (String)"VoucherSummaryFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), new DistributeCache(CacheModule.report).get(String.format("%s_%s", "VoucherSummaryQueryRpt_showBillno", id)));
            printRow.put(VOUCHERNUM, (Field)new TextField(vouchernum));
            printRow.put(ATTACHNUM, (Field)new TextField(attachnum));
            printRow.put(SHOWBILLNO, (Field)new TextField(showbillno));
            printRows.add(printRow);
        } else if ("entry".equals(dataSource.getDsName())) {
            int count = listModel.getRowCount();
            DynamicObjectCollection ds = listModel.getRowData(0, count);
            if (ds == null || ds.isEmpty()) {
                return;
            }
            List field = dataSource.getQueryField();
            List customDataRows = evt.getCustomDataRows();
            String[] rowDataStringFields = ReportPrintHelper.getExistFileds(field, rowDataStringFieldKeys);
            String[] rowDataAmountFields = ReportPrintHelper.getExistFileds(field, rowDataAmountFieldKeys);
            String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(field, rowDataAmountLocalFieldKeys);
            String[] rowDataAmountOriFields = ReportPrintHelper.getExistFileds(field, rowDataAmountOriFieldKeys);
            int i = 1;
            for (DynamicObject rowData : ds) {
                DataRowSet printRow = new DataRowSet();
                ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, "currencyid", (boolean)Boolean.FALSE, rowDataAmountFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, "currencyid", (boolean)Boolean.FALSE, rowDataAmountOriFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, "curlocal", (boolean)Boolean.FALSE, rowDataAmountLocalFields);
                if (i == count) {
                    printRow.put("number.number", (Field)new TextField(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"DailyFormRptPrint_0", (String)"fi-gl-formplugin", (Object[])new Object[0])));
                }
                customDataRows.add(printRow);
                ++i;
            }
        }
    }

    private ReportListModel getListModel(String pageId) {
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        ReportList list = view.getReportList();
        ReportListModel listModel = (ReportListModel)list.getReportModel();
        return listModel;
    }
}

