/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.plugin.args.DynamicColumnArgs;
import kd.bos.entity.print.DynamicColumn;
import kd.bos.entity.print.GridHeader;
import kd.bos.entity.print.MergeBlock;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.report.ReportPrintHelper;

public class AssistBalanceRptPrint
extends AbstractPrintServicePlugin {
    private static final String CURRENCYLOCALID = "currencylocalid";
    private static final String CURRENCYID = "currencyid";
    private static final String MEASUREUNIT = "measureunit";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
    private List<String> assgrpColFields;
    private List<String> assgrpTxtColFields;
    private static final String[] headBaseDataFieldKeys = new String[]{"orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String[] headMulBaseDataFieldKeys = new String[]{"measureunits"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String PARENT_ORG = "parentorg";

    public void addDynamicColumns(DynamicColumnArgs e) {
        super.addDynamicColumns(e);
        ArrayList<DynamicColumn> dynamicColumns = new ArrayList<DynamicColumn>();
        ArrayList<MergeBlock> mBlocks = new ArrayList<MergeBlock>();
        switch (e.getKey()) {
            case "assgrpcolumns": {
                this.createAssgrpColumns(e, dynamicColumns, mBlocks);
                break;
            }
        }
        e.setDynamicColumns(dynamicColumns);
        e.setMergeBlocks(mBlocks);
    }

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        super.customPrintDataEntities(e);
        List dyns = e.getDataEntities();
        String pageId = e.getPageId();
        ReportListModel listModel = ReportPrintHelper.getListModel(pageId);
        if (listModel == null) {
            return;
        }
        ReportQueryParam param = listModel.getReportQueryParam();
        if (e.isMainDs()) {
            this.buildHeadInfo(e, dyns, param);
        } else if ("reporthead".equals(e.getDataSourceName())) {
            FilterInfo filterInfo = listModel.getReportQueryParam().getFilter();
            DynamicObjectType customDT = new DynamicObjectType();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(e, headBaseDataFieldKeys);
            String[] headMulBaseDataFields = ReportPrintHelper.getExistFileds(e, headMulBaseDataFieldKeys);
            ReportPrintHelper.registerStringProperty(customDT, new String[][]{headBaseDataFields, headMulBaseDataFields});
            ReportPrintHelper.registerStringProperty(customDT, CURRENCY_HEAD, PARENT_ORG);
            DynamicObject printDyn = new DynamicObject(customDT);
            ReportPrintHelper.handleBaseDataFilterInfo(filterInfo, printDyn, headBaseDataFields);
            ReportPrintHelper.handleMulBaseDataFilterInfo(filterInfo, printDyn, headMulBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filterInfo, printDyn, CURRENCY_HEAD);
            this.getParentOrgName(filterInfo, printDyn, PARENT_ORG);
            dyns.add(printDyn);
            e.setDataEntities(dyns);
        } else {
            this.buildEntityInfo(e, param, listModel);
        }
    }

    private void getParentOrgName(FilterInfo filterInfo, DynamicObject printDyn, String parentOrg) {
        Object parentOrgId = filterInfo.getCommFilter("parentOrg").getValue();
        String orgName = (String)ThreadCache.get((Object)("AccBalanceRptPrint-getParentOrg-" + parentOrgId), () -> {
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(parentOrgId.toString()));
            DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)NAME, (QFilter[])idFilter.toArray());
            if (orgDyn != null) {
                return orgDyn.getString(NAME);
            }
            return "";
        });
        printDyn.set(parentOrg, (Object)orgName);
    }

    private void createAssgrpColumns(DynamicColumnArgs e, List<DynamicColumn> dynamicColumns, List<MergeBlock> mBlocks) {
        ReportListModel listModel = ReportPrintHelper.getListModel(e.getPageId());
        if (listModel == null) {
            return;
        }
        List columns = listModel.getColumns();
        HashMap<String, String> colFieldAndNameMap = new HashMap<String, String>();
        HashMap<String, String> assistTextMap = new HashMap<String, String>();
        ArrayList<String> assgrpFields = new ArrayList<String>();
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn;
            if (!(column instanceof ReportColumn) || !(reportColumn = (ReportColumn)column).getFieldKey().startsWith("assval")) continue;
            if ("basedata".equals(reportColumn.getFieldType()) || "assistant".equals(reportColumn.getFieldType())) {
                assgrpFields.add(reportColumn.getFieldKey());
                colFieldAndNameMap.put(reportColumn.getFieldKey(), reportColumn.getCaption().getLocaleValue());
                continue;
            }
            if ("text".equals(reportColumn.getFieldType())) {
                assistTextMap.put(reportColumn.getFieldKey(), reportColumn.getCaption().getLocaleValue());
                continue;
            }
            String refProp = reportColumn.getRefBasedataProp();
            if (StringUtils.isEmpty((String)refProp)) continue;
            colFieldAndNameMap.put(refProp, reportColumn.getCaption().getLocaleValue());
        }
        int curColIndex = 1;
        for (String string : assgrpFields) {
            String itemName = (String)colFieldAndNameMap.get(string);
            String itemCode = ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u7801", (String)"AssistBalanceRptPrint_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            if (StringUtils.isEmpty((String)itemName)) {
                itemName = ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0", (String)"AssistBalanceRptPrint_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            } else {
                itemCode = String.format(ResManager.loadKDString((String)"%s\u7f16\u7801", (String)"AssistBalanceRptPrint_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), itemName);
            }
            this.createDynamicColumn(dynamicColumns, mBlocks, curColIndex, string + "_num", itemCode);
            this.createDynamicColumn(dynamicColumns, mBlocks, ++curColIndex, string, itemName);
            ++curColIndex;
        }
        for (Map.Entry entry : assistTextMap.entrySet()) {
            this.createDynamicColumn(dynamicColumns, mBlocks, curColIndex, (String)entry.getKey(), (String)entry.getValue());
            ++curColIndex;
        }
    }

    private void createDynamicColumn(List<DynamicColumn> dynamicColumns, List<MergeBlock> mBlocks, int colIndex, String assgrpField, String colTitle) {
        DynamicColumn col = new DynamicColumn(assgrpField);
        ArrayList<GridHeader> headers = new ArrayList<GridHeader>();
        headers.add(new GridHeader(0, colTitle));
        col.setBindField(assgrpField);
        col.setGridHeader(headers);
        dynamicColumns.add(col);
        MergeBlock mb = this.createMergeBlock(0, 1, colIndex, colIndex, colTitle);
        mBlocks.add(mb);
    }

    private MergeBlock createMergeBlock(int top, int bottom, int left, int right, String title) {
        MergeBlock mb = new MergeBlock(top, bottom, left, right, title);
        return mb;
    }

    private void buildEntityInfo(CustomPrintDataEntitiesArgs e, ReportQueryParam param, ReportListModel listModel) {
        DynamicObject curDyn;
        int count = listModel.getRowCount();
        DynamicObjectCollection ds = listModel.getRowData(0, count);
        if (ds == null || ds.isEmpty()) {
            return;
        }
        DynamicObjectType customDt = new DynamicObjectType("reportlist");
        List<String> commonColFields = this.getCommonFields(customDt);
        boolean showqty = param.getFilter().getBoolean("showqty");
        List<String> amountTypes = this.getAmountTypes(ds.getDynamicObjectType().getProperties());
        List<String> amountColFields = this.getAmountFields(amountTypes, customDt, showqty);
        Map<String, String> typeAndCurrencyField = this.getCurrencyField();
        this.addAssgrpFieldPropertys(ds, customDt);
        String curStr = param.getFilter().getString(CURRENCY_HEAD);
        String curFor = "";
        if (!"allcurrency".equals(curStr) && !"basecurrency".equals(curStr) && (curDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(curStr), (String)"bd_currency")) != null) {
            curFor = curDyn.getString(NAME);
        }
        List dyns = e.getDataEntities();
        HashMap<String, Tuple2<String, String>> flexProp = new HashMap<String, Tuple2<String, String>>();
        for (DynamicObject row : ds) {
            DynamicObject printRow = new DynamicObject(customDt);
            this.commonFieldHandler(printRow, row, commonColFields);
            this.currencyHandler(printRow, row, param, curFor);
            this.amountFieldHandler(printRow, row, amountColFields, amountTypes, typeAndCurrencyField, param);
            this.assgrpFieldHandler(printRow, row, flexProp);
            if (showqty) {
                this.qtyFieldHandler(printRow, row, amountColFields);
            }
            dyns.add(printRow);
        }
    }

    public void currencyHandler(DynamicObject printRow, DynamicObject row, ReportQueryParam param, String currencyFor) {
        String curStr = param.getFilter().getString(CURRENCY_HEAD);
        String curName = "";
        if ("allcurrency".equals(curStr)) {
            DynamicObject curDyn = row.getDynamicObject(CURRENCYID);
            if (curDyn != null) {
                curName = curDyn.getString(NAME);
            }
        } else if ("basecurrency".equals(curStr)) {
            DynamicObject curDyn = row.getDynamicObject(CURRENCYLOCALID);
            if (curDyn != null) {
                curName = curDyn.getString(NAME);
            }
        } else {
            curName = currencyFor;
        }
        printRow.set(CURRENCYID, (Object)curName);
    }

    private void commonFieldHandler(DynamicObject printRow, DynamicObject row, List<String> commonColFields) {
        for (String field : commonColFields) {
            printRow.set(field, row.get(field));
        }
    }

    private void amountFieldHandler(DynamicObject printRow, DynamicObject row, List<String> amountColFields, List<String> amountTypes, Map<String, String> typeAndCurrencyField, ReportQueryParam param) {
        for (String amountType : amountTypes) {
            String curField = typeAndCurrencyField.get(amountType);
            DynamicObject curDyn = row.getDynamicObject(curField);
            if (curDyn == null) continue;
            int amtprecision = curDyn.getInt("amtprecision");
            String signStr = curDyn.getString("sign") == null ? "" : curDyn.getString("sign");
            this.fobj.getCurrencyFormat().setCurrencySymbols(signStr);
            this.fobj.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
            Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(this.fobj);
            for (String field : amountColFields) {
                BigDecimal amount = row.getBigDecimal(field + amountType);
                if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.set(field + amountType, (Object)format.format(amount));
            }
        }
    }

    private void assgrpFieldHandler(DynamicObject printRow, DynamicObject row, Map<String, Tuple2<String, String>> flexProp) {
        if (this.assgrpColFields != null) {
            for (String field : this.assgrpColFields) {
                DynamicObject assgrp = row.getDynamicObject(field);
                if (assgrp == null) continue;
                Tuple2 tuple2 = flexProp.get(field);
                if (tuple2 == null) {
                    BasedataEntityType entityType = (BasedataEntityType)assgrp.getDataEntityType();
                    String name = entityType.getNameProperty();
                    String number = entityType.getNumberProperty();
                    tuple2 = new Tuple2((Object)name, (Object)number);
                    flexProp.put(field, (Tuple2<String, String>)tuple2);
                }
                printRow.set(field, (Object)assgrp.getString((String)tuple2.t1));
                printRow.set(field + "_num", (Object)assgrp.getString((String)tuple2.t2));
            }
        }
        if (this.assgrpTxtColFields != null) {
            for (String field : this.assgrpTxtColFields) {
                printRow.set(field, row.get(field));
            }
        }
    }

    private void qtyFieldHandler(DynamicObject printRow, DynamicObject row, List<String> amountColFields) {
        DynamicObject measureunit = row.getDynamicObject(MEASUREUNIT);
        int precision = 0;
        if (measureunit != null) {
            printRow.set(MEASUREUNIT, measureunit.get(NAME));
            precision = measureunit.getInt("precision");
        }
        for (String field : amountColFields) {
            BigDecimal qtyBigDecimal = row.getBigDecimal(field + "qty");
            if ((qtyBigDecimal = qtyBigDecimal.setScale(precision)).compareTo(BigDecimal.ZERO) == 0) continue;
            printRow.set(field + "qty", (Object)(qtyBigDecimal + ""));
        }
    }

    private List<String> getCommonFields(DynamicObjectType customDt) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("fseq");
        fields.add(NUMBER);
        fields.add(NAME);
        for (String field : fields) {
            customDt.registerProperty(field, String.class, (Object)"", false);
        }
        return fields;
    }

    private Map<String, String> getCurrencyField() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("for", "curfor");
        map.put("rpt", "currencyrptid");
        map.put("local", CURRENCYLOCALID);
        return map;
    }

    private List<String> getAmountFields(List<String> amountTypes, DynamicObjectType customDt, boolean showqty) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("begindebit");
        fields.add("begincredit");
        fields.add("debit");
        fields.add("credit");
        fields.add("yeardebit");
        fields.add("yearcredit");
        fields.add("enddebit");
        fields.add("endcredit");
        customDt.registerProperty(CURRENCYID, String.class, (Object)"", false);
        for (String field : fields) {
            for (String amountType : amountTypes) {
                customDt.registerProperty(field + amountType, String.class, (Object)"", false);
            }
            if (!showqty) continue;
            customDt.registerProperty(field + "qty", String.class, (Object)"", false);
        }
        if (showqty) {
            customDt.registerProperty(MEASUREUNIT, String.class, (Object)"", false);
        }
        return fields;
    }

    private List<String> getAmountTypes(DataEntityPropertyCollection propertys) {
        ArrayList<String> fields = new ArrayList<String>();
        if (propertys.containsKey((Object)"begindebitlocal")) {
            fields.add("local");
        }
        if (propertys.containsKey((Object)"begindebitfor")) {
            fields.add("for");
        }
        if (propertys.containsKey((Object)"begindebitrpt")) {
            fields.add("rpt");
        }
        return fields;
    }

    private void addAssgrpFieldPropertys(DynamicObjectCollection ds, DynamicObjectType customDt) {
        this.assgrpColFields = new ArrayList<String>();
        this.assgrpTxtColFields = new ArrayList<String>();
        DataEntityPropertyCollection propertyCollection = ds.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            String fieldKey = property.getName();
            if (!fieldKey.startsWith("assval")) continue;
            if (property instanceof BasedataProp) {
                customDt.registerProperty(fieldKey, String.class, (Object)"", false);
                customDt.registerProperty(fieldKey + "_num", String.class, (Object)"", false);
                this.assgrpColFields.add(fieldKey);
            }
            if (!(property instanceof TextProp)) continue;
            customDt.registerProperty(fieldKey, String.class, (Object)"", false);
            this.assgrpTxtColFields.add(fieldKey);
        }
    }

    private void buildHeadInfo(CustomPrintDataEntitiesArgs e, List<DynamicObject> dyns, ReportQueryParam param) {
        DynamicObjectType customDt = null;
        customDt = new DynamicObjectType("head");
        customDt.registerProperty("id", String.class, (Object)"", false);
        DynamicObject customD = new DynamicObject(customDt);
        customD.set("id", (Object)1);
        dyns.add(customD);
        e.setDataEntities(dyns);
    }
}

