/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.BeforeLoadDataEvent;
import kd.bos.print.core.plugin.event.BeforeOutputGridEvent;
import kd.bos.print.core.plugin.event.BeforeOutputWidgetEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.print.core.plugin.event.bo.PWGridCellBo;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.util.FlexUtils;

public class AssistBalanceRptPrintNew
extends AbstractPrintPlugin {
    private static final String CURRENCYLOCALID = "currencylocalid";
    private static final String CURRENCYID = "currencyid";
    private static final String MEASUREUNIT = "measureunit";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String ASSISTBALANCE_PRINT_PAGEID_CACHE = "assistBalancePrintPageIdCache";
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
    private List<String> assgrpColFields;
    private List<String> assgrpTxtColFields;
    private static final String[] headBaseDataFieldKeys = new String[]{"orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String[] headMulBaseDataFieldKeys = new String[]{"measureunits"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String PARENT_ORG = "parentorg";
    private boolean showcomassist = false;
    private List<String> comAssistColFields;
    private Map<String, String> assgrpFieldName = new HashMap<String, String>(8);

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel listModel = this.getListModel(pageId);
        if (listModel == null) {
            return;
        }
        ReportQueryParam param = listModel.getReportQueryParam();
        if ("reporthead".equals(dataSource.getDsName())) {
            FilterInfo filterInfo = param.getFilter();
            List queryField = dataSource.getQueryField();
            List printRows = evt.getCustomDataRows();
            DataRowSet printRow = new DataRowSet();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(queryField, headBaseDataFieldKeys);
            String[] headMulBaseDataFields = ReportPrintHelper.getExistFileds(queryField, headMulBaseDataFieldKeys);
            ReportPrintHelper.handleBaseDataFilterInfo(filterInfo, printRow, headBaseDataFields);
            ReportPrintHelper.handleMulBaseDataFilterInfo(filterInfo, printRow, headMulBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filterInfo, printRow, CURRENCY_HEAD);
            ReportPrintHelper.handleMulCur(filterInfo, printRow, queryField);
            this.getParentOrgName(filterInfo, printRow, PARENT_ORG);
            printRows.add(printRow);
        } else if ("reportlistap".equals(dataSource.getDsName())) {
            DynamicObject curDyn;
            int count = listModel.getRowCount();
            DynamicObjectCollection ds = listModel.getRowData(0, count);
            if (ds == null || ds.isEmpty()) {
                return;
            }
            DynamicObjectType customDt = new DynamicObjectType("reportlist");
            List<String> commonColFields = this.getCommonFields(customDt);
            boolean showqty = param.getFilter().getBoolean("showqty");
            List<String> amountTypes = this.getAmountTypes(ds.getDynamicObjectType().getProperties());
            List<String> amountColFields = this.getAmountFields(amountTypes, customDt, showqty);
            Map<String, String> typeAndCurrencyField = this.getCurrencyField();
            List queryField = dataSource.getQueryField();
            this.addAssgrpField(queryField);
            if (Objects.nonNull(this.comAssistColFields)) {
                queryField.addAll(this.comAssistColFields);
            }
            String curStr = param.getFilter().getString(CURRENCY_HEAD);
            String curFor = "";
            if (!"allcurrency".equals(curStr) && !"basecurrency".equals(curStr) && (curDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(curStr), (String)"bd_currency")) != null) {
                curFor = curDyn.getString(NAME);
            }
            List customDataRows = evt.getCustomDataRows();
            HashMap<String, Tuple2<String, String>> flexProp = new HashMap<String, Tuple2<String, String>>(1);
            HashMap<String, Tuple2<String, String>> comAssistProp = new HashMap<String, Tuple2<String, String>>(2);
            for (DynamicObject row : ds) {
                DataRowSet printRow = new DataRowSet();
                this.commonFieldHandler(printRow, row, commonColFields);
                this.currencyHandler(printRow, row, param, curFor);
                this.amountFieldHandler(printRow, row, amountColFields, amountTypes, typeAndCurrencyField, param);
                this.assgrpFieldHandler(printRow, row, flexProp);
                this.comAssistFieldHandler(printRow, row, comAssistProp);
                if (showqty) {
                    this.qtyFieldHandler(printRow, row, amountColFields);
                }
                customDataRows.add(printRow);
            }
        }
    }

    private void comAssistFieldHandler(DataRowSet printRow, DynamicObject row, Map<String, Tuple2<String, String>> flexProp) {
        if (this.comAssistColFields != null) {
            for (String field : this.comAssistColFields) {
                DynamicObject assgrp = row.getDynamicObject(field);
                if (assgrp == null) continue;
                Tuple2 tuple2 = flexProp.get(field);
                if (tuple2 == null) {
                    BasedataEntityType entityType = (BasedataEntityType)assgrp.getDataEntityType();
                    String name = entityType.getNameProperty();
                    String number = entityType.getNumberProperty();
                    tuple2 = new Tuple2((Object)name, (Object)number);
                    flexProp.put(field, (Tuple2<String, String>)tuple2);
                }
                printRow.add(field, (Field)new TextField(assgrp.getString((String)tuple2.t1)));
            }
        }
    }

    private void addAssgrpField(List<String> queryField) {
        queryField.addAll(this.assgrpColFields);
        queryField.addAll(this.assgrpTxtColFields);
    }

    public void beforeLoadData(BeforeLoadDataEvent evt) {
        super.beforeLoadData(evt);
        PrtDataSource dataSource = evt.getDataSource();
        if (dataSource instanceof MainDataSource) {
            String pageId = ((MainDataSource)dataSource).getPageId();
            ReportListModel listModel = this.getListModel(pageId);
            if (listModel == null) {
                return;
            }
            ThreadCache.put((Object)ASSISTBALANCE_PRINT_PAGEID_CACHE, (Object)pageId);
            FilterInfo filterInfo = listModel.getReportQueryParam().getFilter();
            this.showcomassist = filterInfo.getBoolean("showcomassist");
            ReportQueryParam param = listModel.getReportQueryParam();
            List filterItemInfos = param.getFilter().getFlexFilterItems();
            List<String> flexFields = filterItemInfos.stream().map(FilterItemInfo::getPropName).collect(Collectors.toList());
            Map flexInfoMap = FlexUtils.batchGetFlexProperty((String[])flexFields.toArray(new String[0]));
            for (int i = 0; i < filterItemInfos.size(); ++i) {
                String assValKey = i == 0 ? "assval" : "assval" + i;
                String flexName = ((FilterItemInfo)filterItemInfos.get(i)).getPropName();
                this.assgrpFieldName.put(assValKey, ((FlexProperty)flexInfoMap.get(flexName)).getName().getLocaleValue());
            }
        }
    }

    public void beforeOutputWidget(BeforeOutputWidgetEvent e) {
        super.beforeOutputWidget(e);
        if (e.getWidgetKey().equals("DataGrid")) {
            String pageId = (String)ThreadCache.get((Object)ASSISTBALANCE_PRINT_PAGEID_CACHE);
            if (Objects.isNull(pageId)) {
                return;
            }
            List<Object> comAssistFields = new ArrayList(8);
            if (this.showcomassist) {
                comAssistFields = this.createComAssistColumns(pageId);
            }
            ArrayList<String> assgrpList = new ArrayList<String>(8);
            int colWidth = this.createAssgrpColumns((BeforeOutputGridEvent)e, pageId, comAssistFields.size(), assgrpList);
            if (this.showcomassist) {
                this.createComAssistColumnsAndWidth((BeforeOutputGridEvent)e, colWidth, comAssistFields, assgrpList.size());
            }
        }
    }

    private void getParentOrgName(FilterInfo filterInfo, DataRowSet printRow, String parentOrg) {
        Object parentOrgId = filterInfo.getCommFilter("parentOrg").getValue();
        String orgName = (String)ThreadCache.get((Object)("AccBalanceRptPrint-getParentOrg-" + parentOrgId), () -> {
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(parentOrgId.toString()));
            DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)NAME, (QFilter[])idFilter.toArray());
            if (orgDyn != null) {
                return orgDyn.getString(NAME);
            }
            return "";
        });
        printRow.add(parentOrg, (Field)new TextField(orgName));
    }

    private List<Tuple2<String, String>> createComAssistColumns(String pageId) {
        ReportListModel model = this.getListModel(pageId);
        ArrayList<Tuple2<String, String>> comAssistFields = new ArrayList<Tuple2<String, String>>(8);
        if (model == null) {
            return comAssistFields;
        }
        int rowCount = model.getRowCount();
        DynamicObjectCollection rows = model.getRowData(0, rowCount);
        this.addComAssistFieldPropertys(rows);
        List columns = model.getColumns();
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn;
            if (!(column instanceof ReportColumn) || !(reportColumn = (ReportColumn)column).getFieldKey().startsWith("comassist") || !"basedata".equals(reportColumn.getFieldType())) continue;
            comAssistFields.add((Tuple2<String, String>)new Tuple2((Object)reportColumn.getFieldKey(), (Object)reportColumn.getCaption().getLocaleValue()));
        }
        return comAssistFields;
    }

    private void createComAssistColumnsAndWidth(BeforeOutputGridEvent e, int width, List<Tuple2<String, String>> comAssistFields, int assgrpSize) {
        int curColIndex = assgrpSize * 2 + 5;
        for (Tuple2<String, String> comAssistField : comAssistFields) {
            this.createDynamicColumn(e, curColIndex, (String)comAssistField.t1, (String)comAssistField.t2, width);
            ++curColIndex;
        }
    }

    private int createAssgrpColumns(BeforeOutputGridEvent e, String pageId, int comAssistSize, List<String> assgrpFields) {
        ReportListModel model = this.getListModel(pageId);
        int rowCount = model.getRowCount();
        DynamicObjectCollection rows = model.getRowData(0, rowCount);
        this.addAssgrpFieldPropertys(rows);
        List columns = model.getColumns();
        HashMap<String, String> assistTextMap = new HashMap<String, String>(1);
        for (AbstractReportColumn column : columns) {
            ReportColumn reportColumn;
            if (!(column instanceof ReportColumn) || !(reportColumn = (ReportColumn)column).getFieldKey().startsWith("assval")) continue;
            if ("basedata".equals(reportColumn.getFieldType())) {
                assgrpFields.add(reportColumn.getFieldKey());
                continue;
            }
            if ("assistant".equals(reportColumn.getFieldType())) {
                assgrpFields.add(reportColumn.getFieldKey());
                continue;
            }
            if (!"text".equals(reportColumn.getFieldType())) continue;
            assistTextMap.put(reportColumn.getFieldKey(), reportColumn.getCaption().getLocaleValue());
        }
        int curColIndex = 1;
        int totalWidth = e.getRightSpace();
        int width = totalWidth / (assgrpFields.size() * 2 + assistTextMap.size() + comAssistSize);
        for (String string : assgrpFields) {
            String itemName = this.assgrpFieldName.get(string);
            String itemCode = ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u7801", (String)"AssistBalanceRptPrint_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            if (StringUtils.isEmpty((String)itemName)) {
                itemName = ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0", (String)"AssistBalanceRptPrint_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            } else {
                itemCode = String.format(ResManager.loadKDString((String)"%s\u7f16\u7801", (String)"AssistBalanceRptPrintNew_0", (String)"fi-gl-formplugin", (Object[])new Object[0]), itemName);
            }
            this.createDynamicColumn(e, curColIndex, string + "_num", itemCode, width);
            this.createDynamicColumn(e, ++curColIndex, string, itemName, width);
            ++curColIndex;
        }
        for (Map.Entry entry : assistTextMap.entrySet()) {
            this.createDynamicColumn(e, curColIndex, (String)entry.getKey(), (String)entry.getValue(), width);
            ++curColIndex;
        }
        return width;
    }

    private void addComAssistFieldPropertys(DynamicObjectCollection ds) {
        this.comAssistColFields = new ArrayList<String>(2);
        DataEntityPropertyCollection propertyCollection = ds.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            String fieldKey = property.getName();
            if (!fieldKey.startsWith("comassist") || !(property instanceof BasedataProp)) continue;
            this.comAssistColFields.add(fieldKey);
        }
    }

    private void createDynamicColumn(BeforeOutputGridEvent e, int colIndex, String assgrpField, String colTitle, int width) {
        List pwGridCellBos = e.insertColumn(colIndex, width);
        int i = 0;
        for (PWGridCellBo po : pwGridCellBos) {
            if (i == 0) {
                po.setCellValue(colTitle);
            }
            if (i == 2) {
                po.setCellValue("reportlistap", assgrpField);
            }
            ++i;
        }
        MergeBlock mb = this.createMergeBlock(colIndex, colIndex, 0, 1);
        e.addMerge(mb);
    }

    private MergeBlock createMergeBlock(int top, int bottom, int left, int right) {
        MergeBlock mb = MergeBlock.create((int)top, (int)bottom, (int)left, (int)right);
        return mb;
    }

    public void currencyHandler(DataRowSet printRow, DynamicObject row, ReportQueryParam param, String currencyFor) {
        String curStr = param.getFilter().getString(CURRENCY_HEAD);
        String curName = "";
        if ("allcurrency".equals(curStr)) {
            DynamicObject curDyn = row.getDynamicObject(CURRENCYID);
            if (curDyn != null) {
                curName = curDyn.getString(NAME);
            }
        } else if ("basecurrency".equals(curStr)) {
            DynamicObject curDyn = row.getDynamicObject(CURRENCYLOCALID);
            if (curDyn != null) {
                curName = curDyn.getString(NAME);
            }
        } else {
            curName = currencyFor;
        }
        printRow.add(CURRENCYID, (Field)new TextField(curName));
    }

    private void commonFieldHandler(DataRowSet printRow, DynamicObject row, List<String> commonColFields) {
        for (String field : commonColFields) {
            printRow.add(field, (Field)new TextField(row.getString(field)));
        }
    }

    private void amountFieldHandler(DataRowSet printRow, DynamicObject row, List<String> amountColFields, List<String> amountTypes, Map<String, String> typeAndCurrencyField, ReportQueryParam param) {
        for (String amountType : amountTypes) {
            String curField = typeAndCurrencyField.get(amountType);
            DynamicObject curDyn = row.getDynamicObject(curField);
            if (curDyn == null) continue;
            int amtprecision = curDyn.getInt("amtprecision");
            String signStr = curDyn.getString("sign") == null ? "" : curDyn.getString("sign");
            this.fobj.getCurrencyFormat().setCurrencySymbols(signStr);
            this.fobj.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
            Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(this.fobj);
            for (String field : amountColFields) {
                BigDecimal amount = row.getBigDecimal(field + amountType);
                if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.add(field + amountType, (Field)new TextField(format.format(amount)));
            }
        }
    }

    private void assgrpFieldHandler(DataRowSet printRow, DynamicObject row, Map<String, Tuple2<String, String>> flexProp) {
        if (this.assgrpColFields != null) {
            for (String field : this.assgrpColFields) {
                DynamicObject assgrp;
                boolean isNumber = false;
                if (field.endsWith("_num")) {
                    field = field.substring(0, field.length() - 4);
                    isNumber = true;
                }
                if ((assgrp = row.getDynamicObject(field)) == null) continue;
                Tuple2 tuple2 = flexProp.get(field);
                if (tuple2 == null) {
                    BasedataEntityType entityType = (BasedataEntityType)assgrp.getDataEntityType();
                    String name = entityType.getNameProperty();
                    String number = entityType.getNumberProperty();
                    tuple2 = new Tuple2((Object)name, (Object)number);
                    flexProp.put(field, (Tuple2<String, String>)tuple2);
                }
                if (isNumber) {
                    printRow.add(field + "_num", (Field)new TextField(assgrp.getString((String)tuple2.t2)));
                    continue;
                }
                printRow.add(field, (Field)new TextField(assgrp.getString((String)tuple2.t1)));
            }
        }
        if (this.assgrpTxtColFields != null) {
            for (String field : this.assgrpTxtColFields) {
                printRow.add(field, (Field)new TextField(row.getString(field)));
            }
        }
    }

    private void qtyFieldHandler(DataRowSet printRow, DynamicObject row, List<String> amountColFields) {
        DynamicObject measureunit = row.getDynamicObject(MEASUREUNIT);
        int precision = 0;
        if (measureunit != null) {
            printRow.add(MEASUREUNIT, (Field)new TextField(measureunit.getString(NAME)));
            precision = measureunit.getInt("precision");
        }
        for (String field : amountColFields) {
            BigDecimal qtyBigDecimal = row.getBigDecimal(field + "qty");
            if ((qtyBigDecimal = qtyBigDecimal.setScale(precision)).compareTo(BigDecimal.ZERO) == 0) continue;
            printRow.add(field + "qty", (Field)new TextField(qtyBigDecimal + ""));
        }
    }

    private List<String> getCommonFields(DynamicObjectType customDt) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("fseq");
        fields.add(NUMBER);
        fields.add(NAME);
        for (String field : fields) {
            customDt.registerProperty(field, String.class, (Object)"", false);
        }
        return fields;
    }

    private Map<String, String> getCurrencyField() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("for", "curfor");
        map.put("rpt", "currencyrptid");
        map.put("local", CURRENCYLOCALID);
        return map;
    }

    private List<String> getAmountFields(List<String> amountTypes, DynamicObjectType customDt, boolean showqty) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("begindebit");
        fields.add("begincredit");
        fields.add("debit");
        fields.add("credit");
        fields.add("yeardebit");
        fields.add("yearcredit");
        fields.add("enddebit");
        fields.add("endcredit");
        customDt.registerProperty(CURRENCYID, String.class, (Object)"", false);
        for (String field : fields) {
            for (String amountType : amountTypes) {
                customDt.registerProperty(field + amountType, String.class, (Object)"", false);
            }
            if (!showqty) continue;
            customDt.registerProperty(field + "qty", String.class, (Object)"", false);
        }
        if (showqty) {
            customDt.registerProperty(MEASUREUNIT, String.class, (Object)"", false);
        }
        return fields;
    }

    private List<String> getAmountTypes(DataEntityPropertyCollection propertys) {
        ArrayList<String> fields = new ArrayList<String>();
        if (propertys.containsKey((Object)"begindebitlocal")) {
            fields.add("local");
        }
        if (propertys.containsKey((Object)"begindebitfor")) {
            fields.add("for");
        }
        if (propertys.containsKey((Object)"begindebitrpt")) {
            fields.add("rpt");
        }
        return fields;
    }

    private void addAssgrpFieldPropertys(DynamicObjectCollection ds) {
        this.assgrpColFields = new ArrayList<String>(2);
        this.assgrpTxtColFields = new ArrayList<String>(1);
        DataEntityPropertyCollection propertyCollection = ds.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : propertyCollection) {
            String fieldKey = property.getName();
            if (!fieldKey.startsWith("assval")) continue;
            if (property instanceof BasedataProp) {
                this.assgrpColFields.add(fieldKey + "_num");
                this.assgrpColFields.add(fieldKey);
            }
            if (!(property instanceof TextProp)) continue;
            this.assgrpTxtColFields.add(fieldKey);
        }
    }

    private ReportListModel getListModel(String pageId) {
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        ReportList list = view.getReportList();
        ReportListModel listModel = (ReportListModel)list.getReportModel();
        return listModel;
    }
}

