/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.TreeModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.model.schema.JobExecuteFormSchema;
import kd.fi.gl.model.schema.report.SubLedgerSchema;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.ShowByAccountDCParam;
import kd.fi.gl.report.SubLedgerFormRpt;
import kd.fi.gl.report.exportall.multiorg.JobExecuteEdit;
import kd.fi.gl.report.exportall.multiorg.task.MultipleOrgReportExportTask;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.ReportFieldSettingUtil;
import kd.fi.gl.util.VoucherUtil;
import kd.fi.gl.vo.ReportFieldSettingVo;

public class BaseAuxSubLedgerFormRpt
extends AbstractReportFormPlugin
implements ProgresssListener {
    private static final Log LOGGER = LogFactory.getLog(SubLedgerFormRpt.class);
    private static final String ACCOUNT = "accountcolumn";
    private static final String ACCOUNT_NAME = "accountname";
    private static final String BK_DATE = "datefield";
    private static final String BIZ_DATE = "bizdate";
    protected static final String VCH_NUM = "voucherno";
    private static final String DESC = "desc";
    private static final String UNIT = "measureunit";
    private static final String CURRNECY = "currencycolumn";
    private static final String ASSGRP = "assgrp";
    private static final String DEBIT_QTY = "debitqty";
    private static final String CREDIT_QTY = "creditqty";
    private static final String END_QTY = "endqty";
    private static final String DEBIT_PRICE = "debitprice";
    private static final String CREDIT_PRICE = "creditprice";
    private static final String END_PRICE = "endprice";
    private static final String END_RPT = "endrpt";
    private static final String DEBIT_FOR = "debitfor";
    private static final String CREDIT_FOR = "creditfor";
    private static final String END_FOR = "endfor";
    private static final String DEBIT_LOCAL = "debitlocal";
    private static final String CREDIT_LOCAL = "creditlocal";
    private static final String END_LOCAL = "endlocal";
    private static final String DC = "dc";
    private static final String ZERO = "0";
    private static final String EXPORT_EXCEL = "exportexcel";
    protected static final String REPORT_LIST_AP = "reportlistap";
    private static final String SORTCOMBO = "sortcombo";
    private static final String FIELDCOMBO = "fieldcombo";
    private static final String CUSTOMSORTENTRY = "customsortentry";
    private static final String SEARCHTYPE = "searchtype";
    private static final String PERIOD_MAP_KEY = "SubLedgerFormRpt_perioddatemap";

    private static LocaleString getTxtAmount() {
        return new LocaleString(ResManager.loadKDString((String)"\u91d1\u989d", (String)"SubLedgerFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getControl("voucherfiltergridap");
        filterGrid.setEntityNumber("gl_voucher");
        this.setVoucherFilterFields(filterGrid);
    }

    private void setVoucherFilterFields(FilterGrid filterGrid) {
        List filterFileds = ReportFieldSettingUtil.getFilterFieldConfigs((String)"t_rpt_aux_subledger");
        filterGrid.setFilterFieldKeys(filterFileds);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("printFormClose".equals(closedCallBackEvent.getActionId())) {
            ReportQueryParam queryParam = this.getView().getQueryParam();
            queryParam.getFilter().getFilterItems().removeIf(filterItemInfo -> EXPORT_EXCEL.equals(filterItemInfo.getPropName()));
            Optional.ofNullable(queryParam.getFilter().getFilterItems(EXPORT_EXCEL)).ifPresent(List::clear);
            queryParam.getFilter().addFilterItem(EXPORT_EXCEL, (Object)false);
            ReportCacheManager.getInstance().getCache().setReportQueryParam(this.getView().getPageId(), queryParam);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "exportcuracc"});
        ReportList list = (ReportList)this.getControl(REPORT_LIST_AP);
        list.addHyperClickListener(evt -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(REPORT_LIST_AP);
            IReportListModel reportModel = list.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            switch (evt.getFieldName()) {
                case "voucherno": {
                    long voucherId = rowData.getLong("voucherid");
                    if (voucherId == 0L) break;
                    this.viewVoucher(voucherId, reportModel);
                    break;
                }
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        DynamicObject periodType = (DynamicObject)model.getValue("periodtype");
        if (periodType != null) {
            long typeid = periodType.getLong("id");
            switch (e.getProperty().getName()) {
                case "dateend": {
                    Date newDate = (Date)e.getChangeSet()[0].getNewValue();
                    long pid = this.getPeriodIdByDate(newDate, typeid);
                    model.setValue("endperiod", (Object)pid);
                    view.updateView("endperiod");
                    break;
                }
                case "datebegin": {
                    Date newDate = (Date)e.getChangeSet()[0].getNewValue();
                    long pid = this.getPeriodIdByDate(newDate, typeid);
                    model.setValue("startperiod", (Object)pid);
                    view.updateView("startperiod");
                    break;
                }
                case "fieldcombo": {
                    if (DC.equals(e.getChangeSet()[0].getNewValue())) {
                        view.setEnable(Boolean.valueOf(false), e.getChangeSet()[0].getRowIndex(), new String[]{SORTCOMBO});
                        break;
                    }
                    view.setEnable(Boolean.valueOf(true), e.getChangeSet()[0].getRowIndex(), new String[]{SORTCOMBO});
                    break;
                }
                case "org": 
                case "searchtype": 
                case "booktype": 
                case "periodtype": {
                    this.replaceSetPeriod(model, typeid, (IFormView)view);
                    break;
                }
            }
        }
    }

    private void replaceSetPeriod(IDataModel model, long typeid, IFormView view) {
        int searchType;
        if ("gl_rpt_subledger".equals(this.getView().getEntityId()) && 2 == (searchType = Integer.parseInt((String)this.getModel().getValue(SEARCHTYPE)))) {
            Date dateBegin = (Date)model.getValue("datebegin");
            long pid = this.getPeriodIdByDate(dateBegin, typeid);
            model.setValue("startperiod", (Object)pid);
            view.updateView("startperiod");
            Date dateEnd = (Date)model.getValue("dateend");
            pid = this.getPeriodIdByDate(dateEnd, typeid);
            model.setValue("endperiod", (Object)pid);
            view.updateView("endperiod");
        }
    }

    private Long getPeriodIdByDate(Date date, long typeid) {
        QFilter qtype = new QFilter("periodtype", "=", (Object)typeid);
        QFilter qbegin = new QFilter("begindate", "<=", (Object)date);
        QFilter qend = new QFilter("enddate", ">=", (Object)date);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])new QFilter[]{qtype, qbegin, qend}, (String)"id desc", (int)-1);
        if (ids.isEmpty()) {
            return 0L;
        }
        return (Long)ids.get(0);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("setfield".equals(key)) {
            if (!AccSysUtil.isPerm((String)this.getView().getEntityId(), (String)"3+T3DWZJF6/L")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8bbe\u7f6e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SubLedgerFormRpt_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("gl_report_field_seting");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("form_id", (Object)"t_rpt_aux_subledger");
            this.getView().showForm(parameter);
        }
    }

    protected void viewVoucher(Long id, IReportListModel reportModel) {
        long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        VoucherUtil.hyperVoucher(orgId, (long)id, (IFormView)this.getView(), VoucherUtil.getVoucherIdList(reportModel, "voucherid", this.getModel().getEntryCurrentRowIndex(REPORT_LIST_AP)));
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterGrid filterGrid = (FilterGrid)this.getControl("voucherfiltergridap");
        FilterCondition cond = filterGrid.getFilterGridState().getFilterCondition();
        ITimeService timeService = (ITimeService)this.getView().getService(ITimeService.class);
        IUserService userService = (IUserService)this.getView().getService(IUserService.class);
        FilterInfo filter = queryParam.getFilter();
        filter.addCommFilter("gl_voucher", cond, timeService, userService);
        filter.addFilterItem(EXPORT_EXCEL, (Object)false);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection sortEntry;
        DynamicObject[] periodDyns;
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        long periodtype = filterInfo.getLong("periodtype");
        HashSet<Long> periodIds = new HashSet<Long>(2);
        periodIds.add(filterInfo.getLong("startperiod"));
        periodIds.add(filterInfo.getLong("endperiod"));
        for (DynamicObject periodDyn : periodDyns = BusinessDataServiceHelper.load((String)"bd_period", (String)"periodtype", (QFilter[])new QFilter("id", "in", periodIds).toArray())) {
            if (Objects.equals(periodtype, periodDyn.getLong("periodtype.id"))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5f00\u59cb\u671f\u95f4\u548c\u7ed3\u675f\u671f\u95f4\u3002", (String)"AuxSubLedgerFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getDataEntityType().getProperties().get((Object)CUSTOMSORTENTRY) != null && Objects.nonNull(sortEntry = this.getModel().getEntryEntity(CUSTOMSORTENTRY))) {
            HashSet<String> fieldSet = new HashSet<String>(10);
            for (DynamicObject sortRow : sortEntry) {
                if (fieldSet.add(sortRow.getString(FIELDCOMBO))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d\u3002", (String)"SubsiDiaryTreeFormRpt_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
            this.setOtherEntryFilter(queryParam.getFilter());
        }
        return true;
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        DynamicObjectCollection sortEntry;
        super.setOtherEntryFilter(filterInfo);
        if (this.getModel().getDataEntityType().getProperties().get((Object)CUSTOMSORTENTRY) != null && Objects.nonNull(sortEntry = this.getModel().getEntryEntity(CUSTOMSORTENTRY))) {
            HashMap otherEntryFilter = new HashMap();
            ArrayList<DynamicObject> saveEntrys = new ArrayList<DynamicObject>();
            for (DynamicObject sortRow : sortEntry) {
                saveEntrys.add(sortRow);
            }
            otherEntryFilter.put(CUSTOMSORTENTRY, saveEntrys);
            filterInfo.setOtherEntryFilter(otherEntryFilter);
        }
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        DynamicObjectCollection sortEntry;
        super.loadOtherEntryFilter(scheme);
        if (scheme.getDataEntityType().getProperties().get((Object)CUSTOMSORTENTRY) != null && (sortEntry = scheme.getDynamicObjectCollection(CUSTOMSORTENTRY)) != null && !sortEntry.isEmpty()) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData(CUSTOMSORTENTRY);
            model.batchCreateNewEntryRow(CUSTOMSORTENTRY, sortEntry.size());
            for (int i = 0; i < sortEntry.size(); ++i) {
                DynamicObject sortRow = (DynamicObject)sortEntry.get(i);
                model.setValue(FIELDCOMBO, (Object)sortRow.getString(FIELDCOMBO), i);
                model.setValue(SORTCOMBO, (Object)sortRow.getString(SORTCOMBO), i);
            }
            model.endInit();
            this.getView().updateView(CUSTOMSORTENTRY);
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        this.collapseTreePanel();
        FilterInfo filter = event.getQueryParam().getFilter();
        String currencyId = filter.getString("currency");
        boolean exportexcel = filter.getBoolean(EXPORT_EXCEL) || this.isExportExcel();
        boolean isBaseCurrency = this.isBasecurrency(filter);
        DynamicObject account = null;
        if (event.getSelectedObj() instanceof DynamicObject) {
            account = (DynamicObject)event.getSelectedObj();
        }
        boolean showCurrencyCol = currencyId == null || currencyId.equals("allcurrency");
        boolean showQty = filter.getBoolean("showqty") || filter.getBoolean("showsumqty");
        boolean showPrice = this.isShowPrice(showQty, filter.getLong("org"));
        Map<String, String> colWidth = this.getColWidth(showCurrencyCol, exportexcel, isBaseCurrency, showQty, showPrice, account, false);
        this.setColumnStyle(event.getColumns(), colWidth, isBaseCurrency);
    }

    protected boolean isBasecurrency(FilterInfo filter) {
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)((Long)this.getOrgId()), (long)filter.getLong("booktype"));
        String currencyId = filter.getString("currency");
        String baseCurrencyId = String.valueOf(book.getBaseCurrencyId());
        return currencyId != null && (currencyId.equals(baseCurrencyId) || currencyId.equals("basecurrency"));
    }

    private void collapseTreePanel() {
        TreeModel reportTreeModel = ReportCacheManager.getInstance().getCache().getReportTreeModel(this.getView().getPageId());
        if (reportTreeModel != null) {
            List collect = reportTreeModel.getNodes().stream().filter(treeNode -> treeNode.getText().split(" ").length > 1).collect(Collectors.toList());
            SplitContainer splitContainer = (SplitContainer)this.getView().getControl("splitcontainerap");
            splitContainer.setCollapse("treesplitpanel", collect.size() == 1);
        }
    }

    private void setColumnStyle(List<AbstractReportColumn> columns, Map<String, String> colWidth, boolean isBaseCurrency) {
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                String width = colWidth.get(key);
                if (ZERO.equals(width)) {
                    col.setHide(true);
                } else {
                    col.setWidth(new LocaleString(width));
                    if (key.endsWith("local") && isBaseCurrency) {
                        col.setCaption(BaseAuxSubLedgerFormRpt.getTxtAmount());
                    }
                }
                if (!isBaseCurrency || !"localrate".equals(key)) continue;
                col.setHide(true);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup colGroup = (ReportColumnGroup)column;
            this.setColumnStyle(colGroup.getChildren(), colWidth, isBaseCurrency);
        }
    }

    protected Map<String, String> getColWidth(boolean showCurrencyCol, boolean exportExcel, boolean isBaseCurrency, boolean showQty, boolean showPrice, DynamicObject account, boolean isShowAccount) {
        HashMap<String, String> colWidth = new HashMap<String, String>(22);
        boolean showAssGrp = account == null || account.getBoolean("isassist");
        boolean min = isBaseCurrency && !showQty;
        boolean max = !isBaseCurrency || showQty;
        String forWidth = this.getAmountColWidth(min, max);
        colWidth.put(ACCOUNT, exportExcel || isShowAccount ? "8%" : ZERO);
        colWidth.put(ACCOUNT_NAME, exportExcel || isShowAccount ? "10%" : ZERO);
        colWidth.put(BK_DATE, min ? "8%" : "6%");
        colWidth.put(BIZ_DATE, min ? "8%" : "6%");
        colWidth.put(VCH_NUM, min && !showAssGrp ? "15%" : "10%");
        colWidth.put(DESC, min && !showAssGrp ? "15%" : "10%");
        colWidth.put(UNIT, showQty ? "5%" : ZERO);
        colWidth.put(CURRNECY, showCurrencyCol ? "6%" : ZERO);
        colWidth.put(ASSGRP, showAssGrp ? "15%" : ZERO);
        colWidth.put(DEBIT_QTY, showQty ? "9%" : ZERO);
        colWidth.put(DEBIT_PRICE, showPrice ? "9%" : ZERO);
        colWidth.put(DEBIT_FOR, isBaseCurrency ? ZERO : "9%");
        colWidth.put(DEBIT_LOCAL, forWidth);
        colWidth.put(CREDIT_QTY, showQty ? "9%" : ZERO);
        colWidth.put(CREDIT_PRICE, showPrice ? "9%" : ZERO);
        colWidth.put(CREDIT_FOR, isBaseCurrency ? ZERO : "9%");
        colWidth.put(CREDIT_LOCAL, forWidth);
        colWidth.put(DC, "4%");
        colWidth.put(END_QTY, showQty ? "9%" : ZERO);
        colWidth.put(END_PRICE, showPrice ? "9%" : ZERO);
        colWidth.put(END_FOR, isBaseCurrency ? ZERO : "9%");
        colWidth.put(END_LOCAL, forWidth);
        return colWidth;
    }

    private String getAmountColWidth(boolean min, boolean max) {
        if (min) {
            return "15%";
        }
        return max ? "9%" : "12%";
    }

    private boolean isExportExcel() {
        StackTraceElement[] stackTrace;
        boolean isExportExcel = false;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            String methodName = element.getMethodName();
            if (!methodName.equals("exportExcel")) continue;
            isExportExcel = true;
            break;
        }
        return isExportExcel;
    }

    public void processRowData(String gridId, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Date dateEnd = filter.getDate("dateend");
        boolean isExportAll = filter.getBoolean(EXPORT_EXCEL);
        boolean isBaseCur = this.isBasecurrency(filter);
        boolean showPrice = this.isShowPrice(filter.getBoolean("showqty") || filter.getBoolean("showsumqty"), filter.getLong("org"));
        int searchType = filter.getInt(SEARCHTYPE);
        String s1 = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"SubLedgerFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String s3 = ResManager.loadKDString((String)"\u672c\u65e5\u5408\u8ba1", (String)"SubLedgerFormRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String s4 = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"SubLedgerFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String s5 = ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"SubLedgerFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        Map<Long, Date> periodDateMap = this.getPeriodDateMap();
        Object orgId = this.getOrgId();
        String accountNameField = GLUtil.getAcctNameBySysParam((Long)((Long)orgId));
        DynamicObjectCollection accounts = this.getQueryParam().getFilter().getDynamicObjectCollection("account");
        List displayFields = ReportFieldSettingUtil.getDisplayFieldConfigList((String)this.getView().getEntityId());
        Map vchMap = ReportUtils.getVoucherInfo((List)displayFields, (DynamicObjectCollection)rowData);
        for (DynamicObject row : rowData) {
            DynamicObject voucherObj;
            Long fentryid;
            DynamicObject opAcct;
            String rowType;
            Date bookedDate = null;
            long period = row.getLong("period_id");
            if (Objects.nonNull(periodDateMap.get(period))) {
                bookedDate = searchType == 2 && dateEnd.before(periodDateMap.get(period)) ? dateEnd : periodDateMap.get(period);
            }
            if ("1".equals(rowType = row.getString("rowtype"))) {
                row.set(DESC, (Object)s1);
            } else if ("3".equals(rowType)) {
                row.set(DESC, (Object)s3);
            } else if ("4".equals(rowType)) {
                row.set(DESC, (Object)s4);
                row.set("bookeddate", (Object)bookedDate);
            } else if ("5".equals(rowType)) {
                row.set(DESC, (Object)s5);
                row.set("bookeddate", (Object)bookedDate);
            }
            DynamicObject account = isExportAll ? row.getDynamicObject(ACCOUNT) : this.getAccountDyn(accountNameField, row, accounts);
            row.set(ACCOUNT, (Object)account);
            if (account == null) continue;
            row.set(ACCOUNT_NAME, (Object)account.getString(accountNameField));
            BigDecimal endLocal = row.getBigDecimal(END_LOCAL);
            if (endLocal == null || GLUtil.isZero((BigDecimal)endLocal)) {
                row.set(DC, (Object)ZERO);
                row.set(END_PRICE, (Object)BigDecimal.ZERO);
            } else {
                String dc = account.getString(DC);
                row.set(DC, (Object)dc);
                if (dc.equals("-1")) {
                    row.set(END_FOR, (Object)row.getBigDecimal(END_FOR).negate());
                    row.set(END_LOCAL, (Object)row.getBigDecimal(END_LOCAL).negate());
                    if (filter.getBoolean("showqty") || filter.getBoolean("showsumqty")) {
                        row.set(END_QTY, (Object)row.getBigDecimal(END_QTY).negate());
                    }
                    if (filter.getBoolean("showrpt")) {
                        row.set(END_RPT, (Object)row.getBigDecimal(END_RPT).negate());
                    }
                }
            }
            if (filter.getBoolean("showopaccount") && Objects.nonNull(opAcct = row.getDynamicObject("opaccount"))) {
                row.set("opacctname", (Object)(opAcct.getString("number") + " " + opAcct.getString(accountNameField)));
            }
            if ((fentryid = Long.valueOf(row.getLong("fentryid"))) == 0L || displayFields == null || displayFields.isEmpty() || Objects.isNull(voucherObj = (DynamicObject)vchMap.get(fentryid))) continue;
            for (ReportFieldSettingVo vo : displayFields) {
                row.set(vo.getField(), voucherObj.get(vo.getFieldMark()));
            }
        }
        Long defaultOrg = Long.valueOf(this.getOrgId().toString());
        List<String> amountTypes = this.getAmountTypes(rowData.getDynamicObjectType().getProperties());
        ShowByAccountDCParam param = new ShowByAccountDCParam(defaultOrg, Long.valueOf(queryParam.getFilter().getLong("accounttable")));
        param.setMergeDebitAndCreditCol(Boolean.TRUE);
        param.setAmountTypes(amountTypes);
        param.addBalAndDCField("end", DC);
        param.setQtyField(END_QTY);
        ReportUtils.showRowDataByActDC((ShowByAccountDCParam)param, (DynamicObjectCollection)rowData);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (key = source.getOperateKey()) {
            case "printpreview": 
            case "exportexcel": {
                List ids;
                TreeView reportTree = (TreeView)this.getView().getControl("reporttreeap");
                if (reportTree == null || (ids = reportTree.getTreeState().getSelectedNodeId()).isEmpty() || !((String)ids.get(0)).equals(ZERO) && !((String)ids.get(0)).endsWith("t")) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u8fb9\u660e\u7ec6\u8282\u70b9\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SubLedgerFormRpt_13", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    private DynamicObject getAccountDyn(String accountNameField, DynamicObject row, DynamicObjectCollection accounts) {
        DynamicObject account = row.getDynamicObject(ACCOUNT);
        String level = this.getQueryParam().getFilter().getString("accountlevel");
        if (this.getView().getEntityId().equals("gl_rpt_subledger") && accounts != null && accounts.size() == 1 && "1".equals(level)) {
            account = (DynamicObject)accounts.get(0);
        } else {
            List ids;
            TreeView reportTree = (TreeView)this.getView().getControl("reporttreeap");
            if (reportTree != null && !(ids = reportTree.getTreeState().getSelectedNodeId()).isEmpty()) {
                try {
                    Long pk = Long.valueOf((String)ids.get(0));
                    account = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"bd_accountview", (String)("dc," + accountNameField));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return account;
    }

    private List<String> getAmountTypes(DataEntityPropertyCollection props) {
        ArrayList<String> amountTypes = new ArrayList<String>();
        amountTypes.add("local");
        amountTypes.add("for");
        amountTypes.add("rpt");
        return amountTypes;
    }

    private Object getOrgId() {
        String orgStr = this.getPageCache().get("_parentOrg");
        Object orgId = StringUtils.isEmpty((String)orgStr) ? this.getModel().getValue("org_id") : Long.valueOf(Long.parseLong(orgStr));
        return orgId;
    }

    private boolean isShowPrice(boolean showQty, Long org) {
        Boolean showPrice = (Boolean)GLUtil.getSystemParam((String)"p_showprice", (Long)org);
        if (showPrice == null) {
            return false;
        }
        return showQty && showPrice != false;
    }

    private Map<Long, Date> getPeriodDateMap() {
        return (Map)ThreadCache.get((Object)PERIOD_MAP_KEY, () -> {
            HashMap<Long, Date> result = new HashMap<Long, Date>();
            ReportQueryParam queryParam = this.getQueryParam();
            FilterInfo filter = queryParam.getFilter();
            long startperiod = filter.getLong("startperiod");
            long endperiod = filter.getLong("endperiod");
            QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(endperiod / GLUtil.TYPE_PERIOD_L));
            QFilter beginFilter = new QFilter("id", ">=", (Object)startperiod);
            QFilter endFilter = new QFilter("id", "<=", (Object)endperiod);
            try (DataSet rs = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getPeriodIds"), (String)"bd_period", (String)"id,enddate", (QFilter[])new QFilter[]{periodTypeF, beginFilter, endFilter}, null);){
                for (Row r : rs) {
                    result.put(r.getLong(0), r.getDate(1));
                }
            }
            return result;
        });
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        if ((String)this.getModel().getValue(SEARCHTYPE) == null) {
            return;
        }
        int searchtype = Integer.parseInt((String)this.getModel().getValue(SEARCHTYPE));
        if (searchtype == 1) {
            return;
        }
        if (evt.getFilter().getDate("datebegin") == null) {
            return;
        }
        String dateformatStr = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
        SimpleDateFormat format = new SimpleDateFormat(dateformatStr);
        String dateStr = String.format(ResManager.loadKDString((String)"\u65e5\u671f\uff1a%1$s ~ %2$s", (String)"SubLedgerFormRpt_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), format.format(evt.getFilter().getDate("datebegin")), format.format(evt.getFilter().getDate("dateend")));
        String formatStr = evt.getFormatedFilterString();
        String[] split = formatStr.split("; ");
        StringBuilder result = new StringBuilder();
        if (split.length > 0) {
            result.append(split[0]);
            result.append(';');
            result.append(dateStr);
            result.append(';');
            result.append(split[split.length - 1]);
            evt.setFormatedFilterString(result.toString());
        }
    }

    public void onProgress(ProgressEvent evt) {
        TaskInfo taskInfo;
        String taskID = this.getPageCache().get(JobExecuteFormSchema.INSTANCE.Param_TaskID.toTypeName());
        if (this.exportJobStatus() == JobExecuteEdit.JobStatus.backgrounded) {
            Optional.ofNullable(MultipleOrgReportExportTask.UrlManager.consume(taskID)).ifPresent(url -> {
                this.getView().download(url);
                this.getView().sendFormAction((IFormView)this.getView());
            });
        }
        if ((taskInfo = ScheduleServiceHelper.queryTask((String)taskID)) == null || taskInfo.isTaskEnd()) {
            JobExecuteEdit.JobStatus.changeJobStatus(this.getPageCache(), JobExecuteEdit.JobStatus.ended);
            evt.setProgress(100);
        }
    }

    private JobExecuteEdit.JobStatus exportJobStatus() {
        return JobExecuteEdit.JobStatus.jobStatus(this.getPageCache());
    }

    public void setExcelName(List<String> list) {
        super.setExcelName(list);
        if (SubLedgerSchema.INSTANCE.entity.equals(this.getView().getEntityId())) {
            String formName = MetadataServiceHelper.getDataEntityType((String)this.getView().getEntityId()).getDisplayName().getLocaleValue();
            IDataModel model = this.getView().getModel();
            String orgName = this.getView().getPageCache().get("searchCondition").split(";  ")[0].split("\uff1a")[1];
            String bookName = ((DynamicObject)model.getValue(SubLedgerSchema.INSTANCE.bookType.toString())).getLocaleString("name").getLocaleValue();
            String startPeriodName = ((DynamicObject)model.getValue(SubLedgerSchema.INSTANCE.startPeriod.toString())).getLocaleString("name").getLocaleValue();
            String endPeriodName = ((DynamicObject)model.getValue(SubLedgerSchema.INSTANCE.endPeriod.toString())).getLocaleString("name").getLocaleValue();
            String periodDesc = String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"SubLedgerFormRpt_12", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]), startPeriodName, endPeriodName);
            list.add(String.join((CharSequence)"-", formName, orgName, bookName, periodDesc));
        }
    }
}

