/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.math.BigDecimal;
import java.text.Format;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.util.DateUtil;

public class CashFlowFormRptPrintNew
extends AbstractPrintPlugin {
    private static final String CURRENCYID = "currencyid";
    private static final String YEARAMOUNT = "yearamount";
    private static final String AMOUNT = "amount";
    private static final String ORG = "org";
    private static final String ROWNUMBER = "rownumber";
    private static final String ASSGRP = "assgrp";
    private static final String SIGN = "sign";
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
    private List<DataRowSet> customDataRows;

    public void loadCustomData(CustomDataLoadEvent evt) {
        String dsName;
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        this.customDataRows = evt.getCustomDataRows();
        String pageId = dataSource.getPageId();
        ReportListModel listModel = this.getListModel(pageId);
        if (listModel == null) {
            return;
        }
        ReportQueryParam param = listModel.getReportQueryParam();
        FilterInfo filterInfo = param.getFilter();
        switch (dsName = dataSource.getDsName()) {
            case "head": {
                this.handleHeadDataSource(this.customDataRows, filterInfo);
                break;
            }
            case "gl_rpt_cf_prt": {
                try {
                    this.handleRowDataSource(this.customDataRows, listModel, filterInfo);
                    break;
                }
                catch (Exception exp) {
                    throw new BOSException((Throwable)exp);
                }
            }
        }
    }

    private void handleRowDataSource(List<DataRowSet> dyns, ReportListModel model, FilterInfo filterInfo) {
        int count = model.getRowCount();
        DynamicObjectCollection ds = model.getRowData(0, count);
        if (ds == null || ds.isEmpty()) {
            return;
        }
        boolean isShowAssgrp = filterInfo.getBoolean("showassist");
        boolean isShowOrg = filterInfo.getBoolean("showorg");
        for (DynamicObject d : ds) {
            DynamicObject assgrpDyn;
            DynamicObject roworg;
            DataRowSet printRow = new DataRowSet();
            int rowNo = dyns.size() + 1;
            printRow.put(ROWNUMBER, (Field)new TextField(String.valueOf(rowNo)));
            this.handelRow(d, printRow);
            if (isShowOrg && (roworg = d.getDynamicObject("orgid")) != null || (assgrpDyn = d.getDynamicObject(ASSGRP)) != null && isShowAssgrp) continue;
            dyns.add(printRow);
        }
    }

    private void handleHeadDataSource(List<DataRowSet> customDataRows, FilterInfo filterInfo) {
        try {
            String orgName = "";
            Object orgID = filterInfo.getCommFilter("parentOrg").getValue();
            DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter("id", "=", orgID).toArray());
            if (orgDyn != null) {
                orgName = orgDyn.getString("name");
            }
            DataRowSet customD = new DataRowSet();
            customD.put(ORG, (Field)new TextField(orgName));
            String bookType = filterInfo.getDynamicObject("booktype").getString("name");
            customD.put("booktype", (Field)new TextField(bookType));
            boolean isQueryByPeriod = filterInfo.getBoolean("isquerybyperiod");
            if (isQueryByPeriod) {
                DynamicObject beginPeriod = filterInfo.getDynamicObject("startperiod");
                if (beginPeriod != null) {
                    String period = beginPeriod.getString("name");
                    customD.put("period", (Field)new TextField(period));
                }
            } else {
                Date dateBegin = filterInfo.getDate("datebegin");
                Date dateEnd = filterInfo.getDate("dateend");
                dateEnd = this.parseDate(dateEnd, false);
                if (dateBegin != null && dateEnd != null) {
                    customD.put("begindate", (Field)new TextField(TimeServiceHelper.formatDate((Date)dateBegin)));
                    customD.put("enddate", (Field)new TextField(TimeServiceHelper.formatDate((Date)dateEnd)));
                    customD.put(SIGN, (Field)new TextField("~"));
                }
            }
            customDataRows.add(customD);
        }
        catch (Exception exp) {
            throw new BOSException((Throwable)exp);
        }
    }

    private Date parseDate(Date date, boolean isBeginDay) {
        if (date == null) {
            return null;
        }
        if (isBeginDay) {
            return DateUtil.makeDateOnDayStrart((Date)date);
        }
        return DateUtil.makeDateOnDayEnd((Date)date);
    }

    private void handelRow(DynamicObject d, DataRowSet printRow) {
        if (d == null) {
            return;
        }
        try {
            String cashFlowItem = d.getString("name");
            if (cashFlowItem != null) {
                printRow.put("name", (Field)new TextField(cashFlowItem.replace("\t", "   ")));
            }
            this.handleMoney(d, printRow);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void handleMoney(DynamicObject d, DataRowSet printRow) {
        DynamicObject curDynFor = d.getDynamicObject(CURRENCYID);
        if (curDynFor != null) {
            this.handleMoneyWithCur(d, printRow, curDynFor);
        }
    }

    private void handleMoneyWithCur(DynamicObject d, DataRowSet printRow, DynamicObject curDyn) {
        BigDecimal yearAmount;
        int amtprecision = curDyn.getInt("amtprecision");
        String signStr = curDyn.getString(SIGN) == null ? "" : curDyn.getString(SIGN);
        this.fobj.getCurrencyFormat().setCurrencySymbols(signStr);
        this.fobj.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
        Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(this.fobj);
        BigDecimal amount = d.getBigDecimal(AMOUNT);
        if (BigDecimal.ZERO.compareTo(amount) != 0) {
            printRow.put(AMOUNT, (Field)new TextField(format.format(amount)));
        }
        if (BigDecimal.ZERO.compareTo(yearAmount = d.getBigDecimal(YEARAMOUNT)) != 0) {
            printRow.put(YEARAMOUNT, (Field)new TextField(format.format(yearAmount)));
        }
    }

    private ReportListModel getListModel(String pageId) {
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        ReportList list = view.getReportList();
        return (ReportListModel)list.getReportModel();
    }
}

