/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.report.IReportView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.model.schema.report.SubLedgerSchema;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;

public class ExportOrgSettingPlugin
extends AbstractFormPlugin {
    private static final String KEY_BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK});
        MulBasedataEdit orgsEdit = (MulBasedataEdit)this.getControl("orgs");
        orgsEdit.addBeforeF7SelectListener(evt -> evt.addCustomQFilter(AccSysUtil.getAcctOrgFilter((String)SubLedgerSchema.INSTANCE.entity, (boolean)false, (PermissonType)PermissonType.EXPORT)));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object orgParam = this.getView().getFormShowParameter().getCustomParam("orgParam");
        List defaultOrgs = orgParam == null ? Collections.emptyList() : (List)SerializationUtils.deSerializeFromBase64((String)orgParam.toString());
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        DynamicObjectType orgType = ((BasedataProp)orgs.getDynamicObjectType().getProperty("fbasedataid")).getDynamicComplexPropertyType();
        defaultOrgs.forEach(orgID -> {
            DynamicObject orgDyo = orgs.addNew();
            orgDyo.set("fbasedataid_id", orgID);
            orgDyo.set("fbasedataid", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)orgID, (DynamicObjectType)orgType));
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        String entityID = (String)this.getView().getFormShowParameter().getCustomParam("formid");
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTNOK.equals(key)) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
            if (orgs.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CashFlowTreeList_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            List orgIdList = orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
            if (!GLUtil.hasPermission((String)"0YH1MN9OTQ4J", orgIdList, (String)entityID)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5206\u914d\u5bfc\u51fa\u6743\u9650\u3002", (String)"SubsiDiaryTreeFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            String orderfilter = (String)this.getModel().getValue("orderfilter");
            String filefilter = (String)this.getModel().getValue("filefilter");
            Integer sheetlimit = (Integer)this.getModel().getValue("sheetlimit");
            IReportView parentView = (IReportView)this.getView().getParentView();
            ReportQueryParam queryParam = parentView.getQueryParam();
            FormShowParameter showParameter = new FormShowParameter();
            HashMap<String, Object> selectObj = new HashMap<String, Object>(8);
            selectObj.put("filefilter", filefilter);
            selectObj.put("orderfilter", orderfilter);
            selectObj.put("orgIdList", orgIdList);
            selectObj.put("sheetlimit", sheetlimit);
            showParameter.setFormId("gl_reportexportall_subsi");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.getCustomParams().put("entitynumber", this.getView().getEntityId());
            showParameter.getCustomParams().put("entityid", entityID);
            showParameter.getCustomParams().put("entityname", this.getView().getParentView().getFormShowParameter().getFormConfig().getCaption().toString());
            showParameter.getCustomParams().put("selectobj", SerializationUtils.serializeToBase64(selectObj));
            showParameter.getCustomParams().put("queryparam", SerializationUtils.serializeToBase64((Object)queryParam));
            this.getView().showForm(showParameter);
        }
    }
}

