/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.FlexColumnDesc;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.form.field.format.FieldFormatContext;
import kd.bos.form.field.format.FlexValueFormatter;
import kd.bos.mvc.report.ReportListModel;

public class FlexPrintFormatter {
    public static final String FLEX_FIELD_KEY = "assgrp";
    private final FlexValueFormatter flexValueFormatter;
    private final ReportColumn flexColumn;

    public FlexPrintFormatter(ReportListModel reportListModel, DynamicObjectCollection packageData) {
        this.flexColumn = reportListModel.getColumns().stream().filter(c -> c instanceof ReportColumn && ((ReportColumn)c).getFieldKey().equals(FLEX_FIELD_KEY)).map(ReportColumn.class::cast).findAny().orElse(null);
        if (this.flexColumn != null) {
            List<AbstractColumnDesc> columns = this.getColumnDesc(this.getAllReportColumns(reportListModel.getColumns()));
            FieldFormatContext fieldFormatContext = new FieldFormatContext(reportListModel.getItemType(), columns, packageData);
            fieldFormatContext.setForExport(true);
            fieldFormatContext.setPerPageSize(packageData.size());
            this.flexValueFormatter = new FlexValueFormatter(fieldFormatContext, FLEX_FIELD_KEY);
        } else {
            this.flexValueFormatter = null;
        }
    }

    public String getFlexString(DynamicObject reportRow) {
        String res = "";
        if (this.flexColumn != null) {
            res = this.getOriginFlexFieldValue(this.flexColumn, this.flexValueFormatter, reportRow);
        }
        return res;
    }

    private String getOriginFlexFieldValue(ReportColumn flexColumn, FlexValueFormatter flexFormatter, DynamicObject dr) {
        Object list = flexFormatter.getDisplayValueForReport(dr, (FlexProp)flexColumn.getFieldProperty(), ((FlexProp)flexColumn.getFieldProperty()).getBasePropertyKey());
        String flexStr = list instanceof ArrayList ? String.join((CharSequence)"\n", (ArrayList)list) : list.toString();
        return flexStr;
    }

    private List<AbstractColumnDesc> getColumnDesc(List<ReportColumn> cols) {
        ArrayList<AbstractColumnDesc> columns = new ArrayList<AbstractColumnDesc>(cols.size());
        for (ReportColumn reportColumn : cols) {
            DynamicProperty fieldProperty = reportColumn.getFieldProperty();
            if (!(fieldProperty instanceof FlexProp)) continue;
            columns.add((AbstractColumnDesc)new FlexColumnDesc(reportColumn.getFieldKey(), (IDataEntityProperty)fieldProperty, (IDataEntityProperty)fieldProperty, ((FlexProp)fieldProperty).getBasePropertyKey()));
        }
        return columns;
    }

    private List<ReportColumn> getAllReportColumns(List<AbstractReportColumn> columns) {
        ArrayList<ReportColumn> list = new ArrayList<ReportColumn>();
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                list.add((ReportColumn)column);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup group = (ReportColumnGroup)column;
            list.addAll(this.getAllReportColumns(group.getChildren()));
        }
        return list;
    }
}

