/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.service.LocalCurrencyQueryService;
import kd.fi.bd.business.vo.AccountBookMCVO;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.BDCommonResource;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.util.POIUtils;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accountref.utils.BalanceTransferUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.ReportFormUtil;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.vo.RateBean;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class GLRptTemplatePlugin
extends AbstractReportFormPlugin {
    private static final Log LOG = LogFactory.getLog(GLRptTemplatePlugin.class);
    private static final String ORG_PARAM = "org";
    private static final List<String> defaultBaseCurrencyReport = new ArrayList<String>(10);

    private static LocaleString getBaseCurrency() {
        return new LocaleString(ResManager.loadKDString((String)"\u7efc\u5408\u672c\u4f4d\u5e01", (String)"GLRptTemplatePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    protected static LocaleString getAllCurrency() {
        return new LocaleString(ResManager.loadKDString((String)"\u6240\u6709\u5e01\u79cd", (String)"GLRptTemplatePlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        if (value == null) {
            return;
        }
        IDataModel model = this.getModel();
        switch (propertyName) {
            case "org": {
                Long orgId = ((DynamicObject)value).getLong("id");
                if (((Boolean)model.getValue("issupvir")).booleanValue()) {
                    this.setMainView(orgId);
                } else {
                    this.setEntityBookType(orgId);
                }
                this.setUseOrg(Collections.singletonList(orgId));
                break;
            }
            case "orgs": {
                List<Long> orgList;
                DynamicObjectCollection oldOrgs;
                DynamicObjectCollection orgs = (DynamicObjectCollection)value;
                Object oldValue = e.getChangeSet()[0].getOldValue();
                if (oldValue != null && (oldOrgs = (DynamicObjectCollection)oldValue).size() == orgs.size()) {
                    Set oldOrgIds = oldOrgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
                    Set newOrgIds = orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
                    oldOrgIds.removeAll(newOrgIds);
                    if (oldOrgIds.size() == 0) {
                        return;
                    }
                }
                if ((orgList = orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList())).size() == 1) {
                    long id = (Long)orgList.get(0);
                    model.beginInit();
                    model.setValue(ORG_PARAM, (Object)id);
                    model.endInit();
                    if (((Boolean)model.getValue("issupvir")).booleanValue()) {
                        this.setMainView(id);
                    } else {
                        this.setEntityBookType(id);
                    }
                } else {
                    model.setValue(ORG_PARAM, null);
                    this.setMulBookType(orgList);
                }
                this.setUseOrg(orgList);
                break;
            }
            case "orgview": {
                Long viewId = ((DynamicObject)value).getLong("id");
                this.setBookType(viewId);
                break;
            }
            case "booktype": {
                Long bookTypeId = ((DynamicObject)value).getLong("id");
                this.setBook(bookTypeId);
                break;
            }
            case "accounttable": {
                Long accountTableId = ((DynamicObject)value).getLong("id");
                this.setAccount(accountTableId);
                break;
            }
            case "periodtype": {
                String str = this.getPageCache().get("ptSpMap");
                Map ptSpMap = (Map)GLUtil.fromSerializedString((String)str);
                long periodType = ((DynamicObject)value).getLong("id");
                this.setPeriodFilter(periodType, ptSpMap);
                break;
            }
            case "startperiod": {
                long sp = ((DynamicObject)value).getLong("id");
                long ep = (Long)model.getValue("endperiod_id");
                if (ep != 0L && ep >= sp) break;
                model.setValue("endperiod", (Object)sp);
                break;
            }
            case "endperiod": {
                List tableIds;
                Set childOrgSet;
                long endPeriod = ((DynamicObject)value).getLong("id");
                long startPeriod = (Long)model.getValue("startperiod_id");
                if (startPeriod == 0L || startPeriod > endPeriod) {
                    model.setValue("startperiod", (Object)endPeriod);
                }
                List<Long> orgIds = this.getOrgValue();
                long btId = (Long)model.getValue("booktype_id");
                String childOrgSetStr = this.getPageCache().get("_childOrgSet");
                if (childOrgSetStr != null && (childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr)) != null && childOrgSet.size() > 0) {
                    orgIds.addAll(childOrgSet);
                    orgIds = new ArrayList<Long>(new HashSet<Long>(orgIds));
                }
                if (!(tableIds = ReportFormUtil.getVerAcctTable(orgIds, (long)btId, (long)endPeriod)).isEmpty()) {
                    BasedataEdit accountTableEdit = (BasedataEdit)this.getControl("accounttable");
                    GlFormUtil.setF7ClickFilter(accountTableEdit, new QFilter("id", "in", (Object)tableIds));
                    model.setValue("accounttable", tableIds.get(0));
                }
                GlFormUtil.setF7ClickFilter((BasedataEdit)this.getControl("account"), this.getEndDateFilter());
                break;
            }
            case "account": {
                DynamicObjectCollection accCols = (DynamicObjectCollection)value;
                if (accCols.size() == 0 || "1".equals(this.getPageCache().get("propertyChangedMakeAccount"))) {
                    this.getPageCache().remove("propertyChangedMakeAccount");
                    return;
                }
                List levels = accCols.stream().map(x -> x.getDynamicObject("fbasedataid")).mapToInt(x -> x.getInt("level")).boxed().collect(Collectors.toList());
                model.setValue("accountlevel", Collections.max(levels));
                break;
            }
        }
    }

    private void setUseOrg(List<Long> permOrgs) {
        if (this.getModel().getDataEntityType().getAllFields().containsKey("useorg")) {
            this.getModel().setValue("useorg", (Object)(permOrgs.size() == 1 ? permOrgs.get(0) : Long.valueOf(CommonAssistUtil.getPermParentOrg(permOrgs))));
        }
    }

    protected QFilter getEndDateFilter() {
        String entityId = this.getView().getEntityId();
        if ("gl_rpt_agingschedule".equals(entityId) || "gl_rpt_acaccountcheck".equals(entityId)) {
            return null;
        }
        DynamicObject period = (DynamicObject)this.getModel().getValue("endperiod");
        if (period == null) {
            return null;
        }
        QFilter startDate = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
        QFilter endDate = new QFilter("enddate", ">=", (Object)period.getDate("enddate"));
        return startDate.and(endDate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterSetModelValue(DynamicObject scheme) {
        IDataModel model = this.getModel();
        if (!"gl_rpt_agingdetail".equals(this.getView().getEntityId())) {
            boolean allLegalOrg;
            ArrayList<Long> newOrgs = new ArrayList<Long>();
            Set<Long> allPermOrgs = this.getPermOrgs();
            if (model.getProperty("orgs") != null) {
                DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
                if (CollectionUtils.isEmpty((Collection)orgs)) {
                    Long orgId = (Long)model.getValue("org_id");
                    if (orgId == null || orgId == 0L) return;
                    newOrgs.add(orgId);
                } else {
                    orgs.stream().map(org -> org.getLong("fbasedataid.id")).forEach(newOrgs::add);
                }
                allLegalOrg = allPermOrgs.containsAll(newOrgs);
                if (!allLegalOrg) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u7ec4\u7ec7\u7684\u67e5\u8be2\u6743\u9650\uff0c\u65e0\u6cd5\u52a0\u8f7d\u65b9\u6848\u3002", (String)"GLRptTemplatePlugin_100", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                    model.setValue("orgs", null);
                    return;
                }
            } else {
                Long orgId = (Long)model.getValue("org_id");
                if (orgId == 0L) {
                    return;
                }
                newOrgs.add(orgId);
                allLegalOrg = allPermOrgs.containsAll(newOrgs);
                if (!allLegalOrg) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u65b9\u6848\u7ec4\u7ec7\u7684\u67e5\u8be2\u6743\u9650\uff0c\u65e0\u6cd5\u52a0\u8f7d\u65b9\u6848\u3002", (String)"GLRptTemplatePlugin_100", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
                    model.setValue(ORG_PARAM, null);
                    return;
                }
            }
        }
        List<String> list = Arrays.asList("orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "account", "accountlevel", "currency", "currencyrpt", "showassist", "showorg", "showrpt", "mulcur");
        long orgId = 0L;
        model.setValue(ORG_PARAM, scheme.get(ORG_PARAM));
        orgId = scheme.getLong("org_id");
        ArrayList<Long> permOrgs = new ArrayList<Long>();
        if (orgId != 0L) {
            permOrgs.add(orgId);
        }
        if (model.getProperty("orgs") != null) {
            DynamicObjectCollection orgColl = scheme.getDynamicObjectCollection("orgs");
            if (orgId == 0L && orgColl != null && orgColl.size() > 0) {
                orgColl.stream().map(x -> x.getLong("fbasedataid_id")).forEach(permOrgs::add);
                orgId = ((DynamicObject)orgColl.get(0)).getLong("fbasedataid_id");
            }
            if (orgId != 0L && CollectionUtils.isEmpty((Collection)orgColl)) {
                DynamicObject orgDyo = scheme.getDynamicObject(ORG_PARAM);
                if (CollectionUtils.isEmpty((Collection)orgColl) && orgDyo != null) {
                    DynamicObject dynamicObject = orgColl.addNew();
                    dynamicObject.set("fbasedataid_id", orgDyo.getPkValue());
                    dynamicObject.set("fbasedataid", (Object)orgDyo);
                    dynamicObject.set("pkid", (Object)0L);
                }
            }
            model.setValue("orgs", scheme.get("orgs"));
            model.setValue(ORG_PARAM, null);
        }
        this.setUseOrg(permOrgs);
        Boolean isSupVir = (Boolean)this.getModel().getValue("issupvir");
        long bookTypeId = scheme.getLong("booktype_id");
        long viewId = scheme.getLong("orgview_id");
        Set mainViewIds = AccSysUtil.getViewByOrg((Long)orgId);
        this.getView().setVisible(Boolean.valueOf(mainViewIds.size() != 1), new String[]{"orgview"});
        if (isSupVir.booleanValue()) {
            if (viewId == 0L) {
                Long mainViewByOrgAndBT = AccSysUtil.getMainViewByOrgAndBT((Long)orgId, (Long)bookTypeId);
                viewId = mainViewByOrgAndBT == null ? 0L : mainViewByOrgAndBT;
                model.setValue("orgview", (Object)mainViewByOrgAndBT);
                scheme.set("orgview", (Object)viewId);
            }
            BasedataEdit orgViewEdit = (BasedataEdit)this.getControl("orgview");
            GlFormUtil.setF7ClickFilter(orgViewEdit, new QFilter("id", "in", (Object)mainViewIds));
        } else {
            this.setEntityBookType(orgId);
        }
        if (viewId != 0L) {
            this.setBookType(viewId);
        }
        this.setBook(bookTypeId);
        String str = this.getPageCache().get("ptSpMap");
        Map ptSpMap = (Map)GLUtil.fromSerializedString((String)str);
        long periodType = scheme.getLong("periodtype_id");
        this.setPeriodFilter(periodType, ptSpMap);
        for (String s : list) {
            if (!this.hasProperty(s)) continue;
            model.setValue(s, scheme.get(s));
        }
        if (model.getProperty("mulcur") == null || !Objects.isNull(model.getValue("mulcur"))) return;
        model.setValue("mulcur", (Object)"LocalCurrency");
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        switch (e.getCallBackId()) {
            case "download_verifyresult_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)this.getPageCache().get("verifyResultDownloadUrl"));
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        boolean skipPeriodValidate = this.getView().getEntityId().equals("gl_rpt_cashflow");
        if (this.getFilterOrg(filterInfo).size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"GLRptTemplatePlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getBoolean("issupvir") && filterInfo.getLong("orgview") == 0L && this.getFilterOrg(filterInfo).size() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"GLRptTemplatePlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("booktype") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"GLRptTemplatePlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("accounttable") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868\u3002", (String)"GLRptTemplatePlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("periodtype") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"GLRptTemplatePlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.containProp("searchtype")) {
            String searchtype = filterInfo.getString("searchtype");
            if (searchtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u65b9\u5f0f\u3002", (String)"GLRptTemplatePlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
            if ("2".equals(searchtype) && (filterInfo.getDate("datebegin") == null || filterInfo.getDate("dateend") == null)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u65e5\u671f\u3001\u7ed3\u675f\u65e5\u671f\u3002", (String)"GLRptTemplatePlugin_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (filterInfo.getLong("startperiod") == 0L && !skipPeriodValidate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u671f\u95f4\u3002", (String)"GLRptTemplatePlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("endperiod") == 0L && !skipPeriodValidate) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u671f\u95f4\u3002", (String)"GLRptTemplatePlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("startperiod") > filterInfo.getLong("endperiod")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u671f\u95f4\u3002", (String)"GLRptTemplatePlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getString("accountlevel") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u7ea7\u522b\u3002", (String)"GLRptTemplatePlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getString("currency") == null || filterInfo.getString("currency").equals("0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd", (String)"GLRptTemplatePlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        String childOrgSetStr = this.getPageCache().get("_childOrgSet");
        if (childOrgSetStr == null) {
            LOG.error("childOrgSet from PageCache is null.");
            return false;
        }
        Set orgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr);
        String mulCur = filterInfo.getString("mulcur");
        Long localCur = 0L;
        Long bookTypeId = filterInfo.getLong("booktype");
        if (Objects.nonNull(mulCur) && !Objects.equals(mulCur, "LocalCurrency")) {
            if (orgSet.size() > 1) {
                HashSet mulCurSet = new HashSet(orgSet.size());
                LocalCurrencyConfigVO currencyConfig = LocalCurrencyConfigService.getCurrencyConfig((String)mulCur);
                orgSet.stream().forEach(org -> mulCurSet.add(currencyConfig.getCurrencyId(org.longValue(), bookTypeId.longValue())));
                if (mulCurSet.size() != 1) {
                    this.buildMulCurCheckDetail(filterInfo, orgSet, bookTypeId);
                    return false;
                }
                localCur = (Long)mulCurSet.iterator().next();
            } else if (CollectionUtils.isNotEmpty((Collection)orgSet)) {
                LocalCurrencyConfigVO currencyConfig = LocalCurrencyConfigService.getCurrencyConfig((String)mulCur);
                localCur = currencyConfig.getCurrencyId(((Long)orgSet.iterator().next()).longValue(), bookTypeId.longValue());
            }
        } else {
            List bookInfoList;
            boolean isBaseCur = "basecurrency".equals(filterInfo.getString("currency"));
            boolean isMulCur = OrgType.VIRTUAL_M.getValue().equals(filterInfo.getString("orgtype"));
            if (isBaseCur && isMulCur) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u7684\u672c\u4f4d\u5e01\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u67e5\u8be2\u7efc\u5408\u672c\u4f4d\u5e01\u3002", (String)"GLRptTemplatePlugin_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (CollectionUtils.isNotEmpty((Collection)orgSet) && CollectionUtils.isNotEmpty((Collection)(bookInfoList = AccSysUtil.getBookFromAccSys((Set)orgSet, (long)bookTypeId)))) {
                localCur = ((AccountBookInfo)bookInfoList.get(0)).getBaseCurrencyId();
            }
        }
        Map commFilter = filterInfo.getCommFilter();
        commFilter.put("localcur", new QFilter("id", "=", (Object)localCur));
        if (filterInfo.containProp("searchtype") && "2".equals(filterInfo.getString("searchtype")) || filterInfo.containProp("isquerybyperiod") && !filterInfo.getBoolean("isquerybyperiod")) {
            Set childOrgSet;
            long endPeriod;
            long beginPeriod;
            Tuple<String, String> tup;
            Date dateEnd;
            long periodType = filterInfo.getLong("periodtype");
            long bookType = filterInfo.getLong("booktype");
            Date dateBegin = filterInfo.getDate("datebegin");
            String period = ReportUtils.isOverAcctVer((Date)dateBegin, (Date)(dateEnd = filterInfo.getDate("dateend")), (long)periodType, this.getOrgValue(), (long)bookTypeId);
            if (Objects.nonNull(period)) {
                String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u6240\u67e5\u65e5\u671f\u5bf9\u5e94%s\u8fdb\u884c\u4e86\u79d1\u76ee\u8868\u7248\u672c\u5316\u64cd\u4f5c\uff0c\u4e0d\u652f\u6301\u8de8\u7248\u672c\u5316\u67e5\u8be2\uff0c\u8bf7\u8c03\u6574\u3002", (String)"GLRptTemplatePlugin_15", (String)"fi-gl-formplugin", (Object[])new Object[0]), period);
                this.getView().showTipNotification(msg);
                return false;
            }
            String str = this.getPageCache().get("_childOrgSet");
            if (str != null && Objects.nonNull(tup = this.overAcctVerPeriod(beginPeriod = PeriodUtil.getPeriodByDate((Date)dateBegin, (long)periodType).getLong("id"), endPeriod = PeriodUtil.getPeriodByDate((Date)dateEnd, (long)periodType).getLong("id"), new ArrayList<Long>(childOrgSet = (Set)GLUtil.fromSerializedString((String)str)), bookType))) {
                String msg = ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ec4\u7ec7\u8303\u56f4\u4e2d%1$s\u5728%2$s\u8fdb\u884c\u4e86\u79d1\u76ee\u8868\u7248\u672c\u5316\u64cd\u4f5c\uff0c\u4e0d\u652f\u6301\u8de8\u7248\u672c\u5316\u67e5\u8be2\uff0c\u8bf7\u8c03\u6574\u65e5\u671f\u3002", (String)"GLRptTemplatePlugin_33", (String)"fi-gl-formplugin", (Object[])new Object[]{tup.item2, tup.item1});
                this.getView().showTipNotification(msg);
                return false;
            }
        } else {
            String entityId = this.getView().getEntityId();
            if (!("gl_rpt_agingschedule".equals(entityId) || "gl_rpt_acaccountcheck".equals(entityId) || "gl_rpt_reciprocal_log".equals(entityId))) {
                Tuple<String, String> tup = this.overAcctVerPeriod(filterInfo.getLong("startperiod"), filterInfo.getLong("endperiod"), this.getOrgValue(), filterInfo.getLong("booktype"));
                if (Objects.nonNull(tup)) {
                    String period = (String)tup.item1;
                    String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7%s\u5df2\u8fdb\u884c\u79d1\u76ee\u8868\u7248\u672c\u5316\u64cd\u4f5c\uff0c\u4e0d\u652f\u6301\u8de8\u7248\u672c\u5316\u67e5\u8be2\u3002\u8bf7\u8c03\u6574\u671f\u95f4\u3002", (String)"GLRptTemplatePlugin_16", (String)"fi-gl-formplugin", (Object[])new Object[0]), period);
                    this.getView().showTipNotification(msg);
                    return false;
                }
                String str = this.getPageCache().get("_childOrgSet");
                if (str != null) {
                    Set childOrgSet = (Set)GLUtil.fromSerializedString((String)str);
                    tup = this.overAcctVerPeriod(filterInfo.getLong("startperiod"), filterInfo.getLong("endperiod"), new ArrayList<Long>(childOrgSet), filterInfo.getLong("booktype"));
                    if (Objects.nonNull(tup)) {
                        String msg = ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ec4\u7ec7\u8303\u56f4\u4e2d%1$s\u5728%2$s\u8fdb\u884c\u4e86\u79d1\u76ee\u8868\u7248\u672c\u5316\u64cd\u4f5c\uff0c\u4e0d\u652f\u6301\u8de8\u7248\u672c\u5316\u67e5\u8be2\uff0c\u8bf7\u8c03\u6574\u671f\u95f4\u3002", (String)"GLRptTemplatePlugin_23", (String)"fi-gl-formplugin", (Object[])new Object[]{tup.item2, tup.item1});
                        this.getView().showTipNotification(msg);
                        return false;
                    }
                }
            }
        }
        return this.verifyExchangeRate(filterInfo);
    }

    private void buildMulCurCheckDetail(FilterInfo filterInfo, Set<Long> orgSet, Long bookTypeId) {
        ArrayList excelDetailDatas = new ArrayList(orgSet.size());
        String bookTypeName = filterInfo.getDynamicObject("booktype").getString("name");
        Table mulCurrencyTable = LocalCurrencyQueryService.batchQueryMulCurrency(orgSet, (long)bookTypeId);
        HashSet allCurrencyIds = new HashSet(8);
        mulCurrencyTable.values().stream().forEach(x -> x.values().stream().forEach(info -> allCurrencyIds.add(info.getCurrencyId())));
        QFilter currencyIdQFilter = new QFilter("id", "in", allCurrencyIds);
        DynamicObjectCollection currencyColl = QueryServiceHelper.query((String)"bd_currency", (String)"id,name", (QFilter[])currencyIdQFilter.toArray());
        HashMap currencyNameMap = new HashMap(currencyColl.size());
        currencyColl.forEach(x -> currencyNameMap.put(x.getLong("id"), x.getString("name")));
        QFilter bookTypeF = new QFilter("bookstype", "=", (Object)bookTypeId);
        try (DataSet dataSet = BatchProcessUtil.batchQueryDataSet(orgSet, batchOrgs -> QueryServiceHelper.queryDataSet((String)"getAccountbooks", (String)"gl_accountbook", (String)"org.id,org.name,basecurrency.name", (QFilter[])new QFilter[]{new QFilter(ORG_PARAM, "in", batchOrgs), bookTypeF}, (String)"org.name"));){
            for (Row row : dataSet) {
                HashMap<String, String> excelDetailData = new HashMap<String, String>(8);
                excelDetailData.put(ORG_PARAM, row.getString("org.name"));
                excelDetailData.put("booktype", bookTypeName);
                excelDetailData.put("LocalCurrency", row.getString("basecurrency.name"));
                Map currencyInfo = (Map)mulCurrencyTable.get((Object)row.getLong("org.id"), (Object)bookTypeId);
                if (Objects.nonNull(currencyInfo)) {
                    for (Map.Entry info : currencyInfo.entrySet()) {
                        String curencyName = (String)currencyNameMap.get(((AccountBookMCVO.Info)info.getValue()).getCurrencyId());
                        excelDetailData.put((String)info.getKey(), curencyName);
                    }
                }
                excelDetailDatas.add(excelDetailData);
            }
        }
        String url = POIUtils.getDownloadUrl((SXSSFWorkbook)POIUtils.fillMulCurVerifyResultWorkbook(excelDetailDatas), (String)(GlFormUtil.getMulCurVerifyFileNameTxt() + ".xlsx"));
        this.getPageCache().put("verifyResultDownloadUrl", url);
        String mulCur = filterInfo.getString("mulcur");
        String resultSummary = String.format(GlFormUtil.getVerifyResultSummaryTxt(), GlFormUtil.getMulCurText(mulCur));
        MessageBoxOptions options = MessageBoxOptions.YesNo;
        ConfirmTypes confirmTypes = ConfirmTypes.Save;
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("download_verifyresult_confirm", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(8);
        btnNameMaps.put(6, GlFormUtil.getDownloadDetailTxt());
        btnNameMaps.put(7, GlFormUtil.getCancelTxt());
        this.getView().showConfirm(resultSummary, "", options, confirmTypes, callBackListener, btnNameMaps);
    }

    private Tuple<String, String> overAcctVerPeriod(long startPeriodId, long endPeriodId, List<Long> list, long btId) {
        QFilter fs = null;
        QFilter fe = null;
        QFilter fbt = new QFilter("booktype", "=", (Object)btId);
        if (startPeriodId == endPeriodId) {
            fs = new QFilter("enableperiod", ">", (Object)startPeriodId);
            fe = new QFilter("enableperiod", "<", (Object)endPeriodId);
        } else {
            fs = new QFilter("enableperiod", ">=", (Object)startPeriodId);
            fe = new QFilter("enableperiod", "<=", (Object)endPeriodId);
        }
        QFilter finalFs = fs;
        QFilter finalFe = fe;
        DynamicObjectCollection col = BatchProcessUtil.batchQueryDynColl(list, batchOrgs -> QueryServiceHelper.query((String)"gl_book_version", (String)"enableperiod.name, org.name", (QFilter[])new QFilter[]{finalFs, finalFe, new QFilter(ORG_PARAM, "in", batchOrgs), fbt}, (String)"enableperiod desc", (int)1));
        if (col == null || col.isEmpty()) {
            return null;
        }
        String periodName = ((DynamicObject)col.get(0)).getString("enableperiod.name");
        String orgName = ((DynamicObject)col.get(0)).getString("org.name");
        return new Tuple((Object)periodName, (Object)orgName);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initOrg();
        this.initCurrency();
    }

    public void registerListener(EventObject eventObject) {
        BasedataEdit account = (BasedataEdit)this.getControl("account");
        account.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            Object value = this.getModel().getValue("accounttable_id");
            QFilter atF = new QFilter("accounttable", "=", value);
            param.setCustomParam("acct_filter", (Object)"true");
            List qFilters = param.getListFilterParameter().getQFilters();
            qFilters.add(atF);
            if (this.hasProperty("orgs")) {
                DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
                List<Long> orgList = orgs.stream().mapToLong(x -> x.getLong("fbasedataid_id")).boxed().collect(Collectors.toList());
                long parentOrg = GLRptTemplatePlugin.getParentOrgByChildre(orgList);
                QFilter baseDataFilter = AccountUtils.getAccountDataFilter((long)parentOrg, (long)Long.parseLong(value.toString()));
                qFilters.add(baseDataFilter);
            }
        });
        BasedataEdit orgView = (BasedataEdit)this.getControl("orgview");
        orgView.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            param.setFormId("bos_listf7");
        });
        BasedataEdit startPeriod = (BasedataEdit)this.getControl("startperiod");
        startPeriod.addBeforeF7SelectListener(e -> {
            IDataModel model = this.getModel();
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            DynamicObject start = (DynamicObject)model.getValue("startperiod");
            if (start != null) {
                showParam.setSelectedRow(start.getPkValue());
            }
        });
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener(e -> {
            IDataModel model = this.getModel();
            ListShowParameter showParam = (ListShowParameter)e.getFormShowParameter();
            DynamicObject end = (DynamicObject)model.getValue("endperiod");
            if (end != null) {
                showParam.setSelectedRow(end.getPkValue());
            }
        });
    }

    private boolean hasProperty(String name) {
        return this.getModel().getProperty(name) != null;
    }

    public Long getParentOrg() {
        String parentOrg = this.getPageCache().get("_parentOrg");
        if (StringUtils.isBlank((CharSequence)parentOrg)) {
            return 0L;
        }
        return Long.valueOf(parentOrg);
    }

    private boolean verifyExchangeRate(FilterInfo filterInfo) {
        Set childOrgs;
        BigDecimal rateVal;
        long desCur;
        long oriCur;
        Table mulCurrencyTable;
        Map currencyInfo;
        String mulcur;
        AccountBookInfo book;
        IReportView view = this.getView();
        List<Long> filterOrg = this.getFilterOrg(filterInfo);
        boolean isMulSelectedOrg = filterOrg.size() > 1;
        Set<Object> mulSelectedEntityOrg = new HashSet();
        if (isMulSelectedOrg && (mulSelectedEntityOrg = this.getEntityOrg(filterOrg)).isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u591a\u9009\u7ec4\u7ec7\u5fc5\u987b\u5305\u542b\u4e00\u4e2a\u5b9e\u4f53\u7ec4\u7ec7\u3002", (String)"GLRptTemplatePlugin_17", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        Map commFilter = filterInfo.getCommFilter();
        long parentOrg = GLRptTemplatePlugin.getParentOrgByChildre(filterOrg);
        this.getPageCache().put("_parentOrg", String.valueOf(parentOrg));
        commFilter.put("parentOrg", new QFilter("id", "=", (Object)parentOrg));
        if (!filterInfo.getBoolean("showrpt")) {
            return true;
        }
        long rptCur = filterInfo.getLong("currencyrpt");
        if (rptCur == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u544a\u5e01\u201c\u5e01\u79cd\u201d\u3002", (String)"GLRptTemplatePlugin_18", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        long org = parentOrg;
        if (OrgType.ENTITY.getValue().equals(filterInfo.getString("orgtype"))) {
            book = AccSysUtil.getBookFromAccSys((long)org, (long)filterInfo.getLong("booktype"));
        } else {
            org = filterOrg.get(0);
            book = AccSysUtil.getBookFromAccSys((long)org, (long)filterInfo.getLong("booktype"));
        }
        Long exRateTableId = 0L;
        long baseCurrencyId = 0L;
        if (book != null) {
            exRateTableId = book.getExrateTableId();
            baseCurrencyId = book.getBaseCurrencyId();
        }
        if (Objects.nonNull(mulcur = filterInfo.getString("mulcur")) && !Objects.equals(mulcur, "LocalCurrency") && Objects.nonNull(currencyInfo = (Map)(mulCurrencyTable = LocalCurrencyQueryService.batchQueryMulCurrency(Collections.singleton(org), (long)filterInfo.getLong("booktype"))).get((Object)org, (Object)filterInfo.getLong("booktype"))) && Objects.nonNull(currencyInfo.get(mulcur))) {
            AccountBookMCVO.Info info = (AccountBookMCVO.Info)currencyInfo.get(mulcur);
            exRateTableId = info.getExRateTableId();
            baseCurrencyId = info.getCurrencyId();
        }
        if (exRateTableId == 0L) {
            Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)parentOrg);
            if (baseAccountingInfo == null || baseAccountingInfo.isEmpty()) {
                DynamicObject pOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)parentOrg, (String)"bos_org", (String)"name");
                view.showTipNotification(String.format(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u6838\u7b97\u672c\u4f4d\u5e01\uff0c\u8bf7\u524d\u5f80\u7cfb\u7edf\u670d\u52a1\u4e91-\u57fa\u7840\u8d44\u6599-\u8d22\u52a1\u6570\u636e-\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"GLRptTemplatePlugin_22", (String)"fi-gl-formplugin", (Object[])new Object[0]), pOrg != null ? pOrg.getString("name") : ""));
                return false;
            }
            exRateTableId = (Long)baseAccountingInfo.get("exchangeRateTableID");
            baseCurrencyId = (Long)baseAccountingInfo.get("baseCurrencyID");
        }
        if (exRateTableId == null || exRateTableId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u865a\u4f53\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u6c47\u7387\u8868\uff0c\u4e0d\u80fd\u67e5\u8be2\u62a5\u544a\u5e01\u3002", (String)"GLRptTemplatePlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        Date endDate = this.getEnddate();
        boolean isDirectRate = GLUtil.isDirectRate((long)baseCurrencyId, (long)rptCur, (Date)endDate);
        QFilter tableFilter = new QFilter("exctable", "=", (Object)exRateTableId);
        QFilter curFilter = new QFilter("cur", "=", (Object)rptCur).or(new QFilter("orgcur", "=", (Object)rptCur));
        QFilter fdate = new QFilter("effectdate", "<=", (Object)endDate);
        DynamicObjectCollection exrateTree = QueryServiceHelper.query((String)"bd_exrate_tree", (String)"orgcur,cur,effectdate,excval,indirectexrate", (QFilter[])new QFilter[]{tableFilter, curFilter, fdate}, (String)"effectdate desc");
        HashMap<Long, RateBean> rateMap = new HashMap<Long, RateBean>(10);
        int rptPrecision = ((DynamicObject)this.getModel().getValue("currencyrpt")).getInt("amtprecision");
        for (DynamicObject exRate : exrateTree) {
            oriCur = exRate.getLong("orgcur");
            desCur = exRate.getLong("cur");
            if (desCur != rptCur) continue;
            rateVal = isDirectRate ? exRate.getBigDecimal("excval") : exRate.getBigDecimal("indirectexrate");
            rateMap.putIfAbsent(oriCur, new RateBean(rateVal, isDirectRate, rptPrecision));
        }
        for (DynamicObject exRate : exrateTree) {
            oriCur = exRate.getLong("orgcur");
            desCur = exRate.getLong("cur");
            if (oriCur != rptCur) continue;
            rateVal = !isDirectRate ? exRate.getBigDecimal("excval") : exRate.getBigDecimal("indirectexrate");
            rateMap.putIfAbsent(desCur, new RateBean(rateVal, isDirectRate, rptPrecision));
        }
        rateMap.putIfAbsent(rptCur, new RateBean(BigDecimal.ONE, true, rptPrecision));
        if (isMulSelectedOrg) {
            childOrgs = mulSelectedEntityOrg;
        } else if (OrgType.ENTITY.getValue().equals(filterInfo.getString("orgtype"))) {
            childOrgs = new HashSet<Object>();
            childOrgs.add(parentOrg);
        } else {
            childOrgs = AccSysUtil.getChildOrgsByView((Long)parentOrg, (Long)filterInfo.getLong("orgview"), (String)view.getFormShowParameter().getFormId());
        }
        List<Object> baseCurList = new ArrayList(childOrgs.size());
        if (Objects.isNull(mulcur) || Objects.equals(mulcur, "LocalCurrency")) {
            List bookInfoList = AccSysUtil.getBookFromAccSys(childOrgs, (long)filterInfo.getLong("booktype"));
            baseCurList = bookInfoList.stream().map(AccountBookInfo::getBaseCurrencyId).collect(Collectors.toList());
        } else {
            Table mulCurrencyTable2 = LocalCurrencyQueryService.batchQueryMulCurrency(childOrgs, (long)filterInfo.getLong("booktype"));
            baseCurList = mulCurrencyTable2.rowKeySet().stream().map(x -> ((AccountBookMCVO.Info)((Map)mulCurrencyTable2.get(x, (Object)filterInfo.getLong("booktype"))).get(mulcur)).getCurrencyId()).collect(Collectors.toList());
        }
        Set rateCurSet = rateMap.keySet();
        baseCurList.removeAll(rateCurSet);
        if (!baseCurList.isEmpty()) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", baseCurList)};
            ArrayList<String> curName = new ArrayList<String>();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_currency", (String)"name", (QFilter[])filters, null);){
                for (Row row : dataSet) {
                    curName.add(row.getString("name"));
                }
            }
            String s = ((Object)curName).toString();
            s = s.replace("[", "").replace("]", "");
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u4e0d\u5b58\u5728\u5b9e\u4f53\u7ec4\u7ec7\u672c\u4f4d\u5e01\u5bf9\u5e94\u7684\u6c47\u7387\u201c %s\u201d\u3002", (String)"GLRptTemplatePlugin_20", (String)"fi-gl-formplugin", (Object[])new Object[0]), s));
            return false;
        }
        commFilter.put("rateMap", new QFilter("id", "=", rateMap));
        return true;
    }

    protected Date getEnddate() {
        DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
        return endPeriod.getDate("enddate");
    }

    private Set<Long> getEntityOrg(List<Long> filterOrg) {
        HashSet<Long> result = new HashSet<Long>();
        QFilter entityFilter = new QFilter("isbizunit", "=", (Object)true);
        try (DataSet dataSet = BatchProcessUtil.batchQueryDataSet(filterOrg, batchOrgs -> QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)ORG_PARAM, (QFilter[])new QFilter[]{new QFilter(ORG_PARAM, "in", batchOrgs), entityFilter}, null));){
            for (Row row : dataSet) {
                result.add(row.getLong(ORG_PARAM));
            }
        }
        return result;
    }

    public static long getParentOrgByChildre(List<Long> filterOrgs) {
        return AccSysUtil.getParentOrgByChildre(filterOrgs);
    }

    protected List<Long> getFilterOrg(FilterInfo filterInfo) {
        ArrayList<Long> result = new ArrayList<Long>();
        long orgId = filterInfo.getLong(ORG_PARAM);
        if (orgId != 0L) {
            result.add(orgId);
        }
        return result;
    }

    private void initOrg() {
        Boolean isSupVir = (Boolean)this.getModel().getValue("issupvir");
        BasedataEdit orgEdit = this.getOrgEdit();
        Set orgSet = AccSysUtil.getAcctOrgPkList2((String)this.getView().getEntityId(), (boolean)isSupVir, (PermissonType)PermissonType.VIEW);
        this.getPageCache().put("_permOrgList", GLUtil.toSerializedString((Object)orgSet));
        GlFormUtil.setF7ClickFilter(orgEdit, new QFilter("id", "in", (Object)orgSet));
        Long orgId = this.getDefaultOrg(orgSet);
        long defaultOrgId = AccSysUtil.getDefaultOrgId((String)this.getView().getEntityId(), (boolean)isSupVir, (PermissonType)PermissonType.VIEW);
        if (orgSet.contains(defaultOrgId)) {
            orgId = defaultOrgId;
        }
        if (orgId == null) {
            return;
        }
        this.setDefaultOrg(orgId);
        this.getModel().setValue(ORG_PARAM, (Object)orgId);
        this.setUseOrg(Collections.singletonList(orgId));
        if (isSupVir.booleanValue()) {
            this.setMainView(orgId);
        } else {
            this.setEntityBookType(orgId);
        }
    }

    protected List<Long> getOrgValue() {
        ArrayList<Long> result = new ArrayList<Long>();
        Long value = (Long)this.getModel().getValue("org_id");
        if (value != null && value != 0L) {
            result.add(value);
        }
        return result;
    }

    protected void setDefaultOrg(Long orgId) {
        this.getModel().setValue(ORG_PARAM, (Object)orgId);
    }

    protected BasedataEdit getOrgEdit() {
        return (BasedataEdit)this.getControl(ORG_PARAM);
    }

    private Long getDefaultOrg(Set<Long> orgSet) {
        Long orgParam = this.getOrgParam();
        return orgParam != null ? orgParam : GlFormUtil.getDefaultAcctOrg(new ArrayList<Long>(orgSet));
    }

    private Long getOrgParam() {
        String org = (String)this.getView().getFormShowParameter().getCustomParam(ORG_PARAM);
        return org == null ? null : Long.valueOf(org);
    }

    private void setMainView(Long orgId) {
        Set mainViewIds = AccSysUtil.getViewByOrg((Long)orgId);
        Long defaultViewId = 0L;
        if (mainViewIds.size() > 0) {
            defaultViewId = (Long)mainViewIds.iterator().next();
        }
        BasedataEdit orgViewEdit = (BasedataEdit)this.getControl("orgview");
        GlFormUtil.setF7ClickFilter(orgViewEdit, new QFilter("id", "in", (Object)mainViewIds));
        this.getView().setVisible(Boolean.valueOf(mainViewIds.size() != 1), new String[]{"orgview"});
        this.getModel().setValue("orgview", (Object)defaultViewId);
        this.setBookType(defaultViewId);
    }

    private void setBookType(Long orgViewId) {
        List<Long> orgList = this.getOrgValue();
        HashSet<Long> orgParent = new HashSet<Long>();
        if (orgList.size() != 0) {
            orgParent.addAll(orgList);
        }
        Set childOrgSet = AccSysUtil.getChildOrgId((String)"10", (Long)orgViewId, orgParent, (boolean)true);
        Set permOrg = new HashSet();
        String str = this.getPageCache().get("_permOrgList");
        if (str != null) {
            permOrg = (Set)GLUtil.fromSerializedString((String)str);
        }
        childOrgSet.retainAll(permOrg);
        Map viewOrgBTMap = AccSysUtil.getViewOrgBTMap();
        HashSet<Long> bookTypes = new HashSet<Long>();
        Map orgBTMap = (Map)viewOrgBTMap.get(orgViewId);
        if (orgBTMap != null) {
            childOrgSet.retainAll(orgBTMap.keySet());
            this.getPageCache().put("_childOrgSet", GLUtil.toSerializedString((Object)childOrgSet));
            for (Map.Entry listEntry : orgBTMap.entrySet()) {
                Long org = (Long)listEntry.getKey();
                if (!childOrgSet.contains(org)) continue;
                bookTypes.addAll((Collection)listEntry.getValue());
            }
        }
        long defaultBookType = 0L;
        ArrayList orgIds = new ArrayList();
        orgIds.addAll(childOrgSet);
        List btIds = AccSysUtil.getBookTypeDataPermission(orgIds);
        if (btIds != null) {
            bookTypes.retainAll(btIds);
        }
        QFilter fbt = new QFilter("id", "in", bookTypes);
        DynamicObjectCollection btDyn = QueryServiceHelper.query((String)"bd_accountbookstype", (String)"id,accounttype", (QFilter[])new QFilter[]{fbt});
        for (DynamicObject bt : btDyn) {
            defaultBookType = bt.getLong("id");
            if (!"1".equals(bt.getString("accounttype"))) continue;
            defaultBookType = bt.getLong("id");
            break;
        }
        this.setBT(bookTypes, defaultBookType);
    }

    private void setMulBookType(List<Long> orgList) {
        this.getModel().setValue("orgview", null);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"orgview"});
        Long defaultBookType = null;
        LinkedHashSet<Long> bookTypes = new LinkedHashSet<Long>();
        QFilter entityFilter = new QFilter("isbizunit", "=", (Object)true);
        List ids = AccSysUtil.getBookTypeDataPermission(orgList);
        if (ids != null) {
            entityFilter = entityFilter.and(new QFilter("bookstype", "in", (Object)ids));
        }
        QFilter finalEntityFilter = entityFilter;
        DynamicObjectCollection btCol = BatchProcessUtil.batchQueryDynColl(orgList, batchOrgs -> QueryServiceHelper.query((String)"gl_accountbook", (String)"org,bookstype id, bookstype.accounttype type", (QFilter[])new QFilter[]{new QFilter(ORG_PARAM, "in", batchOrgs), finalEntityFilter}));
        HashSet<Long> childOrg = new HashSet<Long>();
        for (DynamicObject bt : btCol) {
            bookTypes.add(bt.getLong("id"));
            if ("1".equals(bt.getString("type"))) {
                defaultBookType = bt.getLong("id");
            }
            childOrg.add(bt.getLong(ORG_PARAM));
        }
        this.getPageCache().put("_childOrgSet", GLUtil.toSerializedString(childOrg));
        if (defaultBookType == null && bookTypes.size() > 0) {
            defaultBookType = (Long)bookTypes.iterator().next();
        }
        if (defaultBookType == null) {
            return;
        }
        this.setBT(bookTypes, defaultBookType);
    }

    private void setEntityBookType(Long orgId) {
        if (orgId == null) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"orgview"});
        HashSet<Long> childOrg = new HashSet<Long>();
        childOrg.add(orgId);
        this.getPageCache().put("_childOrgSet", GLUtil.toSerializedString(childOrg));
        List bookTypes = AccSysUtil.getBookTypeByOrg((long)orgId);
        if (bookTypes.size() <= 0) {
            return;
        }
        Long defaultBookType = (Long)bookTypes.get(0);
        this.setBT(bookTypes, defaultBookType);
    }

    private void setBT(Collection<Long> bookTypes, long defaultBookType) {
        BasedataEdit bookTypeEdit = (BasedataEdit)this.getControl("booktype");
        GlFormUtil.setF7ClickFilter(bookTypeEdit, new QFilter("id", "in", bookTypes));
        this.getView().setVisible(Boolean.valueOf(bookTypes.size() > 1), new String[]{"booktype"});
        this.getModel().setValue("booktype", (Object)defaultBookType);
        this.setBook(defaultBookType);
    }

    private void setBook(Long bookTypeId) {
        List tableIds;
        IDataModel model = this.getModel();
        HashSet<Long> childOrgSet = new HashSet();
        String str = this.getPageCache().get("_childOrgSet");
        if (str != null) {
            childOrgSet = (Set)GLUtil.fromSerializedString((String)str);
        }
        List bookInfoList = AccSysUtil.getBookFromAccSys(childOrgSet, (long)bookTypeId);
        HashSet<Long> accountTables = new HashSet<Long>(bookInfoList.size());
        HashSet<Long> periodTypes = new HashSet<Long>(bookInfoList.size());
        HashSet<Long> baseCurs = new HashSet<Long>(bookInfoList.size());
        Long defaultAccountTable = 0L;
        long defaultPeriodType = 0L;
        Long defaultCurPeriod = 0L;
        long defaultBaseCur = 0L;
        HashMap<Long, Set<Long>> ptSpMap = new HashMap<Long, Set<Long>>();
        for (int i = 0; i < bookInfoList.size(); ++i) {
            AccountBookInfo book = (AccountBookInfo)bookInfoList.get(i);
            long periodtype = book.getPeriodTypeId();
            long startperiod = book.getStartPeriodId();
            long accountTableId = book.getAccountTableId();
            long baseCurrencyId = book.getBaseCurrencyId();
            GlFormUtil.putMap(ptSpMap, periodtype, startperiod);
            periodTypes.add(periodtype);
            accountTables.add(accountTableId);
            baseCurs.add(baseCurrencyId);
            if (i != 0) continue;
            defaultAccountTable = accountTableId;
            defaultPeriodType = periodtype;
            defaultCurPeriod = book.getCurPeriodId();
            defaultBaseCur = baseCurrencyId;
        }
        this.getPageCache().put("ptSpMap", GLUtil.toSerializedString(ptSpMap));
        this.setPeriodFilter(defaultPeriodType, ptSpMap);
        long btId = (Long)this.getModel().getValue("booktype_id");
        BasedataEdit periodTypeEdit = (BasedataEdit)this.getControl("periodtype");
        GlFormUtil.setF7ClickFilter(periodTypeEdit, new QFilter("id", "in", periodTypes));
        Long oldPeriodTypeId = (Long)this.getModel().getValue("periodtype_id");
        model.setValue("periodtype", (Object)defaultPeriodType);
        model.setValue("startperiod", (Object)this.getDefaultPeriod(ptSpMap, childOrgSet, oldPeriodTypeId, defaultPeriodType, defaultCurPeriod, (DynamicObject)model.getValue("startperiod")));
        Long defaultEndPeriod = this.getDefaultPeriod(ptSpMap, childOrgSet, oldPeriodTypeId, defaultPeriodType, defaultCurPeriod, (DynamicObject)model.getValue("endperiod"));
        model.setValue("endperiod", (Object)defaultEndPeriod);
        List<Long> orgIds = this.getOrgValue();
        if (childOrgSet.size() > 0) {
            orgIds.addAll(childOrgSet);
            orgIds = new ArrayList<Long>(new HashSet<Long>(orgIds));
        }
        if (!(tableIds = ReportFormUtil.getVerAcctTable(orgIds, (long)btId, (long)defaultEndPeriod)).isEmpty()) {
            BasedataEdit accountTableEdit = (BasedataEdit)this.getControl("accounttable");
            GlFormUtil.setF7ClickFilter(accountTableEdit, new QFilter("id", "in", (Object)tableIds));
            if (tableIds.contains(defaultAccountTable)) {
                model.setValue("accounttable", (Object)defaultAccountTable);
            } else {
                model.setValue("accounttable", tableIds.get(0));
            }
        } else {
            if (model.getValue(ORG_PARAM) != null) {
                long orgId = (Long)model.getValue("org_id");
                List<Long> accttableIds = this.getUseAccttables(orgId);
                accountTables.retainAll(accttableIds);
            }
            model.setValue("accounttable", (Object)(defaultAccountTable == 0L ? null : defaultAccountTable));
            BasedataEdit accountTableEdit = (BasedataEdit)this.getControl("accounttable");
            GlFormUtil.setF7ClickFilter(accountTableEdit, new QFilter("id", "in", accountTables));
        }
        model.setValue("currency", (Object)this.getDefaultCurrency(childOrgSet, baseCurs.size() > 1, defaultBaseCur));
        this.setOrgTypeAndRpt(childOrgSet, baseCurs.size() > 1);
        this.setAccount(defaultAccountTable);
        GlFormUtil.setF7ClickFilter((BasedataEdit)this.getControl("account"), this.getEndDateFilter());
        this.setMulCur(childOrgSet, bookTypeId);
    }

    private void setMulCur(Set<Long> childOrgSet, Long bookTypeId) {
        ComboEdit mulcurComboEdit = (ComboEdit)this.getControl("mulcur");
        if (mulcurComboEdit == null) {
            return;
        }
        Collection localCurrencyConfigVOS = LocalCurrencyConfigService.queryEnableCurrencies(childOrgSet, (long)bookTypeId);
        this.getView().setVisible(Boolean.valueOf(!localCurrencyConfigVOS.isEmpty()), new String[]{"mulcur"});
        String mulCur = (String)this.getModel().getValue("mulcur");
        if (localCurrencyConfigVOS.isEmpty()) {
            this.getModel().setValue("mulcur", null);
        } else {
            List mulCurList = localCurrencyConfigVOS.stream().map(LocalCurrencyConfigVO::getNumber).collect(Collectors.toList());
            if (StringUtils.isEmpty((CharSequence)mulCur) || !mulCurList.contains(mulCur)) {
                this.getModel().setValue("mulcur", (Object)"LocalCurrency");
            }
        }
        if (!localCurrencyConfigVOS.isEmpty()) {
            this.getPageCache().put("enableMulCur", "true");
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(localCurrencyConfigVOS.size());
            comboItems.add(new ComboItem(new LocaleString(BDCommonResource.getLocalCurText()), "LocalCurrency"));
            localCurrencyConfigVOS.stream().sorted(Comparator.comparing(LocalCurrencyConfigVO::getNumber)).forEach(x -> comboItems.add(new ComboItem(new LocaleString(x.getName().getLocaleValue()), x.getNumber())));
            mulcurComboEdit.setComboItems(comboItems);
        } else {
            this.getPageCache().put("enableMulCur", "false");
        }
    }

    private String getDefaultCurrency(Set<Long> childOrgSet, boolean isMulCur, long defaultBaseCur) {
        String newCurrency = (String)this.getModel().getValue("currency");
        String entityName = this.getModel().getDataEntity().getDynamicObjectType().getName();
        if ("gl_rpt_cashflow".equals(entityName)) {
            newCurrency = String.valueOf(defaultBaseCur);
        } else if (newCurrency == null || newCurrency.equals("0")) {
            newCurrency = defaultBaseCurrencyReport.contains(entityName) ? "basecurrency" : String.valueOf(defaultBaseCur);
            List<Long> orgList = this.getOrgValue();
            if (orgList.size() == 1 && !childOrgSet.contains(orgList.get(0)) && isMulCur) {
                newCurrency = "allcurrency";
            }
        }
        return newCurrency;
    }

    private Long getDefaultPeriod(Map<Long, Set<Long>> ptSpMap, Set<Long> childOrgSet, Long oldPeriodTypeId, Long defaultPeriodTypeid, Long defaultCurPeriod, DynamicObject oldPeriod) {
        Long newPeriodId;
        block8: {
            block7: {
                DynamicObject curPeriod;
                boolean isEntityOrg;
                newPeriodId = defaultCurPeriod;
                if (oldPeriod != null) break block7;
                List<Long> orgList = this.getOrgValue();
                if (orgList.size() != 1 || (isEntityOrg = childOrgSet.contains(orgList.get(0))) || (curPeriod = GLUtil.getPeriodByDate((Date)new Date(), (long)((Long)this.getModel().getValue("periodtype_id")))) == null) break block8;
                newPeriodId = curPeriod.getLong("id");
                break block8;
            }
            Long oldPeriodId = (Long)oldPeriod.getPkValue();
            if (oldPeriodId.compareTo(defaultCurPeriod) != 0) {
                Long minPeriodid = null;
                Set<Long> spSet = ptSpMap.get(defaultPeriodTypeid);
                if (spSet != null && spSet.size() > 0) {
                    minPeriodid = Collections.min(spSet);
                }
                if (oldPeriodTypeId.compareTo(defaultPeriodTypeid) == 0) {
                    newPeriodId = minPeriodid == null ? defaultCurPeriod : (oldPeriodId.compareTo(minPeriodid) < 0 ? minPeriodid : oldPeriodId);
                } else {
                    DynamicObject[] periods;
                    ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
                    qFilters.add(new QFilter("periodtype", "=", (Object)defaultPeriodTypeid));
                    if (minPeriodid != null) {
                        qFilters.add(new QFilter("id", ">=", (Object)minPeriodid));
                    }
                    if ((periods = BusinessDataServiceHelper.load((String)"bd_period", (String)"id,number", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id asc")) != null && periods.length > 0) {
                        String periodNumber = oldPeriod.getString("number");
                        for (int i = 0; i < periods.length; ++i) {
                            DynamicObject period = periods[i];
                            if (!period.getString("number").equals(periodNumber)) continue;
                            newPeriodId = period.getLong("id");
                            break;
                        }
                    }
                }
            }
        }
        return newPeriodId;
    }

    private List<Long> getUseAccttables(long orgId) {
        ArrayList<Long> tables = new ArrayList<Long>(10);
        List orgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)orgId);
        orgIds.add(orgId);
        if (!orgIds.isEmpty()) {
            try (DataSet tableSet = BatchProcessUtil.batchQueryDataSet((Collection)orgIds, batchOrgs -> QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accounttable", (String)"id", (QFilter[])new QFilter(ORG_PARAM, "in", batchOrgs).toArray(), null));){
                while (tableSet.hasNext()) {
                    Row row = tableSet.next();
                    tables.add(row.getLong("id"));
                }
            }
        }
        return tables;
    }

    private void setPeriodFilter(long periodType, Map<Long, Set<Long>> ptSpMap) {
        BasedataEdit startPeriod = (BasedataEdit)this.getControl("startperiod");
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        Set<Long> spSet = ptSpMap.get(periodType);
        Long minPeriod = spSet == null || spSet.size() == 0 ? null : Collections.min(spSet);
        GlFormUtil.setF7ClickFilter(startPeriod, new QFilter("id", ">=", (Object)minPeriod));
        GlFormUtil.setF7ClickFilter(endPeriod, new QFilter("id", ">=", (Object)minPeriod));
    }

    private void setOrgTypeAndRpt(Collection<Long> childOrgSet, boolean isMulCur) {
        List<Long> orgList = this.getOrgValue();
        if (orgList.size() == 0) {
            return;
        }
        IDataModel model = this.getModel();
        if (orgList.size() == 1) {
            boolean isEntityOrg = childOrgSet.contains(orgList.get(0));
            if (isEntityOrg) {
                model.beginInit();
                model.setValue("showorg", (Object)0);
                model.endInit();
                this.getView().updateView("showorg");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"showorg"});
                if (Objects.nonNull(this.getView().getControl("showtreeorg"))) {
                    model.setValue("showtreeorg", (Object)0);
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"showtreeorg"});
                }
                model.setValue("orgtype", (Object)"1");
            } else {
                Boolean isShowAssist = (Boolean)model.getValue("showassist");
                if (isShowAssist.booleanValue()) {
                    model.setValue("showorg", (Object)1);
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"showrpt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"showorg"});
                if (Objects.nonNull(this.getView().getControl("showtreeorg"))) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"showtreeorg"});
                }
                model.setValue("orgtype", (Object)(isMulCur ? "3" : "2"));
            }
        } else {
            Boolean isShowAssist;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"showrpt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"showorg"});
            if (Objects.nonNull(this.getView().getControl("showtreeorg"))) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"showtreeorg"});
            }
            if ((isShowAssist = (Boolean)model.getValue("showassist")).booleanValue()) {
                model.setValue("showorg", (Object)1);
            }
            model.setValue("orgtype", (Object)(isMulCur ? "3" : "2"));
        }
    }

    private void setAccount(Long accountTable) {
        IDataModel model = this.getModel();
        List<Long> orgList = this.getOrgValue();
        if (accountTable == null || accountTable == 0L || orgList.isEmpty()) {
            model.setValue("account", null);
            return;
        }
        List com = ReportFormUtil.createAcctLevel((Object)accountTable);
        if (com != null && !com.isEmpty()) {
            ComboEdit levelEdit = (ComboEdit)this.getControl("accountlevel");
            levelEdit.setComboItems(com);
            String accountLevel = (String)model.getValue("accountlevel");
            if (accountLevel == null) {
                model.setValue("accountlevel", (Object)((ComboItem)com.get(0)).getValue());
            } else {
                String defValue = com.stream().filter(x -> x.getValue().equals(accountLevel)).map(c -> c.getValue()).findFirst().orElseGet(() -> ((ComboItem)com.get(com.size() - 1)).getValue());
                model.setValue("accountlevel", (Object)defValue);
            }
        } else {
            model.setValue("accountlevel", null);
        }
        DynamicObjectCollection accounts = (DynamicObjectCollection)this.getModel().getValue("account");
        if (!accounts.isEmpty()) {
            Long bookTypeId;
            String entityName = this.getModel().getDataEntity().getDynamicObjectType().getName();
            List numbers = accounts.stream().map(account -> account.getString("fbasedataid.number")).collect(Collectors.toList());
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            filters.add(new QFilter("number", "in", numbers));
            filters.add(new QFilter("accounttable.id", "=", (Object)accountTable));
            filters.add(AccountUtils.getAccountDataFilter((long)GLRptTemplatePlugin.getParentOrgByChildre(orgList), (long)accountTable));
            if ("gl_rpt_agingschedule".equals(entityName) || "gl_rpt_agingdetail".equals(entityName)) {
                QFilter acctRefFilter;
                filters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
                filters.add(new QFilter("accheck", "=", (Object)true));
                String str = this.getPageCache().get("_childOrgSet");
                Set childOrgSet = new HashSet();
                if (str != null) {
                    childOrgSet = (Set)GLUtil.fromSerializedString((String)str);
                }
                bookTypeId = (Long)this.getModel().getValue("booktype_id");
                filters.add(ReciprocalUtils.queryEndInitActFilter(childOrgSet, (Long)bookTypeId));
                Date bookedDate = (Date)this.getModel().getValue("bookeddate");
                Long periodType = (Long)this.getModel().getValue("periodtype_id");
                DynamicObject period = GLUtil.getPeriodByDate((Date)bookedDate, (long)periodType);
                if (period != null && (acctRefFilter = BalanceTransferUtils.getAccountRefFilter((Date)period.getDate("enddate"))) != null) {
                    filters.add(acctRefFilter);
                }
            } else {
                DynamicObject period = (DynamicObject)this.getModel().getValue("endperiod");
                if (period == null) {
                    model.setValue("account", null);
                    return;
                }
                if ("gl_reciprocal_acct_report".equals(entityName) || "gl_reciprocal_qing".equals(entityName)) {
                    filters.add(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
                    filters.add(new QFilter("accheck", "=", (Object)true));
                    Long orgId = (Long)model.getValue("org_id");
                    bookTypeId = (Long)model.getValue("booktype_id");
                    filters.add(ReciprocalUtils.queryEndInitActFilter(Collections.singleton(orgId), (Long)bookTypeId));
                }
                filters.add(new QFilter("startdate", "<=", (Object)period.getDate("enddate")));
                filters.add(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
            }
            DynamicObject[] accountObjs = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
            if (accountObjs.length > 0) {
                DynamicObjectCollection accountColls = new DynamicObjectCollection(((DynamicObjectCollection)this.getModel().getValue("account")).getDynamicObjectType(), null);
                for (DynamicObject accountObj : accountObjs) {
                    DynamicObject dynamicObject = accountColls.addNew();
                    dynamicObject.set("fbasedataid_id", accountObj.getPkValue());
                    dynamicObject.set("fbasedataid", (Object)accountObj);
                }
                model.setValue("account", (Object)accountColls);
                this.getPageCache().put("propertyChangedMakeAccount", "1");
            } else {
                model.setValue("account", null);
            }
        }
    }

    private void initCurrency() {
        ComboEdit currency = (ComboEdit)this.getControl("currency");
        currency.setComboItems(this.getCurrencyItems());
    }

    protected List<ComboItem> getCurrencyItems() {
        ArrayList<ComboItem> currColl = new ArrayList<ComboItem>();
        if (!"gl_balance_compare".equals(this.getView().getEntityId())) {
            ComboItem baseCur = new ComboItem();
            baseCur.setValue("basecurrency");
            baseCur.setCaption(GLRptTemplatePlugin.getBaseCurrency());
            currColl.add(baseCur);
        }
        ComboItem allCur = new ComboItem();
        allCur.setValue("allcurrency");
        allCur.setCaption(GLRptTemplatePlugin.getAllCurrency());
        currColl.add(allCur);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_currency", (String)"id, name", null);
        for (DynamicObject obj : coll) {
            ComboItem item = new ComboItem();
            item.setValue(obj.getString("id"));
            item.setCaption(new LocaleString(obj.getString("name")));
            currColl.add(item);
        }
        return currColl;
    }

    public static Map<String, String> processData(Map<String, String> accMap, DynamicObjectCollection rowData, ReportQueryParam queryParam, Consumer<DynamicObject> consumer) {
        FilterInfo filter = queryParam.getFilter();
        if (GLRptTemplatePlugin.hasShowTreeOrg(queryParam.getFilter())) {
            if (!accMap.containsKey("accountnumber_id")) {
                accMap.put("accountnumber_id", "");
            }
        } else if (!accMap.containsKey("number_id")) {
            accMap.put("number_id", "");
        }
        boolean excluedOrg = true;
        FilterItemInfo excluedOrgFilter = queryParam.getFilter().getFilterItem("excluedOrg");
        if (Objects.nonNull(excluedOrgFilter)) {
            excluedOrg = (Boolean)excluedOrgFilter.getValue();
        }
        if (GLRptTemplatePlugin.existOrg(filter) && excluedOrg) {
            if (!accMap.containsKey("orgid_id")) {
                accMap.put("orgid_id", "");
            }
        } else {
            accMap.remove("orgid_id");
        }
        if (GLRptTemplatePlugin.existCur(filter) && excluedOrg) {
            if (!accMap.containsKey("currencyid_id")) {
                accMap.put("currencyid_id", "");
            }
        } else {
            accMap.remove("currencyid_id");
        }
        for (DynamicObject dyn : rowData) {
            if (consumer != null) {
                consumer.accept(dyn);
            }
            if (GLRptTemplatePlugin.isShowTreeOrg(filter)) continue;
            GLRptTemplatePlugin.rmvExtraName(accMap, dyn);
        }
        return accMap;
    }

    public static void rmvExtraName(Map<String, String> accMap, DynamicObject dyn) {
        for (Map.Entry<String, String> entry : accMap.entrySet()) {
            String key = entry.getKey();
            String newValue = String.valueOf(dyn.get(key));
            if (entry.getValue().equals(newValue)) {
                if (key.endsWith("_id")) {
                    if (key.equals("accountnumber_id") || key.equals("number_id")) {
                        dyn.set("number", null);
                        dyn.set("name", (Object)"");
                    } else {
                        dyn.set(key.replace("_id", ""), null);
                    }
                } else {
                    dyn.set(key, (Object)"");
                }
            }
            accMap.put(key, newValue);
        }
    }

    public static boolean existOrg(FilterInfo filter) {
        return !OrgType.ENTITY.getValue().equals(filter.getFilterItem("orgtype").getString()) && filter.getFilterItem("showorg").getBoolean();
    }

    public static boolean existCur(FilterInfo filter) {
        return "allcurrency".equalsIgnoreCase(filter.getFilterItem("currency").getString());
    }

    public static boolean isShowTreeOrg(FilterInfo filter) {
        return null == filter.getFilterItem("showtreeorg") ? false : "1".equalsIgnoreCase(filter.getFilterItem("showtreeorg").getString());
    }

    public static boolean hasShowTreeOrg(FilterInfo filter) {
        return null != filter.getFilterItem("showtreeorg");
    }

    public static List<String> getAmountTypes(DataEntityPropertyCollection props) {
        ArrayList<String> amountTypes = new ArrayList<String>();
        amountTypes.add("local");
        if (props.containsKey((Object)"begindebitfor")) {
            amountTypes.add("for");
        }
        if (props.containsKey((Object)"begindebitqty")) {
            amountTypes.add("qty");
        }
        if (props.containsKey((Object)"begindebitrpt")) {
            amountTypes.add("rpt");
        }
        return amountTypes;
    }

    protected void setPrice(DynamicObject obj, String field) {
        for (String s : field.split(",")) {
            String qty = s.replace("#", "qty");
            BigDecimal qtyB = obj.getBigDecimal(qty);
            if (qtyB.compareTo(BigDecimal.ZERO) == 0) continue;
            String amtfor = s.replace("#", "for");
            String price = s.replace("#", "price");
            BigDecimal priceB = obj.getBigDecimal(amtfor).divide(qtyB, 4, 4);
            obj.set(price, (Object)priceB);
        }
    }

    protected boolean isShowPrice() {
        boolean showQty = this.getQueryParam().getFilter().getBoolean("showqty");
        if (!showQty) {
            return false;
        }
        Long org = this.getParentOrg();
        Boolean showPrice = (Boolean)GLUtil.getSystemParam((String)"p_showprice", (Long)org);
        return showPrice == null ? false : showPrice;
    }

    protected boolean isBaseCurrency(FilterInfo filter) {
        String baseCurrencyId;
        long orgId = (Long)this.getOrgId();
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)orgId, (long)filter.getLong("booktype"));
        if (Objects.isNull(book)) {
            Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
            baseCurrencyId = String.valueOf(baseAccountingInfo.get("baseCurrencyID"));
        } else {
            baseCurrencyId = String.valueOf(book.getBaseCurrencyId());
        }
        if ("null".equals(baseCurrencyId) || StringUtils.isEmpty((CharSequence)baseCurrencyId)) {
            return true;
        }
        String currencyId = filter.getString("currency");
        return currencyId != null && (currencyId.equals(baseCurrencyId) || currencyId.equals("basecurrency"));
    }

    protected Set<Long> getPermOrgs() {
        Set permOrgs;
        String str = this.getPageCache().get("_permOrgList");
        if (str != null) {
            permOrgs = (Set)GLUtil.fromSerializedString((String)str);
        } else {
            Boolean isSupVir = (Boolean)this.getModel().getValue("issupvir");
            permOrgs = AccSysUtil.getAcctOrgPkList2((String)this.getView().getEntityId(), (boolean)isSupVir, (PermissonType)PermissonType.VIEW);
        }
        return new HashSet<Long>(permOrgs);
    }

    private Object getOrgId() {
        String orgStr = this.getPageCache().get("_parentOrg");
        Object orgId = kd.bos.util.StringUtils.isEmpty((String)orgStr) ? this.getModel().getValue("org_id") : Long.valueOf(Long.parseLong(orgStr));
        return orgId;
    }

    protected void setPrice(boolean baseCurrency, DynamicObject row, String field) {
        String suffix = "local";
        if (!baseCurrency) {
            suffix = "for";
        }
        for (String str : field.split(",")) {
            String qty = str.replace("#", "qty");
            BigDecimal qtyBig = row.getBigDecimal(qty);
            if (qtyBig.compareTo(BigDecimal.ZERO) == 0) continue;
            String original = str.replace("#", suffix);
            String price = str.replace("#", "price");
            BigDecimal priceB = row.getBigDecimal(original).divide(qtyBig, 10, 4);
            row.set(price, (Object)priceB);
        }
    }

    protected void unlimitedSyncexportall(Boolean exportAssist) {
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        if (reportList.getReportModel().getRowCount() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u5bfc\u51fa\u7684\u6570\u636e\uff0c\u8bf7\u5148\u67e5\u8be2\u540e\u518d\u5bfc\u51fa\u3002", (String)"AssistbalFormRpt_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = this.getParentOrg();
        String entityId = this.getView().getEntityId();
        if (!GLUtil.hasPermission((String)"0YH1MN9OTQ4J", (Long)orgId, (String)entityId)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SubsiDiaryTreeFormRpt_20", (String)"fi-gl-formplugin", (Object[])new Object[0]), this.getView().getFormShowParameter().getFormConfig().getCaption().toString()));
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        if (exportAssist.booleanValue() && !filterInfo.getBoolean("showassist")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u663e\u793a\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AssistBalFormRpt_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        if (Objects.equals(filterInfo.getString("showtreeorg"), "1")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6240\u6709\u4e0d\u652f\u6301\u9010\u7ea7\u5c55\u793a\u65b9\u5f0f\u3002", (String)"AssistBalFormRpt_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gl_reportexportall_subsi");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("entitynumber", this.getView().getEntityId());
        showParameter.getCustomParams().put("entityid", entityId);
        showParameter.getCustomParams().put("entityname", this.getView().getFormShowParameter().getFormConfig().getCaption().toString());
        showParameter.getCustomParams().put("selectobj", SerializationUtils.serializeToBase64((Object)"0"));
        showParameter.getCustomParams().put("queryparam", SerializationUtils.serializeToBase64((Object)queryParam));
        showParameter.getCustomParams().put("exportAssist", exportAssist);
        this.getView().showForm(showParameter);
    }

    static {
        defaultBaseCurrencyReport.add("gl_rpt_accountbalance");
        defaultBaseCurrencyReport.add("gl_rpt_generalledger");
        defaultBaseCurrencyReport.add("gl_rpt_subledger");
        defaultBaseCurrencyReport.add("gl_rpt_daily");
        defaultBaseCurrencyReport.add("gl_rpt_assistbalance");
        defaultBaseCurrencyReport.add("gl_rpt_assistactbalance");
        defaultBaseCurrencyReport.add("gl_assisttotal");
        defaultBaseCurrencyReport.add("gl_rpt_subsidiaryledger");
        defaultBaseCurrencyReport.add("t_rpt_aux_subledger");
        defaultBaseCurrencyReport.add("gl_rpt_accbalance_qing");
    }
}

