/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterOutputGridEvent;
import kd.bos.print.core.plugin.event.AfterOutputWidgetEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.print.core.plugin.event.EndExportEvent;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.report.ReportPrintHelper;

public class GeneralLedgerCataloguePlugin
extends AbstractPrintPlugin {
    private static final Log LOGGER = LogFactory.getLog(GeneralLedgerCataloguePlugin.class);
    private Map<String, Integer> startPageMap = new LinkedHashMap<String, Integer>(6);
    private static final String EMPTY = "";
    private String account = "";
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "booktype"};
    private String org = "";
    private String booktype = "";

    public void loadCustomData(CustomDataLoadEvent evt) {
        CustomDataSource dataSource = evt.getDataSource();
        String pageId = dataSource.getPageId();
        ReportListModel model = ReportPrintHelper.getListModel(pageId);
        if (model == null) {
            return;
        }
        if ("reporthead".equals(dataSource.getDsName())) {
            List field = dataSource.getQueryField();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(field, headBaseDataFieldKeys);
            ReportQueryParam param = model.getReportQueryParam();
            FilterInfo filter = param.getFilter();
            DataRowSet dsRow = new DataRowSet();
            ReportPrintHelper.handleAccountBaseDataFilterInfo(filter, dsRow, headBaseDataFields);
            this.org = String.valueOf(dsRow.getField("org"));
            this.booktype = String.valueOf(dsRow.getField("booktype"));
        }
    }

    public void afterOutputWidget(AfterOutputWidgetEvent evt) {
        int pageIndex = evt.getPageIndex();
        if ("DataGrid".equals(evt.getWidgetKey())) {
            for (int i = 0; i < ((AfterOutputGridEvent)evt).getWidget().getOutputRows().size(); ++i) {
                AbstractPWGridCell accountNumberCell = ((AfterOutputGridEvent)evt).getWidget().getOutputRow(i).getCell(1);
                AbstractPWGridCell accountNameCell = ((AfterOutputGridEvent)evt).getWidget().getOutputRow(i).getCell(2);
                if (null == accountNumberCell || null == accountNameCell) continue;
                String accountNumber = accountNumberCell.getOutputText();
                String accountName = accountNameCell.getOutputText();
                if (StringUtils.isEmpty((String)accountNumber) || StringUtils.isEmpty((String)accountName)) continue;
                this.account = accountNumber + accountName;
                if (this.account.equals(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801\u79d1\u76ee\u540d\u79f0", (String)"GeneralLedgerCataloguePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0])) || this.startPageMap.containsKey(this.account)) continue;
                this.startPageMap.put(this.account, pageIndex + 1);
            }
        }
    }

    public void endExport(EndExportEvent evt) {
        String entity = evt.getPrtAttach().getFormId();
        String cacheKey = entity + "_" + this.org + "_" + this.booktype;
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);
        cache.put(cacheKey, SerializationUtils.toJsonString(this.startPageMap));
        LOGGER.info("This is GeneralLedgerCataloguePlugin cacheValue:" + SerializationUtils.toJsonString(this.startPageMap));
    }
}

