/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.gl.report.ReportPrintHelper;

public class GeneralLedgerRptPrint
extends AbstractPrintServicePlugin {
    private static final String[] rowDataStringFieldKeys = new String[]{"fseq", "accountnumber", "accountname", "currencylocalid.name", "period.name", "measureunit.name", "description", "currencyid.name", "direction"};
    private static final String[] rowDataQtyFieldKeys = new String[]{"debitqty", "creditqty", "endqty"};
    private static final String[] rowDataAmountLocalFieldKeys = new String[]{"debitlocal", "creditlocal", "endlocal"};
    private static final String[] rowDataAmountForFieldKeys = new String[]{"debitfor", "creditfor", "endfor"};
    private static final String[] headBaseDataFieldKeys = new String[]{"org", "orgview", "booktype", "periodtype", "startperiod", "endperiod", "accounttable", "currencyrpt"};
    private static final String CURRENCY_HEAD = "currency";
    private static final String CURRENCY_LOCAL = "currencylocalid";
    private static final String CURRENCY_FOR = "currencyid";
    private static final String MEASUREUNITFIELD = "measureunit";
    private FormatObject fobj;

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        super.customPrintDataEntities(e);
        List dyns = e.getDataEntities();
        String pageId = e.getPageId();
        ReportListModel listModel = ReportPrintHelper.getListModel(pageId);
        if (listModel == null) {
            return;
        }
        ReportQueryParam param = listModel.getReportQueryParam();
        FilterInfo filterInfo = param.getFilter();
        if (e.isMainDs()) {
            DynamicObjectType customDT = new DynamicObjectType();
            customDT.registerProperty("id", String.class, (Object)"", false);
            DynamicObject printDyn = new DynamicObject(customDT);
            printDyn.set("id", (Object)"1");
            dyns.add(printDyn);
            e.setDataEntities(dyns);
        } else if ("reporthead".equals(e.getDataSourceName())) {
            DynamicObjectType customDT = new DynamicObjectType();
            String[] headBaseDataFields = ReportPrintHelper.getExistFileds(e, headBaseDataFieldKeys);
            ReportPrintHelper.registerStringProperty(customDT, headBaseDataFields);
            ReportPrintHelper.registerStringProperty(customDT, CURRENCY_HEAD);
            DynamicObject printDyn = new DynamicObject(customDT);
            ReportPrintHelper.handleBaseDataFilterInfo(filterInfo, printDyn, headBaseDataFields);
            ReportPrintHelper.handleCurrencyNameById(filterInfo, printDyn, CURRENCY_HEAD);
            dyns.add(printDyn);
            e.setDataEntities(dyns);
        } else {
            int count = listModel.getRowCount();
            DynamicObjectType customDt = new DynamicObjectType();
            String[] rowDataStringFields = ReportPrintHelper.getExistFileds(e, rowDataStringFieldKeys);
            String[] rowDataAmountForFields = ReportPrintHelper.getExistFileds(e, rowDataAmountForFieldKeys);
            String[] rowDataAmountLocalFields = ReportPrintHelper.getExistFileds(e, rowDataAmountLocalFieldKeys);
            String[] rowDataQtyFields = ReportPrintHelper.getExistFileds(e, rowDataQtyFieldKeys);
            ReportPrintHelper.registerStringProperty(customDt, new String[][]{rowDataStringFields, rowDataQtyFields, rowDataAmountLocalFields, rowDataAmountForFields});
            this.fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
            DynamicObjectCollection ds = listModel.getRowData(0, count);
            for (DynamicObject rowData : ds) {
                DynamicObject printRow = new DynamicObject(customDt);
                ReportPrintHelper.handleStringFields(rowData, printRow, rowDataStringFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_LOCAL, (boolean)Boolean.FALSE, rowDataAmountLocalFields);
                ReportPrintHelper.handleAmountFields(rowData, printRow, this.fobj, CURRENCY_FOR, (boolean)Boolean.FALSE, rowDataAmountForFields);
                ReportPrintHelper.handleQtyFields(rowData, printRow, (boolean)Boolean.FALSE, MEASUREUNITFIELD, this.fobj, rowDataQtyFields);
                dyns.add(printRow);
            }
            e.setDataEntities(dyns);
        }
    }
}

