/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.util.VoucherUtil;

public class ReciprocalAgingDetailRpt
extends GLRptTemplatePlugin {
    private static final String AGINGDETAILORG = "agingdetailorg";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener(arg0 -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowData = list.getReportModel().getRowData(rowIndex);
            String voucherId = rowData.getString("voucherid");
            if (StringUtils.isNotBlank((CharSequence)voucherId) && !voucherId.equals("0")) {
                this.viewVoucher(voucherId);
            }
        });
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        IDataModel model = this.getModel();
        Object agingRangeMap = this.getView().getFormShowParameter().getCustomParam("agingrange");
        Object agingDetailOrg = this.getView().getFormShowParameter().getCustomParam(AGINGDETAILORG);
        if (null != agingDetailOrg) {
            queryParam.getFilter().addFilterItem(AGINGDETAILORG, agingDetailOrg);
        }
        queryParam.getFilter().addFilterItem("agingrange", agingRangeMap);
        DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
        ArrayList<String> assgrpNameList = new ArrayList<String>();
        for (DynamicObject row : entryentity) {
            DynamicObject fieldname = row.getDynamicObject("fieldname");
            if (fieldname == null) continue;
            String valueSource = fieldname.getString("valuesource.number");
            DynamicObjectCollection valNameColl = row.getDynamicObjectCollection("value");
            HashSet<Long> valIdSet = new HashSet<Long>();
            ArrayList<String> nameList = new ArrayList<String>();
            for (DynamicObject val : valNameColl) {
                Long id = val.getLong("fbasedataid_id");
                valIdSet.add(id);
            }
            QFilter idFilter = new QFilter("id", "in", valIdSet);
            BasedataEntityType entity = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)valueSource);
            String nameProp = entity.getNameProperty();
            DynamicObjectCollection doc = QueryServiceHelper.query((String)valueSource, (String)(nameProp + " name"), (QFilter[])idFilter.toArray());
            for (DynamicObject val : doc) {
                nameList.add(val.getString("name"));
            }
            String typeName = fieldname.getString("name");
            typeName = typeName == null ? "" : typeName;
            String valName = String.join((CharSequence)",", nameList);
            String name = typeName + ":" + valName;
            assgrpNameList.add(name);
        }
        String assgrpName = String.join((CharSequence)";", assgrpNameList);
        model.setValue("assgrptxt", (Object)assgrpName);
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getDate("bookeddate") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8bb0\u8d26\u65e5\u671f\u3002", (String)"ReciprocalAgingDetailRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getDate("expiredate") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u622a\u6b62\u65e5\u671f\u3002", (String)"ReciprocalAgingDetailRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getDynamicObjectCollection("account") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u79d1\u76ee", (String)"ReciprocalAgingDetailRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        DynamicObject[] periodDynColl;
        super.processRowData(gridPK, rowData, queryParam);
        if (Objects.isNull(rowData) || rowData.size() == 0) {
            return;
        }
        HashMap<Long, VoucherVo> vchIdMap = new HashMap<Long, VoucherVo>(rowData.size());
        rowData.forEach(v -> vchIdMap.put(v.getLong("voucherid"), null));
        HashMap<Long, DynamicObject> periodIdMap = new HashMap<Long, DynamicObject>(rowData.size());
        QFilter vchIdfilter = new QFilter("id", "in", vchIdMap.keySet());
        try (DataSet dataSet = this.queryVoucher(vchIdfilter.toArray());){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long periodId = next.getLong("period");
                periodIdMap.put(periodId, null);
                vchIdMap.put(next.getLong("id"), new VoucherVo(next.getString("vouchernumber"), periodId, next.getDate("bookeddate1")));
            }
        }
        QFilter periodfilter = new QFilter("id", "in", periodIdMap.keySet());
        for (DynamicObject dyn : periodDynColl = BusinessDataServiceHelper.load((String)"bd_period", (String)"id,name", (QFilter[])periodfilter.toArray())) {
            periodIdMap.put(dyn.getLong("id"), dyn);
        }
        rowData.forEach(v -> {
            VoucherVo vchVo = (VoucherVo)vchIdMap.get(v.getLong("voucherid"));
            if (Objects.nonNull(vchVo)) {
                v.set("vouchernumber", (Object)vchVo.getVouchernumber());
                v.set("period", periodIdMap.get(vchVo.getPeriodId()));
                v.set("bookeddate1", (Object)vchVo.getBookeddate1());
            }
        });
    }

    private DataSet queryVoucher(QFilter[] filters) {
        String selectField = "id,vouchertype.name typename,billno,period,bookeddate bookeddate1";
        DataSet dt = QueryServiceHelper.queryDataSet((String)"gl_reciprocal_queryvoucher", (String)"gl_voucher", (String)selectField, (QFilter[])filters, null);
        dt = dt.select(new String[]{"id", "typename+' '+billno vouchernumber", "period", "bookeddate1"});
        return dt;
    }

    @Override
    protected BasedataEdit getOrgEdit() {
        return (BasedataEdit)this.getControl("orgs");
    }

    @Override
    protected List<Long> getOrgValue() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    @Override
    protected void setDefaultOrg(Long orgId) {
        if (orgId == null || orgId == 0L) {
            this.getModel().setValue("orgs", null);
        } else {
            this.getModel().setValue("orgs", (Object)new Long[]{orgId});
        }
    }

    @Override
    protected List<Long> getFilterOrg(FilterInfo filterInfo) {
        List value;
        ArrayList<Long> result = new ArrayList<Long>();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("orgs");
        if (itemInfo != null && (value = (List)itemInfo.getValue()) != null) {
            for (DynamicObject dyn : value) {
                result.add(dyn.getLong("id"));
            }
        }
        return result;
    }

    public void viewVoucher(String id) {
        VoucherUtil.hyperVoucher(Long.parseLong(id), (IFormView)this.getView());
    }

    static class VoucherVo {
        private String vouchernumber;
        private Long periodId;
        private Date bookeddate1;

        public VoucherVo(String vouchernumber, Long period, Date bookeddate1) {
            this.vouchernumber = vouchernumber;
            this.periodId = period;
            this.bookeddate1 = bookeddate1;
        }

        public String getVouchernumber() {
            return this.vouchernumber;
        }

        public Long getPeriodId() {
            return this.periodId;
        }

        public Date getBookeddate1() {
            return this.bookeddate1;
        }
    }
}

