/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.report.IReportView;
import kd.fi.gl.report.GLRptTemplatePlugin;

public class ReciprocalLogVerifyPlugin
extends GLRptTemplatePlugin {
    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (this.getFilterOrg(filterInfo).size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ReciprocalLogVerifyPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getBoolean("issupvir") && filterInfo.getLong("orgview") == 0L && this.getFilterOrg(filterInfo).size() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"ReciprocalLogVerifyPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("booktype") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ReciprocalLogVerifyPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("accounttable") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868", (String)"ReciprocalLogVerifyPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("periodtype") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"ReciprocalLogVerifyPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("startperiod") == 0L) {
            IReportView view = this.getView();
            IDataModel model = this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            DynamicObject booktype = (DynamicObject)model.getValue("booktype");
            if (org != null && booktype != null && this.getPageCache().get(String.format("%s+%s+init", String.valueOf(org.getPkValue()), String.valueOf(booktype.getPkValue()))) == null) {
                long mpid = this.getMinInitPeriod(org, booktype);
                if (mpid != 0L) {
                    model.setValue("startperiod", (Object)mpid);
                    model.setValue("endperiod", (Object)mpid);
                    this.getPageCache().put(String.format("%s+%s+init", String.valueOf(org.getPkValue()), String.valueOf(booktype.getPkValue())), String.valueOf(mpid));
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed3\u675f\u5f80\u6765\u521d\u59cb\u5316\uff0c\u518d\u67e5\u8be2\u5f80\u6765\u6838\u9500\u65e5\u5fd7\u3002", (String)"ReciprocalLogVerifyPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u671f\u95f4\u3002", (String)"ReciprocalLogVerifyPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("endperiod") == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u671f\u95f4\u3002", (String)"ReciprocalLogVerifyPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getLong("startperiod") > filterInfo.getLong("endperiod")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u671f\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u671f\u95f4\u3002", (String)"ReciprocalLogVerifyPlugin_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getString("currency") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd", (String)"ReciprocalLogVerifyPlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private long getMinInitPeriod(DynamicObject org, DynamicObject booktype) {
        if (org != null && booktype != null) {
            String sql = String.format("select min(fendinitperiod) mpid from t_gl_reci_init_state where forgid = %s and fbooktypeid = %s and fisendinit='1'", org.getPkValue(), booktype.getPkValue());
            try (DataSet initState = DB.queryDataSet((String)"fi.gl.ReciprocalAcctQueryRpt.initstate", (DBRoute)DBRoute.of((String)"gl"), (String)sql);){
                if (initState.hasNext()) {
                    long mpid;
                    Row row = initState.next();
                    if (row.get("mpid") == null) {
                        long l = 0L;
                        return l;
                    }
                    long l = mpid = row.getLong("mpid").longValue();
                    return l;
                }
            }
        }
        return 0L;
    }
}

