/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.gl.util.BaseDataUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.vo.NameHistoryVO;

public class ReportPrintHelper {
    private static final String CFG_SUFFIX = "_printsetting";

    public static Object getDefaultTemplateId(String formId) {
        DynamicObject preferenceScheme;
        Object dTemplateId = null;
        Map<String, Object> printSetting = ReportPrintHelper.getPrintSetting(formId);
        if (!printSetting.isEmpty()) {
            dTemplateId = printSetting.get("templateid");
        }
        if (ObjectUtils.isEmpty(dTemplateId) && (preferenceScheme = ReportPrintHelper.getEnableScheme(formId)) != null) {
            dTemplateId = preferenceScheme.get("defaultprinter");
        }
        if (ObjectUtils.isEmpty((Object)dTemplateId)) {
            dTemplateId = ReportPrintHelper.getDefaulttplInManangeTool(formId);
        }
        return dTemplateId;
    }

    private static Map<String, Object> getPrintSetting(String formId) {
        Map<String, Object> myPrintSetting = new HashMap<String, Object>();
        String configKey = formId + CFG_SUFFIX;
        String userId = RequestContext.get().getUserId();
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)configKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            myPrintSetting = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
        }
        return myPrintSetting;
    }

    private static DynamicObject getEnableScheme(String formId) {
        Optional firstScheme;
        DynamicObject scheme = null;
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("ispreference", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        Map schemes = BusinessDataServiceHelper.loadFromCache((String)"bos_printingscheme", (QFilter[])filters);
        if (!schemes.isEmpty() && (firstScheme = schemes.values().stream().findFirst()).isPresent()) {
            scheme = (DynamicObject)firstScheme.get();
        }
        return scheme;
    }

    private static String getDefaulttplInManangeTool(String formId) {
        String tplId = "";
        QFilter[] qFilters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObject defaultObj = QueryServiceHelper.queryOne((String)"bas_manageprinttpl", (String)"printtplid.id", (QFilter[])qFilters);
        if (defaultObj != null) {
            tplId = (String)defaultObj.get("printtplid.id");
        }
        return tplId;
    }

    protected static void registerStringProperty(DynamicObjectType dt, String ... fieldKeys) {
        for (String fieldKey : fieldKeys) {
            dt.registerProperty(fieldKey, String.class, (Object)"", false);
        }
    }

    protected static void registerStringProperty(DynamicObjectType dt, String[] ... allFieldKeys) {
        String[][] stringArray = allFieldKeys;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] fieldKeys;
            for (String fieldKey : fieldKeys = stringArray[i]) {
                dt.registerProperty(fieldKey, String.class, (Object)"", false);
            }
        }
    }

    private static List<String> existProperty(DynamicObject rowData, String ... fieldKeys) {
        DataEntityPropertyCollection properties = rowData.getDataEntityType().getProperties();
        ArrayList<String> existFieldKeys = new ArrayList<String>(fieldKeys.length);
        String[] stringArray = fieldKeys;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            IDataEntityProperty property;
            String fieldKey;
            String key = fieldKey = stringArray[i];
            if (fieldKey.contains(".")) {
                String[] split = fieldKey.split("\\.");
                key = split[0];
            }
            if ((property = (IDataEntityProperty)properties.get((Object)key)) == null) continue;
            existFieldKeys.add(fieldKey);
        }
        return existFieldKeys;
    }

    protected static void handleStringFields(DynamicObject rowData, DynamicObject printRow, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        for (String fieldKey : existPropertys) {
            printRow.set(fieldKey, (Object)rowData.getString(fieldKey));
        }
    }

    protected static void handleStringFields(DynamicObject rowData, DataRowSet printRow, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        for (String fieldKey : existPropertys) {
            printRow.add(fieldKey, (Field)new TextField(null == rowData.getString(fieldKey) ? "" : rowData.getString(fieldKey)));
        }
    }

    protected static void handleStringJointField(DynamicObject rowData, DynamicObject printRow, String printRowField, String jointStr, String ... jointFieldKeys) {
        ArrayList<String> jointStrs = new ArrayList<String>(jointFieldKeys.length);
        for (String fieldKey : jointFieldKeys) {
            String rowDataStr = rowData.getString(fieldKey);
            if (rowDataStr == null) continue;
            jointStrs.add(rowDataStr);
        }
        if (!jointStrs.isEmpty()) {
            printRow.set(printRowField, (Object)String.join((CharSequence)jointStr, jointStrs));
        }
    }

    protected static void handleStringJointField(DynamicObject rowData, DataRowSet printRow, String printRowField, String jointStr, String ... jointFieldKeys) {
        ArrayList<String> jointStrs = new ArrayList<String>(jointFieldKeys.length);
        for (String fieldKey : jointFieldKeys) {
            String rowDataStr = rowData.getString(fieldKey);
            if (rowDataStr == null) continue;
            jointStrs.add(rowDataStr);
        }
        if (!jointStrs.isEmpty()) {
            printRow.add(printRowField, (Field)new TextField(String.join((CharSequence)jointStr, jointStrs)));
        }
    }

    protected static void handleDateFields(DynamicObject rowData, DynamicObject printRow, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        for (String fieldKey : existPropertys) {
            printRow.set(fieldKey, (Object)rowData.getDate(fieldKey));
        }
    }

    protected static void handleDateFields(DynamicObject rowData, DynamicObject printRow, Format timeFormat, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        for (String fieldKey : existPropertys) {
            Date date = rowData.getDate(fieldKey);
            if (date == null) continue;
            printRow.set(fieldKey, (Object)timeFormat.format(date));
        }
    }

    protected static void handleDateFields(DynamicObject rowData, DataRowSet printRow, Format timeFormat, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        for (String fieldKey : existPropertys) {
            Date date = rowData.getDate(fieldKey);
            if (date == null) continue;
            printRow.add(fieldKey, (Field)new TextField(timeFormat.format(date)));
        }
    }

    protected static void handleAmountFields(DynamicObject rowData, DynamicObject printRow, FormatObject fobj, String currenyField, boolean showZero, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        if (!existPropertys.isEmpty()) {
            String signStr = "";
            int amtprecision = 0;
            DynamicObject curDyn = rowData.getDynamicObject(currenyField);
            if (curDyn != null) {
                amtprecision = curDyn.getInt("amtprecision");
                signStr = curDyn.getString("sign");
            }
            fobj.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
            fobj.getCurrencyFormat().setCurrencySymbols(signStr);
            Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
            for (String fieldKey : existPropertys) {
                BigDecimal b = rowData.getBigDecimal(fieldKey);
                if (b == null || !showZero && b.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.set(fieldKey, (Object)format.format(b));
            }
        }
    }

    protected static void handleAmountFields(DynamicObject rowData, DataRowSet printRow, FormatObject fobj, String currenyField, boolean showZero, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        if (!existPropertys.isEmpty()) {
            String signStr = "";
            int amtprecision = 0;
            DynamicObject curDyn = rowData.getDynamicObject(currenyField);
            if (curDyn != null) {
                amtprecision = curDyn.getInt("amtprecision");
                signStr = curDyn.getString("sign");
            }
            fobj.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
            fobj.getCurrencyFormat().setCurrencySymbols(signStr);
            Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
            for (String fieldKey : existPropertys) {
                BigDecimal b = rowData.getBigDecimal(fieldKey);
                if (b == null || !showZero && b.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.add(fieldKey, (Field)new TextField(format.format(b)));
            }
        }
    }

    protected static void handleDecimalFields(DynamicObject rowData, DynamicObject printRow, FormatObject fobj, boolean showZero, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        if (!existPropertys.isEmpty()) {
            Format format = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(fobj);
            for (String fieldKey : existPropertys) {
                BigDecimal b = rowData.getBigDecimal(fieldKey);
                if (b == null || !showZero && b.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.set(fieldKey, (Object)format.format(b));
            }
        }
    }

    protected static void handleDecimalFields(DynamicObject rowData, DataRowSet printRow, FormatObject fobj, boolean showZero, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        if (!existPropertys.isEmpty()) {
            Format format = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(fobj);
            for (String fieldKey : existPropertys) {
                BigDecimal b = rowData.getBigDecimal(fieldKey);
                if (b == null || !showZero && b.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.add(fieldKey, (Field)new TextField(format.format(b)));
            }
        }
    }

    protected static void handleDcFields(DynamicObject rowData, DynamicObject printRow, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        for (String fieldKey : existPropertys) {
            String dc = rowData.getString(fieldKey);
            if (dc == null) continue;
            dc = dc.equals("1") ? ResManager.loadKDString((String)"\u501f", (String)"ReportPrintHelper_0", (String)"fi-gl-formplugin", (Object[])new Object[0]) : (dc.equals("-1") ? ResManager.loadKDString((String)"\u8d37", (String)"ReportPrintHelper_1", (String)"fi-gl-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e73", (String)"ReportPrintHelper_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            printRow.set(fieldKey, (Object)dc);
        }
    }

    protected static void handleDcFields(DynamicObject rowData, DataRowSet printRow, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        for (String fieldKey : existPropertys) {
            String dc = rowData.getString(fieldKey);
            if (dc == null) continue;
            dc = dc.equals("1") ? ResManager.loadKDString((String)"\u501f", (String)"ReportPrintHelper_0", (String)"fi-gl-formplugin", (Object[])new Object[0]) : (dc.equals("-1") ? ResManager.loadKDString((String)"\u8d37", (String)"ReportPrintHelper_1", (String)"fi-gl-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e73", (String)"ReportPrintHelper_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            printRow.add(fieldKey, (Field)new TextField(dc));
        }
    }

    protected static void handleQtyFields(DynamicObject rowData, DynamicObject printRow, boolean showZero, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        for (String fieldKey : existPropertys) {
            BigDecimal qty = rowData.getBigDecimal(fieldKey);
            if (qty == null || !showZero && qty.compareTo(BigDecimal.ZERO) == 0) continue;
            printRow.set(fieldKey, (Object)(qty + ""));
        }
    }

    protected static void handleQtyFields(DynamicObject rowData, DynamicObject printRow, boolean showZero, String measureunitField, FormatObject fobj, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        if (!existPropertys.isEmpty()) {
            int minimumFractionDigits = 10;
            DynamicObject measureunitDyn = rowData.getDynamicObject(measureunitField);
            if (measureunitDyn != null) {
                minimumFractionDigits = measureunitDyn.getInt("precision");
            }
            fobj.getNumberFormat().setMinimumFractionDigits(minimumFractionDigits);
            Format format = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(fobj);
            for (String fieldKey : existPropertys) {
                BigDecimal qty = rowData.getBigDecimal(fieldKey);
                if (qty == null || !showZero && qty.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.set(fieldKey, (Object)format.format(qty));
            }
        }
    }

    protected static void handleQtyFields(DynamicObject rowData, DataRowSet printRow, boolean showZero, String measureunitField, FormatObject fobj, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        if (!existPropertys.isEmpty()) {
            int minimumFractionDigits = 10;
            DynamicObject measureunitDyn = rowData.getDynamicObject(measureunitField);
            if (measureunitDyn != null) {
                minimumFractionDigits = measureunitDyn.getInt("precision");
            }
            fobj.getNumberFormat().setMinimumFractionDigits(minimumFractionDigits);
            Format format = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(fobj);
            for (String fieldKey : existPropertys) {
                BigDecimal qty = rowData.getBigDecimal(fieldKey);
                if (qty == null || !showZero && qty.compareTo(BigDecimal.ZERO) == 0) continue;
                printRow.add(fieldKey, (Field)new TextField(format.format(qty)));
            }
        }
    }

    protected static void handleBaseDataFilterInfo(FilterInfo filterInfo, DynamicObject printDyn, String ... filterItems) {
        for (String itemKey : filterItems) {
            DynamicObject filterObj = filterInfo.getDynamicObject(itemKey);
            if (filterObj == null) continue;
            printDyn.set(itemKey, (Object)filterObj.getString("name"));
        }
    }

    protected static void handleMulBaseDataFilterInfo(FilterInfo filterInfo, DynamicObject printDyn, String ... filterItems) {
        for (String itemKey : filterItems) {
            DynamicObjectCollection vals = filterInfo.getDynamicObjectCollection(itemKey);
            if (vals == null) continue;
            StringBuilder sb = new StringBuilder();
            for (DynamicObject val : vals) {
                if (val == null) continue;
                sb.append(val.getString("name"));
                sb.append("\uff1b");
            }
            printDyn.set(itemKey, (Object)sb.substring(0, sb.length() - 1));
        }
    }

    protected static void handleBaseDataFilterInfo(FilterInfo filterInfo, DataRowSet printDyn, String ... filterItems) {
        for (String itemKey : filterItems) {
            DynamicObject filterObj = filterInfo.getDynamicObject(itemKey);
            if (filterObj == null) continue;
            printDyn.add(itemKey, (Field)new TextField(filterObj.getString("name")));
        }
    }

    protected static void handleAccountBaseDataFilterInfo(FilterInfo filterInfo, DataRowSet dataRowSet, String ... filterItems) {
        for (String itemKey : filterItems) {
            DynamicObject filterObj = filterInfo.getDynamicObject(itemKey);
            if (filterObj == null) continue;
            dataRowSet.add(itemKey, (Field)new TextField(filterObj.getString("id")));
        }
    }

    protected static void handleMulBaseDataFilterInfo(FilterInfo filterInfo, DataRowSet printDyn, String ... filterItems) {
        for (String itemKey : filterItems) {
            DynamicObjectCollection vals = filterInfo.getDynamicObjectCollection(itemKey);
            if (vals == null) continue;
            StringBuilder sb = new StringBuilder();
            for (DynamicObject val : vals) {
                if (val == null) continue;
                sb.append(val.getString("name"));
                sb.append("\uff1b");
            }
            printDyn.add(itemKey, (Field)new TextField(sb.substring(0, sb.length() - 1)));
        }
    }

    protected static void handleDateFilterInfo(FilterInfo filterInfo, DynamicObject printDyn, Format timeFormat, String ... filterItems) {
        for (String field : filterItems) {
            Date date = filterInfo.getDate(field);
            if (date == null) continue;
            printDyn.set(field, (Object)timeFormat.format(date));
        }
    }

    protected static void handleDateFilterInfo(FilterInfo filterInfo, DataRowSet printDyn, Format timeFormat, String ... filterItems) {
        for (String field : filterItems) {
            Date date = filterInfo.getDate(field);
            if (date == null) continue;
            printDyn.add(field, (Field)new TextField(timeFormat.format(date)));
        }
    }

    protected static void handleFlexFields(DynamicObject rowData, DynamicObject printRow, Set<String> hgValueSet, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        for (String fieldKey : existPropertys) {
            DynamicObject assgrpDyn = rowData.getDynamicObject(fieldKey);
            if (assgrpDyn == null) continue;
            String valueStr = assgrpDyn.getString("value");
            hgValueSet.add(valueStr);
            printRow.set(fieldKey, (Object)valueStr);
        }
    }

    protected static void handleFlexFields(DynamicObject rowData, DataRowSet printRow, Set<String> hgValueSet, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        for (String fieldKey : existPropertys) {
            DynamicObject assgrpDyn = rowData.getDynamicObject(fieldKey);
            if (assgrpDyn == null) continue;
            String valueStr = assgrpDyn.getString("value");
            hgValueSet.add(valueStr);
            printRow.add(fieldKey, (Field)new TextField(valueStr));
        }
    }

    protected static void handleDateFlexFields(DynamicObject rowData, DataRowSet printRow, Table<Long, Date, Set<String>> orgBookedDateAssgrp, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        for (String fieldKey : existPropertys) {
            DynamicObject assgrpDyn = rowData.getDynamicObject(fieldKey);
            if (assgrpDyn == null) continue;
            String valueStr = assgrpDyn.getString("value");
            HashSet<String> assgrpValueSet = (HashSet<String>)orgBookedDateAssgrp.get((Object)rowData.getLong("orgname_id"), (Object)rowData.getDate("bookeddate"));
            if (CollectionUtils.isEmpty((Collection)assgrpValueSet)) {
                assgrpValueSet = new HashSet<String>(32);
                orgBookedDateAssgrp.put((Object)rowData.getLong("orgname_id"), (Object)rowData.getDate("bookeddate"), assgrpValueSet);
            }
            assgrpValueSet.add(valueStr);
            printRow.add(fieldKey, (Field)new TextField(valueStr));
        }
    }

    protected static void handleFlexIntoToStr(List<DynamicObject> printRows, Set<String> hgValueSet, String ... flexFields) {
        Map<Object, Map<String, String>> flexToValueToName = ReportPrintHelper.getHgToValueBd(hgValueSet);
        Map<String, String> flexfieldToName = flexToValueToName.get("name");
        for (DynamicObject printRow : printRows) {
            for (String fieldKey : flexFields) {
                String ass = printRow.getString(fieldKey);
                if (StringUtils.isBlank((CharSequence)ass)) continue;
                JSONObject valueJson = JSONObject.parseObject((String)ass);
                StringBuilder itemsStr = new StringBuilder();
                for (Map.Entry map : valueJson.entrySet()) {
                    Map<String, String> valueToName;
                    String key = (String)map.getKey();
                    String value = map.getValue().toString();
                    String name = flexfieldToName.get(key);
                    if (name != null) {
                        itemsStr.append(name).append(":");
                    }
                    String valueStr = (valueToName = flexToValueToName.get(key)) != null ? (valueToName.get(value) != null ? valueToName.get(value) : "") : ((valueToName = flexToValueToName.get("assist")) != null ? (valueToName.get(value) != null ? valueToName.get(value) : value) : value);
                    itemsStr.append(valueStr).append(" \n");
                }
                printRow.set(fieldKey, (Object)itemsStr.substring(0, itemsStr.length() - 2));
            }
        }
    }

    protected static void handleFlexIntoToStrNew(Long orgId, List<DataRowSet> printRows, Format timeFormat, Map<Date, Set<String>> bookedDateHgMap, String ... flexFields) {
        Map<Object, Map<String, String>> flexToValueToName = ReportPrintHelper.getHgToValueBd(orgId, timeFormat, bookedDateHgMap);
        String datePrefix = timeFormat.format(bookedDateHgMap.keySet().iterator().next());
        ReportPrintHelper.fillPrintRows(orgId, printRows, datePrefix, flexToValueToName, flexFields);
    }

    private static void fillPrintRows(Long orgId, List<DataRowSet> printRows, String datePrefix, Map<Object, Map<String, String>> flexToValueToName, String[] flexFields) {
        Map<String, String> flexfieldToName = flexToValueToName.get("name");
        String orgPrefix = "";
        if (orgId != null) {
            orgPrefix = orgId.toString();
        }
        for (DataRowSet printRow : printRows) {
            for (String fieldKey : flexFields) {
                String ass = (String)printRow.getField(fieldKey).getValue();
                if (StringUtils.isBlank((CharSequence)ass)) continue;
                JSONObject valueJson = JSONObject.parseObject((String)ass);
                StringBuilder itemsStr = new StringBuilder();
                for (Map.Entry map : valueJson.entrySet()) {
                    String flexKey;
                    Map<String, String> valueToName;
                    String key = (String)map.getKey();
                    String value = map.getValue().toString();
                    String name = flexfieldToName.get(key);
                    if (name != null) {
                        itemsStr.append(name).append(":");
                    }
                    String valueStr = (valueToName = flexToValueToName.get(flexKey = String.format("%s_%s_%s", StringUtils.isEmpty((CharSequence)orgPrefix) ? printRow.getField("org") : orgPrefix, StringUtils.isEmpty((CharSequence)datePrefix) ? printRow.getField("bookeddate") : datePrefix, key))) != null ? (valueToName.get(value) != null ? valueToName.get(value) : "") : ((valueToName = flexToValueToName.get("assist")) != null ? (valueToName.get(value) != null ? valueToName.get(value) : value) : value);
                    itemsStr.append(valueStr).append(" \n");
                }
                printRow.add(fieldKey, (Field)new TextField(itemsStr.substring(0, itemsStr.length() - 2)));
            }
        }
    }

    protected static void handleDateFlexIntoToStr(List<DataRowSet> printRows, Format timeFormat, Table<Long, Date, Set<String>> orgBookedDateAssgrp, String ... flexFields) {
        HashMap<Object, Map<String, String>> allFlexToValueToName = new HashMap<Object, Map<String, String>>(64);
        allFlexToValueToName.put("name", new HashMap());
        allFlexToValueToName.put("assist", new HashMap());
        orgBookedDateAssgrp.rowKeySet().stream().forEach(x -> {
            Map bookedDateHgMap = orgBookedDateAssgrp.row(x);
            Map<Object, Map<String, String>> flexToValueToName = ReportPrintHelper.getHgToValueBd(x, timeFormat, bookedDateHgMap);
            flexToValueToName.entrySet().stream().forEach(entry -> {
                if (!((Map)entry.getValue()).isEmpty()) {
                    if (Objects.equals(entry.getKey(), "name")) {
                        ((Map)allFlexToValueToName.get("name")).putAll((Map)entry.getValue());
                    } else if (Objects.equals(entry.getKey(), "assist")) {
                        ((Map)allFlexToValueToName.get("assist")).putAll((Map)entry.getValue());
                    } else {
                        allFlexToValueToName.put(entry.getKey(), (Map<String, String>)entry.getValue());
                    }
                }
            });
        });
        ReportPrintHelper.fillPrintRows(null, printRows, "", allFlexToValueToName, flexFields);
    }

    private static Map<Object, Map<String, String>> getHgToValueBd(Set<String> hgValueSet) {
        HashMap<Object, Map<String, String>> flexToValueToName;
        block39: {
            flexToValueToName = new HashMap<Object, Map<String, String>>();
            Map<String, Set<Object>> flexToValues = ReportPrintHelper.getFlexToValues(hgValueSet);
            String selectFields = "name, valuesource.number formid, flexfield";
            QFilter filters = new QFilter("flexfield", "in", flexToValues.keySet());
            try (DataSet asstypes = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.report.ReportPrintHelper.getHgToValueBd", (String)"bd_asstacttype", (String)selectFields, (QFilter[])filters.toArray(), null);){
                String formid;
                HashMap<String, String> flexfieldToName = new HashMap<String, String>();
                HashMap<String, String> flexfieldToFormId = new HashMap<String, String>();
                for (Object row : asstypes) {
                    String string = row.getString("flexfield");
                    String name = row.getString("name");
                    flexfieldToName.put(string, name);
                    formid = row.getString("formid");
                    if (formid == null) continue;
                    flexfieldToFormId.put(string, formid);
                }
                flexToValueToName.put("name", flexfieldToName);
                HashSet allAssSet = new HashSet();
                for (Map.Entry entry : flexToValues.entrySet()) {
                    String key = (String)entry.getKey();
                    formid = (String)flexfieldToFormId.get(key);
                    if ("bos_assistantdata_detail".equals(formid) || "bos_assistantdatagroup".equals(formid)) {
                        allAssSet.addAll((Collection)entry.getValue());
                        continue;
                    }
                    if (formid == null) continue;
                    filters = new QFilter("id", "in", entry.getValue());
                    BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)formid);
                    String nameProp = entityType.getNameProperty();
                    DataSet entitys = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.report.ReportPrintHelper.getHgToValueBd", (String)formid, (String)("id, " + nameProp), (QFilter[])filters.toArray(), null);
                    Throwable throwable = null;
                    try {
                        HashMap<String, String> valueToName = new HashMap<String, String>();
                        for (Row row : entitys) {
                            String id = row.getString("id");
                            String name = row.getString(nameProp);
                            valueToName.put(id, name);
                        }
                        flexToValueToName.put(key, valueToName);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (entitys == null) continue;
                        if (throwable != null) {
                            try {
                                entitys.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        entitys.close();
                    }
                }
                if (allAssSet.isEmpty()) break block39;
                filters = new QFilter("id", "in", allAssSet);
                Throwable throwable = null;
                try (DataSet entitys = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.report.ReportPrintHelper.getHgToValueBd", (String)"bos_assistantdata_detail", (String)"id, name", (QFilter[])filters.toArray(), null);){
                    HashMap<String, String> valueToName = new HashMap<String, String>();
                    for (Row row : entitys) {
                        String id = row.getString("id");
                        String name = row.getString("name");
                        valueToName.put(id, name);
                    }
                    flexToValueToName.put("assist", valueToName);
                }
                catch (Throwable throwable4) {
                    Throwable throwable5 = throwable4;
                    throw throwable4;
                }
            }
        }
        return flexToValueToName;
    }

    public static Map<Object, Map<String, String>> getHgToValueBd(Long orgId, Format timeFormat, Map<Date, Set<String>> bookedDateHgMap) {
        HashMap<Object, Map<String, String>> flexToValueToName = new HashMap<Object, Map<String, String>>();
        HashMap dateFlexToValues = new HashMap(16);
        bookedDateHgMap.entrySet().forEach(entry -> dateFlexToValues.put(entry.getKey(), ReportPrintHelper.getFlexToValues((Set)entry.getValue())));
        HashMap<String, String> flexfieldToName = new HashMap<String, String>();
        flexToValueToName.put("name", flexfieldToName);
        HashMap<String, String> assistValueToName = new HashMap<String, String>();
        flexToValueToName.put("assist", assistValueToName);
        for (Map.Entry<Date, Set<String>> dateEntry : bookedDateHgMap.entrySet()) {
            Map<String, Set<Object>> flexToValues = ReportPrintHelper.getFlexToValues(dateEntry.getValue());
            String selectFields = "name, valuesource.number formid, flexfield";
            QFilter filters = new QFilter("flexfield", "in", flexToValues.keySet());
            DataSet asstypes = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.report.ReportPrintHelper.getHgToValueBd", (String)"bd_asstacttype", (String)selectFields, (QFilter[])filters.toArray(), null);
            Throwable throwable = null;
            try {
                String formid;
                Object row2;
                HashMap<String, String> flexfieldToFormId = new HashMap<String, String>();
                for (Object row2 : asstypes) {
                    String flexno = row2.getString("flexfield");
                    String name = row2.getString("name");
                    flexfieldToName.put(flexno, name);
                    formid = row2.getString("formid");
                    if (formid == null) continue;
                    flexfieldToFormId.put(flexno, formid);
                }
                HashSet allAssSet = new HashSet();
                row2 = flexToValues.entrySet().iterator();
                while (row2.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)row2.next();
                    String key = (String)entry2.getKey();
                    formid = (String)flexfieldToFormId.get(key);
                    if ("bos_assistantdata_detail".equals(formid) || "bos_assistantdatagroup".equals(formid)) {
                        allAssSet.addAll((Collection)entry2.getValue());
                        continue;
                    }
                    if (formid == null) continue;
                    BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)formid);
                    String nameProp = entityType.getNameProperty();
                    NameHistoryVO nameHistoryVO = new NameHistoryVO();
                    nameHistoryVO.setOrgId(orgId);
                    nameHistoryVO.setNameCtrlDate(dateEntry.getKey());
                    nameHistoryVO.setSelectFields(String.format("id,%s name", nameProp));
                    nameHistoryVO.setEntityId(formid);
                    ((Set)entry2.getValue()).forEach(x -> nameHistoryVO.addAssId(Long.valueOf(x.toString())));
                    List<NameHistoryVO> nameHistoryVOList = Collections.singletonList(nameHistoryVO);
                    BaseDataUtil.queryBaseDataByDate(nameHistoryVOList);
                    HashMap valueToName = new HashMap(nameHistoryVO.getAssIdNameMap().size());
                    for (Map.Entry assIdNameEntry : nameHistoryVO.getAssIdNameMap().entrySet()) {
                        valueToName.put(String.valueOf(assIdNameEntry.getKey()), assIdNameEntry.getValue());
                    }
                    String resultKey = String.format("%s_%s_%s", orgId, timeFormat.format(dateEntry.getKey()), key);
                    flexToValueToName.put(resultKey, valueToName);
                }
                if (allAssSet.isEmpty()) continue;
                filters = new QFilter("id", "in", allAssSet);
                DataSet entitys = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.report.ReportPrintHelper.getHgToValueBd", (String)"bos_assistantdata_detail", (String)"id, name", (QFilter[])filters.toArray(), null);
                Throwable throwable2 = null;
                try {
                    for (Row row3 : entitys) {
                        String id = row3.getString("id");
                        String name = row3.getString("name");
                        assistValueToName.put(id, name);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (entitys == null) continue;
                    if (throwable2 != null) {
                        try {
                            entitys.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    entitys.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (asstypes == null) continue;
                if (throwable != null) {
                    try {
                        asstypes.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                asstypes.close();
            }
        }
        return flexToValueToName;
    }

    protected static void handleCurrencyNameById(FilterInfo filterInfo, DynamicObject printDyn, String field) {
        String id = filterInfo.getString(field);
        String name = (String)ThreadCache.get((Object)(ReportPrintHelper.class.getName() + id), () -> {
            DynamicObject dyn;
            if ("basecurrency".equals(id)) {
                return ResManager.loadKDString((String)"\u7efc\u5408\u672c\u4f4d\u5e01", (String)"ReportPrintHelper_3", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            }
            if ("allcurrency".equals(id)) {
                return ResManager.loadKDString((String)"\u6240\u6709\u5e01\u79cd", (String)"ReportPrintHelper_4", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            }
            if (StringUtils.isNotBlank((CharSequence)id) && (dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"name", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(id)).toArray())) != null) {
                return dyn.getString("name");
            }
            return "";
        });
        printDyn.set(field, (Object)name);
    }

    protected static void handleCurrencyNameById(FilterInfo filterInfo, DataRowSet printDyn, String field) {
        String id = filterInfo.getString(field);
        String name = (String)ThreadCache.get((Object)(ReportPrintHelper.class.getName() + id), () -> {
            DynamicObject dyn;
            if ("basecurrency".equals(id)) {
                return ResManager.loadKDString((String)"\u7efc\u5408\u672c\u4f4d\u5e01", (String)"ReportPrintHelper_3", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            }
            if ("allcurrency".equals(id)) {
                return ResManager.loadKDString((String)"\u6240\u6709\u5e01\u79cd", (String)"ReportPrintHelper_4", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            }
            if (StringUtils.isNotBlank((CharSequence)id) && (dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"name", (QFilter[])new QFilter("id", "=", (Object)Long.valueOf(id)).toArray())) != null) {
                return dyn.getString("name");
            }
            return "";
        });
        printDyn.add(field, (Field)new TextField(name));
    }

    protected static void handleMulCur(FilterInfo filterInfo, DataRowSet printDyn, List<String> queryField) {
        String[] mulCurFields;
        for (String mulCurField : mulCurFields = ReportPrintHelper.getExistFileds(queryField, new String[]{"mulcur", "localcur"})) {
            Long localCurId;
            DynamicObject dyn;
            if (Objects.equals(mulCurField, "mulcur")) {
                String mulCur = filterInfo.getString("mulcur");
                String mulCurText = GlFormUtil.getMulCurText(mulCur);
                printDyn.add("mulcur", (Field)new TextField(mulCurText));
            }
            if (!Objects.equals(mulCurField, "localcur")) continue;
            String localCurName = "";
            if (Objects.nonNull(filterInfo.getCommFilter("localcur")) && (dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"name", (QFilter[])new QFilter("id", "=", (Object)(localCurId = Long.valueOf(filterInfo.getCommFilter("localcur").getValue().toString()))).toArray())) != null) {
                localCurName = dyn.getString("name");
            }
            printDyn.add("localcur", (Field)new TextField(localCurName));
        }
    }

    protected static String[] getExistFileds(CustomPrintDataEntitiesArgs e, String[] allFields) {
        Set<String> allFieldSet = Stream.of(allFields).collect(Collectors.toSet());
        Set customFields = e.getCustomFields();
        if (customFields != null) {
            allFieldSet.retainAll(customFields);
        }
        return allFieldSet.toArray(new String[0]);
    }

    protected static String[] getExistFileds(List<String> cusField, String[] allFields) {
        Set<String> allFieldSet = Stream.of(allFields).collect(Collectors.toSet());
        if (cusField != null) {
            allFieldSet.retainAll(cusField);
        }
        return allFieldSet.toArray(new String[0]);
    }

    protected static String[] getExistListFileds(List<String> cusField, String[] allFields) {
        List<String> allFieldList = Stream.of(allFields).collect(Collectors.toList());
        if (cusField != null) {
            allFieldList.retainAll(cusField);
        }
        return allFieldList.toArray(new String[0]);
    }

    private static Map<String, Set<Object>> getFlexToValues(Set<String> hgValueSet) {
        HashMap<String, Set<Object>> flexToValues = new HashMap<String, Set<Object>>();
        for (String str : hgValueSet) {
            JSONObject valueJson = JSONObject.parseObject((String)str);
            for (Map.Entry map : valueJson.entrySet()) {
                String key = (String)map.getKey();
                if (flexToValues.get(key) == null) {
                    HashSet values = new HashSet();
                    values.add(map.getValue());
                    flexToValues.put(key, values);
                    continue;
                }
                ((Set)flexToValues.get(key)).add(map.getValue());
            }
        }
        return flexToValues;
    }

    protected static ReportListModel getListModel(String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null || !(view instanceof ReportView)) {
            return null;
        }
        ReportView reportView = (ReportView)view;
        ReportList list = reportView.getReportList();
        ReportListModel listModel = (ReportListModel)list.getReportModel();
        return listModel;
    }

    protected static void handleCatalogary(String[] headListField, DataRowSet printDyn, String[] filterItems) {
        for (int i = 0; i < headListField.length; ++i) {
            printDyn.add(filterItems[i], (Field)new TextField(headListField[i]));
        }
    }

    protected static String getPageNumType(String formId) {
        String userId = RequestContext.get().getUserId();
        String key = formId + CFG_SUFFIX;
        String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(userId), (String)key);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
            Object pageNumType = jsonData.get("pageNumType");
            return pageNumType == null ? "2" : (String)pageNumType;
        }
        return "2";
    }

    public static String getFlexField(FilterInfo filter) {
        ArrayList<String> flexFields = new ArrayList<String>(2);
        List flexFilterItems = filter.getFlexFilterItems();
        for (FilterItemInfo flexFilterItem : flexFilterItems) {
            if (kd.bos.ext.fi.util.StringUtils.isEmpty((String)flexFilterItem.getPropName())) continue;
            flexFields.add(flexFilterItem.getPropName());
        }
        Map asstTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", flexFields)});
        StringBuilder sb = new StringBuilder();
        for (Map.Entry dynamicObjectEntry : asstTypeMap.entrySet()) {
            String name = ((OrmLocaleValue)((DynamicObject)dynamicObjectEntry.getValue()).get("name")).getLocaleValue();
            sb.append(name).append(";");
        }
        if (sb.toString().length() < 1) {
            return "";
        }
        return sb.substring(0, sb.toString().length() - 1);
    }

    protected static void handleComboFields(DynamicObject rowData, DataRowSet printRow, String ... fieldKeys) {
        List<String> existPropertys = ReportPrintHelper.existProperty(rowData, fieldKeys);
        MainEntityType voucherEntity = EntityMetadataCache.getDataEntityType((String)"gl_voucher");
        for (String fieldKey : existPropertys) {
            voucherEntity.getAllFields().entrySet().forEach(stringIDataEntityPropertyEntry -> {
                String rowDataString;
                String string = rowDataString = rowData.getString(fieldKey) == null ? "" : rowData.getString(fieldKey);
                if (fieldKey.equals(stringIDataEntityPropertyEntry.getKey())) {
                    if (stringIDataEntityPropertyEntry.getValue() instanceof ComboProp) {
                        printRow.add(fieldKey, (Field)new TextField(((ComboProp)stringIDataEntityPropertyEntry.getValue()).getItemByName(rowDataString)));
                    } else {
                        printRow.add(fieldKey, (Field)new TextField(rowDataString));
                    }
                }
            });
        }
    }
}

