/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.exportall;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class ReportExportAllProcessFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String LISTNAME = "listname";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String ENTITYNAME = "entityname";
    private static final String QUERYPARAM = "queryparam";
    private static final String SELECTOBJ = "selectobj";
    private boolean canClose = false;

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        boolean isStart = this.isStart();
        if (isStart && !StringUtils.isEmpty((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo.isTaskEnd()) {
                this.complete(taskInfo, e);
            } else {
                int progress = taskInfo.getProgress();
                if (progress >= 100) {
                    progress = 99;
                } else if (progress < 0) {
                    progress = 0;
                }
                this.showExportDetails(taskInfo);
                e.setProgress(progress);
            }
        }
    }

    private void complete(TaskInfo taskInfo, ProgressEvent e) {
        Map<String, Object> taskData;
        boolean isFinished = this.isFinish();
        this.setFinish(true);
        Map map = taskData = taskInfo.getData() == null ? new HashMap(0) : (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            String errMsg = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"ReportExportAllProcessFormPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok"});
            this.getView().showErrorNotification(errMsg);
            this.stopBar();
        } else if (!isFinished) {
            e.setProgress(99);
            this.showExportDetails(taskInfo);
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok"});
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            if (taskData.containsKey("failReason")) {
                parentView.showTipNotification(taskData.get("failReason").toString());
            }
            this.downloadFile(parentView, taskData);
            this.getView().sendFormAction(parentView);
            e.setProgress(100);
            this.stopBar();
            this.close();
            this.getCurrentAppCache().remove(this.getCurrentAppCacheKey());
        }
    }

    private void close() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void downloadFile(IFormView view, Map<String, Object> taskData) {
        String url;
        if (!taskData.get("complete").equals(taskData.get("total"))) {
            this.showTipNotification(view);
        } else if (this.getCurrentAppCache().get(this.getCurrentAppCacheKey(), String.class) != null) {
            this.showTipNotification(view);
            this.getCurrentAppCache().remove(this.getCurrentAppCacheKey());
        } else if (taskData.containsKey("downloadurl") && StringUtils.isNotBlank((CharSequence)(url = (String)taskData.get("downloadurl")))) {
            view.download(url);
        }
    }

    private void showTipNotification(IFormView view) {
        view.hideLoading();
        this.setSuspending(false);
        String msg = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5df2\u88ab\u4e2d\u6b62\u3002", (String)"ReportExportAllProcessFormPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        view.showTipNotification(msg);
    }

    private void setQueryTask() {
        JobFormInfo info = this.buildJobInfo();
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)info.getJobInfo());
        this.putTaskId(taskId);
        this.setStart(true);
    }

    private JobFormInfo buildJobInfo() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u62a5\u8868\u5bfc\u51fa-%s", (String)"ReportExportAllProcessFormPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), this.getEntityName()));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setAppId(this.getView().getFormShowParameter().getServiceAppId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setTaskClassname("kd.fi.gl.report.exportall.ReportExportAllTask");
        HashMap<String, Object> param = new HashMap<String, Object>(5);
        param.put("parentpageid", this.getView().getFormShowParameter().getParentPageId());
        param.put(ENTITYNUMBER, this.getEntityNumber());
        param.put(ENTITYNAME, this.getEntityName());
        param.put(QUERYPARAM, this.getQueryParam());
        param.put(SELECTOBJ, this.getSelectObj());
        param.put("requestcontext", RequestContext.get());
        jobInfo.setParams(param);
        JobFormInfo info = new JobFormInfo();
        info.setCanBackground(true);
        info.setParentPageId(this.getView().getParentView().getPageId());
        info.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        info.setParentPageId(this.getView().getParentView().getPageId());
        info.setJobInfo(jobInfo);
        info.getParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        if (this.getView().getFormShowParameter().getCloseCallBack() != null) {
            info.setCloseCallBack(this.getView().getFormShowParameter().getCloseCallBack());
        } else {
            CloseCallBack closeCallBack = new CloseCallBack("kd.bos.form.plugin.expt.ExportCallBack", "background_actionid");
            info.setCloseCallBack(closeCallBack);
        }
        info.setClickClassName("kd.bos.form.plugin.report.ReportExportTaskClick");
        return info;
    }

    public void click(EventObject evt) {
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("btncancel".equals(controlKey)) {
            String msg = ResManager.loadKDString((String)"\u5bfc\u51fa\u6b63\u5728\u7ec8\u6b62\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"ReportExportAllProcessFormPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            this.getView().showLoading(new LocaleString(msg));
            this.getView().setVisible(Boolean.FALSE, new String[]{"exportpanel"});
            this.getCurrentAppCache().put(this.getCurrentAppCacheKey(), (Object)this.getCurrentAppCacheKey());
            this.setSuspending(true);
        } else if ("btnok".equals(controlKey)) {
            this.stopBar();
            this.toBackground();
        }
    }

    private void toBackground() {
        this.close();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (!TaskClientProxy.isExistTask((String)taskId)) {
                JobFormInfo jobFormInfo = this.buildJobInfo();
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
                ThreadService.execute((Runnable)subscriber, (TaskType)TaskType.GL_REPORT_EXPORT_ALL_BACKGROUND_MONITOR);
            }
        }
    }

    private IAppCache getCurrentAppCache() {
        return AppCache.get((String)EntityMetadataCache.getDataEntityType((String)this.getEntityNumber()).getAppId());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (this.isStart() && !this.isSuspending()) {
            if (!this.canClose && !this.isFinish() && StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u5bfc\u51fa\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"ReportExportAllProcessFormPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_CONFIRMED", (IFormPlugin)this));
                this.stopBar();
                e.setCancel(true);
            }
        } else {
            e.setCancel(true);
        }
    }

    private boolean isSuspending() {
        String suspending = this.getPageCache().get(this.getCurrentAppCacheKey());
        return StringUtils.isBlank((CharSequence)suspending) ? false : Boolean.parseBoolean(suspending);
    }

    private void setSuspending(boolean suspending) {
        this.getPageCache().put(this.getCurrentAppCacheKey(), String.valueOf(suspending));
    }

    private String getCurrentAppCacheKey() {
        return "EXPT_SUSPEND_" + this.getEntityNumber();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Label title = (Label)this.getControl(LISTNAME);
        String text = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa%s\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"ReportExportAllProcessFormPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), this.getEntityName());
        title.setText(text);
        this.startBar();
        String taskId = this.getTaskId();
        boolean isStart = this.isStart();
        if (!isStart && StringUtils.isEmpty((CharSequence)taskId)) {
            this.setQueryTask();
        }
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            bar.setPercent(progress);
            this.showExportDetails(taskInfo);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getCallBackId().equals("CLOSE_CONFIRMED")) {
            int result = e.getResult().getValue();
            if (result == MessageBoxResult.Yes.getValue()) {
                this.toBackground();
            } else {
                this.startBar();
            }
        }
    }

    private void showExportDetails(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (!StringUtils.isBlank((CharSequence)strData)) {
            Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
            String unKnown = ResManager.loadKDString((String)"\u672a\u77e5", (String)"ReportExportAllProcessFormPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            String totalCount = data.containsKey("total") ? String.valueOf(data.get("total")) : unKnown;
            String completeCount = data.containsKey("complete") ? String.valueOf(data.get("complete")) : unKnown;
            Label totalLabel = (Label)this.getControl("total");
            totalLabel.setText(totalCount);
            Label completeLabel = (Label)this.getControl("complete");
            completeLabel.setText(completeCount);
            if (data.containsKey("total")) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"inittips"});
                HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
                notHidden.put("gr", 1);
                this.getView().updateControlMetadata("progressdatas", notHidden);
            }
        }
    }

    private boolean isStart() {
        return this.getPageCache().get("isstart") == null ? false : Boolean.parseBoolean(this.getPageCache().get("isstart"));
    }

    private void setStart(boolean isStart) {
        this.getPageCache().put("isstart", String.valueOf(isStart));
    }

    private boolean isFinish() {
        return this.getPageCache().get("isfinish") == null ? false : Boolean.parseBoolean(this.getPageCache().get("isfinish"));
    }

    private void setFinish(boolean isFinish) {
        this.getPageCache().put("isfinish", String.valueOf(isFinish));
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put("export_taskid", taskId);
    }

    private String getTaskId() {
        return this.getView().getFormShowParameter().getCustomParams().containsKey("export_taskid") ? (String)this.getView().getFormShowParameter().getCustomParam("export_taskid") : this.getPageCache().get("export_taskid");
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.stop();
    }

    private String getEntityName() {
        return (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNAME);
    }

    private String getEntityNumber() {
        return (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
    }

    private Object getQueryParam() {
        return this.getView().getFormShowParameter().getCustomParam(QUERYPARAM);
    }

    private Object getSelectObj() {
        return this.getView().getFormShowParameter().getCustomParam(SELECTOBJ);
    }
}

