/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.exportall;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDException;
import kd.bos.form.control.UrlUtil;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.export.ExportProgress;
import kd.bos.mvc.export.ExportProgressImpl;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.AbstractReportModel;
import kd.bos.report.ReportList;
import kd.bos.schedule.executor.AbstractTask;
import kd.fi.bd.model.JsonObjectAdapter;

public class ReportExportAllTask
extends AbstractTask {
    protected static final String REPORT_LIST_AP = "reportlistap";
    private ExportProgress exportProgress;
    private static DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));

    public ExportProgress getExportProgress() {
        if (this.exportProgress == null) {
            this.exportProgress = new ExportProgressImpl(this.taskId);
        }
        return this.exportProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Object context = map.get("requestcontext");
        if (StringUtils.isNotBlank((Object)context)) {
            RequestContext reqctx = context instanceof RequestContext ? (RequestContext)context : (RequestContext)((JSONObject)context).toJavaObject(RequestContext.class);
            RequestContext.set((RequestContext)reqctx);
            requestContext = reqctx;
        }
        String queyrparam = (String)map.get("queryparam");
        String pageId = (String)map.get("parentpageid");
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)queyrparam);
        queryParam.setMulLang(requestContext.getLang());
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        ReportList list = (ReportList)view.getControl(REPORT_LIST_AP);
        Object param = map.get("selectobj");
        if (Objects.nonNull(param)) {
            param = SerializationUtils.deSerializeFromBase64((String)((String)param));
        }
        String taskId = Uuid16.create().toString();
        IReportCache reportCache = ReportCacheManager.getInstance().getCache();
        reportCache.setReportQueryParam(taskId, queryParam);
        AbstractReportModel reportModel = (AbstractReportModel)list.getReportModel();
        reportModel.setPageId(taskId);
        view.setExportProgress(this.getExportProgress());
        try {
            list.setAsynQuery(true);
            list.submitTask(queryParam, param);
            int total = list.getTotalRecords();
            this.getExportProgress().feedbackProgress(total, 0);
            String url = list.exportExcel();
            this.getExportProgress().feedbackProgress(total, total);
            if (StringUtils.isNotEmpty((CharSequence)url)) {
                String attachId;
                if (!(url = url + "&fId=" + view.getEntityId() + "&appId=" + view.getServiceAppId(view.getPageId())).contains("tempfile/download.do?configKey") && StringUtils.isNotBlank((CharSequence)(attachId = UrlUtil.getParam((String)url, (String)"attachId")))) {
                    HashMap<String, String> attachInfoMap = new HashMap<String, String>();
                    attachInfoMap.put("logEntityNum", "report_export");
                    attachInfoMap.put("entityNum", view.getEntityId());
                    attachInfoMap.put("permisssionItemId", "0YH1MN9OTQ4J");
                    redisCache.put(attachId, (Object)SerializationUtils.toJsonString(attachInfoMap), 28800);
                }
                this.exportProgress.feedbackFileUrl(url);
            } else {
                this.exportProgress.feedbackCustData((Map)JsonObjectAdapter.getEmpty().registerContext("failReason", (Object)ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"ReportExportAllTask_2", (String)"fi-gl-formplugin", (Object[])new Object[0])).getSource());
            }
        }
        finally {
            this.getExportProgress().complete();
            reportModel.close();
            Optional.ofNullable(view.getQueryParam().getFilter().getFilterItem("exportexcel")).ifPresent(exportFilter -> exportFilter.setValue((Object)false));
            reportCache.setReportQueryParam(pageId, view.getQueryParam());
        }
    }
}

