/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.exportall;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.fi.gl.util.GLApp;

public class ReportExportTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs e) {
        super.click(e);
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo == null) {
            return;
        }
        if (!taskInfo.isTaskEnd()) {
            this.showProgress();
        } else {
            this.complete(taskInfo);
        }
        this.sendActionToParent();
    }

    void sendActionToParent() {
        IFormView view = this.getParentView();
        if (view != null && !StringUtils.equals((CharSequence)this.getMainView().getPageId(), (CharSequence)view.getPageId())) {
            this.getMainView().sendFormAction(view);
        }
    }

    void showProgress() {
        if (this.isExistProgressForm()) {
            return;
        }
        IFormView view = this.getParentView();
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (view == null || jobFormInfo == null) {
            this.getMainView().showMessage(ResManager.loadKDString((String)"\u542f\u52a8\u5f15\u51fa\u4efb\u52a1\u7684\u5217\u8868\u754c\u9762\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u518d\u6253\u5f00\u5f15\u51fa\u8fdb\u5ea6\u754c\u9762", (String)"ReportExportTaskClick_0", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = this.newProgressFormShowParam(jobFormInfo);
        view.showForm(showParameter);
        this.setProgressPageId(showParameter.getPageId());
    }

    FormShowParameter newProgressFormShowParam(JobFormInfo jobFormInfo) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gl_reportexportall_subsi");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().putAll(jobFormInfo.getParams());
        showParameter.getCustomParams().put("export_jobforminfo", SerializationUtils.toJsonString((Object)jobFormInfo));
        showParameter.getCustomParams().put("export_taskid", this.getTaskId());
        return showParameter;
    }

    void complete(TaskInfo taskInfo) {
        IFormView view = this.getParentView();
        if (view == null) {
            view = this.getMainView();
        }
        String strData = taskInfo.getData();
        if (taskInfo.isFailure() || StringUtils.isBlank((CharSequence)strData)) {
            this.showFailMessage(view, taskInfo);
            return;
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
        if (data.containsKey("fail") && data.containsKey("failmessage")) {
            boolean fail = (Boolean)data.get("fail");
            String failmessage = (String)data.get("failmessage");
            if (fail && StringUtils.isNotBlank((CharSequence)failmessage)) {
                view.showErrMessage(failmessage, "");
                return;
            }
        }
        this.showExportDetailForm(view);
    }

    void showFailMessage(IFormView view, TaskInfo taskInfo) {
        String failureReason = taskInfo.getFailureReason();
        if (StringUtils.isNotBlank((CharSequence)failureReason)) {
            view.showErrMessage(failureReason, "");
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u540e\u53f0\u4efb\u52a1\u5df2\u7ec8\u6b62\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ReportExportTaskClick_1", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
        }
    }

    void showExportDetailForm(IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gl_report_export_task");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("taskId", (Object)this.getTaskId());
        view.showForm(showParameter);
        TaskClientProxy.delTask((IFormView)this.getMainView(), (String)this.getTaskId());
    }
}

