/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.notice;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.fi.gl.report.notice.NoticeRptConstant;
import kd.fi.gl.report.notice.NoticeRptFormHelper;
import kd.fi.gl.util.GLApp;

public class NoticeCheckFormRpt
extends AbstractReportFormPlugin
implements SelectRowsEventListener {
    public void pageRelease(EventObject e) {
        ReportList sendList = (ReportList)this.getControl("send");
        sendList.close();
        ReportList receiveList = (ReportList)this.getControl("receive");
        receiveList.close();
    }

    public void initialize() {
        super.initialize();
        ReportList sendList = (ReportList)this.getControl("send");
        ReportList receiveList = (ReportList)this.getControl("receive");
        sendList.addSelectRowsListener((SelectRowsEventListener)this);
        receiveList.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList sendList = (ReportList)this.getControl("send");
        ReportList receiveList = (ReportList)this.getControl("receive");
        sendList.addHyperClickListener(evt -> NoticeRptFormHelper.hyperToVoucher(sendList, evt));
        receiveList.addHyperClickListener(evt -> NoticeRptFormHelper.hyperToVoucher(receiveList, evt));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        IDataModel model = this.getModel();
        if (model.getValue("org") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"NoticeCheckFormRpt_0", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return false;
        }
        if (model.getValue("currencyfield") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e01\u79cd\u3002", (String)"NoticeCheckFormRpt_1", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
            return false;
        }
        ReportList sendList = (ReportList)this.getControl("send");
        ReportList receiveList = (ReportList)this.getControl("receive");
        sendList.clearEntryState();
        sendList.setDefaultSelectRow(false);
        sendList.setAsynQuery(false);
        receiveList.clearEntryState();
        receiveList.setDefaultSelectRow(false);
        receiveList.setAsynQuery(false);
        sendList.submitTask(queryParam, null);
        receiveList.submitTask(queryParam, null);
        return super.verifyQuery(queryParam);
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        String[] fields = "amount,billno,creator,account,period,desc,voucherno,vouchertype,dc,cashflowitem,assgrp".split(",");
        String[] sortFields = "bookeddate".split(",");
        allColumns.forEach(column -> {
            for (String field : fields) {
                if (!column.getColumnName().endsWith(field)) continue;
                column.setFilter(true);
                return;
            }
            for (String sortField : sortFields) {
                if (!column.getColumnName().endsWith(sortField)) continue;
                column.setSort(true);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel"});
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel", "receive", "send"});
        this.getModel().setValue(NoticeRptConstant.RECEIVE_TOTAL, (Object)BigDecimal.ZERO);
        this.getModel().setValue(NoticeRptConstant.SEND_TOTAL, (Object)BigDecimal.ZERO);
        this.getModel().setValue(NoticeRptConstant.RECEIVE_ALL_TOTAL, (Object)NoticeRptFormHelper.getSumResult((ReportList)this.getControl("receive")));
        this.getModel().setValue(NoticeRptConstant.SEND_ALL_TOTAL, (Object)NoticeRptFormHelper.getSumResult((ReportList)this.getControl("send")));
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        super.selectRowsChange(evt);
        Object source = evt.getSource();
        if (source instanceof ReportList) {
            ReportList list = (ReportList)source;
            BigDecimal total = NoticeRptFormHelper.getTotalAmount(list, evt.getNewRows());
            this.getModel().setValue(list.getKey() + "total", (Object)total);
        }
    }
}

