/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.subsidiary;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.bd.util.TimerFactory;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.configuration.ReportConfiguration;
import kd.fi.gl.report.subsidiary.AssistBalanceQuery;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SubsiDiaryHelper;
import org.apache.commons.lang3.tuple.Triple;

public class SubsidiaryLeftQuery {
    private static final Log log = LogFactory.getLog(SubsidiaryLeftQuery.class);
    private static final String entryKey = "entryentity";
    private static final String groupStandard = "groupstandard";
    private static final String FIELD_NAME = "fieldname";
    private static final String showType = "showtype";
    private static final String treeName = "treename";
    private static final String treeEntryKey = "treeentryentity";
    private static final String assistBd = "gl_assist_bd";
    private static final String assistTxt = "gl_assist_txt";
    private static final String assType = "asstype";
    private static final String ASSIST_TYPE = "bd_asstacttype";
    private long standardId = 0L;
    private String treeAlias;
    private String entityId;
    private long orgViewId = 1L;

    public DataSet query(ReportQueryParam param, Map<String, Object> paramMap) {
        String showType = (String)paramMap.get("showType");
        DataSet ds = this.query(param);
        if (showType != null) {
            this.entityId = (String)paramMap.get("entityId");
            this.treeAlias = (String)paramMap.get("treeAlias");
            if (paramMap.get("standardId") != null) {
                this.standardId = Long.parseLong(paramMap.get("standardId").toString());
                ds = this.buildMulTreeEntrySet(ds);
            } else {
                this.setOrgViewId();
                ds = this.buildTreeEntrySet(ds);
            }
            if (ds == null) {
                return null;
            }
            List<String> fieldList = this.getFieldsByDs(ds);
            fieldList.remove("pid");
            fieldList.remove("id");
            fieldList.add("case when pid=null then 0 else pid end as pid");
            fieldList.add("case when id=null or id=0 then -1 else id end as id");
            ds = ds.select(fieldList.toArray(new String[0]));
        }
        return ds;
    }

    DataSet queryLeftHgIDsFast(FilterInfo filter) {
        long org = filter.getLong("org");
        QFilter balFilter = new QFilter("org", "=", (Object)org);
        balFilter.and(new QFilter("booktype", "=", (Object)filter.getLong("booktype")));
        balFilter.and(new QFilter("accounttable", "=", (Object)filter.getLong("accounttable")));
        this.getBalComAssistFilter(filter).forEach(arg_0 -> ((QFilter)balFilter).and(arg_0));
        if (filter.getBoolean("nodisplayforzero")) {
            long beginPeriod = filter.getLong("startperiod");
            long endPeriod = filter.getLong("endperiod");
            balFilter.and(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)beginPeriod, (Long[])new Long[]{org})));
            balFilter.and(new QFilter("period", "in", (Object)GLUtil.getPeriodIds((Long)beginPeriod, (Long)endPeriod)));
            balFilter.and(new QFilter("count", ">", (Object)0));
        } else {
            balFilter.and(new QFilter("endperiod", "=", (Object)GLUtil.MAX_PERIOD));
        }
        String currencyId = filter.getString("currency");
        if (!("allcurrency".equals(currencyId) || "basecurrency".equals(currencyId) || "reportcurrency".equals(currencyId))) {
            balFilter.and(new QFilter("currency", "=", (Object)Long.valueOf(currencyId)));
        }
        balFilter.and(new QFilter("account", "in", (Object)SubsiDiaryHelper.getAcctMasterIds((FilterInfo)filter, (long)filter.getLong("org"))));
        AssistBalanceQuery query = new AssistBalanceQuery(filter);
        Map customFlexProperties = query.getCustomFlexProperties();
        String orderBy = filter.getFlexFilterItems().stream().map(FilterItemInfo::getPropName).map(customFlexProperties::get).map(AssistBalanceQuery.CustomFlexProperty::getInnerAssvalKey).map(key -> {
            key = key + " desc ";
            return key;
        }).collect(Collectors.joining(", "));
        return query.queryWithORM(Collections.singletonList(balFilter), "", orderBy, ReportConfiguration.SUBSIDIARY_LEFT_GROUP_LIMIT.getInt(), (Distinctable)WithDistinctable.get(), new String[]{AssistBalanceQuery.CustomFlexProperty.ofNoneDetailAlia((String)"assval")});
    }

    DataSet query(ReportQueryParam queryParam) {
        TimerFactory.Timer timer = TimerFactory.getTimer(SubsidiaryLeftQuery.class);
        DataSet res = ReportConfiguration.SUBSIDIARY_LEFT_ACCURATE_QUERY.getBoolean() ? this.queryLeftHgIDs(queryParam) : this.queryLeftHgIDsFast(queryParam.getFilter());
        timer.time("left query end.");
        return res;
    }

    DataSet queryLeftHgIDs(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        QueryParam param = SubsiDiaryHelper.getParam((FilterInfo)filterInfo, null, null);
        param.setZeroAmtNoDisplay(false);
        param.setZeroBalNoDisplay(false);
        List customFilter = param.getCustomFilter();
        customFilter.addAll(this.getBalComAssistFilter(filterInfo));
        ArrayList assistEntries = new ArrayList(FlexUtils.buildAssistFilterInfo((ReportQueryParam)queryParam));
        Triple triple = FlexUtils.buildDynamicORMAssistOnBalanceWithZero(assistEntries, (String)"gl_balance", (boolean)true);
        param.setBalEntityType((MainEntityType)triple.getLeft());
        customFilter.addAll((Collection)triple.getMiddle());
        Tuple<List<String>, List<String>> zeroAmtAndGrpFields = this.getZeroAmtAndGrpFields(filterInfo);
        ArrayList selectFields = new ArrayList((Collection)triple.getRight());
        selectFields.addAll((Collection)zeroAmtAndGrpFields.item1);
        selectFields.addAll((Collection)zeroAmtAndGrpFields.item2);
        DataSet assistBds = BalanceQueryExecutor.getInstance().getBalance(String.join((CharSequence)", ", selectFields), new Long[]{filterInfo.getLong("org")}, filterInfo.getLong("booktype"), filterInfo.getLong("accounttable"), filterInfo.getLong("startperiod"), filterInfo.getLong("endperiod"), param);
        String amtFilter = ((List)zeroAmtAndGrpFields.item1).stream().map(f -> f + " <> 0").collect(Collectors.joining(" or "));
        String[] assistFields = (String[])((List)triple.getRight()).stream().map(field -> field.split(" ")[1]).toArray(String[]::new);
        int grpLimit = ReportConfiguration.SUBSIDIARY_LEFT_GROUP_LIMIT.getInt();
        if (amtFilter.length() > 0) {
            assistBds = assistBds.filter(amtFilter);
        }
        assistBds = assistBds.select(assistFields).distinct();
        String[] orderBy = (String[])Arrays.stream(assistFields).map(f -> f + " asc").toArray(String[]::new);
        assistBds = assistBds.orderBy(orderBy).limit(0, grpLimit);
        return assistBds;
    }

    Tuple<List<String>, List<String>> getZeroAmtAndGrpFields(FilterInfo filterInfo) {
        ArrayList<String> zeroAmtFields = new ArrayList<String>(4);
        ArrayList<String> grpFields = new ArrayList<String>(4);
        if (filterInfo.getBoolean("balancezero")) {
            zeroAmtFields.add("endlocal");
            if (!"basecurrency".equals(filterInfo.getString("currency"))) {
                grpFields.add("currency");
                zeroAmtFields.add("endfor");
            }
            if (filterInfo.getBoolean("showqty")) {
                grpFields.add("measureunit");
                zeroAmtFields.add("endqty");
            }
        }
        if (filterInfo.getBoolean("nodisplayforzero")) {
            zeroAmtFields.add("count");
        }
        if (!zeroAmtFields.isEmpty()) {
            grpFields.add("account");
        }
        this.replaceByMulCur(filterInfo, zeroAmtFields);
        return new Tuple(zeroAmtFields, grpFields);
    }

    void replaceByMulCur(FilterInfo filterInfo, List<String> zeroAmtFields) {
        String mulCur = filterInfo.getString("mulcur");
        if (Objects.nonNull(mulCur) && !Objects.equals(mulCur, "LocalCurrency") && zeroAmtFields.remove("endlocal")) {
            zeroAmtFields.add(0, LocalCurrencyConfigService.getCurrencyConfig((String)mulCur).getBalanceField(MCT.END).getMetaId());
        }
    }

    List<QFilter> getBalComAssistFilter(FilterInfo filterInfo) {
        return ComAssistTableService.getComAssistFilters((ComAssistTable)ComAssistTable.get((Long)filterInfo.getLong("accounttable")), (List)Lists.newArrayList((Object[])new Long[]{filterInfo.getLong("org")}), (FilterInfo)filterInfo, key -> key, (String)"masterid");
    }

    private List<String> getGroupAssistKey() {
        return Arrays.asList("bd_customer", "bd_supplier", "bd_material");
    }

    private Set<Long> getFieldVal(DataSet assistSet, String alias) {
        HashSet<Long> ids = new HashSet<Long>();
        for (Row row : assistSet.copy()) {
            if (row.get(this.treeAlias) != null) {
                long id = row.getLong(this.treeAlias);
                ids.add(id);
                continue;
            }
            ids.add(0L);
        }
        return ids;
    }

    private DataSet buildMulTreeEntrySet(DataSet assistSet) {
        if (assistSet != null && this.entityId != null && this.getGroupAssistKey().contains(this.entityId)) {
            HashSet<Long> groupIds = new HashSet<Long>();
            HashMap<Long, Long> pidToLeafIdMap = new HashMap<Long, Long>();
            Set<Long> ids = this.getFieldVal(assistSet, this.treeAlias);
            assistSet = this.queryTreeName(assistSet, ids);
            DataSet groupSet = this.queryGroupDetail(ids);
            for (Row row : groupSet.copy()) {
                long groupId = row.getLong(0);
                long id = row.getLong("id");
                groupIds.add(groupId);
                pidToLeafIdMap.put(id, groupId);
            }
            DataSet detailAssistSet = this.getIdToPidDetail(assistSet, groupSet);
            String groupEntityId = this.entityId + "group";
            HashMap levelMap = new HashMap();
            HashMap longNumberMap = new HashMap();
            HashMap leafIdToMap = new HashMap();
            HashMap relationMap = new HashMap();
            HashMap<String, Long> indexMap = new HashMap<String, Long>();
            indexMap.put("index", 1L);
            SubsiDiaryHelper.getMulTreeLeafIdToMap(leafIdToMap, pidToLeafIdMap, groupIds, (String)groupEntityId, new HashSet(), levelMap, longNumberMap, relationMap, indexMap, new HashSet());
            DataSet parentSet = null;
            if (!leafIdToMap.isEmpty()) {
                List<String> parentFieldList = this.treeFields();
                DataSet relationSet = SubsiDiaryHelper.buildTreeByMap(relationMap);
                parentSet = SubsiDiaryHelper.createMulTreeMapSet(leafIdToMap, (String)groupEntityId, parentFieldList, levelMap, longNumberMap, relationMap, (DataSet)relationSet);
                List<String> assistRelatList = this.getFieldsByDs(detailAssistSet);
                assistRelatList.remove("pid");
                DataSet detailSet = detailAssistSet.join(relationSet, JoinType.LEFT).on("pid", "id").select(assistRelatList.toArray(new String[0]), new String[]{"pid"}).finish();
                parentFieldList.add(treeName);
                parentFieldList.add("treenumber");
                parentFieldList.remove("leafid");
                List<String> otherAssistList = this.getFieldsByDs(assistSet);
                otherAssistList.remove("id");
                otherAssistList.remove(treeName);
                otherAssistList.remove("treenumber");
                parentSet = assistSet.join(parentSet, JoinType.RIGHT).on(this.treeAlias, "leafid").select(otherAssistList.toArray(new String[0]), parentFieldList.toArray(new String[0])).finish();
                List<String> allList = this.getFieldsByDs(detailSet);
                parentSet = parentSet.groupBy(allList.toArray(new String[0])).finish();
                otherAssistList.clear();
                otherAssistList.addAll(allList);
                otherAssistList.removeAll(this.getMulTreeFields());
                detailAssistSet = parentSet.union(detailSet).orderBy(allList.toArray(new String[0]));
            }
            return detailAssistSet;
        }
        return null;
    }

    private List<String> getMulTreeFields() {
        ArrayList<String> mulTeeFieldList = new ArrayList<String>();
        mulTeeFieldList.add("pid");
        mulTeeFieldList.add("id");
        mulTeeFieldList.add("isgroupnode");
        mulTeeFieldList.add("level");
        mulTeeFieldList.add(treeName);
        mulTeeFieldList.add("longnumber");
        return mulTeeFieldList;
    }

    private DataSet getIdToPidDetail(DataSet assistSet, DataSet groupSet) {
        List<String> assistList = this.getFieldsByDs(assistSet);
        DataSet detailAssistSet = assistSet.copy().join(groupSet, JoinType.LEFT).on("id", "id").select(assistList.toArray(new String[0]), new String[]{"pid", "level", "longnumber"}).finish();
        detailAssistSet = detailAssistSet.addField("0", "isgroupnode");
        assistList.clear();
        assistList.addAll(this.getFieldsByDs(detailAssistSet));
        assistList.removeIf(x -> x.equals("level"));
        assistList.add("case when level=null then 1 else level+1 end as level");
        detailAssistSet = detailAssistSet.select(assistList.toArray(new String[0]));
        return detailAssistSet;
    }

    private DataSet queryGroupDetail(Set<Long> ids) {
        String groupKey = this.entityId.substring(3);
        QFilter fid = new QFilter(groupKey, "in", ids);
        QFilter fgroup = new QFilter("standard", "=", (Object)this.standardId);
        String sel = "group pid, group.level level,group.longnumber longnumber,group.number treenumber," + groupKey + " id";
        DataSet groupSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)(this.entityId + "groupdetail"), (String)sel, (QFilter[])new QFilter[]{fid, fgroup}, null);
        return groupSet;
    }

    private DataSet queryTreeName(DataSet assistSet, Set<Long> ids) {
        List<String> assistList = this.getFieldsByDs(assistSet);
        assistList.removeIf(x -> x.equals("id"));
        QFilter fassistNameIds = new QFilter("id", "in", ids);
        DataSet assistNameSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityId, (String)"id,name treename,number treenumber", (QFilter[])new QFilter[]{fassistNameIds}, null);
        assistSet = assistSet.join(assistNameSet, JoinType.LEFT).on(this.treeAlias, "id").select(assistList.toArray(new String[0]), new String[]{"id", treeName, "treenumber"}).finish();
        return assistSet;
    }

    private DataSet buildTreeEntrySet(DataSet assistSet) {
        if (assistSet != null) {
            HashSet<Long> ids = new HashSet<Long>();
            HashMap<Long, Long> idToPidMap = new HashMap<Long, Long>();
            for (Row row : assistSet.copy()) {
                if (row.getLong(this.treeAlias) == null) continue;
                long id = row.getLong(this.treeAlias);
                ids.add(id);
                idToPidMap.put(id, id);
            }
            if (ids.isEmpty()) {
                return null;
            }
            HashSet noLeafIds = new HashSet();
            HashMap levelMap = new HashMap();
            HashMap longNumberMap = new HashMap();
            HashMap leafIdToMap = new HashMap();
            HashMap relationMap = new HashMap();
            HashMap<String, Long> indexMap = new HashMap<String, Long>();
            indexMap.put("index", 1L);
            HashSet pids = new HashSet();
            SubsiDiaryHelper.getTreeLeafIdToMap(leafIdToMap, idToPidMap, ids, (String)this.entityId, noLeafIds, levelMap, longNumberMap, relationMap, indexMap, pids, (long)this.orgViewId);
            SubsiDiaryHelper.getDetailOrParent(pids, leafIdToMap, relationMap, indexMap);
            ArrayList<String> listField = new ArrayList<String>();
            listField.add(this.treeAlias);
            listField.addAll(this.treeFields());
            DataSet treeSet = SubsiDiaryHelper.createTreeMapSet(leafIdToMap, listField, noLeafIds, levelMap, longNumberMap, relationMap);
            listField.clear();
            listField.addAll(this.getFieldsByDs(treeSet));
            listField.remove("leafid");
            List<String> assistList = this.getFieldsByDs(assistSet);
            assistList.remove(this.treeAlias);
            assistSet = assistSet.join(treeSet, JoinType.LEFT).on(this.treeAlias, "leafid").select(assistList.toArray(new String[0]), listField.toArray(new String[0])).finish();
            assistList.addAll(listField);
            assistSet = assistSet.groupBy(assistList.toArray(new String[0])).finish();
            assistList.removeAll(listField);
            assistSet = assistSet.orderBy(assistList.toArray(new String[0]));
            return assistSet;
        }
        return null;
    }

    private List<String> treeFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("pid");
        list.add("id");
        list.add("leafid");
        list.add("isgroupnode");
        list.add("level");
        list.add("longnumber");
        return list;
    }

    private void setOrgViewId() {
        QFilter filter = new QFilter("flexfield", "=", (Object)this.treeAlias);
        DynamicObject assisType = QueryServiceHelper.queryOne((String)ASSIST_TYPE, (String)"valuesource.number number,flexfield,valuetype", (QFilter[])new QFilter[]{filter});
        String valuetype = assisType.getString("valuetype");
        String entityName = assisType.getString("number");
        String flexField = assisType.getString("flexfield");
        this.orgViewId = SubsiDiaryHelper.getOrgViewId((String)valuetype, (String)entityName, (String)flexField);
    }

    private List<String> getFieldsByDs(DataSet dataSet) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (dataSet != null) {
            Field[] fields;
            for (Field field : fields = dataSet.getRowMeta().getFields()) {
                fieldNames.add(field.getAlias());
            }
        }
        return fieldNames;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void createMulTreeValue(DataSet ds, TableValueSetter vs, AbstractFormDataModel model, Map<String, String> keyMap, IFormView view) {
        int idIndex;
        List fields;
        HashMap<String, Map> flexfieldToMasteridAndId;
        String preAssistVal = "";
        int _index = 0;
        List<String> otherAssistList = this.getFieldsByDs(ds);
        List<String> mulTreeFieldList = this.getMulTreeFields();
        otherAssistList.removeAll(mulTreeFieldList);
        if (this.treeAlias != null) {
            otherAssistList.remove(this.treeAlias);
        }
        HashSet<Long> idSet = new HashSet<Long>();
        HashMap<Long, Object> pidMap = new HashMap<Long, Object>(128);
        ArrayList<Object[]> tempList = new ArrayList<Object[]>(10);
        Iterator iterator = ds.iterator();
        while (true) {
            Iterator<String> iterator2;
            Object[] obj;
            int i;
            Row row;
            if (iterator.hasNext()) {
                row = (Row)iterator.next();
                i = 0;
                obj = new Object[vs.getFields().size()];
                StringBuilder curAssistValBuf = new StringBuilder();
                for (String assistField : otherAssistList) {
                    curAssistValBuf = curAssistValBuf.append(row.get(assistField));
                }
                if (!preAssistVal.equals(curAssistValBuf.toString())) {
                    _index = 10000000 + _index;
                }
                preAssistVal = curAssistValBuf.toString();
                iterator2 = vs.getFields().iterator();
            } else {
                flexfieldToMasteridAndId = new HashMap<String, Map>(16);
                fields = vs.getFields();
                idIndex = fields.indexOf("id");
                int treeNameIndex = fields.indexOf(treeName);
                break;
            }
            while (iterator2.hasNext()) {
                block29: {
                    String field;
                    block30: {
                        field = iterator2.next();
                        if (!"pid".equals(field)) break block30;
                        Long o = row.getLong("pid");
                        if (o > 0L) {
                            if (pidMap.containsKey(o)) {
                                obj[i] = pidMap.get(o);
                                break block29;
                            } else {
                                obj[i] = (long)_index + o;
                                pidMap.put(o, obj[i]);
                            }
                            break block29;
                        } else {
                            obj[i] = o;
                        }
                        break block29;
                    }
                    if ("id".equals(field)) {
                        if (row.getBoolean("isgroupnode") != null && row.getBoolean("isgroupnode").booleanValue()) {
                            if (idSet.add(row.getLong("id"))) {
                                obj[i] = row.getLong("id") + (long)_index;
                                break block29;
                            } else {
                                i = 0;
                                break;
                            }
                        }
                        obj[i] = row.getLong("id");
                    } else {
                        obj[i] = field.equals(treeName) ? row.get(treeName) : row.get(keyMap.get(field));
                    }
                }
                ++i;
            }
            if (i == 0) continue;
            tempList.add(obj);
        }
        for (int i = 0; i < fields.size(); ++i) {
            String field = (String)fields.get(i);
            String fieldName = keyMap.get(field);
            if (!FlexUtils.isBaseDataAndMasteridProperty((String)fieldName)) continue;
            int fieldIndex = i;
            if (treeName.equals(field)) {
                fieldIndex = idIndex;
            }
            for (Object[] objectArray : tempList) {
                flexfieldToMasteridAndId.computeIfAbsent(fieldName, k -> new HashMap()).put((Long)objectArray[fieldIndex], (Long)objectArray[fieldIndex]);
            }
        }
        if (DebugTrace.enable()) {
            log.info("{}_flexfieldToMasteridAndId_1:{}", (Object)this.getClass().getName(), (Object)DebugTraceHelper.toString(flexfieldToMasteridAndId));
        }
        HashMap<Long, String> flexfieldToIdAndName = new HashMap<Long, String>(flexfieldToMasteridAndId.size());
        long orgid = ((DynamicObject)model.getValue("org")).getLong("id");
        Date enddate = ((DynamicObject)model.getValue("endperiod")).getDate("enddate");
        for (Map.Entry entry : flexfieldToMasteridAndId.entrySet()) {
            String flexfield = (String)entry.getKey();
            String valuesource = FlexUtils.getFlexProperty((String)flexfield).getValueSource();
            if (StringUtils.isEmpty((CharSequence)valuesource)) continue;
            Map value = (Map)entry.getValue();
            Set ids = value.keySet();
            ids.removeIf(x -> x == null || x == 0L);
            if (ids.size() <= 0) continue;
            for (List batchIds : Lists.partition(new ArrayList(ids), (int)1000)) {
                QFilter qFilter = new QFilter("masterid", "in", (Object)batchIds);
                DynamicObjectCollection assistObjs = BaseDataServiceHelper.queryBaseDataByDate((String)valuesource, (Long)orgid, (QFilter)qFilter, (String)"id,masterid,number,name", (Date)enddate);
                for (DynamicObject assistObj : assistObjs) {
                    value.put(assistObj.getLong("masterid"), assistObj.getLong("id"));
                    flexfieldToIdAndName.put(assistObj.getLong("id"), assistObj.getString("name"));
                }
            }
        }
        if (DebugTrace.enable()) {
            log.info("{}_flexfieldToMasteridAndId_2:{}", (Object)this.getClass().getName(), (Object)DebugTraceHelper.toString(flexfieldToMasteridAndId));
        }
        int i = 0;
        while (true) {
            block32: {
                Iterator tempIterator;
                Map masteridAndIds;
                String string;
                block33: {
                    block31: {
                        if (i >= fields.size()) break block31;
                        string = (String)fields.get(i);
                        String fieldName = keyMap.get(string);
                        if (!FlexUtils.isBaseDataAndMasteridProperty((String)fieldName) || (masteridAndIds = (Map)flexfieldToMasteridAndId.get(fieldName)) == null || masteridAndIds.isEmpty()) break block32;
                        tempIterator = tempList.iterator();
                        break block33;
                    }
                    Iterator iterator3 = tempList.iterator();
                    while (true) {
                        if (!iterator3.hasNext()) {
                            model.beginInit();
                            model.deleteEntryData(treeEntryKey);
                            model.batchCreateNewEntryRow(treeEntryKey, vs);
                            model.endInit();
                            view.updateView(treeEntryKey);
                            return;
                        }
                        Object[] objectArray = (Object[])iterator3.next();
                        vs.addRow(objectArray);
                    }
                }
                while (tempIterator.hasNext()) {
                    Long newId;
                    Object[] tempObj = (Object[])tempIterator.next();
                    if (treeName.equals(string)) {
                        newId = (Long)masteridAndIds.get(tempObj[idIndex]);
                        tempObj[idIndex] = newId;
                        String newNme = (String)flexfieldToIdAndName.get(newId);
                        if (!StringUtils.isNotEmpty((CharSequence)newNme)) continue;
                        tempObj[treeNameIndex] = newNme;
                        continue;
                    }
                    if (tempObj[i] == null) continue;
                    newId = (Long)masteridAndIds.get(tempObj[i]);
                    tempObj[i] = newId;
                }
            }
            ++i;
        }
    }
}

