/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CashflowItemUtil {
    public static List<TreeNode> getChildNodes(List<QFilter> filter, String longNumber, String curNodeId) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        TreeNode node = null;
        HashMap<String, TreeNode> map = new HashMap<String, TreeNode>();
        if (StringUtils.isNotEmpty((CharSequence)longNumber)) {
            filter.add(new QFilter("longnumber", "like", (Object)(longNumber + "@%")));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CashflowItemList#buildChildNode", (String)"gl_cashflowitem", (String)"id, name, number, longnumber, parent", (QFilter[])filter.toArray(new QFilter[0]), (String)"number");
        Object object = null;
        try {
            for (Row row : dataSet) {
                node = new TreeNode();
                node.setId(row.getString("id"));
                String name = row.getString("name") == null ? "" : row.getString("name");
                node.setText(name);
                node.setLongNumber(row.getString("longnumber") == null ? "" : row.getString("longnumber"));
                node.setParentid(row.getString("parent"));
                map.put(row.getString("longnumber"), node);
                list.add(node);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        for (TreeNode nodes : list) {
            String parentNumber = nodes.getLongNumber().lastIndexOf("@") == -1 ? "" : nodes.getLongNumber().substring(0, nodes.getLongNumber().lastIndexOf("@"));
            TreeNode parentNode = (TreeNode)map.get(parentNumber);
            if (parentNode != null) {
                parentNode.addChild(nodes);
                nodes.setParentid(((TreeNode)map.get(parentNumber)).getId());
                continue;
            }
            result.add(nodes);
        }
        if (longNumber == null) {
            result.forEach(x -> x.setParentid(curNodeId));
        }
        return result;
    }
}

