/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.exception.GLErrorCode;

public class GenVoucherFromInvoiceUtils {
    public DynamicObject getVoucherTemplate(long templateId) {
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"gl_templatevoucher", (String)"id,org,name,number,vouchertype,description,book,bookstype,voucherentity.id,voucherentity.seq,voucherentity.edescription,voucherentity.account,voucherentity.assgrp,voucherentity.currency,voucherentity.entrydc, voucherentity.creditlocalcomb, voucherentity.debitlocalcomb");
        return template;
    }

    public VoucherInfo buildVoucher(DynamicObject voucherTemplate) {
        if (voucherTemplate == null) {
            throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u4e3a\u7a7a\u3002", (String)"GenVoucherFromInvoiceUtils_0", (String)"fi-gl-formplugin", (Object[])new Object[0])});
        }
        DynamicObject org = voucherTemplate.getDynamicObject("org");
        long orgid = org.getLong("id");
        String orgName = org.getString("name");
        long bookType = voucherTemplate.getLong("bookstype_id");
        AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys((long)orgid, (long)bookType);
        if (accountBook == null) {
            throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u7b97\u4f53\u7cfb\u7684\u8d26\u7c3f\u5931\u8d25\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e3a\u201c%1$s\u201d\uff0c\u8d26\u7c3f\u7c7b\u578b\u4e3a\u201c%2$s\u201d\u3002", (String)"GenVoucherFromInvoiceUtils_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), orgName, voucherTemplate.getDynamicObject("bookstype").getString("name")});
        }
        long curperiodId = accountBook.getCurPeriodId();
        if (curperiodId == 0L) {
            throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u83b7\u53d6\u5f53\u524d\u671f\u95f4\u5931\u8d25\u3002", (String)"GenVoucherFromInvoiceUtils_3", (String)"fi-gl-formplugin", (Object[])new Object[]{orgName})});
        }
        long localcurId = accountBook.getBaseCurrencyId();
        if (localcurId == 0L) {
            throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u672c\u4f4d\u5e01\u5931\u8d25\uff01\u6838\u7b97\u7ec4\u7ec7\u4e3a\uff1a%s", (String)"GenVoucherFromInvoiceUtils_4", (String)"fi-gl-formplugin", (Object[])new Object[]{orgName})});
        }
        long exratetableId = accountBook.getExrateTableId();
        if (exratetableId == 0L) {
            throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u83b7\u53d6\u6c47\u7387\u8868\u5931\u8d25\u3002", (String)"GenVoucherFromInvoiceUtils_5", (String)"fi-gl-formplugin", (Object[])new Object[]{orgName})});
        }
        VoucherInfo newVoucher = new VoucherInfo();
        Date nowDate = new Date();
        newVoucher.setOrg(Long.valueOf(orgid));
        DynamicObject curperiod = BusinessDataServiceHelper.loadSingleFromCache((Object)curperiodId, (String)"bd_period");
        newVoucher.setBizDate(curperiod.getDate("enddate"));
        newVoucher.setBookedDate(curperiod.getDate("enddate"));
        newVoucher.setVoucherType(Long.valueOf(voucherTemplate.getLong("vouchertype_id")));
        newVoucher.setDesc(voucherTemplate.getString("description"));
        RequestContext context = RequestContext.get();
        long userid = Long.parseLong(context.getUserId());
        newVoucher.setSourceSys("83bfebc8000017ac");
        newVoucher.setSourceType("7");
        newVoucher.setCreator(Long.valueOf(userid));
        DynamicObject obj = newVoucher.toDynamicObject();
        obj.set("createtime", (Object)nowDate);
        obj.set("modifier_id", (Object)userid);
        obj.set("modifytime", (Object)nowDate);
        newVoucher.setStatus("A");
        newVoucher.setBookType(Long.valueOf(accountBook.getBookTypeId()));
        newVoucher.setPeriod(Long.valueOf(curperiodId));
        DynamicObjectCollection entries = voucherTemplate.getDynamicObjectCollection("voucherentity");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject templateEntity = (DynamicObject)entries.get(i);
            VoucherEntryInfo entry = newVoucher.createNewEntry();
            entry.setSeq(i + 1);
            long oriCurid = templateEntity.get("currency_id") == null || templateEntity.getLong("currency_id") == 0L ? localcurId : templateEntity.getLong("currency_id");
            entry.setCurency(Long.valueOf(oriCurid == localcurId ? localcurId : oriCurid));
            entry.setEntryDC(templateEntity.getString("entrydc"));
            entry.setLocRate(new BigDecimal(1));
        }
        newVoucher.setSourceBillType("gl_templatevoucher");
        newVoucher.loadRefence();
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billNoValue = codeRuleService.getNumber(obj.getDataEntityType().getName(), obj, String.valueOf(obj.getLong("org_id")));
        if (StringUtils.isNotEmpty((String)billNoValue)) {
            newVoucher.setNum(billNoValue);
        }
        return newVoucher;
    }

    public VoucherInfo buildVoucher(Map<String, String> data, long templateId) {
        if (data == null) {
            throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a\uff01", (String)"GenVoucherFromInvoiceUtils_6", (String)"fi-gl-formplugin", (Object[])new Object[0])});
        }
        DynamicObject voucherTemplate = this.getVoucherTemplate(templateId);
        if (voucherTemplate == null) {
            throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u4e3a\u7a7a\u3002", (String)"GenVoucherFromInvoiceUtils_0", (String)"fi-gl-formplugin", (Object[])new Object[0])});
        }
        DynamicObject org = voucherTemplate.getDynamicObject("org");
        long orgid = org.getLong("id");
        String orgName = org.getString("name");
        long bookType = voucherTemplate.getLong("bookstype_id");
        AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys((long)orgid, (long)bookType);
        if (accountBook == null) {
            throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u7b97\u4f53\u7cfb\u7684\u8d26\u7c3f\u5931\u8d25\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e3a\u201c%1$s\u201d\uff0c\u8d26\u7c3f\u7c7b\u578b\u4e3a\u201c%2$s\u201d\u3002", (String)"GenVoucherFromInvoiceUtils_1", (String)"fi-gl-formplugin", (Object[])new Object[]{orgName, voucherTemplate.getDynamicObject("bookstype").getString("name")})});
        }
        long curperiodId = accountBook.getCurPeriodId();
        if (curperiodId == 0L) {
            throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u83b7\u53d6\u5f53\u524d\u671f\u95f4\u5931\u8d25\u3002", (String)"GenVoucherFromInvoiceUtils_3", (String)"fi-gl-formplugin", (Object[])new Object[]{orgName})});
        }
        long localcurId = accountBook.getBaseCurrencyId();
        if (localcurId == 0L) {
            throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u672c\u4f4d\u5e01\u5931\u8d25\uff01\u6838\u7b97\u7ec4\u7ec7\u4e3a\uff1a%s", (String)"GenVoucherFromInvoiceUtils_4", (String)"fi-gl-formplugin", (Object[])new Object[]{orgName})});
        }
        long exratetableId = accountBook.getExrateTableId();
        if (exratetableId == 0L) {
            throw new KDBizException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u83b7\u53d6\u6c47\u7387\u8868\u5931\u8d25\u3002", (String)"GenVoucherFromInvoiceUtils_5", (String)"fi-gl-formplugin", (Object[])new Object[]{orgName})});
        }
        VoucherInfo newVoucher = new VoucherInfo();
        String key1 = data.get(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"GenVoucherFromInvoiceUtils_8", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        String key2 = data.get(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"GenVoucherFromInvoiceUtils_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        String description = ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%1$s , \u53d1\u7968\u4ee3\u7801\uff1a%2$s", (String)"GenVoucherFromInvoiceUtils_7", (String)"fi-gl-formplugin", (Object[])new Object[]{key1, key2});
        newVoucher.setDesc(description);
        DynamicObjectCollection entries = voucherTemplate.getDynamicObjectCollection("voucherentity");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject templateEntity = (DynamicObject)entries.get(i);
            long account = templateEntity.getLong("account_id");
            if (account == 0L) continue;
            VoucherEntryInfo entry = newVoucher.createNewEntry();
            entry.setAccount(Long.valueOf(account));
            BigDecimal amount = null;
            String amtType = null;
            amtType = templateEntity.getString("entrydc").equals("1") ? templateEntity.getString("debitlocalcomb") : templateEntity.getString("creditlocalcomb");
            try {
                if (amtType.equals("0")) {
                    amount = new BigDecimal(data.get(ResManager.loadKDString((String)"\u91d1\u989d", (String)"GenVoucherFromInvoiceUtils_11", (String)"fi-gl-formplugin", (Object[])new Object[0])));
                } else if (amtType.equals("1")) {
                    amount = new BigDecimal(data.get(ResManager.loadKDString((String)"\u7a0e\u989d", (String)"GenVoucherFromInvoiceUtils_12", (String)"fi-gl-formplugin", (Object[])new Object[0])));
                } else if (amtType.equals("2")) {
                    amount = new BigDecimal(data.get(ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"GenVoucherFromInvoiceUtils_13", (String)"fi-gl-formplugin", (Object[])new Object[0])));
                }
            }
            catch (Exception e) {
                amount = new BigDecimal("0");
            }
            entry.setAssgrp(Long.valueOf(templateEntity.getLong("assgrp_id")));
            entry.setSeq(i + 1);
            entry.setDesc(templateEntity.getString("edescription"));
            long oriCurid = templateEntity.get("currency_id") == null || templateEntity.getLong("currency_id") == 0L ? localcurId : templateEntity.getLong("currency_id");
            entry.setCurency(Long.valueOf(oriCurid == localcurId ? localcurId : oriCurid));
            entry.setEntryDC(templateEntity.getString("entrydc"));
            if ("1".equals(templateEntity.get("entrydc"))) {
                entry.setDebLoc(amount);
                continue;
            }
            entry.setCreLoc(amount);
        }
        return newVoucher;
    }
}

