/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.ai.PresetCashItemUtil;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowDataRow;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowItemParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.util.GLUtil;

public class PresetCashItemUtilOfNoCache {
    public static final String CREATEORG = "createorg";
    public static final String ROOTKEY = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    public static final String CASHFLOWITEM_ENTITY = "gl_cashflowitem";
    public static final String ID = "id";
    public static final String LONGNUMBER = "longnumber";
    public static final String MASTER_ITEM = "1";
    public static final String SUPPLEMENTARY_ITEM = "3";
    public static final String ISLEAF = "isleaf";
    private static final Log logger = LogFactory.getLog(PresetCashItemUtilOfNoCache.class);

    @Deprecated
    public static Map<PresetCashFlowItemParam, Long> batchGetCashFlowItemIds(List<PresetCashFlowItemParam> paramList, long orgId, long accttabId) {
        QFilter qids = PresetCashItemUtilOfNoCache.getFilter(orgId);
        List<String> flexFields = PresetCashItemUtilOfNoCache.getAllAssistFlexField();
        Map<String, Map<String, Map<String, List<PresetCashFlowDataRow>>>> dataMap = PresetCashItemUtilOfNoCache.getPresetCashFlowItemDataMap(orgId, accttabId, flexFields);
        logger.info("[T_preset]AcctCashFlowItemMap, orgId:{}, accttabId:{}, dataMap.size:{}, dataMap:{}", new Object[]{orgId, accttabId, dataMap.size(), dataMap});
        Map<Object, DynamicObject> acctAssgrpMap = PresetCashItemUtilOfNoCache.getAssgrpObj(paramList);
        HashMap<PresetCashFlowItemParam, Long> resultMap = new HashMap<PresetCashFlowItemParam, Long>();
        HashMap<PresetCashFlowItemParam, String> resultLongNumberMap = new HashMap<PresetCashFlowItemParam, String>();
        for (PresetCashFlowItemParam param : paramList) {
            String acctLongNumber = param.getAcctLongnumber();
            String firstNumber = acctLongNumber.split("_")[0];
            Map<String, Map<String, List<PresetCashFlowDataRow>>> acctNumberMap = dataMap.get(firstNumber);
            if (acctNumberMap == null) continue;
            List<PresetCashFlowDataRow> list = acctNumberMap.get(param.getItemType()).get(param.getDc());
            DynamicObject assgrpObj = acctAssgrpMap.get(param.getAssgrp());
            JSONObject assgrpJson = assgrpObj == null ? new JSONObject() : JSONObject.parseObject((String)assgrpObj.getString("assvals"));
            int maxCount = 0;
            String groupLongnumber = "";
            String zeroLongnumber = "";
            for (PresetCashFlowDataRow row : list) {
                String curnumber = row.getAcctLongNumber();
                int count = 0;
                boolean flag = true;
                if (acctLongNumber.startsWith(curnumber)) {
                    for (String flexField : flexFields) {
                        Object flexVal = row.getAssgrp().get(flexField);
                        if ((!(flexVal instanceof Long) || (Long)flexVal == 0L) && (!(flexVal instanceof String) || "".equals(flexVal))) continue;
                        if (flexVal.equals(assgrpJson.get((Object)flexField))) {
                            ++count;
                            continue;
                        }
                        flag = false;
                    }
                    if (0 == row.getAssgrp().size()) {
                        zeroLongnumber = row.getCfLongNumber();
                    }
                    if (count > maxCount && flag) {
                        maxCount = count;
                        groupLongnumber = row.getCfLongNumber();
                    }
                }
                if ((groupLongnumber = groupLongnumber.isEmpty() ? zeroLongnumber : groupLongnumber).isEmpty()) continue;
                resultLongNumberMap.put(param, groupLongnumber);
            }
        }
        Map realIds = BusinessDataServiceHelper.loadFromCache((String)CASHFLOWITEM_ENTITY, (String)"id,longnumber", (QFilter[])new QFilter[]{qids, new QFilter(LONGNUMBER, "in", resultLongNumberMap.values()), new QFilter(ISLEAF, "=", (Object)MASTER_ITEM)}, null);
        if (CollectionUtils.isEmpty((Map)realIds)) {
            return resultMap;
        }
        HashMap<String, Long> longNumberIdMap = new HashMap<String, Long>(realIds.size());
        for (Map.Entry realIdsEntry : realIds.entrySet()) {
            String realIdLongnumber = ((DynamicObject)realIdsEntry.getValue()).getString(LONGNUMBER);
            longNumberIdMap.put(realIdLongnumber, (Long)realIdsEntry.getKey());
        }
        logger.info("[T_preset]AcctCashFlowItemMap, longNumberIdMap:{}, resultLongNumberMap.values:{}", longNumberIdMap, resultLongNumberMap.values());
        for (PresetCashFlowItemParam param : paramList) {
            String longNumber = (String)resultLongNumberMap.get(param);
            if (StringUtils.isEmpty((CharSequence)longNumber)) continue;
            resultMap.put(param, (Long)longNumberIdMap.get(longNumber));
        }
        return resultMap;
    }

    private static List<String> getAllAssistFlexField() {
        ArrayList<String> flexFields = new ArrayList<String>(10);
        QFilter flexIdFilter = new QFilter("flexid", "=", (Object)2L);
        Map asstactTypes = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"id,flexfield", (QFilter[])flexIdFilter.toArray());
        for (DynamicObject asstactType : asstactTypes.values()) {
            flexFields.add(asstactType.getString("flexfield"));
        }
        return flexFields;
    }

    private static Map<Object, DynamicObject> getAssgrpObj(List<PresetCashFlowItemParam> paramList) {
        HashSet<Long> acctAssgrpIdSet = new HashSet<Long>();
        for (PresetCashFlowItemParam param : paramList) {
            long paramAssgrp = param.getAssgrp();
            if (paramAssgrp == 0L) continue;
            acctAssgrpIdSet.add(paramAssgrp);
        }
        Map acctAssgrpMap = BusinessDataServiceHelper.loadFromCache((String)"gl_assist", (String)"id,assvals", (QFilter[])new QFilter(ID, "in", acctAssgrpIdSet).toArray());
        return acctAssgrpMap;
    }

    private static Map<String, Map<String, Map<String, List<PresetCashFlowDataRow>>>> getPresetCashFlowItemDataMap(long orgId, long accttabId, List<String> flexFields) {
        List<Object> presetItemIds = PresetCashItemUtilOfNoCache.getPresetIds(orgId, accttabId);
        HashMap<String, Map<String, Map<String, List<PresetCashFlowDataRow>>>> dataMap = new HashMap<String, Map<String, Map<String, List<PresetCashFlowDataRow>>>>();
        String acctNumField = "acctlongnumber";
        QFilter qisleaf = new QFilter("group.isleaf", "=", (Object)true);
        String select = "createorg,group,group.type type,group.isleaf,group.longnumber cflongnumber,entryentity.account.longnumber acctlongnumber,entryentity.dc dc,entryentity.assgrp.value assgrp";
        DataSet preSetData = QueryServiceHelper.queryDataSet((String)"fi.gl.PresetCashflowItemUtil", (String)"gl_presetcashflowitem", (String)select, (QFilter[])new QFilter[]{new QFilter(ID, "in", presetItemIds), qisleaf}, (String)"entryentity.account.longnumber");
        String cfMainType = MASTER_ITEM;
        String supMainType = SUPPLEMENTARY_ITEM;
        String debit = MASTER_ITEM;
        String credit = "-1";
        try (DataSet dataSet = preSetData;){
            while (dataSet.hasNext()) {
                String firstNumber;
                HashMap mainSupMap;
                Row row = dataSet.next();
                String acctLongNumber = row.getString(acctNumField);
                if (acctLongNumber == null) continue;
                PresetCashFlowDataRow dataRow = new PresetCashFlowDataRow(row.getString("type"), row.getString("cflongnumber"), row.getString("acctlongnumber"), row.getString("dc"));
                String assgrpVal = row.getString("assgrp");
                if (StringUtils.isNotEmpty((CharSequence)assgrpVal)) {
                    Map assgrpMap = (Map)SerializationUtils.fromJsonString((String)assgrpVal, Map.class);
                    dataRow.getAssgrp().putAll(assgrpMap);
                }
                if ((mainSupMap = (HashMap)dataMap.get(firstNumber = acctLongNumber.split("_")[0])) == null) {
                    mainSupMap = new HashMap(16);
                    dataMap.put(firstNumber, mainSupMap);
                    mainSupMap.put(cfMainType, new HashMap(10));
                    ((Map)mainSupMap.get(cfMainType)).put(debit, new ArrayList(10));
                    ((Map)mainSupMap.get(cfMainType)).put(credit, new ArrayList(10));
                    mainSupMap.put(supMainType, new HashMap(10));
                    ((Map)mainSupMap.get(supMainType)).put(debit, new ArrayList(10));
                    ((Map)mainSupMap.get(supMainType)).put(credit, new ArrayList(10));
                }
                ((List)((Map)mainSupMap.get(dataRow.getCfType())).get(dataRow.getDc())).add(dataRow);
            }
        }
        return dataMap;
    }

    private static QFilter getFilter(long orgId) {
        return BaseDataServiceHelper.getBaseDataFilter((String)CASHFLOWITEM_ENTITY, (Long)orgId);
    }

    private static List<Object> getPresetIds(long orgId, long accttableId) {
        return PresetCashItemUtilOfNoCache.getUsedPresetIds(orgId, accttableId);
    }

    public static List<Object> getUsedPresetIds(Object curOrg, Object accounttableId) {
        return PresetCashItemUtilOfNoCache.getUsedPresetIds(curOrg, accounttableId, null);
    }

    public static List<Object> getUsedPresetIds(Object curOrg, Object accounttableId, String groupLongNumber) {
        QFilter groupLongNumberFilter = null;
        if (groupLongNumber != null) {
            groupLongNumberFilter = new QFilter("group.longnumber", "=", (Object)groupLongNumber);
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        List<Long> porgids = PresetCashItemUtilOfNoCache.getAllSuperiorOrgIds(curOrg, true);
        HashMap info = new HashMap();
        List<Object> itemids = PresetCashItemUtilOfNoCache.getLeafNodes(ROOTKEY, porgids, curOrg);
        if (!itemids.isEmpty()) {
            QFilter qorg = new QFilter(CREATEORG, "in", porgids);
            QFilter qtable = new QFilter("accounttable", "=", accounttableId);
            QFilter qids = new QFilter("group", "in", itemids);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"fi.gl.PersetAccountList", (String)"gl_presetcashflowitem", (String)"id,createorg,group.longnumber,group.id", (QFilter[])new QFilter[]{qorg, qtable, qids, groupLongNumberFilter}, null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    long id = row.getLong(ID);
                    long orgId = row.getLong(CREATEORG);
                    String longnumber = row.getString("group.longnumber");
                    long groupId = row.getLong("group.id");
                    ArrayList curOrgItemInfoList = (ArrayList)info.get(orgId);
                    if (curOrgItemInfoList == null) {
                        curOrgItemInfoList = new ArrayList();
                    }
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put(ID, id);
                    m.put(LONGNUMBER, longnumber);
                    m.put("groupId", groupId);
                    curOrgItemInfoList.add(m);
                    info.put(orgId, curOrgItemInfoList);
                    ids.add(id);
                }
            }
        }
        HashSet<String> usedNumber = new HashSet<String>();
        ArrayList<Long> removeIds = new ArrayList<Long>();
        for (int i = porgids.size() - 1; i >= 0; --i) {
            Long orgid = porgids.get(i);
            List curOrgItemInfoList = (List)info.get(orgid);
            if (curOrgItemInfoList == null) continue;
            for (Map map : curOrgItemInfoList) {
                String longnumber = String.valueOf(map.get(LONGNUMBER));
                if (usedNumber.contains(longnumber)) {
                    long id = (Long)map.get(ID);
                    removeIds.add(id);
                    continue;
                }
                usedNumber.add(longnumber);
            }
        }
        ids.removeAll(removeIds);
        return ids;
    }

    public static List<Long> getAllSuperiorOrgIds(Object useorgId, boolean isIncludeCurOrg) {
        long orgid = Long.parseLong(String.valueOf(useorgId));
        List<Long> ids = PresetCashItemUtilOfNoCache.getAllSuperiorOrgIdsOrderByLevel(orgid);
        if (isIncludeCurOrg) {
            if (!ids.contains(orgid)) {
                ids.add(orgid);
            }
        } else if (ids.contains(orgid)) {
            ids.removeIf(id -> id == orgid);
        }
        return ids;
    }

    private static List<Long> getAllSuperiorOrgIdsOrderByLevel(long orgid) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (orgid == 0L) {
            return ids;
        }
        QFilter f2 = new QFilter("view.number", "=", (Object)"10");
        QFilter f3 = new QFilter("org", "=", (Object)orgid);
        String longNumber = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PresetCashItemUtil.class.getName(), (String)"bos_org_structure", (String)LONGNUMBER, (QFilter[])new QFilter[]{f2, f3}, null);){
            if (ds.hasNext()) {
                Row row = ds.next();
                longNumber = row.getString(LONGNUMBER);
            }
        }
        if (longNumber == null || StringUtils.isBlank(longNumber) || longNumber.indexOf("!") == 0) {
            return ids;
        }
        String[] numbers = StringUtils.substringBeforeLast((String)longNumber, (String)"!").split("!");
        QFilter numberFilter = new QFilter("org.number", "in", (Object)numbers);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)PresetCashItemUtil.class.getName(), (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f2, numberFilter}, (String)"level");){
            while (ds.hasNext()) {
                Row row = ds.next();
                ids.add(row.getLong("org"));
            }
        }
        return ids;
    }

    public static List<Object> getLeafNodes(Object curNodeid, List<Long> porgids, Object curOrg) {
        DynamicObject item;
        ArrayList<Object> ids = new ArrayList<Object>();
        QFilter qlongnumber = null;
        QFilter qorg = new QFilter(CREATEORG, "in", porgids).or(new QFilter("ctrlstrategy", "=", (Object)"5"));
        if (!ROOTKEY.equals(curNodeid) && (item = QueryServiceHelper.queryOne((String)CASHFLOWITEM_ENTITY, (String)LONGNUMBER, (QFilter[])new QFilter(ID, "=", (Object)GLUtil.transferStr2Long((Object)curNodeid)).toArray())) != null) {
            qlongnumber = new QFilter(LONGNUMBER, "like", (Object)(item.getString(LONGNUMBER) + "%"));
        }
        QFilter qids = BaseDataServiceHelper.getBaseDataFilter((String)CASHFLOWITEM_ENTITY, (Long)Long.parseLong(String.valueOf(curOrg)));
        HashSet<String> usefulNumber = new HashSet<String>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"fi.gl.PersetAccountList", (String)CASHFLOWITEM_ENTITY, (String)LONGNUMBER, (QFilter[])new QFilter[]{qids}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String longnumber = row.getString(LONGNUMBER);
                usefulNumber.add(longnumber);
            }
        }
        QFilter quseLongnumber = new QFilter(LONGNUMBER, "in", usefulNumber);
        QFilter[] filters = new QFilter[]{qorg, qlongnumber, quseLongnumber};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"fi.gl.PersetAccountList", (String)CASHFLOWITEM_ENTITY, (String)ID, (QFilter[])filters, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong(ID);
                ids.add(id);
            }
        }
        return ids;
    }
}

