/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api.formula.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.fi.gl.api.formula.param.BaseFormulaParam;

public class BuildParamUtil {
    public static String buildItemAndAssgrp(Collection<String> itemNums, Map<String, Set<String>> assgrpMap) {
        String accountStr = String.join((CharSequence)",", itemNums);
        String assistValueStr = BuildParamUtil.getAssistValueStr(assgrpMap);
        return accountStr + assistValueStr;
    }

    public static String getAssistValueStr(Map<String, Set<String>> map) {
        StringBuilder assistStr = new StringBuilder();
        if (Objects.nonNull(map)) {
            for (Map.Entry<String, Set<String>> assgrpEntry : map.entrySet()) {
                String assistTypeNum = assgrpEntry.getKey();
                String assistValNum = String.join((CharSequence)",", (Iterable<? extends CharSequence>)assgrpEntry.getValue());
                if (!Objects.nonNull(assistTypeNum)) continue;
                assistStr.append("|").append(assistTypeNum).append("|").append(assistValNum);
            }
        }
        return assistStr.toString();
    }

    public static Map<String, Object> getFormulaParamMap(Collection<? extends BaseFormulaParam> formulaParams) {
        HashMap<String, Object> formulaMap = new HashMap<String, Object>(8);
        for (BaseFormulaParam baseFormulaParam : formulaParams) {
            List<String> formulaParamList = baseFormulaParam.transToFormula();
            formulaMap.put(String.valueOf(formulaMap.size() + 1), formulaParamList);
        }
        return formulaMap;
    }
}

