/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.util.GLUtil;
import org.apache.commons.lang3.tuple.Pair;

public class AccountBookEntryUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(AccountBookEntryUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            try {
                AccountBookEntryUpgradeService.upgradeRelateBookEntry();
                AccountBookEntryUpgradeService.upgradeRelateOrgEntry();
                AccountBookEntryUpgradeService.checkUpdateResult();
                result.setSuccess(true);
            }
            catch (Exception e) {
                txHandle.markRollback();
                result.setErrorInfo(GLUtil.printError((Throwable)e));
                result.setSuccess(false);
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private static void checkUpdateResult() {
        Map<Long, List<Long>> faMap = AccountBookEntryUpgradeService.getOldTableInfo("fa");
        boolean faOk = AccountBookEntryUpgradeService.checkData(faMap, "fa");
        Map<Long, List<Long>> arMap = AccountBookEntryUpgradeService.getOldTableInfo("ar");
        boolean arOk = AccountBookEntryUpgradeService.checkData(arMap, "ar");
        Map<Long, List<Long>> calMap = AccountBookEntryUpgradeService.getOldTableInfo("cal");
        boolean calOk = AccountBookEntryUpgradeService.checkData(calMap, "cal");
        Map<Long, List<Long>> apMap = AccountBookEntryUpgradeService.getOldTableInfo("ap");
        boolean apOk = AccountBookEntryUpgradeService.checkData(apMap, "ap");
        Map<Long, List<Long>> casMap = AccountBookEntryUpgradeService.getOldTableInfo("cas");
        boolean casOk = AccountBookEntryUpgradeService.checkData(casMap, "cas");
        if (faOk || arOk || calOk || apOk || casOk) {
            logger.info("\u65b0\u8868\u6570\u636e\u63d2\u5165\u540e\uff0c\u65b0\u65e7\u8868\u6570\u636e\u68c0\u67e5\u4e0d\u901a\u8fc7\uff01");
            throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u8868\u6570\u636e\u63d2\u5165\u540e\uff0c\u65b0\u65e7\u8868\u6570\u636e\u68c0\u67e5\u672a\u901a\u8fc7\u3002", (String)"AccountBookEntryUpgradeService_1", (String)"fi-gl-upgradeservice", (Object[])new Object[0]));
        }
        logger.info("\u5386\u53f2\u6570\u636e\u5347\u7ea7\u6210\u529f\uff0c\u6821\u9a8c\u901a\u8fc7");
    }

    private static void upgradeRelateOrgEntry() {
        AccountBookEntryUpgradeService.upgradeRelateOrgEntry("ap");
        AccountBookEntryUpgradeService.upgradeRelateOrgEntry("cas");
    }

    private static void upgradeRelateBookEntry() {
        AccountBookEntryUpgradeService.upgradeRelateBookEntry("fa");
        AccountBookEntryUpgradeService.upgradeRelateBookEntry("ar");
        AccountBookEntryUpgradeService.upgradeRelateBookEntry("cal");
    }

    private static void upgradeRelateOrgEntry(String bizApp) {
        DBRoute fi = DBRoute.of((String)"fi");
        Pair<String, String> pairInfo = AccountBookEntryUpgradeService.getRelatePair(bizApp);
        DataSet assetBookDs = DB.queryDataSet((String)"upgradeRelateOrgEntry_oldData", (DBRoute)fi, (String)String.format("select fpkid, fid, fbasedataid from %s", pairInfo.getRight()));
        HashSet oldIdSet = new HashSet(16);
        assetBookDs.copy().forEach(r -> oldIdSet.add(r.getLong("fid") + ""));
        logger.info("{}\u5e94\u7528\uff0c\u65e7\u8868\u6570\u636e\u6709{}\u6761", (Object)bizApp, (Object)oldIdSet.size());
        DataSet assetEntryDs = DB.queryDataSet((String)"upgradeRelateOrgEntry_newData", (DBRoute)fi, (String)String.format("select fentryid, fid, fapp from t_bd_bookrelorgentry where fapp='%s'", pairInfo.getLeft()));
        HashSet<String> hasIdSet = new HashSet<String>(16);
        for (Row row : assetEntryDs) {
            String fid = row.getString("fid");
            if (!oldIdSet.contains(fid)) continue;
            hasIdSet.add(row.getLong("fid") + "");
        }
        logger.info("{}\u5e94\u7528\uff0c\u65e7\u8868\u4e0e\u65b0\u8868\u76f8\u540c\u6570\u636e\u6709{}\u6761", (Object)bizApp, (Object)hasIdSet.size());
        oldIdSet.removeAll(hasIdSet);
        if (oldIdSet.isEmpty()) {
            logger.info("{}\u5e94\u7528\uff0c\u65e7\u8868\u6570\u636e\u5df2\u5168\u90e8\u5347\u7ea7\u5b8c\u6210", (Object)bizApp);
            return;
        }
        logger.info("{}\u5e94\u7528\uff0c\u65e7\u8868\u5f85\u5347\u7ea7\u6570\u636e\u6709{}\u6761", (Object)bizApp, (Object)oldIdSet.size());
        assetBookDs = assetBookDs.filter("fid in (" + String.join((CharSequence)",", oldIdSet) + ')');
        HashMap<Long, List> assetMap = new HashMap<Long, List>(8);
        int oldDataSize = 0;
        for (Row row : assetBookDs) {
            String fid = row.getString("fid");
            if (!oldIdSet.contains(fid)) continue;
            List assetList = assetMap.computeIfAbsent(row.getLong("fid"), k -> new ArrayList());
            assetList.add(row.getLong("fbasedataid"));
            ++oldDataSize;
        }
        ArrayList<Object[]> entryParam = new ArrayList<Object[]>(8);
        ArrayList<Object[]> mulParam = new ArrayList<Object[]>(8);
        Set needDoSet = assetMap.keySet();
        long[] entryIdArr = DB.genLongIds((String)"t_bd_bookrelorgentry", (int)needDoSet.size());
        long[] newDataIdArr = DB.genLongIds((String)"t_bd_bookrelorgentry_sub", (int)oldDataSize);
        int i = 0;
        int j = 0;
        for (Map.Entry entry : assetMap.entrySet()) {
            Long fid = (Long)entry.getKey();
            List fbaseList = (List)entry.getValue();
            Object[] row = new Object[]{entryIdArr[i], fid, pairInfo.getLeft()};
            for (Long fbasedataid : fbaseList) {
                Object[] mulRow = new Object[]{newDataIdArr[j], entryIdArr[i], fbasedataid};
                mulParam.add(mulRow);
                ++j;
            }
            entryParam.add(row);
            ++i;
        }
        if (!entryParam.isEmpty()) {
            DB.executeBatch((DBRoute)fi, (String)"insert into t_bd_bookrelorgentry (fentryid,fid,fapp) values(?,?,?)", entryParam);
        }
        if (!mulParam.isEmpty()) {
            DB.executeBatch((DBRoute)fi, (String)"insert into t_bd_bookrelorgentry_sub (fpkid,fentryid,fbasedataid) values(?,?,?)", mulParam);
        }
    }

    private static void upgradeRelateBookEntry(String bizApp) {
        DBRoute fi = DBRoute.of((String)"fi");
        Pair<String, String> pairInfo = AccountBookEntryUpgradeService.getRelatePair(bizApp);
        DataSet assetBookDs = DB.queryDataSet((String)"upgradeRelateBookEntry_oldData", (DBRoute)fi, (String)String.format("select fpkid, fid, fbasedataid from %s", pairInfo.getRight()));
        HashSet oldIdSet = new HashSet(16);
        assetBookDs.copy().forEach(r -> oldIdSet.add(r.getLong("fid") + ""));
        logger.info("{}\u5e94\u7528\uff0c\u65e7\u8868\u6570\u636e\u6709{}\u6761", (Object)bizApp, (Object)oldIdSet.size());
        DataSet assetEntryDs = DB.queryDataSet((String)"upgradeRelateBookEntry_newData", (DBRoute)fi, (String)String.format("select fentryid, fid, fapp from t_bd_bookrelbizentry where fapp='%s'", pairInfo.getLeft()));
        HashSet<String> hasIdSet = new HashSet<String>(16);
        for (Row row : assetEntryDs) {
            String fid = row.getString("fid");
            if (!oldIdSet.contains(fid)) continue;
            hasIdSet.add(fid);
        }
        logger.info("{}\u5e94\u7528\uff0c\u65e7\u8868\u4e0e\u65b0\u8868\u76f8\u540c\u6570\u636e\u6709{}\u6761", (Object)bizApp, (Object)hasIdSet.size());
        oldIdSet.removeAll(hasIdSet);
        if (oldIdSet.isEmpty()) {
            logger.info("{}\u5e94\u7528\uff0c\u65e7\u8868\u6570\u636e\u5df2\u5168\u90e8\u5347\u7ea7\u5b8c\u6210", (Object)bizApp);
            return;
        }
        logger.info("{}\u5e94\u7528\uff0c\u65e7\u8868\u5f85\u5347\u7ea7\u6570\u636e\u6709{}\u6761", (Object)bizApp, (Object)oldIdSet.size());
        int oldDataSize = 0;
        HashMap<Long, List> assetMap = new HashMap<Long, List>(3);
        for (Row row : assetBookDs) {
            String fid = row.getString("fid");
            if (!oldIdSet.contains(fid)) continue;
            List assetList = assetMap.computeIfAbsent(row.getLong("fid"), k -> new ArrayList());
            assetList.add(row.getLong("fbasedataid"));
            ++oldDataSize;
        }
        ArrayList<Object[]> entryParam = new ArrayList<Object[]>(8);
        ArrayList<Object[]> mulParam = new ArrayList<Object[]>(8);
        long[] entryIdArr = DB.genLongIds((String)"t_bd_bookrelbizentry", (int)assetMap.size());
        long[] newDataIdArr = DB.genLongIds((String)"t_bd_bookrelbizentry_sub", (int)oldDataSize);
        int i = 0;
        int j = 0;
        for (Map.Entry entry : assetMap.entrySet()) {
            Long fid = (Long)entry.getKey();
            List fbaseList = (List)entry.getValue();
            Object[] row = new Object[]{entryIdArr[i], fid, pairInfo.getLeft()};
            for (Long fbasedataid : fbaseList) {
                Object[] mulRow = new Object[]{newDataIdArr[j], entryIdArr[i], fbasedataid};
                mulParam.add(mulRow);
                ++j;
            }
            entryParam.add(row);
            ++i;
        }
        if (!entryParam.isEmpty()) {
            DB.executeBatch((DBRoute)fi, (String)"insert into t_bd_bookrelbizentry (fentryid,fid,fapp) values(?,?,?)", entryParam);
        }
        if (!mulParam.isEmpty()) {
            DB.executeBatch((DBRoute)fi, (String)"insert into t_bd_bookrelbizentry_sub (fpkid,fentryid,fbasedataid) values(?,?,?)", mulParam);
        }
    }

    public static Pair<String, String> getRelatePair(String bizApp) {
        Pair pair;
        switch (bizApp) {
            case "fa": {
                pair = Pair.of((Object)"83bfebc800001aac", (Object)"t_bd_assetbookentry");
                break;
            }
            case "ar": {
                pair = Pair.of((Object)"/BBRH+122=39", (Object)"t_bd_policybookentry");
                break;
            }
            case "cal": {
                pair = Pair.of((Object)"/KIUHEXROK3D", (Object)"t_bd_costaccountentry");
                break;
            }
            case "ap": {
                pair = Pair.of((Object)"+HKZHSKFXOX", (Object)"t_bd_glrefaporgs");
                break;
            }
            case "cas": {
                pair = Pair.of((Object)"d2bb1733000000ac", (Object)"t_bd_glrefcasorgs");
                break;
            }
            default: {
                pair = Pair.of((Object)"", (Object)"");
            }
        }
        return pair;
    }

    private static Map<Long, List<Long>> getOldTableInfo(String bizApp) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>();
        DBRoute fi = DBRoute.of((String)"fi");
        Pair<String, String> pairInfo = AccountBookEntryUpgradeService.getRelatePair(bizApp);
        DataSet oldTableDs = DB.queryDataSet((String)"getOldTableInfo", (DBRoute)fi, (String)String.format("select p.fpkid, p.fid, p.fbasedataid from %s p inner join t_bd_accountbooks b on p.fid = b.fid where b.fenable='1' ", pairInfo.getRight()));
        for (Row row : oldTableDs) {
            List list = resultMap.computeIfAbsent(row.getLong("fid"), r -> new ArrayList());
            list.add(row.getLong("fbasedataid"));
        }
        return resultMap;
    }

    private static Map<Long, List<Long>> getNewTableInfo(Set<Long> ids, String bizApp) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>();
        DBRoute fi = DBRoute.of((String)"fi");
        Pair<String, String> pairInfo = AccountBookEntryUpgradeService.getRelatePair(bizApp);
        String entryTable = "ap".equals(bizApp) || "cas".equals(bizApp) ? "t_bd_bookrelorgentry" : "t_bd_bookrelbizentry";
        String subTable = "ap".equals(bizApp) || "cas".equals(bizApp) ? "t_bd_bookrelorgentry_sub" : "t_bd_bookrelbizentry_sub";
        Set idSet = ids.stream().map(r -> r + "").collect(Collectors.toSet());
        if (idSet.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,b.fentryid from t_bd_accountbooks a inner join ", new Object[0]);
        sqlBuilder.append(entryTable, new Object[0]);
        sqlBuilder.append(" b on a.fid=b.fid where ", new Object[0]);
        sqlBuilder.appendIn("a.fid ", idSet.stream().map(Long::parseLong).collect(Collectors.toList()));
        sqlBuilder.append(" and b.fapp = ?", new Object[]{pairInfo.getLeft()});
        if (DebugTrace.enable()) {
            logger.info("debug sql: {}", (Object)sqlBuilder.toString());
        }
        DataSet newTableDs = DB.queryDataSet((String)"getNewTableInfo", (DBRoute)fi, (SqlBuilder)sqlBuilder);
        DataSet subTableDs = DB.queryDataSet((String)"getNewTableInfo_sub", (DBRoute)fi, (String)String.format("select fentryid,fbasedataid from %s", subTable));
        DataSet joinDs = newTableDs.join(subTableDs).on("fentryid", "fentryid").select(newTableDs.getRowMeta().getFieldNames(), new String[]{"fbasedataid"}).finish();
        for (Row row : joinDs) {
            List list = resultMap.computeIfAbsent(row.getLong("fid"), r -> new ArrayList());
            list.add(row.getLong("fbasedataid"));
        }
        return resultMap;
    }

    private static boolean checkData(Map<Long, List<Long>> oldDataMap, String bizApp) {
        if (oldDataMap == null || oldDataMap.isEmpty()) {
            logger.info("{}\u5e94\u7528\uff0c\u65e7\u8868\u65e0\u6570\u636e\uff0c\u4e0d\u7528\u6838\u5bf9", (Object)bizApp);
            return false;
        }
        Map<Long, List<Long>> entryDataMap = AccountBookEntryUpgradeService.getNewTableInfo(oldDataMap.keySet(), bizApp);
        for (Map.Entry<Long, List<Long>> entry : oldDataMap.entrySet()) {
            List<Long> entryList = entryDataMap.get(entry.getKey());
            if (entryList == null) {
                logger.info("{}\u5e94\u7528\uff0c\u65e7\u8868\u6709\u6570\u636e\uff0c\u65b0\u8868\u5374\u65e0\u6570\u636e\u3002\u5bf9\u5e94\u603b\u8d26\u4f1a\u8ba1\u8d26\u7c3fid\u4e3a{}", (Object)bizApp, (Object)entry.getKey());
                return true;
            }
            List<Long> oldDataList = entry.getValue();
            ArrayList<Long> oldCopy = new ArrayList<Long>(oldDataList);
            oldCopy.removeAll(entryList);
            if (!oldCopy.isEmpty()) {
                logger.info("{}\u5e94\u7528\uff0c\u65e7\u8868\u6709\u6570\u636e\uff0c\u65b0\u5206\u5f55\u8868\u4e2d\u5374\u6ca1\u6570\u636e\u3002\u5bf9\u5e94\u603b\u8d26\u4f1a\u8ba1\u8d26\u7c3fid\u4e3a{}", (Object)bizApp, (Object)entry.getKey());
                return true;
            }
            ArrayList<Long> newCopy = new ArrayList<Long>(entryList);
            newCopy.retainAll(oldDataList);
            if (newCopy.size() == oldDataList.size()) continue;
            logger.info("{}\u5e94\u7528\uff0c\u65b0\u8868\u6570\u636e\u4e0d\u6b62\u5305\u542b\u4e00\u4efd\u65e7\u8868\u6570\u636e\u3002\u5bf9\u5e94\u603b\u8d26\u4f1a\u8ba1\u8d26\u7c3fid\u4e3a{}", (Object)bizApp, (Object)entry.getKey());
            return true;
        }
        return false;
    }
}

