/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.GLUtil;

public class AccountBookNumberUpgradeService
implements IUpgradeService {
    private static final String UPDATE_SQL = "UPDATE t_bd_accountbooks SET fnumber = ? WHERE fid = ?;";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            try {
                int count = this.updateAccountBookNumber();
                result.setSuccess(true);
                result.setLog(String.format(ResManager.loadKDString((String)"\u66f4\u65b0%s AccountBookNumberUpgradeService_0", (String)"AccountBookNumberUpgrade_0", (String)"fi-gl-upgradeservice", (Object[])new Object[0]), count));
            }
            catch (Exception e) {
                txHandle.markRollback();
                result.setErrorInfo(GLUtil.printError((Throwable)e));
                result.setSuccess(false);
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private int updateAccountBookNumber() {
        ArrayList<Object[]> params;
        int rows = 0;
        DBRoute gl = DBRoute.of((String)"fi");
        DataSet accountBookDs = QueryServiceHelper.queryDataSet((String)"AccountBookNumberUpgradeService.queryAccountBook", (String)"gl_accountbook", (String)"id,number accountBookNumber,org.number orgNumber,bookstype.number bookstypeNumber", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)" ")}, null);
        Object object = null;
        try {
            params = new ArrayList<Object[]>(accountBookDs.copy().count("id", true));
            Iterator iter = accountBookDs.iterator();
            while (iter != null && iter.hasNext()) {
                String bookstypeNumber;
                Row row = (Row)iter.next();
                Long accountBookId = row.getLong("id");
                String accountBookNumber = row.getString("accountBookNumber");
                String orgNumber = row.getString("orgNumber") != null ? row.getString("orgNumber") : "";
                String string = bookstypeNumber = row.getString("bookstypeNumber") != null ? row.getString("bookstypeNumber") : "";
                if (!StringUtils.isBlank((CharSequence)accountBookNumber)) continue;
                accountBookNumber = orgNumber + "@" + bookstypeNumber;
                params.add(new Object[]{accountBookNumber, accountBookId});
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (accountBookDs != null) {
                if (object != null) {
                    try {
                        accountBookDs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    accountBookDs.close();
                }
            }
        }
        if (!CollectionUtils.isEmpty(params)) {
            int[] executeBatch = DB.executeBatch((DBRoute)gl, (String)UPDATE_SQL, params);
            for (Object i : (Object)executeBatch) {
                rows += i;
            }
        }
        return rows;
    }
}

