/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

public class AmortCustomUpgradeService
implements IUpgradeService {
    private static final int BATCH_SIZE = 3000;
    private static final DBRoute FI = DBRoute.of((String)"fi");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.doUpgrade();
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(GLUtil.printError((Throwable)e));
            result.setSuccess(false);
        }
        return result;
    }

    private void doUpgrade() {
        long startIndex = 0L;
        for (int count = 0; count < BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"prop.fi.gl.customamort.upgrade.maxbatch", (int)50000); ++count) {
            long endIndex = this.getEndIndex(startIndex);
            if (endIndex <= 0L) {
                return;
            }
            this.batchUpdate(startIndex, endIndex);
            startIndex = endIndex;
        }
    }

    private void batchUpdate(long startIndex, long endIndex) {
        DynamicObject[] amorts;
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", ">", (Object)startIndex).add("id", "<=", (Object)endIndex).add("amortstyle", "=", (Object)"4").add("status", "=", (Object)"2");
        for (DynamicObject dyn : amorts = BusinessDataServiceHelper.load((String)"gl_voucheramortacheme", (String)"amortamount,policies.period,custompolicies.camount,custompolicies.cperiod,totalamount,status", (QFilter[])qfBuilder.toArray())) {
            BigDecimal total = BigDecimal.ZERO;
            List periods = dyn.getDynamicObjectCollection("policies").stream().map(x -> x.getLong("period_id")).collect(Collectors.toList());
            for (DynamicObject row : dyn.getDynamicObjectCollection("custompolicies")) {
                if (!periods.contains(row.getLong("cperiod_id"))) continue;
                total = total.add(row.getBigDecimal("camount"));
            }
            dyn.set("amortamount", (Object)total);
            if (total.compareTo(dyn.getBigDecimal("totalamount")) != 0) continue;
            dyn.set("status", (Object)"3");
        }
        SaveServiceHelper.save((DynamicObject[])amorts);
    }

    private long getEndIndex(long startIndex) {
        return (Long)DB.query((DBRoute)FI, (String)"select max(fid) fid from(select top 3000 fid from t_gl_voucheramortscheme where fid > ? and famortstyle='4' and famortstatus='2' order by fid asc) a", (Object[])new Object[]{startIndex}, resultSet -> resultSet.next() ? resultSet.getLong("fid") : 0L);
    }
}

