/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.gl.util.ManageItemUtils;

public class BalanceSheetUpgrade {
    private static final String DELETE_SQL = "DELETE FROM T_GL_BALANCESHEETEXP WHERE FORGID=? AND FACCOUNTTABLEID=? AND FORWID=?  AND FCOLUMNKEY=?;";
    private static final String INSERT_SQL = "INSERT INTO T_GL_BALANCESHEETEXP(FID,FACCOUNTTABLEID,FORGID,FORWID,FBOOKTYPEID,FISTOTALROW,FORGVIEWID,FCOLUMNKEY)VALUES (?,?,?,?,0,'1',0,?);";
    private static final String DELETE_ENTRYSQL = "DELETE FROM T_GL_BALANCESHEETEXPENTRY WHERE FENTRYID = ?;";
    private static final String INSERT_ENTRYSQL = "INSERT INTO T_GL_BALANCESHEETEXPENTRY(FFETCHRULE,FID,FRPTITEMID,FENTRYID,FSIGN,FACCOUNTID,FSEQ) VALUES ('0',?,?,?,?,0,?);";
    private List<Object[]> deleteObjects = new ArrayList<Object[]>();
    private List<Object[]> insertObjects = new ArrayList<Object[]>();
    private List<Object[]> deleteEntryObjects = new ArrayList<Object[]>();
    private List<Object[]> insertEntryObjects = new ArrayList<Object[]>();

    public UpgradeResult upgrade() {
        UpgradeResult result = new UpgradeResult();
        Map itemAndExpressionMap = ManageItemUtils.getBalanceSheetPresetExpressions();
        DBRoute gl = DBRoute.of((String)"gl");
        String selectSql = "SELECT A.FACCOUNTORGID org,A.FACCOUNTTABLEID accounttable,B.FINDEX balrowid, B.FASSETID asset, B.FEQUITYID equity, C1.FISTOTALROW assettype, C2.FISTOTALROW equitytype FROM T_GL_BALANCESHEET A INNER JOIN T_GL_BALANCESHEETENTRY B ON A.FID=B.FID LEFT JOIN T_GL_MANAGERPTITEM C1 ON B.FASSETID =C1.FID LEFT JOIN T_GL_MANAGERPTITEM C2 ON B.FEQUITYID =C2.FID WHERE (C1.FISTOTALROW='1' OR C2.FISTOTALROW='1');";
        try (DataSet dSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)gl, (String)selectSql);){
            for (Row row : dSet) {
                Long orgId = row.getLong("org");
                Long accountTableId = row.getLong("accounttable");
                Integer balRowId = row.getInteger("balrowid");
                if (row.getBoolean("assettype").booleanValue()) {
                    Long assetId = row.getLong("asset");
                    this.createExpSqlObj(itemAndExpressionMap, orgId, accountTableId, balRowId, 1, 2, assetId);
                }
                if (!row.getBoolean("equitytype").booleanValue()) continue;
                Long equityId = row.getLong("equity");
                this.createExpSqlObj(itemAndExpressionMap, orgId, accountTableId, balRowId, 3, 4, equityId);
            }
        }
        var6_6 = null;
        try (TXHandle txHandle = TX.requiresNew((String)"balancesheetexpression");){
            try {
                if (!this.deleteObjects.isEmpty()) {
                    DB.executeBatch((DBRoute)gl, (String)DELETE_SQL, this.deleteObjects);
                }
                if (!this.insertObjects.isEmpty()) {
                    DB.executeBatch((DBRoute)gl, (String)INSERT_SQL, this.insertObjects);
                }
                if (!this.deleteEntryObjects.isEmpty()) {
                    DB.executeBatch((DBRoute)gl, (String)DELETE_ENTRYSQL, this.deleteEntryObjects);
                }
                if (!this.insertEntryObjects.isEmpty()) {
                    DB.executeBatch((DBRoute)gl, (String)INSERT_ENTRYSQL, this.insertEntryObjects);
                }
            }
            catch (Exception e) {
                result.setErrorInfo(e.getMessage());
                result.setLog(e.getMessage());
                result.setSuccess(false);
                txHandle.markRollback();
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u62a5\u8868\u9879\u76ee\u5408\u8ba1\u884c\u5386\u53f2\u6570\u636e\u5df2\u66f4\u65b0\u3002", (String)"BalanceSheetUpgrade_0", (String)"fi-gl-upgradeservice", (Object[])new Object[0]));
        return result;
    }

    private void createExpSqlObj(Map<Long, List<String>> itemAndExpressionMap, Long orgId, Long accountTableId, Integer balRowId, int startCol, int endCol, Long itemId) {
        List<String> expressions = itemAndExpressionMap.get(itemId);
        if (expressions != null) {
            SequenceReader sReader = new SequenceReader(new DBRoute("gl"));
            Long[] ids = (Long[])sReader.getSequences((Object[])new Long[1], "T_GL_BALANCESHEET", endCol - startCol + 1);
            int i = 0;
            for (int colKey = startCol; colKey <= endCol; ++colKey) {
                Long id = ids[i];
                this.deleteObjects.add(new Object[]{orgId, accountTableId, balRowId, colKey});
                this.insertObjects.add(new Object[]{id, accountTableId, orgId, balRowId, colKey});
                this.createEntrySqlObj(expressions, id);
                ++i;
            }
        }
    }

    private void createEntrySqlObj(List<String> expressions, Long id) {
        SequenceReader sReader = new SequenceReader(new DBRoute("gl"));
        Long[] entryIds = (Long[])sReader.getSequences((Object[])new Long[expressions.size()], "T_GL_BALANCESHEETEXPENTRY", expressions.size());
        for (int i = 0; i < expressions.size(); ++i) {
            String[] split = expressions.get(i).split(",");
            Long entryId = entryIds[i];
            this.deleteEntryObjects.add(new Object[]{entryId});
            this.insertEntryObjects.add(new Object[]{id, split[0], entryId, split[1], i});
        }
    }
}

