/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.GLUtil;

public class BalancesheetRepairUpgradeService
implements IUpgradeService {
    private static final String TABLE_INCOME_EXPRESSION = "gl_incomeexpression";
    private static final String TABLE_BALANCE_EXPRESSION = "gl_balancesheetexpression";
    private static final String FIELD_COLUMN_KEY = "columnkey";
    private static final String FIELD_RPTITEM = "rptitem";
    private static final String FIELD_IS_TOTAL_ROW = "istotalrow";
    private static final String FIELD_ORG = "org";
    private static final String FIELD_BOOK_TYPE = "booktype";
    private static final String FIELD_BOOKS_TYPE = "bookstype";
    private static final String FIELD_ACCTABLE = "accounttable";
    private static final String FIELD_BALROW_ID = "balrowid";
    private static final String FIELD_SIGN = "sign";
    private static final String FIELD_FETCH_RULE = "fetchrule";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_PROJECT = "project";
    private static final String FIELD_ENTRY_KEY = "entryentity";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            try {
                this.upgrade(TABLE_BALANCE_EXPRESSION);
                this.upgrade(TABLE_INCOME_EXPRESSION);
                result.setSuccess(true);
            }
            catch (Exception e) {
                txHandle.markRollback();
                result.setErrorInfo(GLUtil.printError((Throwable)e));
                result.setSuccess(false);
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private void upgrade(String entityName) {
        ArrayList<String> groupField = new ArrayList<String>();
        groupField.add(FIELD_ORG);
        groupField.add(FIELD_ACCTABLE);
        String selectFields = "org, accounttable";
        if (TABLE_INCOME_EXPRESSION.equals(entityName)) {
            selectFields = selectFields + ", type";
            groupField.add(FIELD_TYPE);
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)selectFields, (QFilter[])new QFilter(FIELD_BOOK_TYPE, "=", (Object)0L).toArray(), null);
        DataSet groupByOrgDataSet = ds.copy().groupBy(groupField.toArray(new String[0])).finish();
        while (groupByOrgDataSet.hasNext()) {
            Map resourceSheetExp;
            List<DynamicObject> needRepairAccountBook;
            Row row = groupByOrgDataSet.next();
            long orgId = row.getLong(FIELD_ORG);
            String type = "";
            if (TABLE_INCOME_EXPRESSION.equals(entityName)) {
                type = row.getString(FIELD_TYPE);
            }
            if (CollectionUtils.isEmpty(needRepairAccountBook = this.getNeedRepairAccountBook(orgId, type, entityName))) continue;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter(FIELD_ORG, "=", (Object)orgId));
            qFilters.add(new QFilter(FIELD_BOOK_TYPE, "=", (Object)0L));
            qFilters.add(new QFilter(FIELD_ACCTABLE, "=", row.get(FIELD_ACCTABLE)));
            if (!StringUtils.isEmpty((Object)type)) {
                qFilters.add(new QFilter(FIELD_TYPE, "=", (Object)type));
            }
            if (CollectionUtils.isEmpty((Map)(resourceSheetExp = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])qFilters.toArray(new QFilter[0]))))) continue;
            this.repairData(needRepairAccountBook, resourceSheetExp, entityName);
        }
    }

    private List<DynamicObject> getNeedRepairAccountBook(long orgId, String type, String entityName) {
        ArrayList<DynamicObject> needRepairAccountBooks = new ArrayList<DynamicObject>();
        QFilter orgFilter = new QFilter(FIELD_ORG, "=", (Object)orgId);
        Map accountBooks = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (QFilter[])orgFilter.toArray());
        if (!CollectionUtils.isEmpty((Map)accountBooks)) {
            for (Map.Entry accountBookEntry : accountBooks.entrySet()) {
                boolean isExists;
                DynamicObject accountBook = (DynamicObject)accountBookEntry.getValue();
                long bookTypeId = accountBook.getLong(GLField.id_((String)FIELD_BOOKS_TYPE));
                if (bookTypeId == 0L) continue;
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(orgFilter);
                qFilters.add(new QFilter(FIELD_BOOK_TYPE, "=", (Object)bookTypeId));
                qFilters.add(new QFilter(FIELD_ACCTABLE, "=", (Object)accountBook.getLong(GLField.id_((String)FIELD_ACCTABLE))));
                if (!StringUtils.isEmpty((Object)type)) {
                    qFilters.add(new QFilter(FIELD_TYPE, "=", (Object)type));
                }
                if (isExists = QueryServiceHelper.exists((String)entityName, (QFilter[])qFilters.toArray(new QFilter[0]))) continue;
                needRepairAccountBooks.add((DynamicObject)accountBookEntry.getValue());
            }
        }
        return needRepairAccountBooks;
    }

    private boolean repairData(List<DynamicObject> needRepairAccountBook, Map<Object, DynamicObject> reourceSheetExp, String entityName) {
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(1000);
        for (DynamicObject accountBook : needRepairAccountBook) {
            List<DynamicObject> dynamicObjectList = this.copySheetExp(accountBook, reourceSheetExp, entityName);
            records.addAll(dynamicObjectList);
            if (records.size() < 1000) continue;
            SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
            records.clear();
        }
        if (!records.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
        }
        return Boolean.TRUE;
    }

    private List<DynamicObject> copySheetExp(DynamicObject accountBook, Map<Object, DynamicObject> resourceSheetExp, String entityName) {
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Object, DynamicObject> sheetExp : resourceSheetExp.entrySet()) {
            DynamicObject newExpDyn = this.newExpDyn(sheetExp.getValue(), accountBook, entityName);
            records.add(newExpDyn);
        }
        return records;
    }

    private DynamicObject newExpDyn(DynamicObject resourceDynamicObject, DynamicObject accountBook, String entityName) {
        DynamicObject newExpDyn = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        newExpDyn.set(FIELD_ORG, resourceDynamicObject.get(FIELD_ORG));
        newExpDyn.set(FIELD_BOOK_TYPE, (Object)accountBook.getLong(GLField.id_((String)FIELD_BOOKS_TYPE)));
        newExpDyn.set(FIELD_BALROW_ID, (Object)resourceDynamicObject.getString(FIELD_BALROW_ID));
        newExpDyn.set(FIELD_COLUMN_KEY, (Object)resourceDynamicObject.getString(FIELD_COLUMN_KEY));
        newExpDyn.set(FIELD_ACCTABLE, (Object)accountBook.getLong(GLField.id_((String)FIELD_ACCTABLE)));
        newExpDyn.set(FIELD_IS_TOTAL_ROW, resourceDynamicObject.get(FIELD_IS_TOTAL_ROW));
        if (TABLE_INCOME_EXPRESSION.equals(entityName)) {
            newExpDyn.set(FIELD_TYPE, resourceDynamicObject.get(FIELD_TYPE));
        }
        DynamicObjectCollection newColl = newExpDyn.getDynamicObjectCollection(FIELD_ENTRY_KEY);
        DynamicObjectCollection coll = resourceDynamicObject.getDynamicObjectCollection(FIELD_ENTRY_KEY);
        newColl.clear();
        if (coll.isEmpty()) {
            return newExpDyn;
        }
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject row = (DynamicObject)coll.get(i);
            DynamicObject newRow = new DynamicObject(coll.getDynamicObjectType());
            newRow.set(FIELD_PROJECT, row.get(GLField.id_((String)FIELD_PROJECT)));
            newRow.set(FIELD_SIGN, row.get(FIELD_SIGN));
            newRow.set(FIELD_FETCH_RULE, row.get(FIELD_FETCH_RULE));
            newRow.set(FIELD_RPTITEM, row.get(GLField.id_((String)FIELD_RPTITEM)));
            newColl.add((Object)newRow);
        }
        return newExpDyn;
    }
}

