/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.GLUtil;

public class BalancesheetUpgradeService
implements IUpgradeService {
    private static final String INCOME_EDIT = "gl_incomeedit";
    private static final String INCOM_EXPRESSION_FORM_ID = "gl_incomeexpression";
    private static final String ENTITY_BALANCESHEET_EDIT = "gl_balancesheetedit";
    private static final String BALANCE_EXPRESSION_FORM_ID = "gl_balancesheetexpression";
    private static final String ENTITY_BD_ACCOUNTBOOKSTYPE = "bd_accountbookstype";
    private static final String EXPRESSION_FORM_ID = "gl_balancesheetexpression";
    private static final String COLUMNKEY = "columnkey";
    private static final String RPTITEM = "rptitem";
    private static final String ISTOTALROW = "istotalrow";
    private static final String ORG = "org";
    private static final String ORG_VIEW = "orgview";
    private static final String BOOK_TYPE = "booktype";
    private static final String ACCTABLE = "accounttable";
    private static final String ENTRY_KEY = "entryentity";
    private static final String ASSET_ROW = "assetrow";
    private static final String EQUITY_ROW = "equityrow";
    private static final String ASSET = "asset";
    private static final String EQUITY = "equity";
    private static final String BALROW_ID = "balrowid";
    private static final String ASSET_BEGIN = "assetbegin";
    private static final String ASSET_CLOSE = "assetclose";
    private static final String EQUITY_BEGIN = "equitybegin";
    private static final String EQUITY_CLOSE = "equityclose";
    private static final String SIGN = "sign";
    private static final String FETCH_RULE = "fetchrule";
    private static final String ACCOUNT_TYPE = "accounttype";
    private static final String TYPE = "type";
    private static final String INDEX = "index";
    private static final String PROJECT = "project";
    private static final String CURRENT_PERIOD = "currentperiod";
    private static final String YEAR_COUNT = "yearcount";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            try {
                this.upgrade(ENTITY_BALANCESHEET_EDIT);
                this.upgrade(INCOME_EDIT);
                result.setSuccess(true);
            }
            catch (Exception e) {
                txHandle.markRollback();
                result.setErrorInfo(GLUtil.printError((Throwable)e));
                result.setSuccess(false);
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private void upgrade(String entityName) {
        ArrayList<String> groupField = new ArrayList<String>();
        String filterString = "org = %d";
        groupField.add(ORG);
        String selectFields = "id, org, orgview, booktype, accounttable";
        if (INCOME_EDIT.equals(entityName)) {
            selectFields = selectFields + ", type";
            filterString = filterString + " and type = '%s'";
            groupField.add(TYPE);
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityName, (String)selectFields, null, null);
        DataSet groupByOrgDataSet = ds.copy().groupBy(groupField.toArray(new String[0])).finish();
        while (groupByOrgDataSet.hasNext()) {
            Row row = groupByOrgDataSet.next();
            long orgId = row.getLong(ORG);
            String type = "";
            if (INCOME_EDIT.equals(entityName)) {
                type = row.getString(TYPE);
            }
            DataSet dsGroupByOrg = ds.copy().filter(String.format(filterString, orgId, type));
            ArrayList<Long> bookTypeIds = new ArrayList<Long>();
            DynamicObject mainAccountSheet = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            int index = 0;
            for (Row rowData : dsGroupByOrg) {
                if (index == 0 || this.isMainAccount(rowData)) {
                    mainAccountSheet.set("id", rowData.get("id"));
                    mainAccountSheet.set(ORG, rowData.get(ORG));
                    mainAccountSheet.set(ORG_VIEW, rowData.get(ORG_VIEW));
                    mainAccountSheet.set(BOOK_TYPE, rowData.get(BOOK_TYPE));
                    mainAccountSheet.set(ACCTABLE, rowData.get(ACCTABLE));
                    if (INCOME_EDIT.equals(entityName)) {
                        mainAccountSheet.set(TYPE, rowData.get(TYPE));
                    }
                }
                bookTypeIds.add(rowData.getLong(BOOK_TYPE));
                ++index;
            }
            this.dealSheetForOrg(mainAccountSheet, bookTypeIds, entityName);
        }
    }

    private boolean dealSheetForOrg(DynamicObject mainAccountSheet, List<Long> bookTypeIds, String entityName) {
        Map accounts = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (QFilter[])new QFilter(ORG, "=", (Object)mainAccountSheet.getLong(ORG)).toArray());
        if (!CollectionUtils.isEmpty((Map)accounts)) {
            String sheetProjectName = "gl_balancesheetexpression";
            ArrayList<DynamicObject> records = new ArrayList<DynamicObject>();
            for (Map.Entry accountEntry : accounts.entrySet()) {
                DynamicObject account = (DynamicObject)accountEntry.getValue();
                long bookTypeId = account.getLong(GLField.id_((String)"bookstype"));
                if (0L == bookTypeId || bookTypeIds.contains(bookTypeId)) continue;
                DynamicObject balanceSheet = BusinessDataServiceHelper.newDynamicObject((String)entityName);
                balanceSheet.set(BOOK_TYPE, (Object)bookTypeId);
                balanceSheet.set(ACCTABLE, account.get(GLField.id_((String)ACCTABLE)));
                if (INCOME_EDIT.equals(entityName)) {
                    balanceSheet.set(TYPE, (Object)mainAccountSheet.getString(TYPE));
                    sheetProjectName = INCOM_EXPRESSION_FORM_ID;
                }
                this.setBalanceSheet(mainAccountSheet, balanceSheet, entityName);
                records.add(balanceSheet);
            }
            if (!records.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
            }
            this.dealSheetProject(mainAccountSheet, records, sheetProjectName);
        }
        return Boolean.TRUE;
    }

    private boolean dealSheetProject(DynamicObject mainAccountSheet, List<DynamicObject> copyBalanceSheet, String entityName) {
        if (!CollectionUtils.isEmpty(copyBalanceSheet)) {
            Map objectDynamicObjectMap;
            ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(1000);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
            qFilters.add(new QFilter(ORG, "=", (Object)mainAccountSheet.getLong(ORG)));
            qFilters.add(new QFilter(BOOK_TYPE, "=", (Object)mainAccountSheet.getLong(GLField.id_((String)BOOK_TYPE))));
            qFilters.add(new QFilter(ACCTABLE, "=", (Object)mainAccountSheet.getLong(ACCTABLE)));
            if (INCOM_EXPRESSION_FORM_ID.equals(entityName)) {
                qFilters.add(new QFilter(TYPE, "=", (Object)mainAccountSheet.getString(TYPE)));
            }
            if (!CollectionUtils.isEmpty((Map)(objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])qFilters.toArray(new QFilter[0]))))) {
                for (DynamicObject balanceSheet : copyBalanceSheet) {
                    for (Map.Entry objectDynamicObjectEntry : objectDynamicObjectMap.entrySet()) {
                        DynamicObject balanceExpression = (DynamicObject)objectDynamicObjectEntry.getValue();
                        DynamicObject newBalanceExpression = this.newExpDyn(balanceExpression, balanceSheet, entityName);
                        records.add(newBalanceExpression);
                        if (records.size() < 1000) continue;
                        SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
                        records.clear();
                    }
                }
                if (!records.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])records.toArray(new DynamicObject[0]));
                }
            }
        }
        return Boolean.TRUE;
    }

    private void setBalanceSheet(DynamicObject mainAccountSheet, DynamicObject balanceSheet, String entityName) {
        balanceSheet.set(ORG, mainAccountSheet.get(ORG));
        balanceSheet.set(ORG_VIEW, mainAccountSheet.get(ORG_VIEW));
        DynamicObjectCollection dynamicObjectCollection = balanceSheet.getDynamicObjectCollection(ENTRY_KEY);
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{mainAccountSheet.getLong("id")}, (String)entityName);
        if (!CollectionUtils.isEmpty((Map)objectDynamicObjectMap)) {
            for (Map.Entry objectDynamicObjectEntry : objectDynamicObjectMap.entrySet()) {
                DynamicObject value = (DynamicObject)objectDynamicObjectEntry.getValue();
                DynamicObjectCollection entryDatas = value.getDynamicObjectCollection(ENTRY_KEY);
                if (CollectionUtils.isEmpty((Collection)entryDatas)) continue;
                for (DynamicObject entryData : entryDatas) {
                    DynamicObject entry = new DynamicObject(entryDatas.getDynamicObjectType());
                    entry.set(BALROW_ID, (Object)entryData.getInt(BALROW_ID));
                    if (ENTITY_BALANCESHEET_EDIT.equals(entityName)) {
                        entry.set(ASSET_ROW, (Object)entryData.getInt(ASSET_ROW));
                        entry.set(ASSET_BEGIN, (Object)entryData.getString(ASSET_BEGIN));
                        entry.set(ASSET_CLOSE, (Object)entryData.getString(ASSET_CLOSE));
                        entry.set(EQUITY_ROW, (Object)entryData.getString(EQUITY_ROW));
                        entry.set(EQUITY_BEGIN, (Object)entryData.getString(EQUITY_BEGIN));
                        entry.set(EQUITY_CLOSE, (Object)entryData.getString(EQUITY_CLOSE));
                        entry.set(ASSET, (Object)entryData.getInt(GLField.id_((String)ASSET)));
                        entry.set(EQUITY, (Object)entryData.getInt(GLField.id_((String)EQUITY)));
                    } else if (INCOME_EDIT.equals(entityName)) {
                        entry.set(INDEX, (Object)entryData.getInt(INDEX));
                        entry.set(PROJECT, (Object)entryData.getLong(GLField.id_((String)PROJECT)));
                    }
                    dynamicObjectCollection.add((Object)entry);
                }
            }
        }
    }

    private DynamicObject newExpDyn(DynamicObject expDyn, DynamicObject balanceSheet, String entityName) {
        DynamicObject newExpDyn = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        newExpDyn.set(ORG, expDyn.get(ORG));
        newExpDyn.set(BOOK_TYPE, (Object)balanceSheet.getLong(GLField.id_((String)BOOK_TYPE)));
        newExpDyn.set(BALROW_ID, (Object)expDyn.getString(BALROW_ID));
        newExpDyn.set(COLUMNKEY, (Object)expDyn.getString(COLUMNKEY));
        newExpDyn.set(ACCTABLE, (Object)balanceSheet.getLong(GLField.id_((String)ACCTABLE)));
        newExpDyn.set(ISTOTALROW, expDyn.get(ISTOTALROW));
        if (INCOM_EXPRESSION_FORM_ID.equals(entityName)) {
            newExpDyn.set(TYPE, expDyn.get(TYPE));
        }
        DynamicObjectCollection newColl = newExpDyn.getDynamicObjectCollection(ENTRY_KEY);
        DynamicObjectCollection coll = expDyn.getDynamicObjectCollection(ENTRY_KEY);
        newColl.clear();
        if (coll.isEmpty()) {
            return newExpDyn;
        }
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject row = (DynamicObject)coll.get(i);
            DynamicObject newRow = new DynamicObject(coll.getDynamicObjectType());
            newRow.set(PROJECT, row.get(GLField.id_((String)PROJECT)));
            newRow.set(SIGN, row.get(SIGN));
            newRow.set(FETCH_RULE, row.get(FETCH_RULE));
            newRow.set(RPTITEM, row.get(GLField.id_((String)RPTITEM)));
            newColl.add((Object)newRow);
        }
        return newExpDyn;
    }

    private boolean isMainAccount(Row row) {
        Long bookTypeId = row.getLong(BOOK_TYPE);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)bookTypeId), new QFilter(ACCOUNT_TYPE, "=", (Object)"1")};
        return QueryServiceHelper.exists((String)ENTITY_BD_ACCOUNTBOOKSTYPE, (QFilter[])qFilters);
    }
}

