/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.util.GLUtil;

public class InitAccctCurLocalUpgradeService
implements IUpgradeService {
    private static final String UPDATE_SQL = "update t_gl_initacccurrent set fcurlocal = ? where fid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult upgradeResult = new UpgradeResult();
            try {
                this.updateInitAcccurrentLocalCur();
                upgradeResult.setSuccess(true);
            }
            catch (Exception e) {
                txHandle.markRollback();
                upgradeResult.setErrorInfo(GLUtil.printError((Throwable)e));
                upgradeResult.setSuccess(false);
            }
            UpgradeResult upgradeResult2 = upgradeResult;
            return upgradeResult2;
        }
    }

    private void updateInitAcccurrentLocalCur() {
        DBRoute dbRoute = DBRoute.of((String)"fi");
        String sql = "select fid ,forgid, fbooktypeid from t_gl_initacccurrent where fcurlocal = 0";
        try (DataSet initAcccurrentDt = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)sql);){
            ArrayList<Object[]> params = new ArrayList<Object[]>(64);
            HashMap<String, AccountBookInfo> bookInfoMap = new HashMap<String, AccountBookInfo>(6);
            Iterator iterator = initAcccurrentDt.iterator();
            while (iterator != null && initAcccurrentDt.hasNext()) {
                Row row = (Row)iterator.next();
                Long id = row.getLong("fid");
                Long orgId = row.getLong("forgid");
                Long bookTypeId = row.getLong("fbooktypeid");
                String bookKey = orgId + "_" + bookTypeId;
                AccountBookInfo bookInfo = bookInfoMap.computeIfAbsent(bookKey, k -> AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId));
                if (bookInfo != null) {
                    params.add(new Object[]{bookInfo.getBaseCurrencyId(), id});
                }
                if (params.size() < 999) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)UPDATE_SQL, params);
                params.clear();
            }
            if (!CollectionUtils.isEmpty(params)) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)UPDATE_SQL, params);
            }
        }
    }
}

