/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.util.GLUtil;

public class InitAcccurrentUpgradeService
implements IUpgradeService {
    private static final String UPDATE_SQL = "update t_gl_acccurrent set fbookeddate = ? where fvchentryid = 0 and fvoucherid = 0 and forgid = ? and fbooktypeid = ? and facctableid = ? and faccountid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult upgradeResult = new UpgradeResult();
            try {
                this.updateInitAcccurrent();
                upgradeResult.setSuccess(true);
            }
            catch (Exception e) {
                txHandle.markRollback();
                upgradeResult.setErrorInfo(GLUtil.printError((Throwable)e));
                upgradeResult.setSuccess(false);
            }
            UpgradeResult upgradeResult2 = upgradeResult;
            return upgradeResult2;
        }
    }

    private void updateInitAcccurrent() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(64);
        DBRoute dbRoute = DBRoute.of((String)"fi");
        String sql = "select rint.forgid org, rint.fbooktypeid booktype, rint.faccounttableid accounttable, rint.fendinitperiod endinitperiod, acc.fmasterid masterid from t_gl_reci_init_state rint  inner join t_bd_account acc on rint.faccountid = acc.fid where rint.fisendinit = '1'";
        try (DataSet initStateSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)sql);){
            Iterator iterator = initStateSet.iterator();
            while (iterator != null && initStateSet.hasNext()) {
                Row row = (Row)iterator.next();
                Long org = row.getLong("org");
                Long bookType = row.getLong("booktype");
                Long accountMasterId = row.getLong("masterid");
                Long accountTable = row.getLong("accounttable");
                Long endInitPeriod = row.getLong("endinitperiod");
                DynamicObject period = PeriodUtil.getPeriod((Long)endInitPeriod, (String)"begindate");
                if (period == null) continue;
                Date beginDate = period.getDate("begindate");
                params.add(new Object[]{beginDate, org, bookType, accountTable, accountMasterId});
                if (params.size() < 999) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)UPDATE_SQL, params);
                params.clear();
            }
            if (!CollectionUtils.isEmpty(params)) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)UPDATE_SQL, params);
            }
        }
    }
}

