/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.gl.util.GLUtil;

public class NoticeCheckLogUpgradeService
implements IUpgradeService {
    private static long[] genLongID(String name, int count) {
        return DB.genLongIds((String)name, (int)count);
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            try {
                NoticeCheckLogUpgradeService.upgradeCheckLog("t_gl_acnotice_checklog", "t_gl_acnotice_relation", "t_gl_acnotice_logentry", "t_gl_acnotice_oplogentry");
                NoticeCheckLogUpgradeService.upgradeCheckLog("t_gl_cfnotice_checklog", "t_gl_cfnotice_relation", "t_gl_cfnotice_logentry", "t_gl_cfnotice_oplogentry");
                result.setSuccess(true);
            }
            catch (Exception e) {
                txHandle.markRollback();
                result.setErrorInfo(GLUtil.printError((Throwable)e));
                result.setSuccess(false);
                throw e;
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private static void upgradeCheckLog(String oldLogTableName, String newLogTableName, String newLogEntryTableName, String newLogOpEntryTableName) {
        DBRoute dbRoute = DBRoute.of((String)"fi");
        String queryOldLogSql = "select fvoucherid, fentryid, fopentryid, floccheck from " + oldLogTableName + " where fisupdate is null or fisupdate = '0'";
        HashMap<Long, Long> entryIdVoucherIdMapping = new HashMap<Long, Long>(16);
        HashSet<Long> completeEntryIds = new HashSet<Long>(10);
        ArrayList<NoticeNewLog> newLogs = new ArrayList<NoticeNewLog>(10);
        HashMap<Long, NoticeNewLog> entryIdNewLogMapping = new HashMap<Long, NoticeNewLog>(16);
        try (DataSet oldLogSet = DB.queryDataSet((String)NoticeCheckLogUpgradeService.class.getName(), (DBRoute)dbRoute, (String)queryOldLogSql);){
            for (Row row : oldLogSet) {
                Long entryId = row.getLong("FENTRYID");
                Long opEntryId = row.getLong("FOPENTRYID");
                entryIdVoucherIdMapping.put(entryId, row.getLong("FVOUCHERID"));
                if (entryId == 0L || opEntryId == 0L || completeEntryIds.contains(entryId) && completeEntryIds.contains(opEntryId)) continue;
                Boolean isLocCheck = row.getBoolean("FLOCCHECK");
                NoticeNewLog log = (NoticeNewLog)entryIdNewLogMapping.get(entryId);
                if (log != null) {
                    if (log.getEntryIds().contains(entryId)) {
                        log.getOpEntryIds().add(opEntryId);
                    } else {
                        log.getEntryIds().add(opEntryId);
                    }
                    log.setLocCheck(isLocCheck);
                    entryIdNewLogMapping.put(opEntryId, log);
                } else {
                    log = (NoticeNewLog)entryIdNewLogMapping.get(opEntryId);
                    if (log != null) {
                        if (log.getEntryIds().contains(opEntryId)) {
                            log.getOpEntryIds().add(entryId);
                        } else {
                            log.getEntryIds().add(entryId);
                        }
                        log.setLocCheck(isLocCheck);
                        entryIdNewLogMapping.put(entryId, log);
                    } else {
                        log = new NoticeNewLog();
                        log.getEntryIds().add(entryId);
                        log.getOpEntryIds().add(opEntryId);
                        log.setLocCheck(isLocCheck);
                        entryIdNewLogMapping.put(entryId, log);
                        entryIdNewLogMapping.put(opEntryId, log);
                        newLogs.add(log);
                    }
                }
                completeEntryIds.add(entryId);
                completeEntryIds.add(opEntryId);
            }
        }
        String updateOldLogSql = "update " + oldLogTableName + " set fisupdate = '1'";
        DB.execute((DBRoute)dbRoute, (String)updateOldLogSql);
        if (newLogs.isEmpty()) {
            return;
        }
        long[] newLogIds = DB.genLongIds((String)newLogTableName, (int)newLogs.size());
        ArrayList<Object[]> newLogPrams = new ArrayList<Object[]>(newLogs.size());
        ArrayList<Object[]> newLogEntryPrams = new ArrayList<Object[]>(newLogs.size());
        ArrayList<Object[]> newLogOpEntryPrams = new ArrayList<Object[]>(newLogs.size());
        int i = 0;
        for (NoticeNewLog newLog : newLogs) {
            Set<Long> entryIds = newLog.getEntryIds();
            Set<Long> opEntryIds = newLog.getOpEntryIds();
            if (entryIds.isEmpty() || opEntryIds.isEmpty()) continue;
            long newLogId = newLogIds[i++];
            newLogPrams.add(new Object[]{newLogId, newLog.isLocCheck()});
            long[] logEntryIds = NoticeCheckLogUpgradeService.genLongID(newLogEntryTableName, entryIds.size());
            int j = 0;
            for (Long entryId : entryIds) {
                long logEntryId = logEntryIds[j++];
                newLogEntryPrams.add(new Object[]{logEntryId, newLogId, entryId, entryIdVoucherIdMapping.getOrDefault(entryId, 0L), j});
            }
            long[] logOpEntryIds = NoticeCheckLogUpgradeService.genLongID(newLogOpEntryTableName, opEntryIds.size());
            int k = 0;
            for (Long opEntryId : opEntryIds) {
                long logOpEntryId = logOpEntryIds[k++];
                newLogOpEntryPrams.add(new Object[]{logOpEntryId, newLogId, opEntryId, entryIdVoucherIdMapping.getOrDefault(opEntryId, 0L), k});
            }
        }
        DB.executeBatch((DBRoute)dbRoute, (String)("insert into " + newLogTableName + "(fid,floccheck) values (?,?)"), newLogPrams);
        DB.executeBatch((DBRoute)dbRoute, (String)("insert into " + newLogEntryTableName + "(fentryid,fid,fvchentryid,fvoucherid,fseq) values (?,?,?,?,?)"), newLogEntryPrams);
        DB.executeBatch((DBRoute)dbRoute, (String)("insert into " + newLogOpEntryTableName + "(fentryid,fid,fopvchentryid,fopvoucherid,fseq) values (?,?,?,?,?)"), newLogOpEntryPrams);
    }

    private static class NoticeNewLog {
        private final Set<Long> entryIds = new HashSet<Long>(10);
        private final Set<Long> opEntryIds = new HashSet<Long>(10);
        private boolean isLocCheck = false;

        private NoticeNewLog() {
        }

        public Set<Long> getEntryIds() {
            return this.entryIds;
        }

        public Set<Long> getOpEntryIds() {
            return this.opEntryIds;
        }

        public boolean isLocCheck() {
            return this.isLocCheck;
        }

        public void setLocCheck(boolean locCheck) {
            this.isLocCheck = locCheck;
        }
    }
}

