/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.notice.NoticeUtils;
import kd.fi.gl.util.GLUtil;

public class NoticeFieldUpgradeService
implements IUpgradeService {
    private static final int BATCH_SIZE = 3000;
    private static final int MAX_RETRY_TIMES = 5;
    private static final String SQL_SELECT = "select top %s tga.fid, fvoucherentryid, fassgrpid, fassgrp from t_gl_acnotice tga inner join t_gl_voucherentry tgv on tga.FVOUCHERENTRYID = tgv.FENTRYID where tga.fid > %s order by tga.fid asc";
    private static final String SQL_UPDATE = "update t_gl_acnotice set fassgrp = ? where fvoucherentryid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.doUpgrade();
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(GLUtil.printError((Throwable)e));
            result.setSuccess(false);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doUpgrade() {
        long startIndex = this.getMinFidOfACNoticeger() - 1L;
        int retryTimes = 0;
        int batchCount = 0;
        while (batchCount < BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"prop.fi.gl.acnotice.upgrade.maxbatch", (int)50000)) {
            try {
                TXHandle ignored = TX.requiresNew();
                Throwable throwable = null;
                try {
                    ++batchCount;
                    long start = System.currentTimeMillis();
                    startIndex = this.batchUpdate(startIndex);
                    LogFactory.getLog(this.getClass()).info("startIndex={}, cost={}ms", (Object)startIndex, (Object)(System.currentTimeMillis() - start));
                    if (startIndex >= 0L) continue;
                    return;
                }
                catch (Exception e) {
                    ignored.markRollback();
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            catch (Exception e) {
                if (retryTimes > 5) {
                    throw new IllegalStateException(e);
                }
                ++retryTimes;
            }
        }
    }

    private long batchUpdate(long startIndex) {
        HashMap<Long, String> entry2assgrp = new HashMap<Long, String>();
        startIndex = (Long)DB.query((DBRoute)new DBRoute("fi"), (String)String.format(SQL_SELECT, 3000, startIndex), null, resultSet -> {
            long fid = 0L;
            while (resultSet.next()) {
                if (StringUtils.isNotEmpty((String)resultSet.getString("fassgrp"))) continue;
                String assgrp = GLUtil.assgrpId2String((Long)resultSet.getLong("fassgrpid"));
                assgrp = NoticeUtils.getChineseStrLen((String)assgrp) > 85 ? assgrp.substring(0, 85) : assgrp;
                entry2assgrp.put(resultSet.getLong("fvoucherentryid"), assgrp);
                fid = resultSet.getLong("fid");
            }
            return fid;
        });
        if (entry2assgrp.isEmpty()) {
            return -1L;
        }
        ArrayList paramList = new ArrayList();
        entry2assgrp.forEach((entryId, assgrp) -> paramList.add(new Object[]{assgrp, entryId}));
        DB.executeBatch((DBRoute)new DBRoute("fi"), (String)SQL_UPDATE, paramList);
        return startIndex;
    }

    private long getMinFidOfACNoticeger() {
        return (Long)DB.query((DBRoute)new DBRoute("fi"), (String)"select top 1 fid from t_gl_acnotice order by fid asc", resultSet -> resultSet.next() ? resultSet.getLong("fid") : 0L);
    }
}

