/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.gl.util.GLUtil;

public class NoticeWhiteBillDataUpgradeService
implements IUpgradeService {
    private static final int SIZE = 10000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            try {
                NoticeWhiteBillDataUpgradeService.upgradeWhiteBillData();
                result.setSuccess(true);
            }
            catch (Exception e) {
                txHandle.markRollback();
                result.setErrorInfo(GLUtil.printError((Throwable)e));
                result.setSuccess(false);
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private static void upgradeWhiteBillData() {
        String queryNoticeSql = "select a.fid from t_gl_acnotice a left join t_ai_daptracker b on a.fid=b.fsourcebillid where b.fid is null";
        DataSet dataSet = DB.queryDataSet((String)"upgradeWhiteBillData", (DBRoute)DBRoute.of((String)"gl"), (String)queryNoticeSql);
        ArrayList<Long> ids = new ArrayList<Long>(10000);
        for (Row row : dataSet) {
            ids.add(row.getLong("fid"));
            if (ids.size() <= 10000) continue;
            DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)"gl_acnotice", (String)"audit", ids, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.INSERTWRITE);
            ids.clear();
        }
        if (!ids.isEmpty()) {
            DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)"gl_acnotice", (String)"audit", ids, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.INSERTWRITE);
        }
    }
}

