/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PresetAcctUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{new QFilter("accounttable.seperator", "=", (Object)".")}, null, (int)-1);
        ArrayList<DynamicObject> updateAccts = new ArrayList<DynamicObject>();
        if (!ids.isEmpty()) {
            DynamicObject[] dyos = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_accountview"));
            for (DynamicObject acct : dyos) {
                String longnumber = acct.getString("longnumber");
                int level = acct.getInt("level");
                if (level <= 1 || !longnumber.contains(".") || longnumber.contains("_")) continue;
                StringBuilder realLongnumber = new StringBuilder();
                String[] splits = longnumber.split("\\.");
                String curNum = "";
                for (int i = 0; i < splits.length; ++i) {
                    curNum = i == 0 ? splits[0] : curNum + "." + splits[i];
                    if (realLongnumber.length() != 0) {
                        realLongnumber.append("_");
                    }
                    realLongnumber.append(curNum);
                }
                acct.set("longnumber", (Object)realLongnumber.toString());
                updateAccts.add(acct);
            }
        }
        if (!updateAccts.isEmpty()) {
            TXHandle h = TX.requiresNew((String)"bd_accountview");
            Object object = null;
            try {
                try {
                    SaveServiceHelper.save((DynamicObject[])updateAccts.toArray(new DynamicObject[updateAccts.size()]));
                }
                catch (Throwable e) {
                    h.markRollback();
                    result.setSuccess(false);
                    String err = e.getMessage();
                    result.setErrorInfo(err);
                    result.setLog(err);
                    UpgradeResult upgradeResult = result;
                    if (h != null) {
                        if (object != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return upgradeResult;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (h != null) {
                    if (object != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u79d1\u76ee\u5386\u53f2\u6570\u636e\u66f4\u65b0\u5df2\u5b8c\u6210\u3002", (String)"PresetAcctUpgradeService_0", (String)"fi-gl-upgradeservice", (Object[])new Object[0]));
        return result;
    }
}

