/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.gl.util.GLUtil;

public class ReciprocalAcctTableVersionUpgrade
implements IUpgradeService {
    private static final String UPDATE_ACCCURRENT_SQL = "update t_gl_acccurrent set fentrydc =?, fcreatorid =?, fwriteoffpersonid =?, fbookeddate =? WHERE fmasterid =? and fid !=?";
    private static final Log logger = LogFactory.getLog(ReciprocalAcctTableVersionUpgrade.class);
    private static ConcurrentHashMap<ReciprocalAcctTableVersionUpgrade, Boolean> errorMap = new ConcurrentHashMap(8);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        try {
            this.updateAcccurrentVersionData();
            if (errorMap.get(this) != null && errorMap.get(this).booleanValue()) {
                upgradeResult.setSuccess(false);
            } else {
                upgradeResult.setSuccess(true);
            }
        }
        catch (Exception e) {
            upgradeResult.setErrorInfo(GLUtil.printError((Throwable)e));
            upgradeResult.setSuccess(false);
        }
        return upgradeResult;
    }

    private void updateAcccurrentVersionData() {
        DBRoute dbRoute = DBRoute.of((String)"fi");
        SqlBuilder acctTbleRefBuilder = new SqlBuilder();
        acctTbleRefBuilder.append("select forgid from t_bd_accttabref_record", new Object[0]);
        HashSet acctTableRefOrgSet = new HashSet(6);
        DataSet acctTableRefRecordDt = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)acctTbleRefBuilder);
        Object object = null;
        try {
            acctTableRefRecordDt.forEach(x -> acctTableRefOrgSet.add(x.getLong("forgid")));
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (acctTableRefRecordDt != null) {
                if (object != null) {
                    try {
                        acctTableRefRecordDt.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    acctTableRefRecordDt.close();
                }
            }
        }
        if (acctTableRefOrgSet.isEmpty()) {
            return;
        }
        CountDownLatch cdl = new CountDownLatch(acctTableRefOrgSet.size());
        for (Long acctTableRefOrg : acctTableRefOrgSet) {
            SqlBuilder versionSqlBuilder = new SqlBuilder();
            versionSqlBuilder.append("select fmasterid masterid from t_gl_acccurrent where fbookeddate is null and feffectivedate != ?", new Object[]{GLUtil.getInitBeginDate()});
            versionSqlBuilder.append(" and forgid = ?", new Object[]{acctTableRefOrg});
            DataSet versionReciDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)versionSqlBuilder);
            Throwable throwable = null;
            try {
                HashSet<Long> masterIdSet = new HashSet<Long>(32);
                if (versionReciDataSet.isEmpty()) {
                    cdl.countDown();
                    continue;
                }
                Iterator iterRow = versionReciDataSet.iterator();
                while (iterRow.hasNext()) {
                    Row row = (Row)iterRow.next();
                    masterIdSet.add(row.getLong("masterid"));
                    if (masterIdSet.size() <= 5000) continue;
                    this.updateReciData(masterIdSet, iterRow.hasNext() ? null : cdl);
                    masterIdSet.clear();
                }
                if (masterIdSet.isEmpty()) continue;
                this.updateReciData(masterIdSet, cdl);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (versionReciDataSet == null) continue;
                if (throwable != null) {
                    try {
                        versionReciDataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                versionReciDataSet.close();
            }
        }
        try {
            boolean await = cdl.await(3600L, TimeUnit.SECONDS);
            if (!await) {
                logger.error("ReciprocalAcctTableVersionUpgrade_updateAcccurrentVersionData\u811a\u672c\u6267\u884c\u8d85\u65f6");
            }
        }
        catch (InterruptedException e) {
            logger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void updateReciData(Set<Long> masterIdSet, CountDownLatch cdl) {
        DBRoute dbRoute = DBRoute.of((String)"fi");
        SqlBuilder initialSqlBuilder = new SqlBuilder();
        initialSqlBuilder.append("select fmasterid masterid, fentrydc entrydc, fcreatorid creator, fwriteoffpersonid writeoffperson, fbookeddate bookeddate from t_gl_acccurrent where feffectivedate = ?", new Object[]{GLUtil.getInitBeginDate()});
        initialSqlBuilder.appendIn(" and fmasterid", new ArrayList<Long>(masterIdSet));
        try (DataSet initialReciDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (SqlBuilder)initialSqlBuilder);){
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>(64);
            for (Row initialRow : initialReciDataSet) {
                updateParams.add(new Object[]{initialRow.get("entrydc"), initialRow.get("creator"), initialRow.get("writeoffperson"), initialRow.get("bookeddate"), initialRow.get("masterid"), initialRow.get("masterid")});
            }
            ThreadService.submit((Callable)new MyTask(this, updateParams, cdl), (TaskType)TaskType.GL_PARELLEL_COMPUTE);
        }
    }

    private static class MyTask
    implements Callable {
        private ReciprocalAcctTableVersionUpgrade reciprocalAcctTableVersionUpgrade;
        private final List<Object[]> updateParams;
        private CountDownLatch cdl;

        public MyTask(ReciprocalAcctTableVersionUpgrade reciprocalAcctTableVersionUpgrade, List<Object[]> updateParams, CountDownLatch cdl) {
            this.reciprocalAcctTableVersionUpgrade = reciprocalAcctTableVersionUpgrade;
            this.updateParams = new ArrayList<Object[]>(updateParams);
            this.cdl = cdl;
        }

        public Object call() throws Exception {
            try {
                if (!this.updateParams.isEmpty()) {
                    DB.executeBatch((DBRoute)new DBRoute("fi"), (String)ReciprocalAcctTableVersionUpgrade.UPDATE_ACCCURRENT_SQL, this.updateParams);
                }
            }
            catch (Exception e) {
                errorMap.put(this.reciprocalAcctTableVersionUpgrade, true);
                logger.error((Throwable)e);
            }
            finally {
                if (this.cdl != null) {
                    this.cdl.countDown();
                }
            }
            return "";
        }
    }
}

