/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checkstatus.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.checkstatus.checkinfo.ACNoticeEntity;
import kd.fi.gl.checkstatus.checkinfo.AbstractNotice;
import kd.fi.gl.checkstatus.service.AbstractNoticeCheckService;
import kd.fi.gl.checkstatus.unit.AbstractNoticeCheckLogicUnit;
import kd.fi.gl.checkstatus.unit.DapCheckLogicUnit;
import kd.fi.gl.checkstatus.unit.SameReceiveOrgCheckLogicUnit;
import kd.fi.gl.checkstatus.unit.SameVchAndROrgCheckLogicUnit;
import kd.fi.gl.checkstatus.unit.TimeSequenceCheckLogicUnit;
import kd.fi.gl.checkstatus.unit.VoucherAgainstCheckLogicUnit;
import kd.fi.gl.util.SystemParamHelper;

public class ACNoticeCheckService
extends AbstractNoticeCheckService {
    @Override
    protected List<AbstractNotice> convertToAbstractNoticeWithOutChecked(DynamicObject[] allNotices) {
        return Stream.of(allNotices).filter(x -> "0".equals(x.getString("checkstatus"))).map(ACNoticeEntity::new).collect(Collectors.toList());
    }

    @Override
    protected List<AbstractNoticeCheckLogicUnit> getLogicUnits(String checkType) {
        ArrayList<AbstractNoticeCheckLogicUnit> units = new ArrayList<AbstractNoticeCheckLogicUnit>();
        switch (checkType) {
            case "checktype_manual": {
                units.add(new SameVchAndROrgCheckLogicUnit());
                units.add(new SameReceiveOrgCheckLogicUnit());
                units.add(new TimeSequenceCheckLogicUnit());
                break;
            }
            case "checktype_auto": {
                units.add(new SameVchAndROrgCheckLogicUnit());
                units.add(new SameReceiveOrgCheckLogicUnit());
                units.add(new DapCheckLogicUnit());
                units.add(new VoucherAgainstCheckLogicUnit());
                units.add(new TimeSequenceCheckLogicUnit());
                break;
            }
            case "checktype_semi_auto": {
                units.add(new DapCheckLogicUnit());
                units.add(new VoucherAgainstCheckLogicUnit());
                break;
            }
        }
        return units;
    }

    @Override
    protected String getEntityDbTableName() {
        return "t_gl_acnotice";
    }

    @Override
    protected String getLogEntityName() {
        return "gl_acnotice_relation";
    }

    @Override
    protected boolean getMulCheckEnable(String checkType) {
        return "checktype_manual".equals(checkType) || "checktype_semi_auto".equals(checkType);
    }

    @Override
    protected boolean getInitLocCurrencyCheckEnable(long excuteOrgId) {
        if (excuteOrgId > 0L) {
            return SystemParamHelper.getBooleanParam((String)"acnloccurenbale", (long)excuteOrgId, (boolean)false);
        }
        return true;
    }

    @Override
    protected String getEntityName() {
        return "gl_acnotice";
    }
}

