/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checkstatus.service;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.QFBuilder;

public abstract class AbstractNoticeCancelCheckService {
    private static final Log LOGGER = LogFactory.getLog(AbstractNoticeCancelCheckService.class);

    public List<DynamicObject> excute(DynamicObject[] datas) {
        String dbTableName = this.getDbTableName();
        if (StringUtils.isBlank((CharSequence)dbTableName)) {
            LOGGER.error(ResManager.loadKDString((String)"\u53cd\u52fe\u7a3d\u670d\u52a1\u5bf9\u5e94\u7684\u8868\u540d\u4e0d\u5b58\u5728\u3002", (String)"AbstractNoticeCancelCheckService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return Collections.emptyList();
        }
        String checkLogEntity = this.getCheckLogEntity();
        if (StringUtils.isBlank((CharSequence)checkLogEntity)) {
            LOGGER.error(ResManager.loadKDString((String)"\u53cd\u52fe\u7a3d\u670d\u52a1\u5bf9\u5e94\u7684\u52fe\u7a3d\u4fe1\u606f\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"AbstractNoticeCancelCheckService_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            return Collections.emptyList();
        }
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            List checkedDatas = Stream.of(datas).filter(x -> "1".equals(x.getString("checkstatus"))).collect(Collectors.toList());
            List partitionCheckedDatas = Lists.partition(checkedDatas, (int)1000);
            for (List partitionCheckedData : partitionCheckedDatas) {
                Set entryIds = partitionCheckedData.stream().map(x -> x.getLong("voucherentry")).collect(Collectors.toSet());
                if (entryIds.isEmpty()) {
                    List<DynamicObject> list = Collections.emptyList();
                    return list;
                }
                String entryIdField = String.join((CharSequence)".", "logentry", "vchentryid");
                String opEntryIdField = String.join((CharSequence)".", "oplogentry", "opvchentryid");
                QFBuilder qfBuilder = new QFBuilder();
                qfBuilder.add(entryIdField, "in", entryIds);
                DynamicObject[] checkLogs = BusinessDataServiceHelper.load((String)checkLogEntity, (String)String.join((CharSequence)",", entryIdField, opEntryIdField), (QFilter[])qfBuilder.toArray());
                HashSet allEntryIds = new HashSet(checkLogs.length * 2);
                HashSet<Object> logPkSet = new HashSet<Object>(checkLogs.length);
                for (DynamicObject checkLog : checkLogs) {
                    allEntryIds.addAll(checkLog.getDynamicObjectCollection("logentry").stream().map(x -> x.getLong("vchentryid")).collect(Collectors.toSet()));
                    allEntryIds.addAll(checkLog.getDynamicObjectCollection("oplogentry").stream().map(x -> x.getLong("opvchentryid")).collect(Collectors.toSet()));
                    logPkSet.add(checkLog.getPkValue());
                }
                qfBuilder.clear();
                qfBuilder.add(opEntryIdField, "in", entryIds);
                for (DynamicObject checkLog : checkLogs = BusinessDataServiceHelper.load((String)checkLogEntity, (String)String.join((CharSequence)",", entryIdField, opEntryIdField), (QFilter[])qfBuilder.toArray())) {
                    allEntryIds.addAll(checkLog.getDynamicObjectCollection("logentry").stream().map(x -> x.getLong("vchentryid")).collect(Collectors.toSet()));
                    allEntryIds.addAll(checkLog.getDynamicObjectCollection("oplogentry").stream().map(x -> x.getLong("opvchentryid")).collect(Collectors.toSet()));
                    logPkSet.add(checkLog.getPkValue());
                }
                allEntryIds.addAll(entryIds);
                if (logPkSet.isEmpty()) {
                    List<DynamicObject> list = Collections.emptyList();
                    return list;
                }
                DBRoute object = DBRoute.of((String)"fi");
                String entryIdInSql = StringUtils.join((Object[])allEntryIds.toArray(), (String)",");
                String updateSql = "update " + dbTableName + " set fcheckstatus = ? " + (dbTableName.equals("t_gl_acnotice") ? ", fpeerdesc=' '" : "") + " where fvoucherentryid in (" + entryIdInSql + ")";
                DB.execute((DBRoute)object, (String)updateSql, (Object[])new Object[]{"0"});
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)checkLogEntity), (Object[])logPkSet.toArray(new Object[0]));
            }
            List list = checkedDatas;
            return list;
        }
        catch (Exception e) {
            try {
                handle.markRollback();
                LOGGER.error(GLUtil.printError((Throwable)e));
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected abstract String getCheckLogEntity();

    protected abstract String getDbTableName();
}

