/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checkstatus.unit;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.fi.gl.checkstatus.checkinfo.AbstractNotice;
import kd.fi.gl.checkstatus.checkinfo.NoticeCheckContext;
import kd.fi.gl.checkstatus.checkinfo.NoticeCheckLog;

public abstract class AbstractNoticeCheckLogicUnit {
    private Set<Long> completedEntryIds;
    private Set<NoticeCheckLog> resultLogs;
    private boolean locCurrencyEnable;
    private boolean mulCheckEnable;
    private Function<AbstractNotice, String> selfSplitFunction;
    private static final Function<AbstractNotice, String> SELF_SPLITFUNCTION_WITH_MAINDATA = x -> x.getSendOrgId() + "-" + x.getReceiveOrgId() + "-" + x.getType() + "-" + x.getMainDataId();
    private static final Function<AbstractNotice, String> SELF_SPLITFUNCTION = x -> x.getSendOrgId() + "-" + x.getReceiveOrgId() + "-" + x.getType();
    private static final Function<AbstractNotice, String> BOTH_SPLITFUNCTION = x -> x.getType() ? x.getSendOrgId() + "-" + x.getReceiveOrgId() : x.getReceiveOrgId() + "-" + x.getSendOrgId();

    public void doAction(NoticeCheckContext checkContext) {
        this.locCurrencyEnable = checkContext.isLocalCurrencyCheckEnable();
        this.mulCheckEnable = checkContext.isMulCheckEnable();
        this.selfSplitFunction = checkContext.isManualCheck() ? SELF_SPLITFUNCTION : SELF_SPLITFUNCTION_WITH_MAINDATA;
        int maxSize = checkContext.getReadyCheckDatas().size();
        this.completedEntryIds = new HashSet<Long>(maxSize);
        this.resultLogs = new HashSet<NoticeCheckLog>(maxSize);
        this.excute(checkContext);
        checkContext.update(this.resultLogs);
    }

    private void addResult(NoticeCheckLog log) {
        this.resultLogs.add(log);
        this.completedEntryIds.addAll(log.getAllEntryIds());
    }

    protected abstract void excute(NoticeCheckContext var1);

    protected final void singleSelfCheck(List<AbstractNotice> checkDatas) {
        Map splitDatas = checkDatas.stream().collect(Collectors.groupingBy(this.selfSplitFunction, LinkedHashMap::new, Collectors.toList()));
        splitDatas.forEach((k, v) -> {
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                AbstractNotice notice = (AbstractNotice)iterator.next();
                iterator.remove();
                if (this.completedEntryIds.contains(notice.getEntryId())) continue;
                while (iterator.hasNext()) {
                    AbstractNotice opNotice = (AbstractNotice)iterator.next();
                    if (this.completedEntryIds.contains(opNotice.getEntryId())) {
                        iterator.remove();
                        continue;
                    }
                    if (!this.singleCompareAmount(notice, opNotice)) continue;
                    iterator.remove();
                    break;
                }
                iterator = v.iterator();
            }
        });
    }

    protected final void singleBothCheck(List<AbstractNotice> checkDatas) {
        Map splitDatas = checkDatas.stream().collect(Collectors.groupingBy(BOTH_SPLITFUNCTION, LinkedHashMap::new, Collectors.toList()));
        splitDatas.forEach((k, v) -> {
            List sends = v.stream().filter(AbstractNotice::getType).collect(Collectors.toList());
            List receives = v.stream().filter(x -> !x.getType()).collect(Collectors.toList());
            block0: for (AbstractNotice send : sends) {
                Long entryId = send.getEntryId();
                if (this.completedEntryIds.contains(entryId)) continue;
                Iterator iterator = receives.iterator();
                while (iterator.hasNext()) {
                    AbstractNotice recieve = (AbstractNotice)iterator.next();
                    Long opEntryId = recieve.getEntryId();
                    if (this.completedEntryIds.contains(opEntryId)) {
                        iterator.remove();
                        continue;
                    }
                    if (!this.singleCompareAmount(send, recieve)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        });
    }

    private boolean singleCompareAmount(AbstractNotice notice, AbstractNotice opNotice) {
        NoticeCheckLog log = null;
        if (notice.compareOriAmount(opNotice)) {
            log = new NoticeCheckLog(Collections.singletonList(notice), Collections.singletonList(opNotice), Boolean.FALSE);
        } else if (this.locCurrencyEnable && notice.isLocCheckEnable() && opNotice.isLocCheckEnable() && notice.compareLocAmount(opNotice)) {
            log = new NoticeCheckLog(Collections.singletonList(notice), Collections.singletonList(opNotice), Boolean.FALSE);
        }
        if (null != log) {
            this.addResult(log);
            return true;
        }
        return false;
    }

    protected final void mulSelfOriCheck(List<AbstractNotice> checkDatas) {
        if (!this.mulCheckEnable) {
            return;
        }
        checkDatas.sort(Comparator.comparing(o -> o.getOriAmount().abs()));
        Map splitDatas = checkDatas.stream().filter(x -> !this.completedEntryIds.contains(x.getEntryId())).collect(Collectors.groupingBy(this.selfSplitFunction, LinkedHashMap::new, Collectors.toList()));
        splitDatas.forEach((k, v) -> this.mulSelfCompareAmount((List<AbstractNotice>)v, Boolean.FALSE));
    }

    protected final void mulSelfLocCheck(List<AbstractNotice> checkDatas) {
        if (!this.locCurrencyEnable || !this.mulCheckEnable) {
            return;
        }
        checkDatas.sort(Comparator.comparing(o -> o.getLocAmount().abs()));
        Map splitDatas = checkDatas.stream().filter(x -> x.isLocCheckEnable() && !this.completedEntryIds.contains(x.getEntryId())).collect(Collectors.groupingBy(this.selfSplitFunction, LinkedHashMap::new, Collectors.toList()));
        splitDatas.forEach((k, v) -> this.mulSelfCompareAmount((List<AbstractNotice>)v, Boolean.TRUE));
    }

    private void mulSelfCompareAmount(List<AbstractNotice> notices, boolean isLocCheck) {
        Map<String, List<AbstractNotice>> noticesByDc = notices.stream().collect(Collectors.groupingBy(isLocCheck ? AbstractNotice::getLocAmountDc : AbstractNotice::getOriAmountDc));
        if (noticesByDc.size() < 2) {
            return;
        }
        Iterator<List<AbstractNotice>> iterator = noticesByDc.values().iterator();
        List<AbstractNotice> sends = iterator.next();
        List<AbstractNotice> receives = iterator.next();
        this.mulBothCompareAmount(sends, receives, isLocCheck);
    }

    protected final void mulBothOriCheck(List<AbstractNotice> checkDatas) {
        if (!this.mulCheckEnable) {
            return;
        }
        checkDatas.sort(Comparator.comparing(o -> o.getOriAmount().abs()));
        Map splitDatas = checkDatas.stream().filter(x -> !this.completedEntryIds.contains(x.getEntryId())).collect(Collectors.groupingBy(BOTH_SPLITFUNCTION, LinkedHashMap::new, Collectors.toList()));
        splitDatas.forEach((k, v) -> {
            List<AbstractNotice> sends = v.stream().filter(AbstractNotice::getType).collect(Collectors.toList());
            List<AbstractNotice> receives = v.stream().filter(x -> !x.getType()).collect(Collectors.toList());
            this.mulBothCompareAmount(sends, receives, Boolean.FALSE);
        });
    }

    protected final void mulBothLocCheck(List<AbstractNotice> checkDatas) {
        if (!this.mulCheckEnable || !this.locCurrencyEnable) {
            return;
        }
        Map splitDatas = checkDatas.stream().filter(x -> x.isLocCheckEnable() && !this.completedEntryIds.contains(x.getEntryId())).collect(Collectors.groupingBy(BOTH_SPLITFUNCTION, LinkedHashMap::new, Collectors.toList()));
        splitDatas.forEach((k, v) -> {
            List<AbstractNotice> sends = v.stream().filter(AbstractNotice::getType).collect(Collectors.toList());
            List<AbstractNotice> receives = v.stream().filter(x -> !x.getType()).collect(Collectors.toList());
            this.mulBothCompareAmount(sends, receives, Boolean.TRUE);
        });
    }

    private void mulBothCompareAmount(List<AbstractNotice> notices, List<AbstractNotice> opNotices, Boolean isLocCheck) {
        notices.removeIf(x -> this.completedEntryIds.contains(x.getEntryId()));
        opNotices.removeIf(x -> this.completedEntryIds.contains(x.getEntryId()));
        if (notices.isEmpty() || opNotices.isEmpty()) {
            return;
        }
        if (isLocCheck.booleanValue()) {
            Map<Long, List<AbstractNotice>> noticesByLocCurId = notices.stream().collect(Collectors.groupingBy(AbstractNotice::getLocCurrencyId));
            Map<Long, List<AbstractNotice>> opNoticesByLocCurId = opNotices.stream().collect(Collectors.groupingBy(AbstractNotice::getLocCurrencyId));
            for (Map.Entry<Long, List<AbstractNotice>> entry : noticesByLocCurId.entrySet()) {
                Long locCurId = entry.getKey();
                List<AbstractNotice> tempOpNotices = opNoticesByLocCurId.get(locCurId);
                if (tempOpNotices == null) continue;
                List<AbstractNotice> tempNotices = entry.getValue();
                BigDecimal sumResult = BigDecimal.ZERO;
                String tempDc = tempNotices.get(0).getLocAmountDc();
                for (AbstractNotice notice : tempNotices) {
                    if (tempDc.equals(notice.getLocAmountDc())) {
                        sumResult = sumResult.add(notice.getLocAmount().abs());
                        continue;
                    }
                    sumResult = sumResult.subtract(notice.getLocAmount().abs());
                }
                for (AbstractNotice opNotice : tempOpNotices) {
                    if (tempDc.equals(opNotice.getLocAmountDc())) {
                        sumResult = sumResult.add(opNotice.getLocAmount().abs());
                        continue;
                    }
                    sumResult = sumResult.subtract(opNotice.getLocAmount().abs());
                }
                if (sumResult.signum() != 0) continue;
                NoticeCheckLog log = new NoticeCheckLog(tempNotices, tempOpNotices, true);
                this.addResult(log);
            }
        } else {
            Map<Long, List<AbstractNotice>> noticesByOriCurId = notices.stream().collect(Collectors.groupingBy(AbstractNotice::getOriCurrencyId));
            Map<Long, List<AbstractNotice>> opNoticesByOriCurId = opNotices.stream().collect(Collectors.groupingBy(AbstractNotice::getOriCurrencyId));
            for (Map.Entry<Long, List<AbstractNotice>> entry : noticesByOriCurId.entrySet()) {
                Long oriCurId = entry.getKey();
                List<AbstractNotice> tempOpNotices = opNoticesByOriCurId.get(oriCurId);
                if (tempOpNotices == null) continue;
                List<AbstractNotice> tempNotices = entry.getValue();
                BigDecimal sumResult = BigDecimal.ZERO;
                String tempDc = tempNotices.get(0).getOriAmountDc();
                for (AbstractNotice notice : tempNotices) {
                    if (tempDc.equals(notice.getOriAmountDc())) {
                        sumResult = sumResult.add(notice.getOriAmount().abs());
                        continue;
                    }
                    sumResult = sumResult.subtract(notice.getOriAmount().abs());
                }
                for (AbstractNotice opNotice : tempOpNotices) {
                    if (tempDc.equals(opNotice.getOriAmountDc())) {
                        sumResult = sumResult.add(opNotice.getOriAmount().abs());
                        continue;
                    }
                    sumResult = sumResult.subtract(opNotice.getOriAmount().abs());
                }
                if (sumResult.signum() != 0) continue;
                NoticeCheckLog log = new NoticeCheckLog(tempNotices, tempOpNotices, false);
                this.addResult(log);
            }
        }
    }
}

