/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.checkstatus.unit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.ai.v2.fah.dto.BillToVchRelationDto;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.checkstatus.checkinfo.ACNoticeEntity;
import kd.fi.gl.checkstatus.checkinfo.AbstractNotice;
import kd.fi.gl.checkstatus.checkinfo.NoticeCheckContext;
import kd.fi.gl.checkstatus.unit.AbstractNoticeCheckLogicUnit;
import kd.fi.gl.interfaces.service.dap.IDAPService;

public class DapCheckLogicUnit
extends AbstractNoticeCheckLogicUnit {
    private static IDAPService getDAPService() {
        return (IDAPService)GLServiceFactory.getService(IDAPService.class);
    }

    @Override
    protected void excute(NoticeCheckContext checkContext) {
        if (!Objects.equals("gl_acnotice", checkContext.getEntityName())) {
            return;
        }
        List<AbstractNotice> readyCheckDatas = checkContext.getReadyCheckDatas();
        List voucherIds = readyCheckDatas.stream().map(AbstractNotice::getVoucherId).collect(Collectors.toList());
        int size = voucherIds.size();
        HashMap<Long, List> voucherId2noticeIds = new HashMap<Long, List>(size);
        ArrayList<Long> noticeIds = new ArrayList<Long>(size);
        Set readyCheckNoticeIds = readyCheckDatas.stream().map(AbstractNotice::getId).collect(Collectors.toSet());
        BillToVchRelationDto voucherRelations = DapCheckLogicUnit.getDAPService().getBillToVchReDtoByBillTypeVchIDSet("gl_acnotice", new HashSet(voucherIds));
        for (BillToVchRelationDto.BillToVoucherRelation voucherRelation : voucherRelations) {
            Long voucherId = voucherRelation.getVoucherId();
            Long noticeId = voucherRelation.getBillId();
            if (!"checktype_semi_auto".equals(checkContext.getCheckType()) && !readyCheckNoticeIds.contains(noticeId)) continue;
            voucherId2noticeIds.compute(voucherId, (k, v) -> {
                if (null == v) {
                    v = new ArrayList<Long>();
                }
                v.add(noticeId);
                return v;
            });
            noticeIds.add(noticeId);
        }
        QFilter noticeIdFilter = new QFilter("id", "in", noticeIds);
        QFilter unCheckedFilter = new QFilter("checkstatus", "=", (Object)"0");
        Map id2val = BusinessDataServiceHelper.loadFromCache((String)"gl_acnotice", (QFilter[])noticeIdFilter.and(unCheckedFilter).toArray());
        Map<Long, AbstractNotice> id2abstractNotices = id2val.entrySet().stream().collect(Collectors.toMap(x -> Long.valueOf(x.getKey().toString()), x -> new ACNoticeEntity((DynamicObject)x.getValue())));
        voucherId2noticeIds.forEach((k, v) -> {
            List<AbstractNotice> notices = readyCheckDatas.stream().filter(x -> k.equals(x.getVoucherId())).collect(Collectors.toList());
            notices.addAll(id2abstractNotices.entrySet().stream().filter(x -> v.contains(x.getKey())).map(Map.Entry::getValue).collect(Collectors.toList()));
            this.singleBothCheck(notices);
            this.mulBothOriCheck(notices);
            this.mulBothLocCheck(notices);
        });
    }
}

