/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeinit;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.gl.closeinit.BatchInitInfo;
import kd.fi.gl.constant.GLField;

public class BatchQueryInitInfo
extends BatchInitInfo {
    Set<Long> orgIds = new HashSet<Long>(1);
    Set<Long> accountTable = new HashSet<Long>(1);
    Set<Long> bookType = new HashSet<Long>(1);
    Map<String, Long> keyMap = new HashMap<String, Long>(200);

    public BatchQueryInitInfo(int comsize) {
        super(comsize, (Collection<LocalCurrencyConfigVO>)LocalCurrencyConfigService.queryEnableCurrencies());
    }

    public void add(DynamicObject initBal) {
        this.orgIds.add(initBal.getLong(GLField.id_((String)"org")));
        this.bookType.add(initBal.getLong(GLField.id_((String)"booktype")));
        this.accountTable.add(initBal.getLong(GLField.id_((String)"accounttable")));
        this.accounts.add(initBal.getLong("account.masterid"));
        this.assgrps.add(initBal.getLong(GLField.id_((String)"assgrp")));
        this.currencys.add(initBal.getLong(GLField.id_((String)"currency")));
        this.measureunits.add(initBal.getLong(GLField.id_((String)"measureunit")));
        for (int i = 1; i <= this.comsize; ++i) {
            Set set = this.comassist.computeIfAbsent(i, x -> new HashSet());
            set.add(initBal.getLong(GLField.id_((String)("comassist" + i))));
        }
        this.keyMap.put(this.getKey(initBal), initBal.getLong("id"));
    }

    private String getKey(DynamicObject initBal) {
        String key = String.join((CharSequence)"-", initBal.getString(GLField.id_((String)"org")), initBal.getString(GLField.id_((String)"booktype")), initBal.getString(GLField.id_((String)"accounttable")), initBal.getString("account.masterid"), initBal.getString(GLField.id_((String)"assgrp")), initBal.getString(GLField.id_((String)"currency")), initBal.getString(GLField.id_((String)"measureunit")));
        StringBuilder sb = new StringBuilder(key);
        for (int i = 1; i <= this.comsize; ++i) {
            sb.append("-").append(initBal.getLong(GLField.id_((String)("comassist" + i))));
        }
        return sb.toString();
    }

    public Set<Long> getOrgIds() {
        return this.orgIds;
    }

    public Set<Long> getAccountTable() {
        return this.accountTable;
    }

    public Set<Long> getBookType() {
        return this.bookType;
    }

    public Map<String, Long> getKeyMap() {
        return this.keyMap;
    }

    @Override
    public void clear() {
        super.clear();
        this.orgIds.clear();
        this.accountTable.clear();
        this.bookType.clear();
    }
}

