/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.opservice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.flex.FlexService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.rate.ExchangeRate;
import kd.fi.bd.service.balance.AppHelper;
import kd.fi.bd.util.iterators.impl.BaseBufferedIterator;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.enums.endingprocess.RecordDirection;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.finalprocess.info.AdjustSchemeInfo;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.finalprocess.info.BalanceInfo;
import kd.fi.gl.finalprocess.info.GenerateVoucherReslutInfo;
import kd.fi.gl.finalprocess.opservice.IGenerateVoucherService;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.ContextUtil;

public class AdjustGenerateVoucherService
implements IGenerateVoucherService {
    private Map<Long, List<AmountInfo>> adjustLog = new HashMap<Long, List<AmountInfo>>(16);
    private int ASSGRPID_SIZE = 20000;
    private Map<Long, String> assVals = new HashMap<Long, String>(this.ASSGRPID_SIZE);
    private Map<String, Long> val2new = new HashMap<String, Long>(this.ASSGRPID_SIZE);
    private AdjustSchemeInfo schemeInfo;
    private DistributeSessionlessCache progressCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CacheKeyUtil.getAcctId() + ":" + "FPCreateVoucher");

    @Override
    public List<VoucherInfo> generateVoucher(DynamicObject schemeDyn, OperateOption option) {
        this.schemeInfo = new AdjustSchemeInfo(schemeDyn, option);
        this.constructVoucherHead();
        List<VoucherInfo> voucherInfos = this.constructVoucherEntities();
        return voucherInfos;
    }

    @Override
    public void writeBack(List<GenerateVoucherReslutInfo> genreateSuccessResults) {
        ArrayList<DynamicObject> adjustLogDyns = new ArrayList<DynamicObject>(10);
        for (GenerateVoucherReslutInfo generateVoucherReslutInfo : genreateSuccessResults) {
            List successPkIds = generateVoucherReslutInfo.getVoucherSaveResult().getSuccessPkIds();
            Set schemes = generateVoucherReslutInfo.getScheme2voucherInfos().keySet();
            for (Object voucherId : successPkIds) {
                for (DynamicObject scheme : schemes) {
                    List<AmountInfo> logInfos = this.adjustLog.get(scheme.getLong("id"));
                    if (logInfos == null || logInfos.isEmpty()) continue;
                    for (AmountInfo logInfo : logInfos) {
                        DynamicObject adjustLogDyn = BusinessDataServiceHelper.newDynamicObject((String)"gl_adjustratelog");
                        adjustLogDyn.set("account_id", (Object)logInfo.getAccountId());
                        adjustLogDyn.set("assgrp_id", (Object)logInfo.getAssgrpId());
                        adjustLogDyn.set("currency_id", (Object)logInfo.getCrrencyId());
                        adjustLogDyn.set("measureunit_id", (Object)logInfo.getUnitId());
                        adjustLogDyn.set("endfor", (Object)logInfo.getOriAmount());
                        adjustLogDyn.set("endlocal", (Object)logInfo.getLocAmount());
                        adjustLogDyn.set("voucherid", voucherId);
                        adjustLogDyn.set("tarmulcur", (Object)("BaseCurrency".equals(logInfo.getMulCurType()) ? " " : logInfo.getMulCurType()));
                        for (Map.Entry comAssistIdEntry : logInfo.getComAssistIdMap().entrySet()) {
                            adjustLogDyn.set(GLField.id_((String)CommonAssistUtil.getComassistField((int)((Integer)comAssistIdEntry.getKey()))), comAssistIdEntry.getValue());
                        }
                        adjustLogDyns.add(adjustLogDyn);
                    }
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])adjustLogDyns.toArray(new DynamicObject[0]));
    }

    private VoucherInfo constructVoucherHead() {
        VoucherInfo voucherInfo = this.schemeInfo.getVoucherInfo();
        voucherInfo.setDesc(this.schemeInfo.getVoucherDesc());
        Date bizDate = this.schemeInfo.getBizDate();
        voucherInfo.setBizDate(bizDate);
        voucherInfo.setBookedDate(bizDate);
        voucherInfo.setPeriod(Long.valueOf(this.schemeInfo.getPeriodDyn().getLong("id")));
        voucherInfo.setCreator(Long.valueOf(ContextUtil.getUserId()));
        voucherInfo.setAttachMent(0);
        voucherInfo.setStatus("A");
        voucherInfo.setSourceSys(AppHelper.getAppIdByFormId((String)"gl_voucher"));
        voucherInfo.setBookType(Long.valueOf(this.schemeInfo.getAccountBookInfo().getBookTypeId()));
        voucherInfo.setVoucherType(this.schemeInfo.getVoucherTypeId());
        voucherInfo.setSourceType("2");
        voucherInfo.setOrg(this.schemeInfo.getOrgId());
        if (this.schemeInfo.enableMulCur()) {
            voucherInfo.setMulCur(this.schemeInfo.getMurCurConfigs());
            voucherInfo.loadRefence();
            for (LocalCurrencyConfigVO config : this.schemeInfo.getMurCurConfigs()) {
                VoucherInfo copy = voucherInfo.copy();
                this.schemeInfo.getMulCurVoucherInfo().put(config.getNumber(), copy);
            }
        }
        voucherInfo.loadRefence();
        return voucherInfo;
    }

    private List<VoucherInfo> constructVoucherEntities() {
        DataSet dataSet = this.schemeInfo.getBalance();
        Object object = null;
        try {
            if (dataSet == null || !dataSet.hasNext()) {
                throw new GLException(GLErrorCode.common, new Object[]{String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u65b9\u6848\u671f\u672b\u8c03\u6c47\u7c7b\u79d1\u76ee\u4f59\u989d\u4e3a\u96f6\uff0c\u65e0\u9700\u8fdb\u884c\u671f\u672b\u8c03\u6c47\u3002", (String)"AdjustGenerateVoucherService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), this.schemeInfo.getNumber())});
            }
            boolean enCache = Boolean.parseBoolean(System.getProperty("fi.gl.adjust.prepareflex", "true"));
            if (enCache) {
                this.prepareAssvalData(this.assVals, this.val2new, dataSet);
            }
            DataSet copyDataSet = dataSet.copy();
            ArrayList rowTotal = new ArrayList(8);
            copyDataSet.forEach(x -> rowTotal.add(x.getString("accountid")));
            Long finish = 0L;
            String pageId = this.schemeInfo.getPageId();
            Long amountScheme = Long.valueOf((String)this.progressCache.get(pageId + "amountScheme"));
            Long completeScheme = Long.valueOf((String)this.progressCache.get(pageId + "completeScheme"));
            for (Row row : dataSet) {
                this.preCreateAdjustEntry(row, null);
                for (LocalCurrencyConfigVO murCurConfig : this.schemeInfo.getMurCurConfigs()) {
                    this.preCreateAdjustEntry(row, murCurConfig);
                }
                Long l = finish;
                Long l2 = finish = Long.valueOf(finish + 1L);
                if (finish % 500L != 0L) continue;
                this.setProgressCache(pageId + "progress", completeScheme == 0L ? String.valueOf(finish * 100L / (long)rowTotal.size() / amountScheme) : String.valueOf(completeScheme * 100L / amountScheme + finish * 100L / (long)rowTotal.size() / amountScheme));
            }
            this.setProgressCache(pageId + "progress", String.valueOf((completeScheme + 1L) * 100L / amountScheme));
        }
        catch (Throwable enCache) {
            object = enCache;
            throw enCache;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable enCache) {
                        ((Throwable)object).addSuppressed(enCache);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        if (this.schemeInfo.getVoucherInfo().getEntries().isEmpty() && this.schemeInfo.getLossVoucherInfo().getEntries().isEmpty()) {
            if (!this.schemeInfo.enableMulCur()) {
                throw new GLException(GLErrorCode.common, new Object[]{String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u671f\u672b\u8c03\u6c47\u7c7b\u79d1\u76ee\u6c47\u7387\u672a\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u9700\u8981\u671f\u672b\u8c03\u6c47\u3002", (String)"AdjustGenerateVoucherService_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), this.schemeInfo.getNumber())});
            }
            List collected = this.schemeInfo.getMurCurConfigs().stream().filter(configVO -> !this.schemeInfo.getVoucherInfo(configVO.getNumber()).getEntries().isEmpty() || !this.schemeInfo.getLossVoucherInfo(configVO.getNumber()).getEntries().isEmpty()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collected)) {
                throw new GLException(GLErrorCode.common, new Object[]{String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u671f\u672b\u8c03\u6c47\u7c7b\u79d1\u76ee\u6c47\u7387\u672a\u53d1\u751f\u53d8\u5316\uff0c\u4e0d\u9700\u8981\u671f\u672b\u8c03\u6c47\u3002", (String)"AdjustGenerateVoucherService_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), this.schemeInfo.getNumber())});
            }
        }
        this.preCreatePLEntries();
        ArrayList<VoucherInfo> voucherInfos = new ArrayList<VoucherInfo>();
        if (!this.schemeInfo.getVoucherInfo().getEntries().isEmpty()) {
            voucherInfos.add(this.schemeInfo.getVoucherInfo());
        }
        if (this.schemeInfo.isSplitProfitAndLoss() && !this.schemeInfo.getLossVoucherInfo().getEntries().isEmpty()) {
            voucherInfos.add(this.schemeInfo.getLossVoucherInfo());
        }
        if (this.schemeInfo.enableMulCur()) {
            for (LocalCurrencyConfigVO config : this.schemeInfo.getMurCurConfigs()) {
                String mulCurType = config.getNumber();
                VoucherInfo mulCurVoucherInfo = this.schemeInfo.getVoucherInfo(mulCurType);
                if (!mulCurVoucherInfo.getEntries().isEmpty()) {
                    voucherInfos.add(mulCurVoucherInfo);
                }
                if (!this.schemeInfo.isSplitProfitAndLoss() || this.schemeInfo.getLossVoucherInfo(mulCurType).getEntries().isEmpty()) continue;
                voucherInfos.add(this.schemeInfo.getLossVoucherInfo(mulCurType));
            }
        }
        return voucherInfos;
    }

    private void prepareAssvalData(Map<Long, String> assVals, Map<String, Long> val2new, DataSet ds) {
        HashSet<Long> assgrpIds = new HashSet<Long>(this.ASSGRPID_SIZE);
        int i = 1;
        for (Row row : ds.copy()) {
            long assgrp = row.getLong("assgrp");
            if (assgrp > 0L) {
                assgrpIds.add(assgrp);
            }
            if (i > this.ASSGRPID_SIZE) break;
            ++i;
        }
        if (assgrpIds.size() > 0) {
            BaseBufferedIterator bufferedIterator = new BaseBufferedIterator(assgrpIds.iterator(), 1000);
            while (bufferedIterator.hasNext()) {
                Long[] next = (Long[])bufferedIterator.next();
                DataSet assistDs = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "#prepareAssvalData"), (String)"gl_assist", (String)"id,assvals", (QFilter[])new QFilter("id", "in", (Object)next).toArray(), null);
                Throwable throwable = null;
                try {
                    ArrayList<FlexEntireData> flexEntires = new ArrayList<FlexEntireData>(next.length);
                    for (Row ass : assistDs) {
                        String assVal = ass.getString(1);
                        assVals.put(ass.getLong(0), assVal);
                        if (this.schemeInfo.isSplitProfitAndLoss()) {
                            flexEntires.add(ReciprocalUtils.buildFlexEntireData(this.getAssgrpValByPLAccount(assVal, this.schemeInfo.getProfitAccountFlexs())));
                            continue;
                        }
                        if (!this.schemeInfo.getLossAccountFlexs().isEmpty()) {
                            flexEntires.add(ReciprocalUtils.buildFlexEntireData(this.getAssgrpValByPLAccount(assVal, this.schemeInfo.getLossAccountFlexs())));
                        }
                        if (this.schemeInfo.getProfitAccountFlexs().isEmpty()) continue;
                        flexEntires.add(ReciprocalUtils.buildFlexEntireData(this.getAssgrpValByPLAccount(assVal, this.schemeInfo.getProfitAccountFlexs())));
                    }
                    if (flexEntires.isEmpty()) continue;
                    MainEntityType mainEntity = new MainEntityType();
                    mainEntity.setAlias("T_GL_ASSIST");
                    mainEntity.setDBRouteKey("gl");
                    FlexService.batchSaveFlexData((MainEntityType)mainEntity, flexEntires);
                    for (FlexEntireData entry : flexEntires) {
                        val2new.put(entry.concatFlexData(), entry.getId());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (assistDs == null) continue;
                    if (throwable != null) {
                        try {
                            assistDs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    assistDs.close();
                }
            }
        }
    }

    private void preCreateAdjustEntry(Row row, LocalCurrencyConfigVO config) {
        boolean isLoss;
        Long baseCurrencyId = this.schemeInfo.getBaseCurrencyId();
        String endLocalKey = "endlocal";
        int baseCurrencyAmtPrecision = this.schemeInfo.getBaseCurrencyAmtPrecision();
        String mulCurType = null;
        if (config != null) {
            baseCurrencyId = config.getCurrencyId(this.schemeInfo.getOrgId().longValue(), this.schemeInfo.getAccountBookInfo().getBookTypeId());
            endLocalKey = config.getBalanceField(MCT.END).getMetaId();
            mulCurType = config.getNumber();
            baseCurrencyAmtPrecision = (Integer)this.schemeInfo.getMulCurBaseCurrencyAmtPrecision().get(mulCurType);
        }
        long currencyId = row.getLong("currency");
        ExchangeRate rate = (ExchangeRate)this.schemeInfo.getCurRateConfig().get((Object)baseCurrencyId, (Object)currencyId);
        if (rate == null) {
            return;
        }
        AmountInfo amountInfo = new AmountInfo.Builder().mulCurType(mulCurType).build();
        String dc = row.getString("acctdc");
        amountInfo.setRate(rate.getValue());
        Long accountId = row.getLong("accountid");
        amountInfo.setAccountId(accountId);
        Long assgrpId = row.getLong("assgrp");
        amountInfo.setAssgrpId(assgrpId);
        amountInfo.setCrrencyId(Long.valueOf(currencyId));
        Long unitId = row.getLong("measureunit");
        amountInfo.setUnitId(unitId);
        HashMap<Integer, Long> comAssistIdMap = new HashMap<Integer, Long>(8);
        for (int index = 0; index < this.schemeInfo.getComAssistCount(); ++index) {
            comAssistIdMap.put(index + 1, row.getLong(CommonAssistUtil.getComassistField((int)(index + 1))));
        }
        amountInfo.setComAssistIdMap(comAssistIdMap);
        BigDecimal dcDecimal = row.getBigDecimal("acctdc");
        BigDecimal oriAmount = row.getBigDecimal("endfor");
        BigDecimal locAmount = row.getBigDecimal(endLocalKey);
        BigDecimal locBal = locAmount.multiply(dcDecimal);
        BigDecimal oriBal = oriAmount.multiply(dcDecimal);
        locAmount = rate.getRateType().getRateCalculator().calLocAmount(rate.getValue(), oriAmount, baseCurrencyAmtPrecision).subtract(locAmount).setScale(baseCurrencyAmtPrecision, RoundingMode.HALF_UP);
        boolean bl = isLoss = locAmount.signum() < 0;
        if ("1".equals(this.schemeInfo.getAccDirectionType())) {
            dc = "1".equals(dc) ? "-1" : "1";
        } else if ("2".equals(this.schemeInfo.getAccDirectionType())) {
            dc = isLoss ? "-1" : "1";
        }
        amountInfo.setDc(dc);
        if ("-1".equals(dc)) {
            locAmount = locAmount.negate();
        }
        amountInfo.setLocAmount(locAmount);
        amountInfo.setOriAmount(BigDecimal.ZERO);
        if (this.preCreateAdjustVoucherEntry(isLoss, amountInfo)) {
            this.addAdjustLog(amountInfo, oriBal, locBal);
        }
    }

    private boolean preCreateAdjustVoucherEntry(boolean isLoss, AmountInfo amount) {
        String key = this.getSumKey(isLoss, amount);
        if (isLoss) {
            AmountInfo usedAmount = this.createSingleVoucherEntry(this.schemeInfo.getLossVoucherInfo(amount.getMulCurType()), amount);
            if (usedAmount != null) {
                this.schemeInfo.getSumByCurrencyLossBalance(amount.getMulCurType()).update(amount, key);
                return true;
            }
        } else {
            AmountInfo usedAmount = this.createSingleVoucherEntry(this.schemeInfo.getVoucherInfo(amount.getMulCurType()), amount);
            if (usedAmount != null) {
                this.schemeInfo.getSumByCurrencyProfitBalance(amount.getMulCurType()).update(amount, key);
                return true;
            }
        }
        return false;
    }

    private String getSumKey(boolean isLoss, AmountInfo amount) {
        Long assgrpId = this.getAssgrpIdKey(isLoss, amount);
        Long currencyId = amount.getCrrencyId();
        String currencyKey = String.valueOf(currencyId);
        if (isLoss) {
            if (!this.schemeInfo.existsCurrencyIdInLossAccountCurrencyIds(currencyId)) {
                currencyKey = String.valueOf(this.schemeInfo.getBaseCurrencyId());
            }
        } else if (!this.schemeInfo.existsCurrencyIdInProfitAccountCurrencyIds(currencyId)) {
            currencyKey = String.valueOf(this.schemeInfo.getBaseCurrencyId());
        }
        Map comAssistIdMap = amount.getComAssistIdMap();
        StringBuilder comAssistKey = new StringBuilder();
        for (int index = 0; index < this.schemeInfo.getComAssistCount(); ++index) {
            comAssistKey.append(comAssistIdMap.getOrDefault(index + 1, 0L)).append("_");
        }
        if (comAssistKey.length() > 0) {
            comAssistKey.deleteCharAt(comAssistKey.length() - 1);
        }
        return String.join((CharSequence)"-", currencyKey, String.valueOf(assgrpId), amount.getMulCurType(), comAssistKey.toString());
    }

    private Long getAssgrpIdKey(boolean isLoss, AmountInfo amount) {
        Long assgrpId = amount.getAssgrpId();
        if (isLoss) {
            if (this.schemeInfo.getLossAssgrpId() > 0L) {
                return this.getAssgrpKeyByPLAccount(this.schemeInfo.getLossAssgrpId(), this.schemeInfo.getLossAccountFlexs());
            }
            if (assgrpId > 0L) {
                return this.getAssgrpKeyByPLAccount(assgrpId, this.schemeInfo.getLossAccountFlexs());
            }
        } else {
            if (this.schemeInfo.getProfitAssgrpId() > 0L) {
                return this.getAssgrpKeyByPLAccount(this.schemeInfo.getProfitAssgrpId(), this.schemeInfo.getProfitAccountFlexs());
            }
            if (assgrpId > 0L) {
                return this.getAssgrpKeyByPLAccount(assgrpId, this.schemeInfo.getProfitAccountFlexs());
            }
        }
        return 0L;
    }

    private Long getAssgrpKeyByPLAccount(Long assgrpId, List<String> plFlexs) {
        if (!plFlexs.isEmpty()) {
            Map flexValMap;
            Map<String, Object> newValueMap;
            String flexVal = this.assVals.get(assgrpId);
            if (Objects.isNull(flexVal)) {
                flexVal = this.getFlexValByAssgrpIdFromCache(assgrpId);
            }
            if (StringUtils.isNotBlank((CharSequence)flexVal) && !(newValueMap = (flexValMap = (Map)SerializationUtils.fromJsonString((String)flexVal, Map.class)).entrySet().stream().filter(x -> plFlexs.contains(x.getKey())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> x.getValue()))).isEmpty()) {
                FlexEntireData flexEntireData = ReciprocalUtils.buildFlexEntireData(newValueMap);
                Long newAssgrpId = this.val2new.get(flexEntireData.concatFlexData());
                if (newAssgrpId != null && newAssgrpId > 0L) {
                    return newAssgrpId;
                }
                MainEntityType mainEntity = new MainEntityType();
                mainEntity.setAlias("T_GL_ASSIST");
                mainEntity.setDBRouteKey("gl");
                return FlexService.saveFlexData((MainEntityType)mainEntity, (FlexEntireData)flexEntireData);
            }
        }
        return 0L;
    }

    private Map<String, Object> getAssgrpValByPLAccount(String flexVal, List<String> plFlexs) {
        if (!plFlexs.isEmpty() && StringUtils.isNotBlank((CharSequence)flexVal)) {
            Map flexValMap = (Map)SerializationUtils.fromJsonString((String)flexVal, Map.class);
            Map<String, Object> newValueMap = flexValMap.entrySet().stream().filter(x -> plFlexs.contains(x.getKey())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> x.getValue()));
            return newValueMap;
        }
        return Collections.EMPTY_MAP;
    }

    private String getFlexValByAssgrpIdFromCache(Long assgrpId) {
        String threadCacheKey = String.join((CharSequence)"-", this.getClass().getName(), "assist", String.valueOf(assgrpId));
        return (String)ThreadCache.get((Object)threadCacheKey, () -> {
            DynamicObject assistDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_assist", (String)"assvals", (QFilter[])new QFilter("id", "=", (Object)assgrpId).toArray());
            return assistDyn == null ? "" : assistDyn.getString("assvals");
        });
    }

    private void preCreatePLEntries() {
        if (this.schemeInfo.isSplitProfitAndLoss()) {
            this.preCreatePLEntries(this.schemeInfo.getSumByCurrencyProfitBalance().getBalances(), this.schemeInfo.getVoucherInfo(), this.schemeInfo.getProfitAccountId());
            this.preCreatePLEntries(this.schemeInfo.getSumByCurrencyLossBalance().getBalances(), this.schemeInfo.getLossVoucherInfo(), this.schemeInfo.getLossAccountId());
        } else {
            this.preCreatePLEntries(this.schemeInfo.getSumByCurrencyProfitBalance().getBalances(), this.schemeInfo.getVoucherInfo(), this.schemeInfo.getProfitAccountId());
        }
        for (LocalCurrencyConfigVO murCurConfig : this.schemeInfo.getMurCurConfigs()) {
            String mulCurType = murCurConfig.getNumber();
            if (this.schemeInfo.isSplitProfitAndLoss()) {
                this.preCreatePLEntries(this.schemeInfo.getSumByCurrencyProfitBalance(mulCurType).getBalances(), this.schemeInfo.getVoucherInfo(mulCurType), this.schemeInfo.getProfitAccountId());
                this.preCreatePLEntries(this.schemeInfo.getSumByCurrencyLossBalance(mulCurType).getBalances(), this.schemeInfo.getLossVoucherInfo(mulCurType), this.schemeInfo.getLossAccountId());
                continue;
            }
            this.preCreatePLEntries(this.schemeInfo.getSumByCurrencyProfitBalance(mulCurType).getBalances(), this.schemeInfo.getVoucherInfo(mulCurType), this.schemeInfo.getProfitAccountId());
        }
    }

    private void preCreatePLEntries(Map<String, BalanceInfo> balances, VoucherInfo voucherHead, Long accountId) {
        balances.forEach((k, v) -> this.preCreatePLEntry(voucherHead, (String)k, (BalanceInfo)v, accountId));
    }

    private void preCreatePLEntry(VoucherInfo voucherHead, String k, BalanceInfo v, Long accountId) {
        int selfAdaptedDirection;
        String[] split = k.split("-");
        Long currencyId = Long.valueOf(split[0]);
        Long assgrpId = Long.valueOf(split[1]);
        String localCurType = String.valueOf(split[2]);
        ExchangeRate rate = new ExchangeRate();
        rate.setDirectRate(BigDecimal.ONE);
        Long baseCurrencyId = this.schemeInfo.getBaseCurrencyId();
        int baseCurrencyAmtPrecision = this.schemeInfo.getBaseCurrencyAmtPrecision();
        if (!this.schemeInfo.getBaseCurrencyId().equals(currencyId)) {
            if (!"BaseCurrency".equals(localCurType)) {
                Optional<LocalCurrencyConfigVO> first = this.schemeInfo.getMurCurConfigs().stream().filter(configVO -> configVO.getNumber().equals(localCurType)).findFirst();
                baseCurrencyId = first.map(configVO -> configVO.getCurrencyId(this.schemeInfo.getOrgId().longValue(), this.schemeInfo.getAccountBookInfo().getBookTypeId())).orElseGet(() -> this.schemeInfo.getBaseCurrencyId());
                baseCurrencyAmtPrecision = first.map(configVO -> this.schemeInfo.getBaseCurrencyAmtPrecision(configVO.getNumber())).orElseGet(() -> this.schemeInfo.getBaseCurrencyAmtPrecision("BaseCurrency"));
            }
            rate = this.schemeInfo.getCurRateConfig().get((Object)baseCurrencyId, (Object)currencyId) == null ? rate : (ExchangeRate)this.schemeInfo.getCurRateConfig().get((Object)baseCurrencyId, (Object)currencyId);
        }
        BigDecimal endLocalSum = v.getEndLocalSum().setScale(baseCurrencyAmtPrecision, RoundingMode.HALF_UP);
        AmountInfo amountInfo = new AmountInfo.Builder().mulCurType(localCurType).build();
        amountInfo.setAccountId(accountId);
        amountInfo.setAssgrpId(assgrpId);
        amountInfo.setCrrencyId(currencyId);
        amountInfo.setRate(rate.getValue());
        RecordDirection directionToRecord = this.schemeInfo.getPLAccountRecordDirection();
        int recordDirection = directionToRecord.value;
        int directionReadyToRecord = selfAdaptedDirection = Integer.parseInt(endLocalSum.signum() > 0 ? "-1" : "1");
        BigDecimal amtReadyToRecord = endLocalSum.abs();
        if (!directionToRecord.ifSelfAdapted()) {
            directionReadyToRecord = recordDirection;
            boolean isSame = selfAdaptedDirection * recordDirection > 0;
            amtReadyToRecord = isSame ? amtReadyToRecord : amtReadyToRecord.negate();
        }
        amountInfo.setDc(directionReadyToRecord + "");
        amountInfo.setLocAmount(amtReadyToRecord);
        amountInfo.setOriAmount(BigDecimal.ZERO);
        if (split.length > 3) {
            String comAssistKey = split[3];
            String[] comAssistIds = comAssistKey.split("_");
            HashMap<Integer, Long> comAssistIdMap = new HashMap<Integer, Long>(8);
            for (int index = 0; index < comAssistIds.length; ++index) {
                comAssistIdMap.put(index + 1, Long.parseLong(comAssistIds[index]));
            }
            amountInfo.setComAssistIdMap(comAssistIdMap);
        }
        this.createSingleVoucherEntry(voucherHead, amountInfo);
    }

    private AmountInfo createSingleVoucherEntry(VoucherInfo voucherHead, AmountInfo amount) {
        if (amount.getLocAmount().signum() != 0 || amount.getOriAmount().signum() != 0 || amount.getQty().signum() != 0) {
            VoucherEntryInfo voucherEntry = voucherHead.createNewEntry();
            voucherEntry.setDesc(this.schemeInfo.getVoucherDesc());
            voucherEntry.setAccount(amount.getAccountId());
            voucherEntry.setAssgrp(amount.getAssgrpId());
            voucherEntry.setCurency(amount.getCrrencyId());
            voucherEntry.setUnit(amount.getUnitId());
            voucherEntry.setQty(amount.getQty());
            String dc = amount.getDc();
            voucherEntry.setEntryDC(dc);
            String vchLocalDebitField = "debitlocal";
            String vchLocalCreditField = "creditlocal";
            String vchRateField = "localrate";
            for (LocalCurrencyConfigVO config : this.schemeInfo.getMurCurConfigs()) {
                if (!amount.getMulCurType().equals(config.getNumber())) continue;
                vchRateField = config.getVoucherField(MCT.EX_RATE).getMetaId();
                vchLocalDebitField = config.getVoucherField(MCT.DEBIT).getMetaId();
                vchLocalCreditField = config.getVoucherField(MCT.CREDIT).getMetaId();
            }
            voucherEntry.set(vchRateField, (Object)amount.getRate());
            if ("1".equals(dc)) {
                voucherEntry.set(vchLocalDebitField, (Object)amount.getLocAmount());
                voucherEntry.set(vchLocalCreditField, (Object)BigDecimal.ZERO);
                voucherEntry.setOriAmt(BigDecimal.ZERO, BigDecimal.ZERO);
            } else {
                voucherEntry.set(vchLocalDebitField, (Object)BigDecimal.ZERO);
                voucherEntry.set(vchLocalCreditField, (Object)amount.getLocAmount());
                voucherEntry.setOriAmt(BigDecimal.ZERO, BigDecimal.ZERO);
            }
            Map comAssistIdMap = amount.getComAssistIdMap();
            for (Map.Entry comAssistIdEntry : comAssistIdMap.entrySet()) {
                voucherEntry.setComAssist(((Integer)comAssistIdEntry.getKey()).intValue(), (Long)comAssistIdEntry.getValue());
            }
            return amount;
        }
        return null;
    }

    private void addAdjustLog(AmountInfo amount, BigDecimal endFor, BigDecimal endLocal) {
        AmountInfo amountInfo = new AmountInfo.Builder().mulCurType(amount.getMulCurType()).build();
        amountInfo.setAccountId(amount.getAccountId());
        amountInfo.setAssgrpId(amount.getAssgrpId());
        amountInfo.setCrrencyId(amount.getCrrencyId());
        amountInfo.setUnitId(amount.getUnitId());
        amountInfo.setLocAmount(endLocal);
        amountInfo.setOriAmount(endFor);
        amountInfo.setComAssistIdMap(amount.getComAssistIdMap());
        long dataEntityId = (Long)this.schemeInfo.getDataEntity().getPkValue();
        this.adjustLog.compute(dataEntityId, (k, v) -> {
            if (v == null) {
                v = new ArrayList<AmountInfo>();
            }
            v.add(amountInfo);
            return v;
        });
    }

    private void setProgressCache(String key, String value) {
        this.progressCache.put(key, (Object)value);
    }
}

