/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocess.opservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.finalprocess.info.GenerateVoucherReslutInfo;
import kd.fi.gl.finalprocess.opservice.GenerateVoucherServiceFactory;
import kd.fi.gl.finalprocess.opservice.IGenerateVoucherService;
import kd.fi.gl.finalprocess.opservice.validator.GenerateVoucherVaildatorFactory;

public class FinalProcessGenerateVoucherOpService
extends AbstractOperationServicePlugIn {
    private IGenerateVoucherService service;
    private Map<Object, DynamicObject> pk2successSchemes;
    private List<GenerateVoucherReslutInfo> genreateSuccessResults;
    private Map<DynamicObject, List<VoucherInfo>> all_scheme2vouchers;
    protected DistributeSessionlessCache progressCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CacheKeyUtil.getAcctId() + ":" + "FPCreateVoucher");

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        String entityName = this.billEntityType.getName();
        AbstractValidator generateVoucherVaildator = GenerateVoucherVaildatorFactory.getGenerateVoucherVaildator(entityName);
        if (generateVoucherVaildator != null) {
            e.addValidator(generateVoucherVaildator);
        }
    }

    private DynamicObject[] loadFullDynamicObjects(DynamicObject[] dataEntities) {
        List pks = Stream.of(dataEntities).map(x -> x.getPkValue()).collect(Collectors.toList());
        QFilter pkFilter = new QFilter("id", "in", pks);
        String entityName = this.billEntityType.getName();
        return BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])pkFilter.toArray()).values().toArray(new DynamicObject[0]);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String entityName = this.billEntityType.getName();
        this.service = GenerateVoucherServiceFactory.getGenerateVoucherService(entityName);
        if (this.service == null) {
            return;
        }
        DynamicObject[] localDataEntities = this.loadFullDynamicObjects(args.getDataEntities());
        if (localDataEntities == null || localDataEntities.length == 0) {
            return;
        }
        this.pk2successSchemes = Stream.of(localDataEntities).collect(Collectors.toMap(x -> x.getPkValue(), x -> x));
        this.all_scheme2vouchers = new HashMap<DynamicObject, List<VoucherInfo>>(localDataEntities.length);
        String pageId = this.getOption().containsVariable("pageId") ? this.getOption().getVariableValue("pageId") : "";
        this.setProgressCache(pageId + "amountScheme", String.valueOf(localDataEntities.length));
        Long completeScheme = 0L;
        this.setProgressCache(pageId + "completeScheme", String.valueOf(completeScheme));
        for (DynamicObject schemeDyn : localDataEntities) {
            try {
                List<VoucherInfo> singleSchemeVoucherInfos = this.service.generateVoucher(schemeDyn, this.operateOption);
                this.all_scheme2vouchers.put(schemeDyn, singleSchemeVoucherInfos);
            }
            catch (Exception e) {
                if (e instanceof GLException) {
                    this.addOperateErrorInfo(schemeDyn, e.getMessage());
                }
                throw e;
            }
            Long l = completeScheme;
            Long l2 = completeScheme = Long.valueOf(completeScheme + 1L);
            this.setProgressCache(pageId + "completeScheme", String.valueOf(completeScheme));
        }
        this.setProgressCache(pageId + "progress", "99");
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.baforeSaveVoucherOperation();
                this.beginSaveVoucherOperation();
                this.endSaveVoucherOperation();
                this.afterSaveVoucherOperation();
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        args.setDataEntities(this.pk2successSchemes.values().toArray(new DynamicObject[0]));
    }

    private void baforeSaveVoucherOperation() {
        Iterator<Map.Entry<DynamicObject, List<VoucherInfo>>> iterator = this.all_scheme2vouchers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<DynamicObject, List<VoucherInfo>> entry = iterator.next();
            DynamicObject schemeDyn = entry.getKey();
            List<VoucherInfo> voucherInfos = entry.getValue();
            if (voucherInfos == null) {
                this.addOperateErrorInfo(schemeDyn, ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u672a\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u914d\u7f6e\u3002", (String)"FinalProcessGenerateVoucherOpService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                iterator.remove();
                continue;
            }
            Iterator<VoucherInfo> voucherInfoIterator = voucherInfos.iterator();
            while (voucherInfoIterator.hasNext()) {
                VoucherInfo voucherInfo = voucherInfoIterator.next();
                if (voucherInfo == null || voucherInfo.getEntries() == null || voucherInfo.getEntries().isEmpty()) {
                    this.addOperateErrorInfo(schemeDyn, ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u751f\u6210\u4e00\u5f20\u7a7a\u5206\u5f55\u51ed\u8bc1\u3002", (String)"FinalProcessGenerateVoucherOpService_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    voucherInfoIterator.remove();
                    continue;
                }
                voucherInfo.loadRefence();
            }
            if (!voucherInfos.isEmpty()) continue;
            this.addOperateErrorInfo(schemeDyn, ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u751f\u6210\u51ed\u8bc1\u5206\u5f55\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848\u914d\u7f6e\u3002", (String)"FinalProcessGenerateVoucherOpService_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            iterator.remove();
        }
    }

    public void beginSaveVoucherOperation() {
        if (this.all_scheme2vouchers == null || this.all_scheme2vouchers.isEmpty()) {
            this.genreateSuccessResults = Collections.emptyList();
            return;
        }
        if (this.getOption().containsVariable("MergeVoucherEntries")) {
            List<Tuple2<Map<DynamicObject, List<VoucherInfo>>, VoucherInfo>> mergeVoucherInfos = this.mergeVoucher(this.all_scheme2vouchers);
            mergeVoucherInfos.forEach(mergeVoucherInfo -> {
                List<Object> voucherInfos = Collections.singletonList(mergeVoucherInfo.t2);
                for (VoucherInfo voucherInfo : voucherInfos) {
                    this.setExpireDate(voucherInfo);
                }
                List<DynamicObject> voucherDyns = voucherInfos.stream().map(x -> x.toDynamicObject()).collect(Collectors.toList());
                if (voucherDyns != null) {
                    this.saveVoucherOperation(voucherDyns, (Map)mergeVoucherInfo.t1);
                }
            });
        } else {
            this.all_scheme2vouchers.forEach((k, voucherInfos) -> {
                for (VoucherInfo voucherInfo : voucherInfos) {
                    this.setExpireDate(voucherInfo);
                }
                List<DynamicObject> voucherDyns = voucherInfos.stream().map(x -> x.toDynamicObject()).collect(Collectors.toList());
                if (voucherDyns != null) {
                    Map<DynamicObject, List<VoucherInfo>> singletonMap = Collections.singletonMap(k, voucherInfos);
                    this.saveVoucherOperation(voucherDyns, singletonMap);
                }
            });
        }
        if (this.genreateSuccessResults == null) {
            this.genreateSuccessResults = Collections.emptyList();
        }
    }

    private void setExpireDate(VoucherInfo voucherInfo) {
        String fieldEntry = "entries";
        String fieldAccountId = "account_id";
        Set accounts = voucherInfo.toDynamicObject().getDynamicObjectCollection(fieldEntry).stream().map(x -> x.getLong(fieldAccountId)).collect(Collectors.toSet());
        if (accounts.isEmpty()) {
            return;
        }
        String filedAcCheck = "accheck";
        List acAccounts = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter("id", "in", accounts).and(new QFilter(filedAcCheck, "=", (Object)Boolean.TRUE)).toArray(), null, (int)-1);
        if (acAccounts.isEmpty()) {
            return;
        }
        String filedEndDate = "enddate";
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)filedEndDate, (QFilter[])new QFilter("id", "=", (Object)voucherInfo.getPeriod()).toArray());
        if (periodDyn == null) {
            return;
        }
        Date date = periodDyn.getDate(filedEndDate);
        voucherInfo.getEntries().forEach(x -> {
            if (acAccounts.contains(x.getAccount())) {
                x.setExpireDate(date);
            }
        });
    }

    private void saveVoucherOperation(List<DynamicObject> voucherDyns, Map<DynamicObject, List<VoucherInfo>> scheme2vouchers) {
        DynamicObject[] pkVlaues = scheme2vouchers.keySet().toArray(new DynamicObject[0]);
        try (TXHandle tx = TX.requiresNew();){
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"gl_voucher", (DynamicObject[])voucherDyns.toArray(new DynamicObject[0]), null);
            if (!operationResult.isSuccess()) {
                List infos = operationResult.getAllErrorOrValidateInfo();
                String errorMsg = infos.stream().map(IOperateInfo::getMessage).collect(Collectors.joining(System.lineSeparator()));
                this.addOperateErrorInfo(errorMsg, pkVlaues);
                tx.markRollback();
                operationResult.getSuccessPkIds().clear();
            } else if (operationResult.getSuccessPkIds().size() == 0) {
                this.addOperateErrorInfo(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u672a\u751f\u6210\u51ed\u8bc1\u3002", (String)"FinalProcessGenerateVoucherOpService_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), pkVlaues);
            } else {
                this.addSuccessResult(operationResult, scheme2vouchers);
            }
        }
    }

    private List<Tuple2<Map<DynamicObject, List<VoucherInfo>>, VoucherInfo>> mergeVoucher(Map<DynamicObject, List<VoucherInfo>> scheme2voucherInfos) {
        Map<String, List<Map.Entry>> collect = scheme2voucherInfos.entrySet().stream().filter(x -> x.getValue() != null && !((List)x.getValue()).isEmpty() && ((List)x.getValue()).get(0) != null).collect(Collectors.groupingBy(x -> ((VoucherInfo)((List)x.getValue()).get(0)).getGruopKey()));
        ArrayList<Tuple2<Map<DynamicObject, List<VoucherInfo>>, VoucherInfo>> result = new ArrayList<Tuple2<Map<DynamicObject, List<VoucherInfo>>, VoucherInfo>>(collect.size());
        for (List<Map.Entry> group : collect.values()) {
            Map<DynamicObject, List> groupScheme2voucherInfos = group.stream().collect(Collectors.toMap(x -> (DynamicObject)x.getKey(), x -> (List)x.getValue()));
            ArrayList mergeVoucherInfos = new ArrayList();
            for (Map.Entry entry : group) {
                mergeVoucherInfos.addAll((Collection)entry.getValue());
            }
            if (mergeVoucherInfos == null || mergeVoucherInfos.isEmpty()) continue;
            VoucherInfo voucherInfo = ((VoucherInfo)mergeVoucherInfos.get(0)).copy();
            if (mergeVoucherInfos.size() > 1) {
                for (int i = 1; i < mergeVoucherInfos.size(); ++i) {
                    VoucherInfo tempVoucherInfo = (VoucherInfo)mergeVoucherInfos.get(i);
                    voucherInfo.addEntries(tempVoucherInfo.getEntries());
                }
            }
            DynamicObjectCollection dyns = voucherInfo.toDynamicObject().getDynamicObjectCollection("entries");
            int i = 1;
            for (DynamicObject dyn : dyns) {
                dyn.set("seq", (Object)i++);
            }
            result.add((Tuple2<Map<DynamicObject, List<VoucherInfo>>, VoucherInfo>)new Tuple2(groupScheme2voucherInfos, (Object)voucherInfo));
        }
        return result;
    }

    private void endSaveVoucherOperation() {
        if (this.genreateSuccessResults != null && !this.genreateSuccessResults.isEmpty()) {
            ArrayList relations = new ArrayList(10);
            this.genreateSuccessResults.stream().map(x -> x.getVoucherRelationDyns()).forEach(x -> relations.addAll(x));
            SaveServiceHelper.save((DynamicObject[])relations.toArray(new DynamicObject[0]));
        }
        this.service.writeBack(this.genreateSuccessResults);
    }

    private void afterSaveVoucherOperation() {
        HashMap scheme2vouchers = new HashMap(16);
        this.genreateSuccessResults.stream().filter(x -> x.getVoucherSaveResult() != null).forEach(x -> x.getScheme2voucherInfos().keySet().forEach(k -> scheme2vouchers.put(k.getPkValue(), new ArrayList(x.getVoucherSaveResult().getSuccessPkIds()))));
        this.getOption().setVariableValue("finialProcessResult", SerializationUtils.serializeToBase64(scheme2vouchers));
        List<Object> allVoucherIds = new LinkedList();
        for (List vouchers : scheme2vouchers.values()) {
            allVoucherIds.addAll(vouchers);
        }
        allVoucherIds = allVoucherIds.stream().distinct().collect(Collectors.toList());
        this.getOption().setVariableValue("FinalProcessingVouchers", SerializationUtils.serializeToBase64(allVoucherIds));
    }

    private void addSuccessResult(OperationResult operationResult, Map<DynamicObject, List<VoucherInfo>> scheme2vouchers) {
        GenerateVoucherReslutInfo generateVoucherReslutInfo = new GenerateVoucherReslutInfo(scheme2vouchers, operationResult);
        if (this.genreateSuccessResults == null) {
            this.genreateSuccessResults = new ArrayList<GenerateVoucherReslutInfo>(10);
        }
        this.genreateSuccessResults.add(generateVoucherReslutInfo);
    }

    private void addOperateErrorInfo(String errorMsg, DynamicObject ... schemeDyns) {
        for (DynamicObject schemeDyn : schemeDyns) {
            this.addOperateErrorInfo(schemeDyn, errorMsg);
        }
    }

    private void addOperateErrorInfo(DynamicObject schemeDyn, String errorMsg) {
        this.addOperateErrorInfo(schemeDyn.getPkValue(), errorMsg);
    }

    private void addOperateErrorInfo(Object pkValue, String errorMsg) {
        this.pk2successSchemes.remove(pkValue);
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setMessage(errorMsg);
        errorInfo.setPkValue(pkValue);
        errorInfo.setErrorLevel(ErrorLevel.Error.name());
        this.getOperationResult().setSuccess(false);
        this.getOperationResult().addErrorInfo(errorInfo);
    }

    private void setProgressCache(String key, String value) {
        this.progressCache.put(key, (Object)value);
    }
}

