/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.operateservice;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.accountref.AccountVersionReplaceParam;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.flex.FlexService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.fi.bd.rate.IRateCalculator;
import kd.fi.bd.rate.RateServiceHelper;
import kd.fi.bd.rate.RateType;
import kd.fi.bd.service.balance.AppHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BdBusinessDataServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.autotrans.BalanceInfo;
import kd.fi.gl.autotrans.FinalProcessAssgrp;
import kd.fi.gl.bean.GlVoucherField;
import kd.fi.gl.cache.ThreadCacheKey;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.common.VoucherEntryCollection;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.constant.basedata.CurrencyConstant;
import kd.fi.gl.constant.basedata.MeasureUnitConstant;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.finalprocess.constant.AutoTransConstant;
import kd.fi.gl.finalprocess.entrysort.EntrySortFactory;
import kd.fi.gl.finalprocess.entrysort.IVoucherEntrySort;
import kd.fi.gl.finalprocess.info.AmountInfo;
import kd.fi.gl.finalprocess.info.scheme.AutoTransScheme;
import kd.fi.gl.finalprocess.info.scheme.DynamicEntryRow;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;
import kd.fi.gl.finalprocess.merge.EntryMergeOption;
import kd.fi.gl.finalprocess.merge.VoucherEntryDSMergeHelper;
import kd.fi.gl.finalprocess.service.impl.AutoTransService;
import kd.fi.gl.finalprocessing.info.AutoTransGenVchInfo;
import kd.fi.gl.finalprocessing.operateservice.AbstractFinalProcessingOperateService;
import kd.fi.gl.finalprocessing.parser.autotrans.AutoTransAssgrpExpParser;
import kd.fi.gl.finalprocessing.parser.autotrans.AutoTransBcmFormulaParser;
import kd.fi.gl.finalprocessing.parser.autotrans.AutoTransCurrencyParser;
import kd.fi.gl.finalprocessing.parser.autotrans.AutoTransFormulaValueParser;
import kd.fi.gl.finalprocessing.parser.autotrans.AutoTransPercentExpParser;
import kd.fi.gl.finalprocessing.parser.autotrans.AutoTransRptExpParser;
import kd.fi.gl.finalprocessing.parser.result.AutoTransDataFormula;
import kd.fi.gl.finalprocessing.validate.AutoTransGenVchValidator;
import kd.fi.gl.util.AssgrpRelationUtil;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.ExcelUtils;
import kd.fi.gl.util.FinalProcessUtil;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.FlexValueReader;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.NumberFormatUtil;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.ss.usermodel.Workbook;

public class AutoTransGenVchOperateService
extends AbstractFinalProcessingOperateService {
    private static final Log logger = LogFactory.getLog(AutoTransGenVchOperateService.class);
    private static int PRE_SAVE_THRESHOLD;
    private AutoTransGenVchInfo schemeInfo;
    private AutoTransService autoTransService;
    AutoTransScheme autoTransScheme;
    private static final String entityName = "gl_autotrans";
    private static final String Key_RowId = "autorowid";
    private static final String Key_AssgrpType = "assisttranstype";
    private static final String Key_DataType = "datasourcetype";
    private static final String Key_CurrencyId = "currencyid_id";
    private static final String Key_UnitId = "measureunitid_id";
    private static final String Key_CurrencyScale = "currencyid.amtprecision";
    private static final String Key_DcType = "dc";
    private static final String KEY_SEQ = "seq";
    private static final String TRANSFER_TYPE_TRANS_PL = "2";
    private Map<String, Set<Long>> row2accountIds;
    private Set<String> sameNumberInRow;
    private Map<Long, String> accountId2number = new HashMap<Long, String>();
    private Map<Long, BigDecimal> accountId2dc = new HashMap<Long, BigDecimal>();
    private Map<Long, Set<Long>> accountId2opAccountIds = new HashMap<Long, Set<Long>>();
    private Map<Long, Set<String>> accountId2flexs = new HashMap<Long, Set<String>>();
    private Map<Long, DynamicObject> accountId2Dyn = new HashMap<Long, DynamicObject>();
    private Map<Long, Integer> measureunit2precision = new HashMap<Long, Integer>();
    private Map<String, FinalProcessAssgrp> row2assgrp;
    private Map<String, AutoTransDataFormula> row2formula;
    private Map<String, Object> rptReturnData;
    private Map<String, BigDecimal> row2rate;
    private Map<Long, FlexEntireData> transOutAssgrp2FlexEntries;
    private Map<String, BigDecimal> row2percent;
    private Map<String, BigDecimal> row2bcmFormulaCalculateInfo;

    private void parseExp() {
        AutoTransAssgrpExpParser assgrpExpParser = new AutoTransAssgrpExpParser(this.schemeInfo);
        this.row2assgrp = assgrpExpParser.parse();
        AutoTransFormulaValueParser formulaValueParser = new AutoTransFormulaValueParser(this.schemeInfo);
        this.row2formula = formulaValueParser.parse();
        AutoTransCurrencyParser currencyParser = new AutoTransCurrencyParser(this.schemeInfo);
        this.row2rate = currencyParser.parse();
        AutoTransPercentExpParser percentExpParser = new AutoTransPercentExpParser(this.schemeInfo);
        this.row2percent = percentExpParser.parse();
        AutoTransRptExpParser rptExpParser = new AutoTransRptExpParser(this.schemeInfo);
        this.rptReturnData = rptExpParser.parse();
        AutoTransBcmFormulaParser bcmFormulaParser = new AutoTransBcmFormulaParser(this.schemeInfo);
        this.row2bcmFormulaCalculateInfo = bcmFormulaParser.parse();
    }

    private List<VoucherInfo> createVoucherEntries() {
        VoucherInfo voucherHead = this.schemeInfo.getVoucherInfo();
        DynamicObject scheme = this.schemeInfo.getDataEntity();
        DynamicObjectCollection schemeEntries = scheme.getDynamicObjectCollection("autotransentry");
        this.parseExp();
        this.accountId2number.clear();
        this.row2accountIds = this.getRowIdAndLeafActMap(voucherHead.getOrg(), schemeEntries);
        BalanceInfo transOutSumInfo = new BalanceInfo();
        BalanceInfo transInSumInfo = new BalanceInfo();
        for (Object schemeRow : schemeEntries) {
            this.preCreateTransOutVoucherEntry(voucherHead, (DynamicObject)schemeRow, transOutSumInfo);
        }
        Map assgrp2balancne = transOutSumInfo.getAssgrp2balancne();
        this.transOutAssgrp2FlexEntries = this.parseTransOutAssgrp(assgrp2balancne.keySet());
        for (DynamicObject schemeRow : schemeEntries) {
            this.preCreateExpTransInVoucherEntry(voucherHead, schemeRow, transInSumInfo);
            this.preCreateTransInVoucherEntry(voucherHead, schemeRow, transOutSumInfo, transInSumInfo);
        }
        for (DynamicObject schemeRow : schemeEntries) {
            this.preCreateRemainTransInVoucherEntry(voucherHead, schemeRow, transOutSumInfo, transInSumInfo);
        }
        this.orderByEntry();
        this.combineVchEntry(voucherHead);
        ArrayList<VoucherInfo> list = new ArrayList<VoucherInfo>();
        list.add(voucherHead);
        return list;
    }

    private void preCreateTransOutVoucherEntry(VoucherInfo voucherHead, DynamicObject schemeRow, BalanceInfo transOutSumInfo) {
        String dataType;
        List<AmountInfo> amountInfos = null;
        switch (dataType = schemeRow.getString(Key_DataType)) {
            case "5": {
                amountInfos = this.getFormulaValue(schemeRow);
                break;
            }
            case "8": {
                amountInfos = this.getRptExpValue(schemeRow);
                break;
            }
            case "10": {
                amountInfos = this.getExcelValue(schemeRow);
                break;
            }
            case "3": 
            case "4": 
            case "2": {
                amountInfos = this.getTransOutAmountInfos(schemeRow);
                break;
            }
            case "12": {
                amountInfos = this.getBCMFormulaValue(schemeRow);
            }
        }
        if (amountInfos == null || amountInfos.isEmpty()) {
            return;
        }
        this.preCreateVoucherEntry(voucherHead, schemeRow, amountInfos, transOutSumInfo);
    }

    private List<AmountInfo> getBCMFormulaValue(DynamicObject schemeRow) {
        FinalProcessAssgrp finalProcessAssgrp;
        List<AmountInfo> amountInfoList = new LinkedList<AmountInfo>();
        String transDir = schemeRow.getString(Key_DataType).equals("13") ? "_IN" : "_OUT";
        String bcmFormula = schemeRow.getString(AutoTransConstant.Entry_AMT_FORMULA.key);
        if (StringUtils.isEmpty((CharSequence)bcmFormula)) {
            return amountInfoList;
        }
        Set assgrpIds = null;
        String rowId = schemeRow.getString(Key_RowId);
        if (TRANSFER_TYPE_TRANS_PL.equals(schemeRow.getString(Key_AssgrpType)) && (finalProcessAssgrp = this.row2assgrp.get(rowId)) != null) {
            assgrpIds = finalProcessAssgrp.getHgIds();
        }
        amountInfoList = this.splitAmountByRowAccountsAndAssgrps(this.row2bcmFormulaCalculateInfo.get(rowId + transDir), schemeRow, this.row2accountIds.get(rowId), assgrpIds);
        return amountInfoList;
    }

    private void preCreateExpTransInVoucherEntry(VoucherInfo voucherHead, DynamicObject schemeRow, BalanceInfo transInSumInfo) {
        String dataType;
        List<AmountInfo> amountInfos = null;
        switch (dataType = schemeRow.getString(Key_DataType)) {
            case "6": {
                amountInfos = this.getFormulaValue(schemeRow);
                break;
            }
            case "9": {
                amountInfos = this.getRptExpValue(schemeRow);
                break;
            }
            case "11": {
                amountInfos = this.getExcelValue(schemeRow);
                break;
            }
            case "13": {
                amountInfos = this.getBCMFormulaValue(schemeRow);
            }
        }
        if (amountInfos == null || amountInfos.isEmpty()) {
            return;
        }
        this.preCreateVoucherEntry(voucherHead, schemeRow, amountInfos, transInSumInfo);
    }

    private void preCreateTransInVoucherEntry(VoucherInfo voucherHead, DynamicObject schemeRow, BalanceInfo transOutSumInfo, BalanceInfo transInSumInfo) {
        String dataType;
        List<AmountInfo> amountInfos = null;
        switch (dataType = schemeRow.getString(Key_DataType)) {
            case "1": {
                amountInfos = this.getTransInAmountInfos(transOutSumInfo, schemeRow);
            }
        }
        if (amountInfos == null || amountInfos.isEmpty()) {
            return;
        }
        this.preCreateVoucherEntry(voucherHead, schemeRow, amountInfos, transInSumInfo);
    }

    private void preCreateRemainTransInVoucherEntry(VoucherInfo voucherHead, DynamicObject schemeRow, BalanceInfo transOutSumInfo, BalanceInfo transInSumInfo) {
        List<AmountInfo> amountInfos = null;
        String dataType = schemeRow.getString(Key_DataType);
        String rowId = schemeRow.getString(Key_RowId);
        switch (dataType) {
            case "7": {
                BigDecimal remainDebitAmount = transOutSumInfo.getDebitLocalSum().add(transInSumInfo.getDebitLocalSum());
                BigDecimal remainCreditAmount = transOutSumInfo.getCreditLocalSum().add(transInSumInfo.getCreditLocalSum());
                BigDecimal remainAmount = remainDebitAmount.subtract(remainCreditAmount);
                if (remainAmount.compareTo(BigDecimal.ZERO) == 0) break;
                Set assgrpIds = null;
                FinalProcessAssgrp finalProcessAssgrp = this.row2assgrp.get(rowId);
                if (finalProcessAssgrp != null) {
                    assgrpIds = finalProcessAssgrp.getHgIds();
                }
                amountInfos = this.splitAmountByRowAccountsAndAssgrps(remainAmount, schemeRow, this.row2accountIds.get(rowId), assgrpIds);
            }
        }
        if (amountInfos == null || amountInfos.isEmpty()) {
            return;
        }
        this.preCreateVoucherEntry(voucherHead, schemeRow, amountInfos, transInSumInfo);
    }

    private void preCreateVoucherEntry(VoucherInfo voucherHead, DynamicObject schemeRow, List<AmountInfo> amountInfos, BalanceInfo balanceInfo) {
        String desc;
        if (DebugTrace.enable()) {
            logger.info(String.format("amount trans at the row number %s :\n%s", schemeRow.getString(KEY_SEQ), AmountInfo.displayInfos(amountInfos)));
        }
        if (StringUtils.isBlank((CharSequence)(desc = schemeRow.getString("autodescription")))) {
            desc = this.schemeInfo.getEntryDefaultDesc();
        }
        for (AmountInfo amount : amountInfos) {
            this.handleAmountByScheme(schemeRow, amount);
            if (amount.getLocAmount().compareTo(BigDecimal.ZERO) == 0 && amount.getOriAmount().compareTo(BigDecimal.ZERO) == 0 && amount.getQty().compareTo(BigDecimal.ZERO) == 0) continue;
            AmountInfo usedAmount = this.createSingleVoucherEntry(voucherHead, desc, amount, schemeRow.getInt(KEY_SEQ));
            balanceInfo.update(usedAmount);
        }
    }

    private void handleAmountByScheme(DynamicObject schemeRow, AmountInfo amount) {
        String rowId = schemeRow.getString(Key_RowId);
        amount.setCrrencyId(Long.valueOf(schemeRow.getLong(Key_CurrencyId) == 0L ? amount.getCrrencyId().longValue() : schemeRow.getLong(Key_CurrencyId)));
        BigDecimal percent = Optional.ofNullable(this.row2percent.get(rowId)).orElse(BigDecimal.ZERO);
        int oriScale = schemeRow.getInt(Key_CurrencyScale);
        int locScale = this.schemeInfo.getBaseCurrencyDyn().getInt("amtprecision");
        Long measureUnitID = amount.getMeasureUnitID();
        int qtyScale = -1;
        if (measureUnitID != 0L) {
            qtyScale = BusinessDataServiceHelper.loadSingleFromCache((Object)amount.getMeasureUnitID(), (String)"bd_measureunits").getInt("precision");
        }
        amount.multiplyPercent(percent, locScale, oriScale, qtyScale);
        this.handleDcByScheme(schemeRow, amount);
    }

    private void handleDcByScheme(DynamicObject schemeRow, AmountInfo amount) {
        String dcType = schemeRow.getString(Key_DcType);
        boolean isAutoDc = StringUtils.isBlank((CharSequence)dcType) || "0".equals(dcType);
        String dataType = schemeRow.getString(Key_DataType);
        Long accountId = amount.getAccountId();
        String accountDc = Optional.ofNullable(this.accountId2dc.get(accountId)).orElseGet(() -> BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview").getBigDecimal(Key_DcType)).toString();
        String dc = isAutoDc ? "1" : dcType;
        BigDecimal oriAmount = amount.getOriAmount();
        BigDecimal locAmount = amount.getLocAmount();
        switch (dataType) {
            case "4": {
                if (!"-1".equals(dc)) break;
                locAmount = locAmount.negate();
                oriAmount = oriAmount.negate();
                break;
            }
            case "3": {
                if (isAutoDc) {
                    dc = "-1";
                }
                if (!"1".equals(dc)) break;
                locAmount = locAmount.negate();
                oriAmount = oriAmount.negate();
                amount.setQty(amount.getQty().negate());
                break;
            }
            case "2": {
                String autoDc;
                String string = autoDc = locAmount.compareTo(BigDecimal.ZERO) >= 0 ? "-1" : "1";
                if (locAmount.compareTo(BigDecimal.ZERO) < 0) {
                    locAmount = locAmount.negate();
                    oriAmount = oriAmount.negate();
                    amount.setQty(amount.getQty().negate());
                }
                if (isAutoDc) {
                    dc = autoDc;
                    break;
                }
                if (dc.equals(autoDc)) break;
                locAmount = locAmount.negate();
                oriAmount = oriAmount.negate();
                amount.setQty(amount.getQty().negate());
                break;
            }
            case "5": 
            case "8": 
            case "10": 
            case "12": {
                if (isAutoDc && "1".equals(accountDc)) {
                    dc = "-1";
                }
                if (!dc.equals(accountDc)) break;
                locAmount = locAmount.negate();
                oriAmount = oriAmount.negate();
                break;
            }
            case "11": 
            case "9": 
            case "6": 
            case "13": {
                if (isAutoDc) {
                    dc = accountDc;
                }
                if (dc.equals(accountDc)) break;
                locAmount = locAmount.negate();
                oriAmount = oriAmount.negate();
                break;
            }
            case "1": {
                if (isAutoDc) {
                    dc = accountDc;
                }
                if (!"1".equals(dc)) break;
                locAmount = locAmount.negate();
                oriAmount = oriAmount.negate();
                break;
            }
            case "7": {
                if (isAutoDc) {
                    if (locAmount.compareTo(BigDecimal.ZERO) >= 0) {
                        dc = "-1";
                    }
                    locAmount = locAmount.abs();
                    oriAmount = oriAmount.abs();
                    break;
                }
                if (!"1".equals(dc)) break;
                locAmount = locAmount.negate();
                oriAmount = oriAmount.negate();
            }
        }
        amount.setLocAmount(locAmount);
        amount.setOriAmount(oriAmount);
        if (amount.getRate() == null) {
            BigDecimal rate = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(oriAmount) != 0) {
                long currencyId = schemeRow.getLong(Key_CurrencyId) == 0L ? amount.getCrrencyId().longValue() : schemeRow.getLong(Key_CurrencyId);
                rate = this.calRate(oriAmount, locAmount, currencyId);
            }
            amount.setRate(rate.abs());
        }
        amount.setDc(dc);
    }

    private AmountInfo createSingleVoucherEntry(VoucherInfo voucherHead, String desc, AmountInfo amount, int templateSeq) {
        int qtyScale;
        VoucherEntryInfo voucherEntry = voucherHead.createNewEntry();
        voucherEntry.setDesc(desc);
        voucherEntry.setAccount(amount.getAccountId());
        voucherEntry.setAssgrp(amount.getAssgrpId());
        voucherEntry.setCurency(amount.getCrrencyId());
        voucherEntry.setLocRate(amount.getRate());
        voucherEntry.setUnit(amount.getMeasureUnitID());
        Map comAssistIdMap = amount.getComAssistIdMap();
        for (Map.Entry comAssistIdEntry : comAssistIdMap.entrySet()) {
            voucherEntry.setComAssist(((Integer)comAssistIdEntry.getKey()).intValue(), (Long)comAssistIdEntry.getValue());
        }
        DynamicObject currencyDyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter("id", "=", (Object)amount.getCrrencyId()).toArray());
        DynamicObject unitDyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_measureunits", (QFilter[])new QFilter("id", "=", (Object)amount.getMeasureUnitID()).toArray());
        int priceScale = currencyDyo == null ? 4 : currencyDyo.getInt(CurrencyConstant.Entity_Price_Scale.key);
        int n = qtyScale = unitDyo == null ? 4 : unitDyo.getInt(MeasureUnitConstant.Entity_QTY_Scale.key);
        if (amount.getPrice().compareTo(BigDecimal.ZERO) == 0 && amount.getQty().compareTo(BigDecimal.ZERO) != 0) {
            voucherEntry.setPrice(amount.getOriAmount().divide(amount.getQty(), priceScale, 4));
        } else {
            voucherEntry.setPrice(amount.getPrice());
        }
        voucherEntry.setPrice(voucherEntry.getPrice().abs());
        if (amount.getQty().compareTo(BigDecimal.ZERO) == 0 && amount.getPrice().compareTo(BigDecimal.ZERO) != 0) {
            voucherEntry.setQty(amount.getOriAmount().divide(amount.getPrice(), qtyScale, 4));
        } else {
            voucherEntry.setQty(amount.getQty());
        }
        voucherEntry.setTemplateSeq(templateSeq);
        String dc = amount.getDc();
        voucherEntry.setEntryDC(dc);
        if ("1".equals(dc)) {
            voucherEntry.setLocAmt(amount.getLocAmount(), BigDecimal.ZERO);
            voucherEntry.setOriAmt(amount.getOriAmount(), BigDecimal.ZERO);
        } else {
            voucherEntry.setLocAmt(BigDecimal.ZERO, amount.getLocAmount());
            voucherEntry.setOriAmt(BigDecimal.ZERO, amount.getOriAmount());
        }
        if (voucherHead.getEntries().size() >= PRE_SAVE_THRESHOLD && !this.isMerge()) {
            logger.info("[gl_autotrans]: entries exceed threshold, execute presave.");
            voucherHead.appendSave();
        }
        return amount;
    }

    private List<AmountInfo> getTransInAmountInfos(BalanceInfo transOutSumInfo, DynamicObject schemeRow) {
        String rowId = schemeRow.getString(Key_RowId);
        String assgrpType = schemeRow.getString(Key_AssgrpType);
        boolean isLeafTrans = this.schemeInfo.isLeafToLeaf() && this.sameNumberInRow != null && this.sameNumberInRow.contains(rowId);
        Set<Long> accountIds = this.row2accountIds.get(rowId);
        if (accountIds == null || accountIds.isEmpty()) {
            return null;
        }
        HashMap<Long, Long> account2MeasureunitGroup = new HashMap(accountIds.size());
        if (!CollectionUtils.isEmpty((Map)transOutSumInfo.getAccount2assgrp2measureunit2balance())) {
            ArrayList<Long> accts = new ArrayList<Long>(accountIds.size());
            accts.addAll(accountIds);
            transOutSumInfo.getAccount2assgrp2measureunit2balance().keySet().forEach(e -> accts.add((Long)e));
            account2MeasureunitGroup = this.getAccount2MeasureunitGroup(accts);
        }
        List<AmountInfo> amountInfos = new ArrayList<AmountInfo>(accountIds.size());
        if (isLeafTrans) {
            if ("1".equals(assgrpType)) {
                Map account2assgrp2measureunit2balance = transOutSumInfo.getAccount2assgrp2measureunit2balance();
                if (!CollectionUtils.isEmpty((Map)account2assgrp2measureunit2balance)) {
                    for (Long accountId : accountIds) {
                        Set<Long> sameNumberOutAccounts = this.accountId2opAccountIds.get(accountId);
                        for (Long opAccountId : sameNumberOutAccounts) {
                            Map assgrp2measureunit2balance = (Map)account2assgrp2measureunit2balance.get(opAccountId);
                            if (CollectionUtils.isEmpty((Map)assgrp2measureunit2balance)) continue;
                            for (Map.Entry assgrp2measureunit2Amount : assgrp2measureunit2balance.entrySet()) {
                                Long assgrpId = (Long)assgrp2measureunit2Amount.getKey();
                                Map measureunit2balance = (Map)assgrp2measureunit2Amount.getValue();
                                HashMap<Long, Set<Long>> accountId2assgrpIds = new HashMap<Long, Set<Long>>(accountIds.size());
                                if (CollectionUtils.isEmpty((Map)measureunit2balance)) continue;
                                for (Map.Entry measureunit2locAmount : measureunit2balance.entrySet()) {
                                    BigDecimal amount = (BigDecimal)((Tuple)measureunit2locAmount.getValue()).item1;
                                    BigDecimal qty = (BigDecimal)((Tuple)measureunit2locAmount.getValue()).item2;
                                    if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
                                    accountId2assgrpIds.clear();
                                    Set<Long> assgrpIds = this.getAutoAssgrpTransInAssgrpIds(accountId, assgrpId, rowId);
                                    accountId2assgrpIds.put(accountId, assgrpIds);
                                    List<AmountInfo> tempAmountInfos = this.splitAmountByRowAccountsAndAssgrps(amount, schemeRow, accountId2assgrpIds, (Long)measureunit2locAmount.getKey(), qty, account2MeasureunitGroup, opAccountId);
                                    if (tempAmountInfos == null) continue;
                                    amountInfos.addAll(tempAmountInfos);
                                }
                            }
                        }
                    }
                }
            } else {
                HashSet<Long> tempAccouts = new HashSet<Long>(1);
                for (Long accountId : accountIds) {
                    List<AmountInfo> tempAmountInfos;
                    tempAccouts.clear();
                    tempAccouts.add(accountId);
                    Set<Long> sameNumberOutAccounts = this.accountId2opAccountIds.get(accountId);
                    BigDecimal accountIdsAmount = transOutSumInfo.getLocBalanceByAccountIds(sameNumberOutAccounts);
                    if (accountIdsAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    Set assgrpIds = null;
                    FinalProcessAssgrp finalProcessAssgrp = this.row2assgrp.get(rowId);
                    if (finalProcessAssgrp != null) {
                        assgrpIds = finalProcessAssgrp.getHgIds();
                    }
                    if ((tempAmountInfos = this.splitAmountByRowAccountsAndAssgrps(accountIdsAmount, schemeRow, tempAccouts, assgrpIds)) == null) continue;
                    amountInfos.addAll(tempAmountInfos);
                }
            }
        } else if ("1".equals(assgrpType)) {
            Map account2assgrp2measureunit2balance = transOutSumInfo.getAccount2assgrp2measureunit2balance();
            if (DebugTrace.enable()) {
                logger.info("account2assgrp2measureunit2balance : " + account2assgrp2measureunit2balance);
            }
            if (!CollectionUtils.isEmpty((Map)account2assgrp2measureunit2balance)) {
                for (Map.Entry account2assgrp2measureunit2Amount : account2assgrp2measureunit2balance.entrySet()) {
                    Long transOutAccountId = (Long)account2assgrp2measureunit2Amount.getKey();
                    Map assgrp2measureunit2balance = (Map)account2assgrp2measureunit2Amount.getValue();
                    if (CollectionUtils.isEmpty((Map)assgrp2measureunit2balance)) continue;
                    HashMap<Long, Set<Long>> accountId2assgrpIds = new HashMap<Long, Set<Long>>(accountIds.size());
                    for (Map.Entry assgrp2measureunit2Amount : assgrp2measureunit2balance.entrySet()) {
                        Long assgrpId = (Long)assgrp2measureunit2Amount.getKey();
                        Map measureunit2balance = (Map)assgrp2measureunit2Amount.getValue();
                        for (Map.Entry measureunit2locAmount : measureunit2balance.entrySet()) {
                            BigDecimal amount = (BigDecimal)((Tuple)measureunit2locAmount.getValue()).item1;
                            BigDecimal qty = (BigDecimal)((Tuple)measureunit2locAmount.getValue()).item2;
                            if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
                            for (Long accountId : accountIds) {
                                Set<Long> assgrpIds = this.getAutoAssgrpTransInAssgrpIds(accountId, assgrpId, rowId);
                                accountId2assgrpIds.put(accountId, assgrpIds);
                            }
                            List<AmountInfo> tempAmountInfos = this.splitAmountByRowAccountsAndAssgrps(amount, schemeRow, accountId2assgrpIds, (Long)measureunit2locAmount.getKey(), qty, account2MeasureunitGroup, transOutAccountId);
                            if (tempAmountInfos == null) continue;
                            amountInfos.addAll(tempAmountInfos);
                        }
                    }
                }
            }
        } else {
            BigDecimal endLocalSum = transOutSumInfo.getEndLocalSum();
            if (endLocalSum.compareTo(BigDecimal.ZERO) != 0) {
                Set assgrpIds = null;
                FinalProcessAssgrp finalProcessAssgrp = this.row2assgrp.get(rowId);
                if (finalProcessAssgrp != null) {
                    assgrpIds = finalProcessAssgrp.getHgIds();
                }
                amountInfos = this.splitAmountByRowAccountsAndAssgrps(endLocalSum, schemeRow, accountIds, assgrpIds);
            }
        }
        return amountInfos;
    }

    private Set<Long> getAutoAssgrpTransInAssgrpIds(Long accountId, Long assgrpId, String rowId) {
        MainEntityType mainEntity = new MainEntityType();
        mainEntity.setAlias("T_GL_ASSIST");
        mainEntity.setDBRouteKey("gl");
        HashSet<Long> result = new HashSet<Long>();
        Set<String> inAccFlexField = this.accountId2flexs.get(accountId);
        FlexEntireData outFlexEntireData = this.transOutAssgrp2FlexEntries.get(assgrpId);
        if (inAccFlexField != null) {
            List<List<FlexEntireData.FlexData>> extAssgrpFlexData;
            HashSet<String> inAccDiffOutSetFlex = new HashSet<String>(inAccFlexField);
            FinalProcessAssgrp inFinalProcessAssgrp = this.row2assgrp.get(rowId);
            ArrayList<FlexEntireData.FlexData> newFlexDatas = new ArrayList<FlexEntireData.FlexData>();
            if (outFlexEntireData != null) {
                String propId;
                if (inFinalProcessAssgrp != null) {
                    Map flex2valuesTransInRow = inFinalProcessAssgrp.getFlex2values();
                    for (FlexEntireData.FlexData flexData : outFlexEntireData.getFlexDatas()) {
                        propId = flexData.getPropId();
                        FinalProcessAssgrp.AssgrpValues values = (FinalProcessAssgrp.AssgrpValues)flex2valuesTransInRow.get(propId);
                        if ((values == null || !values.getValues().isEmpty()) && (values != null || !inAccFlexField.contains(propId)) || !inAccDiffOutSetFlex.remove(propId)) continue;
                        newFlexDatas.add(flexData);
                    }
                } else {
                    HashSet<String> inAccountFlexs = new HashSet<String>(inAccFlexField);
                    for (FlexEntireData.FlexData flexData : outFlexEntireData.getFlexDatas()) {
                        propId = flexData.getPropId();
                        if (!inAccountFlexs.remove(propId)) continue;
                        newFlexDatas.add(flexData);
                    }
                }
            } else {
                outFlexEntireData = new FlexEntireData();
            }
            if ((extAssgrpFlexData = this.buildExtAssgrp(outFlexEntireData, inFinalProcessAssgrp, inAccDiffOutSetFlex)) == null || extAssgrpFlexData.isEmpty()) {
                FlexEntireData newEntireData = new FlexEntireData();
                newEntireData.setFlexDatas(newFlexDatas);
                long l = (Long)ThreadCache.get((Object)ThreadCacheKey.buildAssgrpIdKey((String)newEntireData.getFlexValue().toString()), () -> FlexService.saveFlexData((MainEntityType)mainEntity, (FlexEntireData)newEntireData));
                result.add(l);
            } else {
                for (List list : extAssgrpFlexData) {
                    FlexEntireData newEntireData = new FlexEntireData();
                    list.addAll(newFlexDatas);
                    newEntireData.setFlexDatas(list);
                    long hgId = (Long)ThreadCache.get((Object)ThreadCacheKey.buildAssgrpIdKey((String)newEntireData.getFlexValue().toString()), () -> FlexService.saveFlexData((MainEntityType)mainEntity, (FlexEntireData)newEntireData));
                    result.add(hgId);
                }
            }
        }
        return result;
    }

    private Map<String, Set<Long>> getRowIdAndLeafActMap(Long orgId, DynamicObjectCollection autoTransParamEntry) {
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>();
        HashMap<String, HashSet<Long>> inAccountMap = new HashMap<String, HashSet<Long>>();
        HashMap<String, HashSet<Long>> outAccoutMap = new HashMap<String, HashSet<Long>>();
        boolean isInAccountsAllParent = true;
        HashSet<Long> newLeafAcc = new HashSet<Long>(autoTransParamEntry.size());
        block4: for (Object entryRow : autoTransParamEntry) {
            String string = entryRow.getString(Key_RowId);
            DynamicObject account = this.getAccountOnCurPeriod((DynamicObject)entryRow);
            long accoutId = account.getLong("id");
            boolean isleaf = account.getBoolean("isleaf");
            String number = account.getString("number");
            HashSet<Long> leafAccounts = new HashSet<Long>();
            if (isleaf) {
                leafAccounts.add(accoutId);
                this.accountId2number.put(accoutId, number);
                this.accountId2dc.put(accoutId, account.getBigDecimal(Key_DcType));
                DynamicObjectCollection entries = account.getDynamicObjectCollection("checkitementry");
                Set flexIds = entries.stream().map(x -> x.getLong("asstactitem_id")).collect(Collectors.toSet());
                Map flexDyns = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)"flexfield", (QFilter[])new QFilter("id", "in", flexIds).toArray());
                Set flexs = flexDyns.values().stream().map(x -> x.getString("flexfield")).collect(Collectors.toSet());
                this.accountId2flexs.put(accoutId, flexs);
                this.accountId2Dyn.put(accoutId, account);
            } else {
                HashSet<String> parentAccounts = new HashSet<String>();
                parentAccounts.add(number);
                this.getLeafAccountIds(parentAccounts, leafAccounts, orgId, this.schemeInfo.getAccountTableId());
                newLeafAcc.addAll(leafAccounts);
            }
            int datasourcetype = entryRow.getInt(Key_DataType);
            switch (datasourcetype) {
                case 2: 
                case 3: 
                case 4: {
                    outAccoutMap.put(string, leafAccounts);
                    continue block4;
                }
                case 1: {
                    if (!isleaf) {
                        inAccountMap.put(string, leafAccounts);
                        continue block4;
                    }
                    isInAccountsAllParent = false;
                    resultMap.put(string, leafAccounts);
                    continue block4;
                }
            }
            resultMap.put(string, leafAccounts);
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty(newLeafAcc)) {
            BusinessDataServiceHelper.loadFromCache((Object[])newLeafAcc.toArray(), (String)"bd_accountview").forEach((o, dynamicObject) -> this.accountId2Dyn.put(dynamicObject.getLong("id"), (DynamicObject)dynamicObject));
        }
        if (this.schemeInfo.isLeafToLeaf() && !outAccoutMap.isEmpty() && !inAccountMap.isEmpty()) {
            int topIndex = this.getAccountTopIndex();
            for (Map.Entry entry : outAccoutMap.entrySet()) {
                Set outAccounts = (Set)entry.getValue();
                HashSet<Long> newOutAccounts = new HashSet<Long>(outAccounts.size());
                for (Map.Entry inEntry : inAccountMap.entrySet()) {
                    HashSet inAccounts = new HashSet((Collection)inEntry.getValue());
                    block7: for (Long outAccount : outAccounts) {
                        Iterator iterator = inAccounts.iterator();
                        while (iterator.hasNext()) {
                            Long inAccount = (Long)iterator.next();
                            if (!this.compareAccountNumberAndWriteRelationMap(topIndex, outAccount, inAccount)) continue;
                            newOutAccounts.add(outAccount);
                            iterator.remove();
                            continue block7;
                        }
                    }
                }
                if (!newOutAccounts.isEmpty()) {
                    resultMap.put((String)entry.getKey(), (Set<Long>)newOutAccounts);
                }
                if (isInAccountsAllParent) continue;
                resultMap.put((String)entry.getKey(), outAccounts);
            }
            Set<Long> allInAccounts = this.accountId2opAccountIds.keySet();
            if (!allInAccounts.isEmpty()) {
                if (this.sameNumberInRow == null) {
                    this.sameNumberInRow = new HashSet<String>(inAccountMap.size());
                }
                Iterator iterator = inAccountMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry inEntry = iterator.next();
                    Set inAccounts = (Set)inEntry.getValue();
                    inAccounts.retainAll(allInAccounts);
                    if (!inAccounts.isEmpty()) continue;
                    iterator.remove();
                }
                this.sameNumberInRow.addAll(inAccountMap.keySet());
                resultMap.putAll(inAccountMap);
            }
        } else {
            resultMap.putAll(outAccoutMap);
            resultMap.putAll(inAccountMap);
        }
        return resultMap;
    }

    private DynamicObject getAccountOnCurPeriod(DynamicObject entryRow) {
        long orgID = this.schemeInfo.getAccountBookInfo().getOrgId();
        long bookTypeID = this.schemeInfo.getAccountBookInfo().getBookTypeId();
        Long accountID = entryRow.getLong(AutoTransConstant.Entity_Account.toIDString());
        if (this.autoTransScheme.getSelfBaseDatas("bd_accountview", new Long[]{accountID}).isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5df2\u6ca1\u6709\u79d1\u76ee%s\u7684\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u65b9\u6848\u3002", (String)"AutoTransGenVchOperateService_6", (String)"fi-gl-opplugin", (Object[])new Object[0]), entryRow.getString(AutoTransConstant.Entity_Account.toNumberString())));
        }
        DynamicObject accountDyo = BusinessDataServiceHelper.loadSingle((Object)accountID, (String)"bd_accountview");
        String accountNumber = accountDyo.getString("number");
        DynamicObject periodDyo = this.schemeInfo.getCurPeroid();
        try {
            return AccountRefUtils.getCurVersionAccount((AccountVersionReplaceParam)new AccountVersionReplaceParam(orgID, accountDyo.getLong("masterid"), 0L, 0L, accountNumber, periodDyo, bookTypeID, accountDyo, 0L));
        }
        catch (KDBizException e) {
            if (!e.getErrorCode().getCode().equals("acct")) {
                throw e;
            }
            String msg = e.getMessage();
            this.toOperateErrorInfo(this.schemeInfo.getDataEntity(), String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55 %2$s \u79d1\u76ee%3$s\u3002", (String)"AutoTranGenVchOperateService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), entryRow.get(KEY_SEQ), accountNumber, msg));
            return accountDyo;
        }
    }

    private int getAccountTopIndex() {
        String accountlevel;
        long accountTableId = this.schemeInfo.getAccountTableId();
        int topIndex = 0;
        DynamicObject accountTableDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accounttable", (String)"accountlevel", (QFilter[])new QFilter("id", "=", (Object)accountTableId).toArray());
        if (accountTableDyn != null && (accountlevel = accountTableDyn.getString("accountlevel")) != null) {
            String topIndexStr = accountlevel.split("-")[0];
            topIndex = Integer.parseInt(topIndexStr);
        }
        return topIndex;
    }

    private boolean compareAccountNumberAndWriteRelationMap(int topIndex, Long outAccount, Long inAccount) {
        String inLeafNumber;
        String outLeafNumber;
        String outNumber = this.accountId2number.get(outAccount);
        String inNumber = this.accountId2number.get(inAccount);
        if (StringUtils.isNotBlank((CharSequence)outNumber) && StringUtils.isNotBlank((Object)inAccount) && (outLeafNumber = outNumber.substring(topIndex)).equalsIgnoreCase(inLeafNumber = inNumber.substring(topIndex))) {
            if (this.accountId2opAccountIds.get(inAccount) == null) {
                HashSet<Long> outAccounts = new HashSet<Long>();
                outAccounts.add(outAccount);
                this.accountId2opAccountIds.put(inAccount, outAccounts);
            } else {
                this.accountId2opAccountIds.get(inAccount).add(outAccount);
            }
            return true;
        }
        return false;
    }

    private void getLeafAccountIds(Set<String> parentNumbers, Set<Long> leafs, Long orgId, Long accountTableId) {
        QFilter parentFilter = new QFilter("parent.number", "in", parentNumbers);
        if (TRANSFER_TYPE_TRANS_PL.equals(this.schemeInfo.getDataEntity().getString("transfertype"))) {
            parentFilter.and(QFilter.of((String)"(accounttype.accounttype=? and ischangecurrency='0') or accounttype.accounttype=?", (Object[])new Object[]{TRANSFER_TYPE_TRANS_PL, "4"}));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(parentFilter);
        filters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObject periodDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)this.autoTransScheme.getCurPeriodId()).toArray());
        if (null == periodDO) {
            filters.add(new QFilter("enddate", "=", (Object)GLUtil.getEndDate()));
        } else {
            filters.add(new QFilter("startdate", "<=", (Object)periodDO.getDate("enddate")));
            filters.add(new QFilter("enddate", ">", (Object)periodDO.getDate("enddate")));
        }
        try (DataSet ds = AccountUtils.queryAccountDataSet((long)orgId, (long)accountTableId, (String)"id,isleaf,number,dc,checkitementry.asstactitem.flexfield flexfield", filters);){
            parentNumbers.clear();
            for (Row row : ds) {
                long id = row.getLong("id");
                String number = row.getString("number");
                if (row.getBoolean("isleaf").booleanValue()) {
                    leafs.add(id);
                    this.accountId2number.put(id, number);
                    this.accountId2dc.put(id, row.getBigDecimal(Key_DcType));
                    this.accountId2flexs.compute(id, (k, v) -> {
                        if (v == null) {
                            v = new HashSet<String>();
                        }
                        v.add(row.getString("flexfield"));
                        return v;
                    });
                    continue;
                }
                parentNumbers.add(number);
            }
            if (parentNumbers.size() > 0) {
                this.getLeafAccountIds(parentNumbers, leafs, orgId, accountTableId);
            }
        }
    }

    private void combineVchEntry(VoucherInfo voucherHead) {
        if (voucherHead.isBigEntryMode()) {
            return;
        }
        VoucherEntryCollection entrys = voucherHead.getEntries();
        LinkedHashMap<String, VoucherEntryInfo> map = new LinkedHashMap<String, VoucherEntryInfo>();
        for (VoucherEntryInfo entry : entrys) {
            String entryDC;
            String key = entry.getAccount() + "-" + entry.getAssgrp() + "-" + entry.getCurency() + "-" + entry.getUnit() + "-" + entry.getDesc() + "-" + entry.getEntryDC();
            StringBuilder addComAssistKey = new StringBuilder(key);
            for (int index = 0; index < this.schemeInfo.getComAssistCount(); ++index) {
                addComAssistKey.append("-").append(entry.getComAssist(index + 1));
            }
            key = addComAssistKey.toString();
            VoucherEntryInfo tmEntryInfo = (VoucherEntryInfo)map.get(key);
            if (tmEntryInfo == null) {
                map.put(key, entry);
                continue;
            }
            BigDecimal debitLocal = tmEntryInfo.getDebLoc();
            BigDecimal debitFor = tmEntryInfo.getDebOri();
            BigDecimal creditLocal = tmEntryInfo.getCreLoc();
            BigDecimal creditFor = tmEntryInfo.getCreOri();
            BigDecimal qty = tmEntryInfo.getQty();
            tmEntryInfo.setDebLoc(debitLocal.add(entry.getDebLoc()));
            tmEntryInfo.setDebOri(debitFor.add(entry.getDebOri()));
            tmEntryInfo.setCreLoc(creditLocal.add(entry.getCreLoc()));
            tmEntryInfo.setCreOri(creditFor.add(entry.getCreOri()));
            tmEntryInfo.setQty(qty.add(entry.getQty()));
            if (tmEntryInfo.getQty().compareTo(BigDecimal.ZERO) != 0) {
                tmEntryInfo.setPrice(tmEntryInfo.getOriAmt().divide(tmEntryInfo.getQty(), entry.getPrice().scale(), RoundingMode.HALF_UP));
            }
            tmEntryInfo.setLocRate("-1".equals(entryDC = tmEntryInfo.getEntryDC()) ? this.calRate(tmEntryInfo.getCreOri(), tmEntryInfo.getCreLoc(), tmEntryInfo.getCurency()) : this.calRate(tmEntryInfo.getDebOri(), tmEntryInfo.getDebLoc(), tmEntryInfo.getCurency()));
        }
        entrys.clear();
        int seq = 1;
        for (VoucherEntryInfo entry : map.values()) {
            if (BigDecimal.ZERO.compareTo(entry.getCreLoc()) == 0 && BigDecimal.ZERO.compareTo(entry.getDebLoc()) == 0 && BigDecimal.ZERO.compareTo(entry.getQty()) == 0 && BigDecimal.ZERO.compareTo(entry.getCreOri()) == 0 && BigDecimal.ZERO.compareTo(entry.getDebOri()) == 0) continue;
            entry.setSeq(seq);
            entrys.add(entry);
            ++seq;
        }
    }

    private List<AmountInfo> getFormulaValue(DynamicObject schemeRow) {
        DataSet balanceSet;
        ArrayList<Long> accts;
        Long[] longArray;
        long periodId;
        String rowId = schemeRow.getString(Key_RowId);
        AutoTransDataFormula rowFormula = this.row2formula.get(rowId);
        if (rowFormula == null) {
            return null;
        }
        ArrayList<AmountInfo> amountInfos = new ArrayList<AmountInfo>(10);
        long orgId = this.schemeInfo.getOrgId();
        long bookTypeId = this.schemeInfo.getAccountBookInfo().getBookTypeId();
        long accountTableId = this.schemeInfo.getAccountTableId();
        long startPeriodId = periodId = this.schemeInfo.getCurPeriodId().longValue();
        long endPeriodId = periodId;
        if (TRANSFER_TYPE_TRANS_PL.equals(rowFormula.getPeriodRange()) || "3".equals(rowFormula.getPeriodRange()) || "4".equals(rowFormula.getPeriodRange())) {
            DynamicObject curPeriodDyo = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
            QFilter periodType = new QFilter("periodtype", "=", (Object)curPeriodDyo.getLong(GLField.id_((String)"periodtype")));
            QFilter periodYear = new QFilter("periodyear", "=", (Object)curPeriodDyo.getLong("periodyear"));
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(periodType);
            qFilters.add(periodYear);
            if (TRANSFER_TYPE_TRANS_PL.equals(rowFormula.getPeriodRange())) {
                QFilter periodQuarter = new QFilter("periodquarter", "=", (Object)curPeriodDyo.getLong("periodquarter"));
                qFilters.add(periodQuarter);
            } else if ("3".equals(rowFormula.getPeriodRange())) {
                Integer[] periodQuarters = null;
                periodQuarters = curPeriodDyo.getInt("periodquarter") > 2 ? new Integer[]{3, 4} : new Integer[]{1, 2};
                QFilter periodQuarter = new QFilter("periodquarter", "in", (Object)periodQuarters);
                qFilters.add(periodQuarter);
            }
            DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"begindate asc");
            if (!CollectionUtils.isEmpty((Collection)periods)) {
                startPeriodId = ((DynamicObject)periods.get(0)).getLong("id");
                endPeriodId = ((DynamicObject)periods.get(periods.size() - 1)).getLong("id");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.setAccountFilter(new QFilter("id", "=", (Object)rowFormula.getAccountId()));
        if (rowFormula.getCurrencyId() == 0L) {
            longArray = null;
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = rowFormula.getCurrencyId();
        }
        queryParam.setCurrencyIds(longArray);
        long unitId = rowFormula.getUnitId();
        if (GLUtil.isPkValNotNull((Object)unitId)) {
            queryParam.setMeasureUnitIds(new Long[]{unitId});
        }
        queryParam.setOnlyLeafAcctBal(true);
        String locAmountKey = rowFormula.getLocAmountKey();
        String oriAmountKey = rowFormula.getOriAmountKey();
        Map<Integer, Set<Long>> comAssistIdsMap = rowFormula.getComAssistIdsMap();
        List customFilter = queryParam.getCustomFilter() != null ? queryParam.getCustomFilter() : new ArrayList(8);
        for (Map.Entry<Integer, Set<Long>> comAssistIdsEntry : comAssistIdsMap.entrySet()) {
            Set<Long> comAssistIdSet = comAssistIdsEntry.getValue();
            if (!kd.bos.util.CollectionUtils.isNotEmpty(comAssistIdSet)) continue;
            customFilter.add(new QFilter(CommonAssistUtil.getComassistField((int)comAssistIdsEntry.getKey()), "in", comAssistIdSet));
        }
        queryParam.setCustomFilter(customFilter);
        HashMap<Long, List<Tuple<String, String>>> acct2assts = new HashMap<Long, List<Tuple<String, String>>>();
        if ("1".equals(schemeRow.getString(Key_AssgrpType))) {
            accts = new ArrayList<Long>();
            accts.addAll((Collection)this.row2accountIds.get(rowId));
            accts.add(rowFormula.getAccountId());
            DynamicObjectCollection collection = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id, isassist", (QFilter[])new QFilter[]{new QFilter("id", "in", accts)}, null);
            for (DynamicObject dyn : collection) {
                if (dyn.getBoolean("isassist")) {
                    accts.add(dyn.getLong("id"));
                    continue;
                }
                accts.remove(dyn.getLong("id"));
            }
            DataSet assTypeDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_asstacttype", (String)"id assid, flexfield, valuetype", null, null);
            DataSet acct2asstsDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id, checkitementry.asstactitem asstactitem", (QFilter[])new QFilter[]{new QFilter("id", "in", accts)}, null);
            acct2asstsDs = acct2asstsDs.join(assTypeDs, JoinType.LEFT).on("asstactitem", "assid").select(new String[]{"id", "flexfield", "valuetype"}).finish();
            for (Row row : acct2asstsDs) {
                Tuple tuple = new Tuple((Object)row.getString("flexfield"), (Object)row.getString("valuetype"));
                if (acct2assts.containsKey(row.getLong("id"))) {
                    ((List)acct2assts.get(row.getLong("id"))).add(tuple);
                    continue;
                }
                ArrayList<Tuple> list = new ArrayList<Tuple>(5);
                list.add(tuple);
                acct2assts.put(row.getLong("id"), list);
            }
        }
        accts = new ArrayList(this.row2accountIds.get(rowId).size());
        accts.addAll((Collection)this.row2accountIds.get(rowId));
        accts.add(rowFormula.getAccountId());
        Map<Long, Long> account2MeasureunitGroup = this.getAccount2MeasureunitGroup(accts);
        DataSet hgIdSet = rowFormula.getHgIdSet();
        String finalSelector = locAmountKey + ", " + oriAmountKey + ", assgrp,endqty,measureunit,currency";
        if (hgIdSet == null) {
            balanceSet = BalanceQueryExecutor.getInstance().getBalance(finalSelector, new Long[]{orgId}, bookTypeId, accountTableId, startPeriodId, endPeriodId, queryParam);
        } else {
            long tempStart = startPeriodId;
            long tempEnd = endPeriodId;
            balanceSet = DataSetHelper.partitionBuild((DataSet)hgIdSet, (String)"hg", (int)1999, batchHgIds -> {
                queryParam.setAssGrpIds(new HashSet(batchHgIds));
                return BalanceQueryExecutor.getInstance().getBalance(finalSelector, new Long[]{orgId}, bookTypeId, accountTableId, tempStart, tempEnd, queryParam);
            });
        }
        boolean isCustomAssgrp = TRANSFER_TYPE_TRANS_PL.equals(schemeRow.getString(Key_AssgrpType));
        ArrayList<String> groupByList = new ArrayList<String>();
        if (!isCustomAssgrp) {
            groupByList.add("assgrp");
        }
        groupByList.add("currency");
        groupByList.add("measureunit");
        balanceSet = balanceSet.groupBy(groupByList.toArray(new String[0])).sum(locAmountKey).sum(oriAmountKey).sum("endqty").finish();
        while (balanceSet.hasNext()) {
            FinalProcessAssgrp finalProcessAssgrp;
            Row row = balanceSet.next();
            Set assgrpIds = null;
            if (isCustomAssgrp && (finalProcessAssgrp = this.row2assgrp.get(rowId)) != null) {
                assgrpIds = finalProcessAssgrp.getHgIds();
            }
            String accountDCInFormula = BusinessDataServiceHelper.loadSingleFromCache((Object)rowFormula.getAccountId(), (String)"bd_accountview").getString(Key_DcType);
            BigDecimal locAmount = rowFormula.getLocAmountKey().startsWith("end") ? row.getBigDecimal(locAmountKey).multiply(new BigDecimal(accountDCInFormula)) : row.getBigDecimal(locAmountKey);
            BigDecimal oriAmount = rowFormula.getOriAmountKey().startsWith("end") ? row.getBigDecimal(oriAmountKey).multiply(new BigDecimal(accountDCInFormula)) : row.getBigDecimal(oriAmountKey);
            BigDecimal endQty = row.getBigDecimal("endqty").multiply(new BigDecimal(accountDCInFormula));
            long balanceAssgrpId = isCustomAssgrp ? 0L : row.getLong("assgrp");
            AmountInfo amountInfo = new AmountInfo();
            amountInfo.setLocAmount(locAmount);
            amountInfo.setOriAmount(oriAmount);
            amountInfo.setMeasureUnitID(row.getLong("measureunit"));
            amountInfo.setQty(endQty);
            amountInfo.setCrrencyId(row.getLong("currency"));
            amountInfos.addAll((Collection<AmountInfo>)Objects.requireNonNull(this.splitLocAndOriAmount(schemeRow, amountInfo, assgrpIds, acct2assts, balanceAssgrpId, rowFormula.getAccountId(), account2MeasureunitGroup)));
        }
        return amountInfos;
    }

    private List<AmountInfo> splitLocAndOriAmount(DynamicObject schemeRow, AmountInfo splitInfo, Set<Long> assgrpIds, Map<Long, List<Tuple<String, String>>> acct2assts, Long assgrp, Long fromAccountId, Map<Long, Long> account2MeasureUnitGroup) {
        int oriScale;
        Set<Long> accountIds = this.row2accountIds.get(schemeRow.getString(Key_RowId));
        if (accountIds == null || accountIds.isEmpty()) {
            return null;
        }
        if (assgrpIds == null) {
            assgrpIds = new HashSet<Long>(1);
        }
        if (assgrpIds.isEmpty()) {
            assgrpIds.add(assgrp);
        }
        int splitSize = accountIds.size() * assgrpIds.size();
        List<List<Object>> comAssistCombination = this.getComAssistCombination(schemeRow);
        if (kd.bos.util.CollectionUtils.isNotEmpty(comAssistCombination)) {
            splitSize *= comAssistCombination.size();
        }
        ArrayList<AmountInfo> amountInfos = new ArrayList<AmountInfo>(splitSize);
        DynamicEntryRow transEntryRow = new DynamicEntryRow(schemeRow, this.getEntryRowInitContext(), new PropertyKey[]{AutoTransConstant.Entry_QTY, AutoTransConstant.Entry_Rate, AutoTransConstant.Entry_Currency, AutoTransConstant.Entry_MeasureUnit, AutoTransConstant.Entry_PRICE});
        BigDecimal oriAmount = splitInfo.getOriAmount();
        BigDecimal locAmount = splitInfo.getLocAmount();
        long currencyId = schemeRow.getLong(Key_CurrencyId);
        if (currencyId > 0L) {
            oriScale = (Integer)transEntryRow.getInnerProperty(new PropertyKey[]{AutoTransConstant.Entry_Currency, CurrencyConstant.Entity_AMT_Scale});
        } else {
            currencyId = splitInfo.getCrrencyId();
            DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
            if (currency == null) {
                return amountInfos;
            }
            oriScale = currency.getInt("amtprecision");
        }
        int locScale = this.schemeInfo.getBaseCurrencyDyn().getInt(CurrencyConstant.Entity_AMT_Scale.key);
        BigDecimal rate = this.calRate(oriAmount, locAmount, currencyId);
        BigDecimal count = new BigDecimal(splitSize);
        BigDecimal rowLocAmount = locAmount.divide(count, locScale, RoundingMode.HALF_UP);
        BigDecimal rowOriAmount = oriAmount.divide(count, oriScale, RoundingMode.HALF_UP);
        BigDecimal remainLocAmount = this.getRemainValue(locAmount, count, locScale);
        BigDecimal remainOriAmount = this.getRemainValue(oriAmount, count, oriScale);
        Long entryMeasureUnit = (Long)transEntryRow.getPropertyPK(AutoTransConstant.Entry_MeasureUnit);
        Long measureUnitID = entryMeasureUnit == null ? splitInfo.getMeasureUnitID() : entryMeasureUnit;
        BigDecimal price = transEntryRow.getBigDecimal(AutoTransConstant.Entry_PRICE);
        BigDecimal entryQty = transEntryRow.getBigDecimal(AutoTransConstant.Entry_QTY);
        BigDecimal qtySummary = entryQty.compareTo(BigDecimal.ZERO) == 0 ? splitInfo.getQty() : entryQty;
        int qtyScale = entryMeasureUnit == null ? this.getPrecision(measureUnitID) : transEntryRow.getInnerInt(new PropertyKey[]{AutoTransConstant.Entry_MeasureUnit, MeasureUnitConstant.Entity_QTY_Scale});
        BigDecimal qtyAvr = qtySummary.divide(count, qtyScale, RoundingMode.HALF_UP);
        BigDecimal qtyRemainInTail = this.getRemainValue(qtySummary, count, qtyScale);
        DynamicObjectCollection assistBD = QueryServiceHelper.query((String)"gl_assist_bd", (String)"asstype, assval", (QFilter[])new QFilter[]{new QFilter("hg", "=", (Object)assgrp)});
        DynamicObjectCollection assistTXT = QueryServiceHelper.query((String)"gl_assist_txt", (String)"asstype, assval", (QFilter[])new QFilter[]{new QFilter("hg", "=", (Object)assgrp)});
        int index = 1;
        Set<Long> transInAssgrpIds = null;
        for (Long accountId : accountIds) {
            DynamicObject accDyn = this.accountId2Dyn.get(accountId);
            if (accDyn == null) continue;
            String currencyType = accDyn.getString("acctcurrency");
            boolean includeCurrency = true;
            if ("nocurrency".equals(currencyType)) {
                includeCurrency = this.schemeInfo.getBaseCurrencyId() == splitInfo.getCrrencyId().longValue();
            } else if ("descurrency".equals(currencyType)) {
                Set desCur = accDyn.getDynamicObjectCollection("currencyentry").stream().map(dynamicObject -> dynamicObject.getLong(GLField.id_((String)"currency"))).collect(Collectors.toSet());
                desCur.add(this.schemeInfo.getBaseCurrencyId());
                includeCurrency = desCur.contains(splitInfo.getCrrencyId());
            }
            boolean isSameMeasureUnit = this.isSameMeasureUnit(account2MeasureUnitGroup.get(accountId), account2MeasureUnitGroup.get(fromAccountId));
            if ("1".equals(schemeRow.getString(Key_AssgrpType))) {
                if (acct2assts != null && acct2assts.containsKey(accountId)) {
                    Map<String, Object> transInAssists = acct2assts.get(accountId).stream().collect(Collectors.toMap(k -> (String)k.item1, v -> AssistValueType.isManualTxt((String)((String)v.item2)) ? "" : Long.valueOf(0L)));
                    for (DynamicObject dyn : assistBD) {
                        transInAssists.computeIfPresent(dyn.getString("asstype"), (k, v) -> dyn.getLong("assval"));
                    }
                    for (DynamicObject dyn : assistTXT) {
                        transInAssists.computeIfPresent(dyn.getString("asstype"), (k, v) -> dyn.getString("assval"));
                    }
                    transInAssgrpIds = Collections.singleton(FlexUtils.saveFlexData(transInAssists));
                } else {
                    transInAssgrpIds = Collections.singleton(0L);
                }
            } else {
                transInAssgrpIds = assgrpIds;
            }
            boolean isChangeDC = this.isChangeDC(schemeRow, accountId);
            for (Long assgrpId : transInAssgrpIds) {
                int combinationIndex = 0;
                do {
                    AmountInfo amountInfo = new AmountInfo();
                    amountInfo.setAccountId(accountId);
                    amountInfo.setAssgrpId(assgrpId);
                    amountInfo.setCrrencyId(Long.valueOf(includeCurrency ? currencyId : this.schemeInfo.getBaseCurrencyId()));
                    if (index == splitSize) {
                        amountInfo.setLocAmount(remainLocAmount);
                        amountInfo.setOriAmount(includeCurrency ? remainOriAmount : remainLocAmount);
                    } else {
                        amountInfo.setLocAmount(rowLocAmount);
                        amountInfo.setOriAmount(includeCurrency ? rowOriAmount : rowLocAmount);
                    }
                    amountInfo.setRate(includeCurrency ? rate : BigDecimal.ONE);
                    if (entryMeasureUnit != null || isSameMeasureUnit) {
                        amountInfo.setMeasureUnitID(measureUnitID);
                    }
                    if (entryQty.compareTo(BigDecimal.ZERO) != 0 || isSameMeasureUnit) {
                        if (isChangeDC) {
                            amountInfo.setQty(index < splitSize ? qtyAvr.negate() : qtyRemainInTail.negate());
                        } else {
                            amountInfo.setQty(index < splitSize ? qtyAvr : qtyRemainInTail);
                        }
                    }
                    amountInfo.setPrice(price);
                    if (kd.bos.util.CollectionUtils.isNotEmpty(comAssistCombination)) {
                        List<Object> comAssistIdList = comAssistCombination.get(combinationIndex++);
                        this.setComAssist(amountInfo, comAssistIdList);
                    }
                    amountInfos.add(amountInfo);
                    ++index;
                } while (combinationIndex < comAssistCombination.size());
            }
        }
        return amountInfos;
    }

    private List<AmountInfo> splitAmountByRowAccountsAndAssgrps(BigDecimal locAmount, DynamicObject schemeRow, Set<Long> accountIds, Set<Long> assgrpIds) {
        if (accountIds == null || accountIds.isEmpty()) {
            return null;
        }
        if (assgrpIds == null) {
            assgrpIds = new HashSet<Long>(1);
        }
        if (assgrpIds.isEmpty()) {
            assgrpIds.add(0L);
        }
        int splitSize = accountIds.size() * assgrpIds.size();
        List<List<Object>> comAssistCombination = this.getComAssistCombination(schemeRow);
        if (kd.bos.util.CollectionUtils.isNotEmpty(comAssistCombination)) {
            splitSize *= comAssistCombination.size();
        }
        ArrayList<AmountInfo> amountInfos = new ArrayList<AmountInfo>(splitSize);
        DynamicEntryRow transEntryRow = new DynamicEntryRow(schemeRow, this.getEntryRowInitContext(), new PropertyKey[]{AutoTransConstant.Entry_QTY, AutoTransConstant.Entry_Rate, AutoTransConstant.Entry_Currency, AutoTransConstant.Entry_MeasureUnit, AutoTransConstant.Entry_PRICE});
        int oriScale = (Integer)transEntryRow.getInnerProperty(new PropertyKey[]{AutoTransConstant.Entry_Currency, CurrencyConstant.Entity_AMT_Scale});
        int locScale = this.schemeInfo.getBaseCurrencyDyn().getInt(CurrencyConstant.Entity_AMT_Scale.key);
        long currencyId = schemeRow.getLong(Key_CurrencyId);
        IRateCalculator rateCalculator = this.getRateCalculator(currencyId);
        BigDecimal rate = transEntryRow.getBigDecimal(AutoTransConstant.Entry_Rate);
        BigDecimal count = new BigDecimal(splitSize);
        BigDecimal rowLocAmount = locAmount.divide(count, locScale, RoundingMode.HALF_UP);
        BigDecimal rowOriAmount = rateCalculator.calOriAmount(rate, rowLocAmount, oriScale);
        BigDecimal remainLocAmount = this.getRemainValue(locAmount, count, locScale);
        Long currencyID = (Long)transEntryRow.getPropertyPK(AutoTransConstant.Entry_Currency);
        Long measureUnitID = (Long)transEntryRow.getPropertyPK(AutoTransConstant.Entry_MeasureUnit);
        BigDecimal price = transEntryRow.getBigDecimal(AutoTransConstant.Entry_PRICE);
        BigDecimal qtySummary = transEntryRow.getBigDecimal(AutoTransConstant.Entry_QTY);
        int qtyScale = transEntryRow.getInnerInt(new PropertyKey[]{AutoTransConstant.Entry_MeasureUnit, MeasureUnitConstant.Entity_QTY_Scale});
        BigDecimal qtyAvr = qtySummary.divide(count, qtyScale, RoundingMode.HALF_UP);
        BigDecimal qtyRemainInTail = this.getRemainValue(qtySummary, count, qtyScale);
        int index = 1;
        for (Long accountId : accountIds) {
            for (Long assgrpId : assgrpIds) {
                int combinationIndex = 0;
                do {
                    AmountInfo amountInfo = new AmountInfo();
                    amountInfo.setAccountId(accountId);
                    amountInfo.setAssgrpId(assgrpId);
                    amountInfo.setCrrencyId(currencyID);
                    if (index == splitSize) {
                        amountInfo.setLocAmount(remainLocAmount);
                        amountInfo.setOriAmount(rateCalculator.calOriAmount(rate, remainLocAmount, oriScale));
                    } else {
                        amountInfo.setLocAmount(rowLocAmount);
                        amountInfo.setOriAmount(rowOriAmount);
                    }
                    amountInfo.setRate(rate);
                    amountInfo.setQty(index < splitSize ? qtyAvr : qtyRemainInTail);
                    amountInfo.setMeasureUnitID(measureUnitID);
                    amountInfo.setPrice(price);
                    if (kd.bos.util.CollectionUtils.isNotEmpty(comAssistCombination)) {
                        List<Object> comAssistIdList = comAssistCombination.get(combinationIndex++);
                        this.setComAssist(amountInfo, comAssistIdList);
                    }
                    amountInfos.add(amountInfo);
                    ++index;
                } while (combinationIndex < comAssistCombination.size());
            }
        }
        return amountInfos;
    }

    private Map<String, Object> getEntryRowInitContext() {
        HashMap<String, Object> initContext = new HashMap<String, Object>(8);
        initContext.put("row2bcmFormulaCalculateInfo", this.row2bcmFormulaCalculateInfo);
        initContext.put(AutoTransConstant.Entry_Rate.toString(), this.row2rate);
        return initContext;
    }

    private List<AmountInfo> splitAmountByRowAccountsAndAssgrps(BigDecimal locAmount, DynamicObject schemeRow, Map<Long, Set<Long>> accountId2AsssgrpIds, Long transOutMeasureUnitID, BigDecimal transOutQty, Map<Long, Long> account2MeasureunitGroup, Long transOutAccountId) {
        if (accountId2AsssgrpIds == null || accountId2AsssgrpIds.isEmpty()) {
            return null;
        }
        int splitSize = 0;
        for (Map.Entry<Long, Set<Long>> k2v : accountId2AsssgrpIds.entrySet()) {
            Long accountId = k2v.getKey();
            Set<Long> assgrpIds = k2v.getValue();
            if (assgrpIds == null) {
                assgrpIds = new HashSet<Long>(1);
            }
            if (assgrpIds.isEmpty()) {
                assgrpIds.add(0L);
            }
            accountId2AsssgrpIds.put(accountId, assgrpIds);
            splitSize += assgrpIds.size();
        }
        List<List<Object>> comAssistCombination = this.getComAssistCombination(schemeRow);
        if (kd.bos.util.CollectionUtils.isNotEmpty(comAssistCombination)) {
            splitSize *= comAssistCombination.size();
        }
        ArrayList<AmountInfo> amountInfos = new ArrayList<AmountInfo>(splitSize);
        BigDecimal count = new BigDecimal(splitSize);
        DynamicEntryRow transEntryRow = new DynamicEntryRow(schemeRow, this.getEntryRowInitContext(), new PropertyKey[]{AutoTransConstant.Entry_QTY, AutoTransConstant.Entry_Rate, AutoTransConstant.Entry_Currency, AutoTransConstant.Entry_MeasureUnit, AutoTransConstant.Entry_PRICE});
        int oriScale = (Integer)transEntryRow.getInnerProperty(new PropertyKey[]{AutoTransConstant.Entry_Currency, CurrencyConstant.Entity_AMT_Scale});
        int locScale = this.schemeInfo.getBaseCurrencyDyn().getInt(CurrencyConstant.Entity_AMT_Scale.key);
        long currencyId = schemeRow.getLong(Key_CurrencyId);
        IRateCalculator rateCalculator = this.getRateCalculator(currencyId);
        BigDecimal rate = transEntryRow.getBigDecimal(AutoTransConstant.Entry_Rate);
        BigDecimal rowLocAmount = locAmount.divide(count, locScale, RoundingMode.HALF_UP);
        BigDecimal rowOriAmount = rateCalculator.calOriAmount(rate, rowLocAmount, oriScale);
        BigDecimal remainLocAmount = this.getRemainValue(locAmount, count, locScale);
        Long currencyID = (Long)transEntryRow.getPropertyPK(AutoTransConstant.Entry_Currency);
        Long entryMeasureUnit = (Long)transEntryRow.getPropertyPK(AutoTransConstant.Entry_MeasureUnit);
        Long measureUnitID = entryMeasureUnit == null ? transOutMeasureUnitID : entryMeasureUnit;
        int qtyScale = entryMeasureUnit == null ? this.getPrecision(measureUnitID) : transEntryRow.getInnerInt(new PropertyKey[]{AutoTransConstant.Entry_MeasureUnit, MeasureUnitConstant.Entity_QTY_Scale});
        BigDecimal price = transEntryRow.getBigDecimal(AutoTransConstant.Entry_PRICE);
        BigDecimal entryQty = transEntryRow.getBigDecimal(AutoTransConstant.Entry_QTY);
        BigDecimal qtySummary = entryQty.compareTo(BigDecimal.ZERO) == 0 ? transOutQty : entryQty;
        BigDecimal qtyAvr = qtySummary.divide(count, qtyScale, RoundingMode.HALF_UP);
        BigDecimal qtyRemainInTail = this.getRemainValue(qtySummary, count, qtyScale);
        int index = 1;
        for (Map.Entry<Long, Set<Long>> k2v : accountId2AsssgrpIds.entrySet()) {
            Long accountId = k2v.getKey();
            Set<Long> assgrpIds = k2v.getValue();
            boolean isSameMeasureUnit = this.isSameMeasureUnit(account2MeasureunitGroup.get(accountId), account2MeasureunitGroup.get(transOutAccountId));
            boolean isChangeDC = this.isChangeDC(schemeRow, accountId);
            for (Long assgrpId : assgrpIds) {
                int combinationIndex = 0;
                do {
                    AmountInfo amountInfo = new AmountInfo();
                    amountInfo.setAccountId(accountId);
                    amountInfo.setAssgrpId(assgrpId);
                    amountInfo.setCrrencyId(currencyID);
                    if (index == splitSize) {
                        amountInfo.setLocAmount(remainLocAmount);
                        amountInfo.setOriAmount(rateCalculator.calOriAmount(rate, remainLocAmount, oriScale));
                    } else {
                        amountInfo.setLocAmount(rowLocAmount);
                        amountInfo.setOriAmount(rowOriAmount);
                    }
                    if (entryMeasureUnit != null || isSameMeasureUnit) {
                        amountInfo.setMeasureUnitID(measureUnitID);
                    }
                    if (entryQty.compareTo(BigDecimal.ZERO) != 0 || isSameMeasureUnit) {
                        if (isChangeDC) {
                            amountInfo.setQty(index < splitSize ? qtyAvr.negate() : qtyRemainInTail.negate());
                        } else {
                            amountInfo.setQty(index < splitSize ? qtyAvr : qtyRemainInTail);
                        }
                    }
                    amountInfo.setPrice(price);
                    amountInfo.setRate(rate);
                    if (kd.bos.util.CollectionUtils.isNotEmpty(comAssistCombination)) {
                        List<Object> comAssistIdList = comAssistCombination.get(combinationIndex++);
                        this.setComAssist(amountInfo, comAssistIdList);
                    }
                    amountInfos.add(amountInfo);
                    ++index;
                } while (combinationIndex < comAssistCombination.size());
            }
        }
        return amountInfos;
    }

    private BigDecimal getRemainValue(BigDecimal totalAmount, BigDecimal count, int locScale) {
        BigDecimal avgAmount = totalAmount.divide(count, locScale, RoundingMode.HALF_UP);
        BigDecimal remainAmount = totalAmount.subtract(avgAmount.multiply(count.subtract(BigDecimal.ONE))).setScale(locScale, RoundingMode.HALF_UP);
        return remainAmount;
    }

    private Map<Long, FlexEntireData> parseTransOutAssgrp(Set<Long> assgrpIds) {
        FlexEntireData.FlexData flexData;
        FlexProperty flexProperty;
        ArrayList flexDatas;
        FlexEntireData flexEntireData;
        Object val;
        String type;
        Long id;
        HashMap<Long, FlexEntireData> map = new HashMap<Long, FlexEntireData>();
        HashMap<String, FlexProperty> flexFieldPropertyMap = new HashMap<String, FlexProperty>();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_assist_bd", (String)"hg,asstype,assval", (QFilter[])new QFilter[]{new QFilter("hg", "in", assgrpIds)}, null);){
            for (Row row : dSet) {
                id = row.getLong("hg");
                type = row.getString("asstype");
                val = row.getLong("assval");
                flexEntireData = (FlexEntireData)map.get(id);
                if (flexEntireData == null) {
                    flexEntireData = new FlexEntireData();
                    flexDatas = new ArrayList();
                    flexEntireData.setFlexDatas(flexDatas);
                    map.put(id, flexEntireData);
                }
                flexProperty = flexFieldPropertyMap.computeIfAbsent(type, FlexUtils::getFlexProperty);
                FlexEntireData flexEntireData2 = flexEntireData;
                flexEntireData2.getClass();
                flexData = new FlexEntireData.FlexData(flexEntireData2, flexProperty, val);
                flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
                flexEntireData.getFlexDatas().add(flexData);
            }
        }
        dSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_assist_txt", (String)"hg,asstype,assval", (QFilter[])new QFilter[]{new QFilter("hg", "in", assgrpIds)}, null);
        var5_5 = null;
        try {
            for (Row row : dSet) {
                id = row.getLong("hg");
                type = row.getString("asstype");
                val = row.getString("assval");
                flexEntireData = (FlexEntireData)map.get(id);
                if (flexEntireData == null) {
                    flexEntireData = new FlexEntireData();
                    flexDatas = new ArrayList();
                    flexEntireData.setFlexDatas(flexDatas);
                    map.put(id, flexEntireData);
                }
                flexProperty = flexFieldPropertyMap.computeIfAbsent(type, FlexUtils::getFlexProperty);
                FlexEntireData flexEntireData3 = flexEntireData;
                flexEntireData3.getClass();
                flexData = new FlexEntireData.FlexData(flexEntireData3, flexProperty, val);
                flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
                flexEntireData.getFlexDatas().add(flexData);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (dSet != null) {
                if (var5_5 != null) {
                    try {
                        dSet.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    dSet.close();
                }
            }
        }
        return map;
    }

    private List<List<FlexEntireData.FlexData>> buildExtAssgrp(FlexEntireData flexEntireData, FinalProcessAssgrp finalProcessAssgrp, Set<String> inAccountFlexs) {
        if (finalProcessAssgrp == null) {
            return null;
        }
        Map flex2values = finalProcessAssgrp.getFlex2values();
        if (flex2values.isEmpty()) {
            return null;
        }
        ArrayList<List<FlexEntireData.FlexData>> listEntireData = new ArrayList<List<FlexEntireData.FlexData>>();
        for (String flex : inAccountFlexs) {
            FinalProcessAssgrp.AssgrpValues assgrpValues = (FinalProcessAssgrp.AssgrpValues)flex2values.get(flex);
            if (assgrpValues == null) continue;
            Boolean isBaseData = assgrpValues.getIsBaseData();
            Set values = assgrpValues.getValues();
            if (listEntireData.isEmpty()) {
                for (Object v : values) {
                    ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>();
                    FlexEntireData flexEntireData2 = flexEntireData;
                    flexEntireData2.getClass();
                    FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData2, flex, v);
                    if (isBaseData.booleanValue()) {
                        flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
                    } else {
                        flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
                    }
                    flexDatas.add(flexData);
                    listEntireData.add(flexDatas);
                }
                continue;
            }
            ArrayList tempListEntireData = new ArrayList();
            for (Object v : values) {
                for (List list : listEntireData) {
                    FlexEntireData flexEntireData3 = flexEntireData;
                    flexEntireData3.getClass();
                    FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData3, flex, v);
                    if (isBaseData.booleanValue()) {
                        flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
                    } else {
                        flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
                    }
                    ArrayList<FlexEntireData.FlexData> tmpflexDatas = new ArrayList<FlexEntireData.FlexData>();
                    tmpflexDatas.addAll(list);
                    tmpflexDatas.add(flexData);
                    tempListEntireData.add(tmpflexDatas);
                }
            }
            if (tempListEntireData.isEmpty()) continue;
            listEntireData.clear();
            listEntireData.addAll(tempListEntireData);
        }
        return listEntireData;
    }

    private long getExcelAssgrpId(Map<String, Object> flexFieldValueMap) {
        return flexFieldValueMap.isEmpty() ? 0L : FlexUtils.saveFlexData(flexFieldValueMap);
    }

    private long getAssgrpId(Map<String, String> groupvalueMap, String rowIdVal, String assgrpTypeVal) {
        HashMap<String, Object> flexFieldValueMap = new HashMap<String, Object>();
        FinalProcessAssgrp finalProcessAssgrp = this.row2assgrp.get(rowIdVal);
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_asstacttype", (String)"name,number,flexfield,valuetype,valuesource", (QFilter[])new QFilter("number", "in", groupvalueMap.keySet()).toArray(), null);){
            String entityId = null;
            block18: while (dt.hasNext()) {
                Row row = dt.next();
                String valuetype = row.getString("valuetype");
                String flexfield = row.getString("flexfield");
                String number = row.getString("number");
                String dimensiondetailNum = groupvalueMap.get(number);
                String numProp = "number";
                if (AssistValueType.isBaseData((String)valuetype)) {
                    entityId = row.getString("valuesource");
                    BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityId);
                    numProp = entityType.getNumberProperty();
                } else if (AssistValueType.isAssistData((String)valuetype)) {
                    entityId = "bos_assistantdata_detail";
                } else if (AssistValueType.isManualTxt((String)valuetype)) {
                    flexFieldValueMap.put(flexfield, dimensiondetailNum);
                    continue;
                }
                DataSet assistvalue = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityId, (String)"id", (QFilter[])new QFilter(numProp, "=", (Object)dimensiondetailNum).toArray(), null);
                Throwable throwable = null;
                try {
                    while (assistvalue.hasNext()) {
                        Long valueId = assistvalue.next().getLong("id");
                        if (TRANSFER_TYPE_TRANS_PL.equals(assgrpTypeVal)) {
                            Set assgrpids;
                            FinalProcessAssgrp.AssgrpValues assgrpValues = (FinalProcessAssgrp.AssgrpValues)finalProcessAssgrp.getFlex2values().get(flexfield);
                            if (assgrpValues == null || !assgrpValues.getIsBaseData().booleanValue() || (assgrpids = assgrpValues.getValues()) == null || !assgrpids.contains(valueId)) continue;
                            flexFieldValueMap.put(flexfield, valueId);
                            continue block18;
                        }
                        flexFieldValueMap.put(flexfield, valueId);
                        continue block18;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (assistvalue == null) continue;
                    if (throwable != null) {
                        try {
                            assistvalue.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    assistvalue.close();
                }
            }
        }
        return flexFieldValueMap.isEmpty() ? 0L : FlexUtils.saveFlexData(flexFieldValueMap);
    }

    private DataSet getTransOutAssgrpDataSet(String rowId) {
        DataSet result = null;
        FinalProcessAssgrp finalProcessAssgrp = this.row2assgrp.get(rowId);
        if (finalProcessAssgrp != null) {
            result = finalProcessAssgrp.getHgIdSet();
        }
        return result;
    }

    private Map<String, Object> resolve(String url, DynamicObjectCollection entry) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream in = service.getInputStream(url);
        Workbook book = ExcelUtils.readExcel((String)url, (InputStream)in);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("filepath", url);
        String entityId = null;
        FlexValueReader flexValueReader = new FlexValueReader(this.autoTransScheme.getOrgId().longValue(), FlexValueReader.MatchMode.NAME);
        for (DynamicObject entryRow : entry) {
            String entrykey;
            HashMap<String, Object> rowparam = new HashMap<String, Object>();
            int page = entryRow.getInt("page");
            String position = entryRow.getString("position");
            if (page == 0 || kd.bos.util.StringUtils.isEmpty((String)position)) continue;
            rowparam.put("page", page);
            rowparam.put("position", position);
            Map<String, Integer> excelPosition = this.resolvePosition(position);
            int column = excelPosition.get("column");
            int startRow = excelPosition.get("start");
            int endRow = excelPosition.get("end");
            List values = new ArrayList();
            try {
                values = ExcelUtils.getColumnSet((Workbook)book, (int)page, (int)column, (int)startRow, (int)endRow);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4eceEXCEL\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u8bbe\u7f6e\u3002", (String)"AutoTransGenVchOperateService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            }
            DynamicObject assgrp = entryRow.getDynamicObject("assgrp");
            if (assgrp != null) {
                String valueType = assgrp.getString("valuetype");
                if ("1".equals(valueType)) {
                    entityId = assgrp.getString("valuesource_id");
                } else {
                    if (!TRANSFER_TYPE_TRANS_PL.equals(valueType)) continue;
                    entityId = "bos_assistantdata_detail";
                }
                if (!values.isEmpty()) {
                    List flexValues = flexValueReader.batchGetFlexValue(assgrp.getString("flexfield"), false, values.toArray());
                    rowparam.put("values", flexValues.stream().map(String::valueOf).collect(Collectors.toList()));
                }
                HashMap<String, String> assgrpMap = new HashMap<String, String>();
                rowparam.put("assgrp", assgrpMap);
                assgrpMap.put("number", assgrp.getString("number"));
                assgrpMap.put("entity", entityId);
                assgrpMap.put("flexfield", assgrp.getString("flexfield"));
                entrykey = assgrp.getString("number");
            } else {
                entrykey = "moneycolumn";
                rowparam.put("values", values);
            }
            params.put(entrykey, rowparam);
        }
        return params;
    }

    private Map<String, Integer> resolvePosition(String position) {
        position = position.toUpperCase().replace(" ", "");
        String[] splits = position.split(":");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        try {
            if (splits.length > 3) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f4d\u7f6e\u683c\u5f0f\u8f93\u5165\u6709\u8bef\uff1a\u8bf7\u8f93\u5165(A1:A3)\u3002", (String)"AutoTransGenVchOperateService_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
            }
            for (int i = 0; i < splits.length; ++i) {
                boolean isLastLetter = true;
                int index = 0;
                for (int j = 0; j < splits[i].length(); ++j) {
                    Character c = Character.valueOf(splits[i].charAt(j));
                    if (c.charValue() >= 'A' && c.charValue() <= 'Z' || c.charValue() >= 'a' && c.charValue() <= 'z') {
                        if (!isLastLetter) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u4f4d\u7f6e\u683c\u5f0f\u8f93\u5165\u6709\u8bef\uff1a\u8bf7\u8f93\u5165(A1:A3)\u3002", (String)"AutoTransGenVchOperateService_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        }
                        isLastLetter = true;
                        continue;
                    }
                    if (c.charValue() >= '0' && c.charValue() <= '9') {
                        index = index == 0 ? j : index;
                        isLastLetter = false;
                        continue;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u4f4d\u7f6e\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u3002", (String)"AutoTransGenVchOperateService_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                }
                int column = ExcelUtils.excelColStrToNum((String)splits[i].substring(0, index));
                if (result.get("column") == null) {
                    result.put("column", column);
                } else if ((Integer)result.get("column") != column) {
                    throw new KDBizException(ResManager.loadKDString((String)"ERROR:\u8d77\u59cb\u5750\u6807\u548c\u7ed3\u675f\u5750\u6807\u9700\u8981\u5728\u540c\u4e00\u5217\uff0c\u5982\uff1aB2:B5", (String)"AutoTransGenVchOperateService_7", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                }
                int row = Integer.parseInt(splits[i].substring(index));
                if (i == 0) {
                    result.put("start", row);
                    result.put("end", row);
                    continue;
                }
                result.put("end", row);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String message = e.getMessage();
            message = message.startsWith("ERROR") ? message.replace("ERROR:", "") : ResManager.loadKDString((String)"\u4eceEXCEL\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u8bbe\u7f6e\u3002", (String)"AutoTransGenVchOperateService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        return result;
    }

    private Set<String> getAcctFlexFields(DynamicObject account) {
        DynamicObjectCollection acctEntry = account.getDynamicObjectCollection("checkitementry");
        HashSet<Object> itemids = new HashSet<Object>();
        for (DynamicObject row : acctEntry) {
            itemids.add(row.getDynamicObject("asstactitem").getPkValue());
        }
        HashSet<String> flexFields = new HashSet<String>();
        if (!itemids.isEmpty()) {
            try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_asstacttype", (String)"flexfield", (QFilter[])new QFilter("id", "in", itemids).toArray(), null);){
                while (dt.hasNext()) {
                    flexFields.add(dt.next().getString("flexfield"));
                }
            }
        }
        return flexFields;
    }

    private List<AmountInfo> getExcelValue(DynamicObject schemeRow) {
        long orgid = this.schemeInfo.getVoucherInfo().getOrg();
        List<AmountInfo> amountInfos = new ArrayList<AmountInfo>();
        DynamicObject acct = this.getAccountOnCurPeriod(schemeRow);
        Set<String> flexFields = this.getAcctFlexFields(acct);
        String rowId = schemeRow.getString(Key_RowId);
        Map excelSettings = BusinessDataServiceHelper.loadFromCache((String)"gl_autotransexcelseting", (QFilter[])new QFilter(Key_RowId, "=", (Object)rowId).toArray());
        BigDecimal acctDcVal = acct.getBigDecimal(Key_DcType);
        String assgrpTypeVal = schemeRow.getString(Key_AssgrpType);
        int amtprecision = schemeRow.getInt(Key_CurrencyScale);
        for (Map.Entry entry : excelSettings.entrySet()) {
            DynamicObject setting = (DynamicObject)entry.getValue();
            DynamicObjectCollection settingEntry = setting.getDynamicObjectCollection("entryentity");
            String url = setting.getString("filepath");
            Map<String, Object> expMap = null;
            try {
                expMap = this.resolve(url, settingEntry);
            }
            catch (Exception e) {
                if (e instanceof NotOfficeXmlFileException) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bfb\u53d6Excel\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"AutoTransGenVchOperateService_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                }
                throw e;
            }
            if (expMap == null) {
                return null;
            }
            Map moneyparam = (Map)expMap.get("moneycolumn");
            if (moneyparam == null) {
                return null;
            }
            List moneyValues = (List)moneyparam.get("values");
            if (moneyValues.isEmpty()) {
                return null;
            }
            HashMap<String, Map<String, Object>> sumAcctInfo = new HashMap<String, Map<String, Object>>();
            for (int i = 0; i < moneyValues.size(); ++i) {
                try {
                    BigDecimal value = new BigDecimal(NumberFormatUtil.isValidNumber((String)moneyValues.get(i)) ? (String)moneyValues.get(i) : "0");
                    HashMap<String, Object> flexFieldValueMap = new HashMap<String, Object>();
                    HashMap<String, String> flexFieldEntityMap = new HashMap<String, String>();
                    for (Map.Entry<String, Object> expMapEntry : expMap.entrySet()) {
                        Set baseDataValues;
                        FinalProcessAssgrp.AssgrpValues assgrpValues;
                        String assgrpNum = expMapEntry.getKey();
                        if ("moneycolumn".equals(assgrpNum) || "filepath".equals(assgrpNum)) continue;
                        Map rowparam = (Map)expMapEntry.getValue();
                        Map assgrpMap = (Map)rowparam.get("assgrp");
                        String flexfield = (String)assgrpMap.get("flexfield");
                        String entity = (String)assgrpMap.get("entity");
                        List values = (List)rowparam.get("values");
                        String detailValue = (String)values.get(i);
                        if (StringUtils.isEmpty((CharSequence)detailValue)) continue;
                        Long detailLongValue = Long.valueOf(detailValue);
                        if ("1".equals(assgrpTypeVal)) {
                            if (values.size() <= i || kd.bos.util.StringUtils.isEmpty((String)detailValue)) continue;
                            flexFieldValueMap.put(flexfield, detailLongValue);
                            flexFieldEntityMap.put(flexfield, entity);
                            continue;
                        }
                        FinalProcessAssgrp finalProcessAssgrp = this.row2assgrp.get(rowId);
                        if (finalProcessAssgrp == null || (assgrpValues = finalProcessAssgrp.getValuesByAssgrpNumber(assgrpNum)) == null || !assgrpValues.getIsBaseData().booleanValue() || (baseDataValues = assgrpValues.getValues()) == null || kd.bos.util.StringUtils.isEmpty((String)detailValue) || !baseDataValues.contains(detailLongValue)) continue;
                        flexFieldValueMap.put(flexfield, detailLongValue);
                        flexFieldEntityMap.put(flexfield, entity);
                        break;
                    }
                    HashSet<String> unUseFieldKeySet = new HashSet<String>();
                    Set usedfieldKeySet = flexFieldValueMap.keySet();
                    for (String flexField : flexFields) {
                        if (usedfieldKeySet.contains(flexField)) continue;
                        unUseFieldKeySet.add(flexField);
                    }
                    if (!usedfieldKeySet.isEmpty()) {
                        for (Map.Entry entrymap : flexFieldValueMap.entrySet()) {
                            String entity = (String)flexFieldEntityMap.get(entrymap.getKey());
                            Object fromval = entrymap.getValue();
                            Map assgrpValByRelation = AssgrpRelationUtil.getAssgrpValByRelation((String)((String)entrymap.getKey()), unUseFieldKeySet, (String)entity, fromval, (Long)orgid);
                            flexFieldValueMap.putAll(assgrpValByRelation);
                        }
                    }
                    long assgrpId = this.getExcelAssgrpId(flexFieldValueMap);
                    String sumkey = "" + acct.getPkValue() + assgrpId;
                    HashMap<String, BigDecimal> acctInfo = (HashMap<String, BigDecimal>)sumAcctInfo.get(sumkey);
                    BigDecimal rate = this.row2rate.get(rowId);
                    if (acctInfo == null) {
                        acctInfo = new HashMap<String, BigDecimal>();
                        acctInfo.put("accountid", (BigDecimal)acct.getPkValue());
                        acctInfo.put("endfor", value);
                        acctInfo.put("endlocal", value.multiply(rate));
                        acctInfo.put("hgid", (BigDecimal)((Object)Long.valueOf(assgrpId)));
                        acctInfo.put(Key_DcType, acctDcVal);
                        acctInfo.put("currency", acctDcVal);
                        acctInfo.put("amtprecision", (BigDecimal)((Object)Integer.valueOf(amtprecision)));
                    } else {
                        acctInfo.put("endfor", value.add((BigDecimal)acctInfo.get("endfor")));
                        acctInfo.put("endlocal", value.multiply(rate).add((BigDecimal)acctInfo.get("endlocal")));
                    }
                    sumAcctInfo.put(sumkey, acctInfo);
                    continue;
                }
                catch (KDBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u91d1\u989d\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u8bbe\u7f6e%s\u3002", (String)"AutoTransGenVchOperateService_4", (String)"fi-gl-opplugin", (Object[])new Object[0]), Strings.nullToEmpty((String)e.getMessage())));
                }
            }
            if (TRANSFER_TYPE_TRANS_PL.equals(schemeRow.getString(Key_AssgrpType))) {
                BigDecimal sumAmount = BigDecimal.ZERO;
                for (Map v : sumAcctInfo.values()) {
                    sumAmount = sumAmount.add((BigDecimal)v.get("endlocal"));
                }
                Set<Long> leafAccts = this.row2accountIds.get(rowId);
                Set assgrpIds = null;
                FinalProcessAssgrp finalProcessAssgrp = this.row2assgrp.get(rowId);
                if (finalProcessAssgrp != null) {
                    assgrpIds = finalProcessAssgrp.getHgIds();
                }
                amountInfos = this.splitAmountByRowAccountsAndAssgrps(sumAmount, schemeRow, leafAccts, assgrpIds);
                continue;
            }
            this.divideAcct(rowId, amountInfos, sumAcctInfo, schemeRow);
        }
        return amountInfos;
    }

    private void divideAcct(String rowIdVal, List<AmountInfo> amountInfos, Map<String, Map<String, Object>> sumAcctInfo, DynamicObject schemeRow) {
        Set<Long> leafAccts = this.row2accountIds.get(rowIdVal);
        if (leafAccts != null && !leafAccts.isEmpty()) {
            List<List<Object>> comAssistCombination = this.getComAssistCombination(schemeRow);
            for (Map.Entry<String, Map<String, Object>> entry : sumAcctInfo.entrySet()) {
                Map<String, Object> acctInfos = entry.getValue();
                int index = 1;
                BigDecimal endfor = (BigDecimal)acctInfos.get("endfor");
                BigDecimal endlocal = (BigDecimal)acctInfos.get("endlocal");
                int amtprecision = (Integer)acctInfos.get("amtprecision");
                BigDecimal size = kd.bos.util.CollectionUtils.isNotEmpty(comAssistCombination) ? new BigDecimal(comAssistCombination.size() * leafAccts.size()) : new BigDecimal(leafAccts.size());
                BigDecimal lastSize = size.subtract(BigDecimal.ONE);
                for (Long accountId : leafAccts) {
                    int combinationIndex = 0;
                    do {
                        BigDecimal endLocal;
                        BigDecimal endFor;
                        AmountInfo amountInfo = new AmountInfo();
                        amountInfo.setAssgrpId((Long)acctInfos.get("hgid"));
                        amountInfo.setDc(acctInfos.get(Key_DcType).toString());
                        amountInfo.setAccountId(accountId);
                        if (leafAccts.size() != index++) {
                            endFor = endfor.divide(size, amtprecision, 4);
                            endLocal = endlocal.divide(size, amtprecision, 4);
                        } else {
                            endFor = endfor.subtract(endfor.divide(size, amtprecision, 4).multiply(lastSize));
                            endLocal = endlocal.subtract(endlocal.divide(size, amtprecision, 4).multiply(lastSize));
                        }
                        amountInfo.setLocAmount(endLocal);
                        amountInfo.setOriAmount(endFor);
                        amountInfo.setRate(this.row2rate.get(rowIdVal));
                        if (kd.bos.util.CollectionUtils.isNotEmpty(comAssistCombination)) {
                            List<Object> comAssistIdList = comAssistCombination.get(combinationIndex++);
                            this.setComAssist(amountInfo, comAssistIdList);
                        }
                        amountInfos.add(amountInfo);
                    } while (combinationIndex < comAssistCombination.size());
                }
            }
        }
    }

    private List<AmountInfo> getRptExpValue(DynamicObject schemeRow) {
        List<AmountInfo> amountInfos = new ArrayList<AmountInfo>();
        DynamicObject acct = this.getAccountOnCurPeriod(schemeRow);
        int amtprecision = schemeRow.getInt(Key_CurrencyScale);
        long currencyID = schemeRow.getLong(Key_CurrencyId);
        DynamicObjectCollection assgrpEntry = acct.getDynamicObjectCollection("checkitementry");
        Map dimensions = (Map)this.rptReturnData.get("dimensions");
        Map entryrows = (Map)this.rptReturnData.get("entryrows");
        Map entryFixRows = (Map)this.rptReturnData.get("entryfixrows");
        Map dimMap = (Map)this.rptReturnData.get("dimMap");
        if (entryrows == null) {
            return amountInfos;
        }
        String rowId = schemeRow.getString(Key_RowId);
        Map entryrow = (Map)entryrows.get(rowId);
        boolean isFixReportType = entryrow == null;
        ArrayList<Map<String, Integer>> dimensionInfos = new ArrayList<Map<String, Integer>>();
        for (int j = 0; j < assgrpEntry.size(); ++j) {
            DynamicObject asstactitem = ((DynamicObject)assgrpEntry.get(j)).getDynamicObject("asstactitem");
            String assgrpNum = asstactitem.getString("number");
            String string = asstactitem.getString("name");
            int index = 0;
            for (Map.Entry entry : dimensions.entrySet()) {
                String dimNameAfterMap = (String)entry.getValue();
                if (dimMap != null) {
                    dimNameAfterMap = (String)dimMap.getOrDefault(entry.getValue(), entry.getValue());
                }
                ++index;
                if (!string.equals(dimNameAfterMap)) continue;
                Map<String, Integer> dimensionInfo = new HashMap<String, Object>();
                dimensionInfo.put("number", (Integer)((Object)assgrpNum));
                dimensionInfo.put("index", index - 1);
                dimensionInfos.add(dimensionInfo);
            }
        }
        String assgrpTypeVal = schemeRow.getString(Key_AssgrpType);
        HashMap<String, Map<String, Object>> sumAcctInfo = new HashMap<String, Map<String, Object>>(16);
        if (!isFixReportType) {
            for (Map.Entry entry : entryrow.entrySet()) {
                List key = (List)entry.getKey();
                BigDecimal value = (BigDecimal)entry.getValue();
                HashMap<String, String> groupvalueMap = new HashMap<String, String>();
                for (Map<String, Integer> dimensionInfo : dimensionInfos) {
                    List baseDataNumbers;
                    FinalProcessAssgrp.AssgrpValues assgrpValues;
                    int index = (Integer)dimensionInfo.get("index");
                    String dimensiondetailNum = (String)key.get(index);
                    String dimensionNum = (String)dimensionInfo.get("number");
                    if ("1".equals(assgrpTypeVal)) {
                        groupvalueMap.put(dimensionNum, dimensiondetailNum);
                        continue;
                    }
                    FinalProcessAssgrp finalProcessAssgrp = this.row2assgrp.get(rowId);
                    if (finalProcessAssgrp == null || (assgrpValues = finalProcessAssgrp.getValuesByAssgrpNumber(dimensionNum)) == null || (baseDataNumbers = assgrpValues.getBaseDataNumbers()) == null || !baseDataNumbers.contains(dimensiondetailNum)) continue;
                    groupvalueMap.put(dimensionNum, dimensiondetailNum);
                }
                long assgrpId = this.getAssgrpId(groupvalueMap, rowId, assgrpTypeVal);
                BigDecimal acctDcVal = acct.getBigDecimal(Key_DcType);
                String sumkey = "" + acct.getPkValue() + assgrpId;
                HashMap<String, BigDecimal> acctInfo = (HashMap<String, BigDecimal>)sumAcctInfo.get(sumkey);
                BigDecimal rate = this.row2rate.get(rowId);
                if (acctInfo == null) {
                    acctInfo = new HashMap<String, BigDecimal>();
                    acctInfo.put("accountid", (BigDecimal)acct.getPkValue());
                    acctInfo.put("endfor", value);
                    acctInfo.put("endlocal", value.multiply(rate));
                    acctInfo.put("hgid", (BigDecimal)((Object)Long.valueOf(assgrpId)));
                    acctInfo.put(Key_DcType, acctDcVal);
                    acctInfo.put("currency", acctDcVal);
                    acctInfo.put("amtprecision", (BigDecimal)((Object)Integer.valueOf(amtprecision)));
                } else {
                    acctInfo.put("endfor", value.add((BigDecimal)acctInfo.get("endfor")));
                    acctInfo.put("endlocal", value.multiply(rate).add((BigDecimal)acctInfo.get("endlocal")));
                }
                sumAcctInfo.put(sumkey, acctInfo);
            }
        } else {
            String sumkey = "" + acct.getPkValue() + 0L;
            Map map = sumAcctInfo.getOrDefault(sumkey, new HashMap());
            Object fixAmt = entryFixRows.get(rowId);
            if (fixAmt != null && !(fixAmt instanceof BigDecimal)) {
                fixAmt = new BigDecimal(fixAmt.toString());
            }
            BigDecimal fixForAmt = Optional.ofNullable((BigDecimal)fixAmt).orElse(BigDecimal.ZERO);
            map.put("accountid", acct.getPkValue());
            map.put("endfor", fixForAmt);
            BigDecimal rate = this.row2rate.get(rowId);
            map.put("endlocal", fixForAmt.multiply(rate));
            map.put("hgid", 0L);
            BigDecimal acctDcVal = acct.getBigDecimal(Key_DcType);
            map.put(Key_DcType, acctDcVal);
            map.put("currency", currencyID);
            map.put("amtprecision", amtprecision);
            sumAcctInfo.put(sumkey, map);
        }
        if (TRANSFER_TYPE_TRANS_PL.equals(schemeRow.getString(Key_AssgrpType))) {
            BigDecimal sumAmount = BigDecimal.ZERO;
            for (Map v : sumAcctInfo.values()) {
                sumAmount = sumAmount.add((BigDecimal)v.get("endlocal"));
            }
            Set<Long> set = this.row2accountIds.get(rowId);
            Set assgrpIds = null;
            FinalProcessAssgrp finalProcessAssgrp = this.row2assgrp.get(rowId);
            if (finalProcessAssgrp != null) {
                assgrpIds = finalProcessAssgrp.getHgIds();
            }
            amountInfos = this.splitAmountByRowAccountsAndAssgrps(sumAmount, schemeRow, set, assgrpIds);
        } else {
            this.divideAcct(rowId, amountInfos, sumAcctInfo, schemeRow);
        }
        return amountInfos;
    }

    private List<AmountInfo> getTransOutAmountInfos(DynamicObject schemeRow) {
        String sourceType;
        String rowId = schemeRow.getString(Key_RowId);
        Set<Long> accountIds = this.row2accountIds.get(rowId);
        if (accountIds == null || accountIds.isEmpty()) {
            return null;
        }
        String selector = "account, assgrp, measureunit";
        String locAmountKey = null;
        String oriAmountKey = null;
        String qtyAmountKey = null;
        switch (sourceType = schemeRow.getString(Key_DataType)) {
            case "4": {
                locAmountKey = "creditlocal";
                oriAmountKey = "creditfor";
                qtyAmountKey = "creditqty";
                break;
            }
            case "3": {
                locAmountKey = "debitlocal";
                oriAmountKey = "debitfor";
                qtyAmountKey = "debitqty";
                break;
            }
            case "2": {
                locAmountKey = "endlocal";
                oriAmountKey = "endfor";
                qtyAmountKey = "endqty";
                break;
            }
            default: {
                return null;
            }
        }
        selector = selector + ", " + locAmountKey + ", " + oriAmountKey + "," + qtyAmountKey;
        int comAssistCount = this.schemeInfo.getComAssistCount();
        StringBuilder comAssistFields = new StringBuilder(selector);
        for (int index = 0; index < comAssistCount; ++index) {
            comAssistFields.append(", ").append(CommonAssistUtil.getComassistField((int)(index + 1)));
        }
        selector = comAssistFields.toString();
        long orgId = this.schemeInfo.getOrgId();
        long bookTypeId = this.schemeInfo.getAccountBookInfo().getBookTypeId();
        long accountTableId = this.autoTransService.getAccountTableInVersion();
        long curPeriodId = this.schemeInfo.getCurPeriodId();
        QueryParam param = new QueryParam();
        QFilter accountFilter = new QFilter("id", "in", accountIds);
        param.setAccountFilter(accountFilter);
        long currencyId = schemeRow.getLong(Key_CurrencyId);
        param.setCurrencyIds(new Long[]{currencyId});
        String assgrpType = schemeRow.getString(Key_AssgrpType);
        DataSet assgrpDs = null;
        if (TRANSFER_TYPE_TRANS_PL.equals(assgrpType) && (assgrpDs = this.getTransOutAssgrpDataSet(rowId)) != null && assgrpDs.isEmpty()) {
            assgrpDs.close();
            return null;
        }
        param.setOnlyLeafAcctBal(true);
        ArrayList<QFilter> comAssistFilters = new ArrayList<QFilter>(8);
        for (int index = 0; index < comAssistCount; ++index) {
            String comAssistField = CommonAssistUtil.getComassistField((int)(index + 1));
            Set comAssistIdSet = schemeRow.getDynamicObjectCollection(comAssistField).stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toSet());
            if (!kd.bos.util.CollectionUtils.isNotEmpty(comAssistIdSet)) continue;
            comAssistFilters.add(new QFilter(comAssistField, "in", comAssistIdSet));
        }
        if (param.getCustomFilter() == null) {
            param.setCustomFilter(comAssistFilters);
        } else {
            param.getCustomFilter().addAll(comAssistFilters);
        }
        DataSet balance = BalanceQueryExecutor.getInstance().getBalance(selector, new Long[]{orgId}, bookTypeId, accountTableId, curPeriodId, curPeriodId, param);
        if (assgrpDs != null) {
            ArrayList<String> selectFieldList = new ArrayList<String>(Arrays.asList("assgrp", locAmountKey, oriAmountKey, qtyAmountKey, "account", "measureunit"));
            for (int index = 0; index < comAssistCount; ++index) {
                selectFieldList.add(CommonAssistUtil.getComassistField((int)(index + 1)));
            }
            balance = balance.join(assgrpDs, JoinType.INNER).on("assgrp", "hg").select(selectFieldList.toArray(new String[0]), null).finish();
        }
        ArrayList<AmountInfo> result = new ArrayList<AmountInfo>(accountIds.size());
        for (Row row : balance) {
            AmountInfo amountInfo = new AmountInfo();
            amountInfo.setAccountId(row.getLong("account"));
            amountInfo.setAssgrpId(row.getLong("assgrp"));
            BigDecimal locAmount = row.getBigDecimal(locAmountKey);
            BigDecimal oriAmount = row.getBigDecimal(oriAmountKey);
            amountInfo.setLocAmount(locAmount);
            amountInfo.setOriAmount(oriAmount);
            BigDecimal rate = this.calRate(oriAmount, locAmount, currencyId);
            amountInfo.setRate(rate);
            amountInfo.setQty(row.getBigDecimal(qtyAmountKey));
            amountInfo.setMeasureUnitID(row.getLong("measureunit"));
            amountInfo.setPrice(schemeRow.getBigDecimal(AutoTransConstant.Entry_PRICE.toString()));
            for (int index = 0; index < comAssistCount; ++index) {
                amountInfo.getComAssistIdMap().put(index + 1, row.getLong(CommonAssistUtil.getComassistField((int)(index + 1))));
            }
            result.add(amountInfo);
        }
        return result;
    }

    @Override
    public void saveVoucherRelations(Long id, List<VoucherInfo> voucherInfos, OperationResult operationResult) {
    }

    @Override
    public void afterSaveVoucher(HashMap<Long, OperationResult> opResult) {
        super.afterSaveVoucher(opResult);
        if (opResult == null) {
            return;
        }
        HashSet<Long> schemeIds = new HashSet<Long>(opResult.keySet());
        DynamicObject[] schemeDyns = BdBusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (String)"id", (String)entityName);
        ArrayList<DynamicObject> relationDyn = new ArrayList<DynamicObject>();
        for (DynamicObject schemeInfo : schemeDyns) {
            long schemeid = schemeInfo.getLong("id");
            OperationResult result = opResult.get(schemeid);
            List ids = result.getSuccessPkIds();
            QFilter fids = new QFilter("id", "in", (Object)ids);
            DynamicObjectCollection voucherDyns = QueryServiceHelper.query((String)"gl_voucher", (String)"id,period", (QFilter[])new QFilter[]{fids});
            if (voucherDyns.size() == 0) continue;
            for (DynamicObject voucherDyn : voucherDyns) {
                DynamicObject amortschemevoucherref = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucherrelation");
                amortschemevoucherref.set("type", (Object)TRANSFER_TYPE_TRANS_PL);
                amortschemevoucherref.set("iseffective", (Object)1);
                amortschemevoucherref.set("targentity", voucherDyn.get("id"));
                amortschemevoucherref.set("srcentity", schemeInfo.get("id"));
                amortschemevoucherref.set("period", voucherDyn.get("period"));
                relationDyn.add(amortschemevoucherref);
            }
        }
        SaveServiceHelper.save((DynamicObject[])relationDyn.toArray(new DynamicObject[0]));
    }

    private void orderByEntry() {
        VoucherInfo voucherInfo = this.schemeInfo.getVoucherInfo();
        if (voucherInfo.isBigEntryMode()) {
            return;
        }
        DynamicObject autoDyn = this.schemeInfo.getDataEntity();
        String sortType = autoDyn.getString("voucherentrysort");
        IVoucherEntrySort entrySort = EntrySortFactory.getEntrySort((String)sortType);
        if (entrySort != null) {
            entrySort.SortVchEntryRows(voucherInfo);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AutoTransGenVchValidator("org", "bookstype"));
    }

    @Override
    public void initField(DynamicObject dataEntity) {
        this.schemeInfo = new AutoTransGenVchInfo(dataEntity, this.operateOption);
        this.autoTransScheme = new AutoTransScheme(dataEntity);
        this.autoTransService = new AutoTransService(this.autoTransScheme);
    }

    @Override
    public List<VoucherInfo> constructVoucher() {
        this.constructVoucherHead();
        return this.createVoucherEntries();
    }

    private VoucherInfo constructVoucherHead() {
        AccountBookInfo accountBookInfo = this.schemeInfo.getAccountBookInfo();
        DynamicObject periodDyn = this.schemeInfo.getPeriodDyn();
        Date bizDate = this.schemeInfo.getBizDate();
        if (bizDate == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5f53\u524d\u8bb0\u8d26\u65e5\u671f\u7684\u671f\u95f4\u3002", (String)"AutoTransGenVchOperateService_5", (String)"fi-gl-opplugin", (Object[])new Object[0])});
        }
        VoucherInfo voucherInfo = this.schemeInfo.getVoucherInfo();
        voucherInfo.setDesc(this.schemeInfo.getVoucherDesc());
        voucherInfo.setBizDate(bizDate);
        voucherInfo.setBookedDate(bizDate);
        voucherInfo.setPeriod(Long.valueOf(periodDyn.getLong("id")));
        voucherInfo.setCreator(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        voucherInfo.setAttachMent(0);
        voucherInfo.setStatus("A");
        voucherInfo.setSourceSys(AppHelper.getAppIdByFormId((String)"gl_voucher"));
        voucherInfo.setBookType(Long.valueOf(accountBookInfo.getBookTypeId()));
        voucherInfo.setVoucherType(Long.valueOf(this.schemeInfo.getVoucherTypeId()));
        voucherInfo.setSourceType(this.schemeInfo.getSourceType());
        voucherInfo.setOrg(Long.valueOf(accountBookInfo.getOrgId()));
        voucherInfo.loadRefence();
        return voucherInfo;
    }

    @Override
    public void initPropsToPrepare() {
        super.initPropsToPrepare();
        this.propToPrepare.add(AutoTransConstant.Prop_Entry);
        this.propToPrepare.add(AutoTransConstant.Entry_Key_Account);
        this.propToPrepare.addAll(Arrays.asList(AutoTransConstant.Entry_QTY, AutoTransConstant.Entry_Rate, AutoTransConstant.Entry_Currency, AutoTransConstant.Entry_MeasureUnit, AutoTransConstant.Entry_QTY_FROM));
        super.putPropsToPrepare(AutoTransConstant.Prop_Entry, AutoTransConstant.Entity_Seq, AutoTransConstant.Entity_Account);
    }

    @Override
    public String getEndingProcessType() {
        return new AutoTransScheme().getEndingProcessType();
    }

    private BigDecimal calRate(BigDecimal oriAmount, BigDecimal locAmount, long currencyId) {
        long baseCurrencyId = this.schemeInfo.getBaseCurrencyId();
        Date bizDate = this.schemeInfo.getBizDate();
        IRateCalculator rateCalculator = this.getRateCalculator(currencyId);
        int ratePrecision = RateServiceHelper.getRatePrecision((Long)currencyId, (Long)baseCurrencyId, (Long)this.schemeInfo.getExchangeTableId(), (Date)bizDate);
        return oriAmount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : rateCalculator.calRate(oriAmount, locAmount, ratePrecision);
    }

    private IRateCalculator getRateCalculator(long currencyId) {
        long baseCurrencyId = this.schemeInfo.getBaseCurrencyId();
        Date bizDate = this.schemeInfo.getBizDate();
        RateType rateType = RateServiceHelper.getRateType((long)currencyId, (long)baseCurrencyId, (Date)bizDate);
        return rateType.getRateCalculator();
    }

    private List<List<Object>> getComAssistCombination(DynamicObject schemeRow) {
        int comAssistCount = this.schemeInfo.getComAssistCount();
        HashMap comAssistIdMap = new HashMap(comAssistCount);
        for (int index = 0; index < comAssistCount; ++index) {
            Set comAssistIdSet = schemeRow.getDynamicObjectCollection(CommonAssistUtil.getComassistField((int)(index + 1))).stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toSet());
            comAssistIdMap.put(index + 1, comAssistIdSet);
        }
        return FinalProcessUtil.getCartesianProduct(comAssistIdMap.values().stream().map(set -> Arrays.asList(set.toArray())).collect(Collectors.toList()));
    }

    private void setComAssist(AmountInfo amountInfo, List<Object> comAssistIdList) {
        HashMap<Integer, Long> comAssistMap = new HashMap<Integer, Long>(8);
        for (int i = 0; i < comAssistIdList.size(); ++i) {
            comAssistMap.put(i + 1, Long.parseLong(comAssistIdList.get(i).toString()));
        }
        amountInfo.setComAssistIdMap(comAssistMap);
    }

    private boolean isSameMeasureUnit(Long measureunitgroup1, Long measureunitgroup2) {
        if (Long.valueOf(0L).equals(measureunitgroup1)) {
            return true;
        }
        if (measureunitgroup1 != null && measureunitgroup2 != null) {
            return measureunitgroup1.equals(measureunitgroup2);
        }
        return false;
    }

    public Map<Long, Long> getAccount2MeasureunitGroup(List<Long> accountIds) {
        HashMap<Long, Long> result = new HashMap<Long, Long>(accountIds.size());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_accountview", (String)"id,isqty,measureunitgroup", (QFilter[])new QFilter[]{new QFilter("id", "in", accountIds)});
        for (DynamicObject dyn : collection) {
            if (!dyn.getBoolean("isqty")) continue;
            result.put(dyn.getLong("id"), dyn.getLong("measureunitgroup"));
        }
        return result;
    }

    private boolean isChangeDC(DynamicObject schemeRow, Long accountId) {
        String dcType = schemeRow.getString(Key_DcType);
        boolean isAutoDc = StringUtils.isBlank((CharSequence)dcType) || "0".equals(dcType);
        String dc = isAutoDc ? "1" : dcType;
        String dataType = schemeRow.getString(Key_DataType);
        String accountDc = Optional.ofNullable(this.accountId2dc.get(accountId)).orElseGet(() -> BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bd_accountview", (String)Key_DcType).getBigDecimal(Key_DcType)).toString();
        if ("6".equals(dataType)) {
            if (isAutoDc) {
                dc = accountDc;
            }
            if (!dc.equals(accountDc)) {
                return true;
            }
        } else if ("5".equals(dataType)) {
            if (isAutoDc && "1".equals(accountDc)) {
                dc = "-1";
            }
            if (dc.equals(accountDc)) {
                return true;
            }
        } else if ("1".equals(dataType)) {
            if (isAutoDc) {
                dc = accountDc;
            }
            if ("1".equals(dc)) {
                return true;
            }
        }
        return false;
    }

    private int getPrecision(Long measureunit) {
        if (measureunit == 0L) {
            return 0;
        }
        if (this.measureunit2precision.containsKey(measureunit)) {
            return this.measureunit2precision.get(measureunit);
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)measureunit, (String)"bd_measureunits", (String)"precision");
        if (dynamicObject != null) {
            int precision = dynamicObject.getInt("precision");
            this.measureunit2precision.put(measureunit, precision);
            return precision;
        }
        return 0;
    }

    private boolean isMerge() {
        return this.getOption().containsVariable("MergeVoucherEntries");
    }

    @Override
    protected void updateSeq(List<VoucherInfo> dbVoucherInfos) {
        for (VoucherInfo voucherInfo : dbVoucherInfos) {
            if (!voucherInfo.isBigEntryMode()) continue;
            PerformanceWatch watcher = new PerformanceWatch(logger, "[gl_autotrans]", false);
            watcher.start("merge big entry");
            Map pkMap = VoucherEntryDSMergeHelper.create().init(new EntryMergeOption(), new GlVoucherField()).merge((Set)Sets.newHashSet((Object[])new Object[]{voucherInfo.getPK()}));
            Map.Entry next = pkMap.entrySet().iterator().next();
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)"update t_gl_voucherentry set fid = ? where fid = ?", (Object[])new Object[]{next.getKey(), next.getValue()});
            watcher.stop();
            watcher.start("sort big entry");
            watcher.stop();
        }
    }

    static {
        String mcKey = String.format("%s_%s", RequestContext.get().getTenantId(), "fi.gl.autotrans.presave");
        ConfigurationUtil.observeInteger((String)mcKey, (int)100000, newVal -> {
            logger.info("[gl_autotrans]detect threshold changed:" + newVal);
            PRE_SAVE_THRESHOLD = newVal;
        });
    }
}

