/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.operateservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.service.balance.AppHelper;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.VoucherEntryCollection;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.common.VoucherInfo;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.finalprocessing.info.TransPLProgramInfo;
import kd.fi.gl.finalprocessing.operateservice.AbstractFinalProcessingOperateService;
import kd.fi.gl.finalprocessing.operateservice.BalanceDTO;
import kd.fi.gl.finalprocessing.operateservice.BalanceService;
import kd.fi.gl.finalprocessing.operateservice.ComAssistBalanceDTO;
import kd.fi.gl.finalprocessing.operateservice.IBalanceDTO;
import kd.fi.gl.finalprocessing.operateservice.MulLocalBalanceDTO;
import kd.fi.gl.finalprocessing.operateservice.VoucherInfoDTO;
import kd.fi.gl.finalprocessing.operateservice.YearProfitAcctDTO;
import kd.fi.gl.finalprocessing.validate.TransPLProgramsGenVchValidator;
import kd.fi.gl.reciprocal.FlexSaveService;
import kd.fi.gl.util.CommonAssistUtil;

public class TransPLProgramsGenVchOperateService
extends AbstractFinalProcessingOperateService {
    private static final Log logger = LogFactory.getLog(TransPLProgramsGenVchOperateService.class);
    private TransPLProgramInfo info;
    private final Map<String, Map<String, Map<String, Set<Long>>>> transPLKeyInCurGen = new HashMap<String, Map<String, Map<String, Set<Long>>>>(16);
    private final Map<Long, Map<String, Set<Long>>> transPLAccountNumberSortMap = new HashMap<Long, Map<String, Set<Long>>>(16);
    private final Map<Long, Long> assistValueMap = new HashMap<Long, Long>();
    private boolean isMerge = false;
    private Map<String, Long> mergeGroupKeyVoucherIdMap = new HashMap<String, Long>(16);
    private boolean isHugeEntries = false;
    private int save_rows = 0;
    private int batchSize = 10000;
    private int assBatchSize = 999;
    private VoucherInfoDTO voucherInfoDTO = new VoucherInfoDTO();
    private int assCostTotal = 0;
    private int saveCostTotal = 0;
    private Long defaultTotalRows = 100000L;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TransPLProgramsGenVchValidator("org", "book"));
    }

    @Override
    public void initField(DynamicObject dataEntity) {
        this.info = new TransPLProgramInfo(dataEntity, this.operateOption);
    }

    @Override
    public List<VoucherInfo> constructVoucher() {
        this.constructVoucherHead();
        List<VoucherInfo> voucherInfos = this.constructVoucherEntries();
        return voucherInfos;
    }

    @Override
    public String getEndingProcessType() {
        return "gl_transplprogram";
    }

    private void constructVoucherHead() {
        VoucherInfo voucherInfo = this.info.getVoucherInfo();
        AccountBookInfo bookInfo = this.info.getAccountBookInfo();
        voucherInfo.setAttachMent(0);
        voucherInfo.setOrg(Long.valueOf(bookInfo.getOrgId()));
        voucherInfo.setBookType(Long.valueOf(bookInfo.getBookTypeId()));
        voucherInfo.setSourceType("1");
        voucherInfo.setStatus("A");
        voucherInfo.setSourceSys(AppHelper.getAppIdByFormId((String)"gl_voucher"));
        DynamicObject curPeriod = this.info.getCurPeroid();
        Date endDate = curPeriod.getDate("enddate");
        voucherInfo.setBizDate(endDate);
        voucherInfo.setBookedDate(endDate);
        voucherInfo.setPeriod(this.info.getCurPeriodId());
        voucherInfo.setCreator(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        voucherInfo.setVoucherType(Long.valueOf(this.info.getVoucherTypeId()));
        if (!this.info.getLocalCurrencyConfig().isEmpty()) {
            voucherInfo.setMulCur(this.info.getLocalCurrencyConfig());
        }
        voucherInfo.loadRefence();
        this.isMerge = this.getOption().containsVariable("MergeVoucherEntries");
        if (this.isMerge) {
            Long mergeVoucherId = this.mergeGroupKeyVoucherIdMap.computeIfAbsent(voucherInfo.getGruopKey(), k -> (Long)voucherInfo.getPK());
            voucherInfo.setPK((Object)mergeVoucherId);
        }
    }

    private List<VoucherInfo> constructVoucherEntries() {
        StringBuilder selectField = new StringBuilder("org, booktype, account.number accountnumber,account.dc accountdc,account.id accountid,measureunit.id measureunitid,assgrp.id assistGrpID,currency.id currencyid,account.isqty accountIsQty,endqty,endlocal,endfor,account.pltype pltype,account.masterid masterid,");
        for (int i = 0; i < this.info.getComAssistCount(); ++i) {
            selectField.append(CommonAssistUtil.getComassistField((int)(i + 1))).append(",");
        }
        for (LocalCurrencyConfigVO localCurrencyConfigVO : this.info.getLocalCurrencyConfig()) {
            selectField.append(localCurrencyConfigVO.getBalanceField(MCT.END).getMetaId()).append(",");
        }
        AccountBookInfo accountBookInfo = this.info.getAccountBookInfo();
        QueryParam queryParam = this.buildQueryParam();
        return this.buildVoucherEntryInfo(accountBookInfo, queryParam, selectField.delete(selectField.length() - 1, selectField.length()).toString());
    }

    private QueryParam buildQueryParam() {
        QueryParam queryParam = new QueryParam();
        QFilter accountFilter = new QFilter("accounttype.accounttype", "=", (Object)"4");
        HashMap hmPLAccount = this.info.getHmPLAccount();
        if (!hmPLAccount.isEmpty()) {
            accountFilter = accountFilter.and(new QFilter("id", "in", hmPLAccount.keySet()));
        }
        queryParam.setAccountFilter(accountFilter);
        queryParam.setCustomFilter(this.info.getComAssistFilters());
        return queryParam;
    }

    private List<VoucherInfo> buildVoucherEntryInfo(AccountBookInfo accountBookInfo, QueryParam queryParam, String selectField) {
        this.assCostTotal = 0;
        this.saveCostTotal = 0;
        long queryBalanceStart = System.currentTimeMillis();
        try (DataSet dataSet = this.getBalance(accountBookInfo, selectField, queryParam, this.info.getVoucherInfo().getBookedDate());){
            long queryBalanceEnd = System.currentTimeMillis();
            logger.info("[trans_pl_huge_rows][query_balance_cost]\u67e5\u8be2\u4f59\u989d\u8017\u65f6: {} ms", (Object)(queryBalanceEnd - queryBalanceStart));
            this.voucherInfoDTO.initVoucherInfoAndPLSums(this.info.isByPl(), this.info.getVoucherInfo(), this.isMerge);
            ArrayList<BalanceDTO> batchList = new ArrayList<BalanceDTO>();
            int balanceRows = 0;
            boolean hasBalanceData = false;
            while (dataSet.hasNext()) {
                if (!hasBalanceData) {
                    hasBalanceData = true;
                }
                ++balanceRows;
                Row rs = dataSet.next();
                this.spiltDataBuildVoucherNew(rs, batchList);
                if (batchList.size() >= this.batchSize) {
                    this.dealBatchList(batchList);
                    batchList.clear();
                }
                if (balanceRows % this.batchSize != 0) continue;
                this.cacheSchemeProgressRuuningRows(balanceRows, this.voucherInfoDTO.getPLSumSize());
            }
            if (!hasBalanceData) {
                throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u635f\u76ca\u7c7b\u79d1\u76ee\u4f59\u989d\u4e3a\u96f6\uff0c\u4e0d\u9700\u8981\u7ed3\u8f6c\u635f\u76ca\u3002", (String)"TransPLProgramsGenVchOperateService_0", (String)"fi-gl-opplugin", (Object[])new Object[0])});
            }
            this.dealBatchList(batchList);
            List<VoucherInfo> voucherInfos = this.addPlacctEntry0New();
            long transPLEnd = System.currentTimeMillis();
            logger.info("[trans_pl_huge_rows][create_entries_cost][balanceRows: {}]\u751f\u6210\u5206\u5f55\u8017\u65f6: {} ms, assCostTotal:{}, saveCostTotal:{}", new Object[]{balanceRows, transPLEnd - queryBalanceEnd, this.assCostTotal, this.saveCostTotal});
            if (this.isHugeEntries) {
                List<VoucherInfo> list = voucherInfos;
                return list;
            }
            for (VoucherInfo voucherInfo : voucherInfos) {
                VoucherEntryCollection entries = voucherInfo.getEntries();
                logger.info("[trans_pl_huge_rows][entries_rows]\u51ed\u8bc1\u5206\u5f55\u884c\u6570: {}", (Object)entries.size());
                entries.sort(Comparator.comparing(VoucherEntryInfo::getAccNumber));
                int i = 1;
                for (VoucherEntryInfo voucherEntryInfo : entries) {
                    voucherEntryInfo.setSeq(i++);
                }
            }
            long sortEnd = System.currentTimeMillis();
            logger.info("[trans_pl_huge_rows][sort_time]\u51ed\u8bc1\u5206\u5f55\u6309\u79d1\u76ee\u6392\u5e8f\u8017\u65f6: {} ms", (Object)(sortEnd - transPLEnd));
            List<VoucherInfo> list = voucherInfos;
            return list;
        }
    }

    private List<VoucherInfo> addPlacctEntry0New() {
        List<VoucherInfoDTO.VoucherInfoAndPLSum> voucherInfoAndPLSumList = this.voucherInfoDTO.getVoucherInfoAndPLSumList();
        ArrayList<VoucherInfo> voucherInfos = new ArrayList<VoucherInfo>();
        for (VoucherInfoDTO.VoucherInfoAndPLSum voucherInfoAndPLSum : voucherInfoAndPLSumList) {
            this.addPlVoucherEntryInfoByConditionNew(voucherInfoAndPLSum);
            this.preSaveVoucher(voucherInfos, voucherInfoAndPLSum.voucherInfo);
        }
        return voucherInfos;
    }

    private void addPlVoucherEntryInfoByConditionNew(VoucherInfoDTO.VoucherInfoAndPLSum voucherInfoAndPLSum) {
        HashMap<String, YearProfitAcctDTO> localCurSumMap = new HashMap<String, YearProfitAcctDTO>();
        for (Map.Entry<String, HashMap<String, BigDecimal>> entry : voucherInfoAndPLSum.plSumMap.entrySet()) {
            this.genVouchereByCondition(voucherInfoAndPLSum.voucherInfo, localCurSumMap, entry.getKey(), entry.getValue());
        }
        this.sumTransByBCAndUnit(localCurSumMap, voucherInfoAndPLSum.voucherInfo);
    }

    @Override
    protected void cacheSchemeProgressBegin(int totalScheme) {
        super.cacheSchemeProgressBegin(totalScheme);
        String pageId = this.getOptionPageId();
        if (StringUtils.isNotEmpty((CharSequence)pageId)) {
            this.setProgressCache(pageId + "amountScheme", String.valueOf(totalScheme));
            this.setProgressCache(pageId + "completeScheme", "0");
        }
    }

    @Override
    protected void cacheSchemeProgressRuuning(int completeScheme) {
        super.cacheSchemeProgressRuuning(completeScheme);
        String pageId = this.getOptionPageId();
        if (StringUtils.isNotEmpty((CharSequence)pageId)) {
            this.setProgressCache(pageId + "completeScheme", String.valueOf(completeScheme));
        }
    }

    private void cacheSchemeProgressRuuningRows(int rows, int plSumSize) {
        String pageId = this.getOptionPageId();
        String amountSchemeStr = this.getProgressCache(pageId + "amountScheme");
        String completeSchemeStr = this.getProgressCache(pageId + "completeScheme");
        if (StringUtils.isNotEmpty((CharSequence)pageId) && StringUtils.isNotEmpty((CharSequence)amountSchemeStr) && StringUtils.isNotEmpty((CharSequence)completeSchemeStr)) {
            Long estTotalRows = this.defaultTotalRows + (long)rows + (long)plSumSize;
            Long amountScheme = Long.parseLong(amountSchemeStr);
            Long completeScheme = Long.parseLong(completeSchemeStr);
            Long progressPercent = completeScheme * 100L / amountScheme + (long)(rows * 100) / estTotalRows / amountScheme;
            this.setProgressCache(pageId + "progress", String.valueOf(progressPercent));
        }
    }

    @Override
    protected void cacheSchemeProgressEnd() {
        super.cacheSchemeProgressEnd();
        String pageId = this.getOptionPageId();
        if (StringUtils.isNotEmpty((CharSequence)pageId)) {
            this.setProgressCache(pageId + "progress", "99");
        }
    }

    private String getOptionPageId() {
        return this.getOption().getVariableValue("pageId", null);
    }

    @Override
    protected void updateSeq(List<VoucherInfo> dbVoucherInfos) {
        if (DebugTrace.enable()) {
            logger.info("[trans_pl_huge_rows][updateSeq][isHugeEntries]: {}", (Object)this.isHugeEntries);
        }
        if (!this.isHugeEntries) {
            return;
        }
        for (VoucherInfo voucherInfo : dbVoucherInfos) {
            this.addToAccountNumberSortMap(voucherInfo);
        }
        for (Map.Entry entry : this.transPLAccountNumberSortMap.entrySet()) {
            Long vid = (Long)entry.getKey();
            Map accountNumberEntryIdsMap = (Map)entry.getValue();
            int seq = 1;
            if (DebugTrace.enable()) {
                logger.info("[trans_pl_huge_rows][sorted accountNumbers]: {}", accountNumberEntryIdsMap.keySet());
            }
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            for (Map.Entry accountAndEntryIds : accountNumberEntryIdsMap.entrySet()) {
                Set entryIds = (Set)accountAndEntryIds.getValue();
                for (Long entryId : entryIds) {
                    Object[] param = new Object[]{seq++, vid, entryId};
                    params.add(param);
                    if (params.size() != this.batchSize) continue;
                    this.updateSeqBatch(params);
                    params.clear();
                }
            }
            if (params.size() <= 0) continue;
            this.updateSeqBatch(params);
        }
    }

    private void updateSeqBatch(List<Object[]> params) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"update t_gl_voucherentry set fseq = ? where fid = ? and fentryid = ? ", params);
    }

    @Override
    protected void deleteDirtyEntryRows() {
        if (DebugTrace.enable()) {
            logger.info("deleteDirtyEntryRows isHugeEntries: {}", (Object)this.isHugeEntries);
        }
        if (!this.isHugeEntries) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                Set<Long> voucherIds = this.transPLAccountNumberSortMap.keySet();
                if (DebugTrace.enable()) {
                    logger.info("deleteDirtyEntryRows isHugeEntries: {}, voucherIds: {}", (Object)this.isHugeEntries, voucherIds);
                }
                SqlBuilder sqlBuilder = new SqlBuilder();
                sqlBuilder.append("delete from t_gl_voucherentry where ", new Object[0]).appendIn(" fid", new ArrayList<Long>(voucherIds));
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
            }
            catch (Exception e) {
                logger.error("deleteDirtyEntryRows error: {}", (Object)e.getMessage(), (Object)e);
                tx.markRollback();
                throw e;
            }
        }
    }

    private void spiltDataBuildVoucherNew(Row rs, List<BalanceDTO> batchList) {
        Set accountIdSet = this.info.getNotEnableAccount();
        Long acctId = rs.getLong("accountid");
        String accountnumber = rs.getString("accountnumber");
        if (acctId == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801\u4e3a\uff1a%s\u7684\u6570\u636e\u6709\u8bef\uff0c\u627e\u4e0d\u5230\u6570\u636e", (String)"TransPLProgramsGenVchOperateService_1", (String)"fi-gl-opplugin", (Object[])new Object[]{accountnumber})});
        }
        if (accountIdSet.contains(acctId)) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5b58\u5728\u7f16\u7801\u4e3a%s\u7981\u7528\u72b6\u6001\u79d1\u76ee\uff0c\u4e0d\u80fd\u7ed3\u8f6c\u635f\u76ca\u3002", (String)"TransPLProgramsGenVchOperateService_3", (String)"fi-gl-opplugin", (Object[])new Object[]{accountnumber})});
        }
        long curId = rs.getLong("currencyid");
        long grpId = rs.getLong("assistGrpID");
        Long measureunitId = rs.getLong("measureunitid");
        long acctBookTypeID = this.info.getAccountBookInfo().getBookTypeId();
        long orgID = this.info.getAccountBookInfo().getOrgId();
        long acctMasterID = rs.getLong("masterid");
        HashMap<String, Long> comAssistMap = new HashMap<String, Long>(8);
        for (int i = 0; i < this.info.getComAssistCount(); ++i) {
            String comAssistField = CommonAssistUtil.getComassistField((int)(i + 1));
            comAssistMap.put(comAssistField, rs.getLong(comAssistField));
        }
        if (this.checkRepeatAndAddTransPLKey(orgID, acctBookTypeID, acctMasterID, curId, grpId, measureunitId, comAssistMap)) {
            return;
        }
        batchList.add(this.createBalanceDTO(rs));
    }

    private BalanceDTO createBalanceDTO(Row rs) {
        BalanceDTO balanceDTO = new BalanceDTO();
        ArrayList<IBalanceDTO> extSpec = new ArrayList<IBalanceDTO>();
        if (this.info.getComAssistCount() != 0) {
            extSpec.add(new ComAssistBalanceDTO(this.info.getComAssistCount()));
        }
        if (!LocalCurrencyConfigService.queryEnableCurrencies((long)this.info.getOrgId(), (long)this.info.getAccountBookInfo().getBookTypeId()).isEmpty()) {
            extSpec.add(new MulLocalBalanceDTO(this.info.getLocalCurrencyConfig()));
        }
        balanceDTO.init(rs, extSpec);
        return balanceDTO;
    }

    private boolean checkRepeatAndAddTransPLKey(long orgID, long acctBookTypeID, long acctMasterID, long curId, long grpId, Long measureunitId, Map<String, Long> comAssistMap) {
        Set grpIdSet;
        boolean notRepeat;
        String orgBookKey = StringUtils.join((Object[])new Object[]{orgID, acctBookTypeID}, (String)"-");
        String accountCurUnitKey = StringUtils.join((Object[])new Object[]{acctMasterID, curId, measureunitId}, (String)"-");
        StringBuilder comAssistKey = new StringBuilder();
        for (int i = 0; i < this.info.getComAssistCount(); ++i) {
            comAssistKey.append(comAssistMap.getOrDefault(CommonAssistUtil.getComassistField((int)(i + 1)), 0L)).append("-");
        }
        if (comAssistKey.length() > 0) {
            comAssistKey.deleteCharAt(comAssistKey.length() - 1);
        }
        return !(notRepeat = (grpIdSet = this.transPLKeyInCurGen.computeIfAbsent(orgBookKey, k1 -> new HashMap()).computeIfAbsent(accountCurUnitKey, k2 -> new HashMap()).computeIfAbsent(comAssistKey.toString(), k3 -> new HashSet())).add(grpId));
    }

    private void dealBatchList(List<BalanceDTO> batchList) {
        if (CollectionUtils.isEmpty(batchList)) {
            return;
        }
        this.assistValueMap.clear();
        this.assistValueMap.put(0L, 0L);
        HashSet<Long> assgrpIdSet = new HashSet<Long>(this.assBatchSize);
        for (BalanceDTO balanceDTO : batchList) {
            if (balanceDTO.getGrpId() == 0L) continue;
            assgrpIdSet.add(balanceDTO.getGrpId());
            if (assgrpIdSet.size() != this.assBatchSize) continue;
            Map<String, Long> assistValues = this.queryAssvals(assgrpIdSet);
            this.buildAssistValueMap(assistValues);
            assgrpIdSet.clear();
        }
        Map<String, Long> assistValues = this.queryAssvals(assgrpIdSet);
        this.buildAssistValueMap(assistValues);
        for (BalanceDTO balanceDTO : batchList) {
            this.putPlSumAndSetAccEntryNew(balanceDTO);
        }
    }

    private Map<String, Long> queryAssvals(Set<Long> assgrpIdSet) {
        if (assgrpIdSet.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Long> assistValues = new HashMap<String, Long>(assgrpIdSet.size());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fvalue from t_gl_assist where ", new Object[0]).appendIn("fid", new ArrayList<Long>(assgrpIdSet));
        HashMap<Long, String> resultMap = new HashMap<Long, String>(assgrpIdSet.size());
        try (DataSet dataSet = DB.queryDataSet((String)"transPL.queryAssvals", (DBRoute)new DBRoute("gl"), (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                resultMap.put(row.getLong("fid"), row.getString("fvalue"));
            }
        }
        for (Long assgrpid : assgrpIdSet) {
            String assJsonVals = (String)resultMap.get(assgrpid);
            if (null == assJsonVals) {
                throw new KDBizException(String.format("assgrpid: %s not found value from t_gl_assist", assgrpid));
            }
            assistValues.put(assJsonVals, assgrpid);
        }
        return assistValues;
    }

    private void putPlSumAndSetAccEntryNew(BalanceDTO balanceDTO) {
        boolean isCreDC = this.isCreDC(balanceDTO.getPltype());
        VoucherInfoDTO.VoucherInfoAndPLSum voucherInfoAndPLSum = this.voucherInfoDTO.getVoucherInfoAndPLSum(isCreDC);
        this.putPlSum(balanceDTO, voucherInfoAndPLSum.plSumMap);
        this.setVoucherEntryInfoByAcctdc(voucherInfoAndPLSum.voucherInfo, balanceDTO);
    }

    private void buildAssistValueMap(Map<String, Long> assistValues) {
        if (CollectionUtils.isEmpty(assistValues)) {
            return;
        }
        long buildAssistValueMapStart = System.currentTimeMillis();
        HashMap flexMap = this.info.getYearProfitAcctBasedataUsedFlexProperties();
        FlexEntityType met = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)"gl_voucher", (String)"account", (int)2, new ArrayList(flexMap.keySet()));
        Map<String, FlexProperty> flexPropertyMap = this.getFlexPropertyMap(flexMap);
        ArrayList<FlexEntireData> fetList = new ArrayList<FlexEntireData>(assistValues.size());
        HashMap<String, String> keyMap = new HashMap<String, String>(assistValues.size());
        for (String assvals : assistValues.keySet()) {
            Map valueMap = (Map)SerializationUtils.fromJsonString((String)assvals, Map.class);
            FlexEntireData fet = new FlexEntireData();
            ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>(flexMap.size());
            for (Map.Entry entry : flexMap.entrySet()) {
                String v = (String)entry.getValue();
                Object value = valueMap.get(v);
                if (value == null) continue;
                FlexEntireData flexEntireData = new FlexEntireData();
                flexEntireData.getClass();
                FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData, flexPropertyMap.get(v), value);
                if (value instanceof Long || value instanceof Integer) {
                    flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
                } else {
                    flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
                }
                flexDatas.add(flexData);
            }
            fet.setFlexDatas(flexDatas);
            keyMap.put(assvals, fet.concatFlexData());
            fetList.add(fet);
        }
        long batchSaveFlexDataStart = System.currentTimeMillis();
        Map newAssgrpIdMap = FlexSaveService.batchSaveFlexData((MainEntityType)met, fetList);
        long batchSaveFlexDataEnd = System.currentTimeMillis();
        long assSaveCost = batchSaveFlexDataEnd - batchSaveFlexDataStart;
        logger.info("[trans_pl_huge_rows][buildAssistValueMap] assSaveCost: {}", (Object)assSaveCost);
        for (Map.Entry<String, Long> entry : assistValues.entrySet()) {
            Long newAssgrpId = (Long)newAssgrpIdMap.get(keyMap.get(entry.getKey()));
            this.assistValueMap.put(entry.getValue(), newAssgrpId);
        }
        long buildAssistValueMapEnd = System.currentTimeMillis();
        long assCost = buildAssistValueMapEnd - buildAssistValueMapStart;
        this.assCostTotal = (int)((long)this.assCostTotal + assCost);
        logger.info("[trans_pl_huge_rows][buildAssistValueMap]assCost: {}", (Object)assCost);
    }

    private Map<String, FlexProperty> getFlexPropertyMap(HashMap<Long, String> flexMap) {
        HashMap<String, FlexProperty> flexPropertyMap = new HashMap<String, FlexProperty>(flexMap.size());
        for (String propId : flexMap.values()) {
            FlexProperty flexProperty = FlexEntityMetaUtils.getFlexProperty((String)propId);
            flexPropertyMap.put(propId, flexProperty);
        }
        return flexPropertyMap;
    }

    private void genVouchereByCondition(VoucherInfo vch, HashMap<String, YearProfitAcctDTO> sumMap, String k, HashMap<String, BigDecimal> v) {
        YearProfitAcctDTO yearProfitAcctDTO = new YearProfitAcctDTO(k, v);
        yearProfitAcctDTO.init(this.info);
        if (!this.info.isTransByBaseCurrency() && this.containYearProfitAcctCurrency(yearProfitAcctDTO.getCurId())) {
            this.addPlacctEntry(vch, yearProfitAcctDTO);
        } else {
            String key = BalanceService.appendPlSumKey(this.info, yearProfitAcctDTO);
            if (sumMap.get(key) != null) {
                yearProfitAcctDTO.add(sumMap.get(key));
            }
            sumMap.put(key, yearProfitAcctDTO);
        }
    }

    private boolean containYearProfitAcctCurrency(long orgCurId) {
        Set currencySet = this.info.getYearProfitAcctCurrencyIds();
        if (currencySet != null) {
            return currencySet.contains(orgCurId);
        }
        return true;
    }

    public void sumTransByBCAndUnit(HashMap<String, YearProfitAcctDTO> sumMap, VoucherInfo vch) {
        if (!sumMap.isEmpty()) {
            sumMap.forEach((k, v) -> this.addPlacctEntry(vch, (YearProfitAcctDTO)v));
        }
    }

    private void addPlacctEntry(VoucherInfo vch, YearProfitAcctDTO yearProfitAcctDTO) {
        if (yearProfitAcctDTO.needGenVchEntry()) {
            vch = this.appendEntrySave(vch);
            VoucherEntryInfo entry = vch.createNewEntry();
            entry.setOrg(vch.getOrg());
            entry.setPeriod(vch.getPeriod());
            BalanceService.fillPlVchEntry(this.info, entry, yearProfitAcctDTO);
        }
    }

    private VoucherInfo appendEntrySave(VoucherInfo vch) {
        VoucherEntryCollection entries = vch.getEntries();
        if (entries.size() == this.batchSize) {
            long batchEntrySaveStart = System.currentTimeMillis();
            this.isHugeEntries = true;
            ArrayList<Long> accountIds = new ArrayList<Long>(2);
            for (VoucherEntryInfo entry : vch.getEntries()) {
                accountIds.add(entry.getAccount());
            }
            Map<Long, DynamicObject> accountMap = this.getAccountMap(accountIds);
            this.setExpireDate(vch, accountMap);
            DynamicObject voucher = vch.toDynamicObject();
            DynamicObjectType vchDType = voucher.getDynamicObjectType();
            this.save_rows += this.batchSize;
            logger.info("[trans_pl_huge_rows][save_rows]: {}", (Object)this.save_rows);
            try (TXHandle tx = TX.requiresNew();){
                try {
                    BusinessDataWriter.save((IDataEntityType)vchDType, (Object[])new Object[]{voucher});
                    DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_gl_voucher where fid=?", (Object[])new Object[]{voucher.getPkValue()});
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
            this.addToAccountNumberSortMap(vch);
            long batchEntrySaveEnd = System.currentTimeMillis();
            long saveCost = batchEntrySaveEnd - batchEntrySaveStart;
            this.saveCostTotal = (int)((long)this.saveCostTotal + saveCost);
            logger.info("[trans_pl_huge_rows][batchEntrySave]cost: {}", (Object)saveCost);
            return this.voucherInfoDTO.resetVoucherInfo(vch);
        }
        return vch;
    }

    private void addToAccountNumberSortMap(VoucherInfo vch) {
        DynamicObject voucher = vch.toDynamicObject();
        Object vid = voucher.getPkValue();
        VoucherEntryCollection entries = vch.getEntries();
        Map accountNumberEntryIdsMap = this.transPLAccountNumberSortMap.computeIfAbsent((Long)vid, k -> new TreeMap());
        for (VoucherEntryInfo voucherEntryInfo : entries) {
            Long entryId = (Long)voucherEntryInfo.getEntryId();
            String accNumber = voucherEntryInfo.getAccNumber();
            accountNumberEntryIdsMap.computeIfAbsent(accNumber, k -> new LinkedHashSet()).add(entryId);
        }
    }

    private void putPlSum(BalanceDTO balanceDTO, Map<String, HashMap<String, BigDecimal>> plSumMap) {
        long grpIdKey = this.info.getAssgrpId() > 0L ? this.info.getAssgrpId().longValue() : this.getYearAssitGrpIdNew(balanceDTO.getGrpId());
        long measureUnitKey = this.info.isContainPLUnit(balanceDTO.getMeasureunitId().longValue()) ? balanceDTO.getMeasureunitId() : 0L;
        String key = BalanceService.appendSumKey(balanceDTO, grpIdKey, measureUnitKey);
        BalanceService.updatePlSumMap(key, plSumMap, balanceDTO.getSumMap());
    }

    private long getYearAssitGrpIdNew(long grpId) {
        Long newAssgrpId = this.assistValueMap.get(grpId);
        if (null == newAssgrpId) {
            if (DebugTrace.enable()) {
                logger.info("assistValueMap: " + this.assistValueMap);
            }
            throw new RuntimeException("The assgrp id corresponding to this year's profit was not found in assistValueMap. ");
        }
        return this.assistValueMap.get(grpId);
    }

    private boolean isCreDC(String pltype) {
        return !"1".equals(pltype);
    }

    private void setVoucherEntryInfoByAcctdc(VoucherInfo vch, BalanceDTO balanceDTO) {
        if (balanceDTO.needGenVchEntry()) {
            vch = this.appendEntrySave(vch);
            VoucherEntryInfo preEntry = vch.createNewEntry();
            preEntry.setOrg(vch.getOrg());
            preEntry.setPeriod(vch.getPeriod());
            balanceDTO.fillVchEntry(this.info, preEntry);
        }
    }
}

