/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.operateservice;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.exception.KDBizException;
import kd.fi.gl.common.VoucherInfo;

public class VoucherInfoDTO {
    private VoucherInfo voucherInfoHeadTmp;
    private VoucherInfoAndPLSum plDebVoucherInfoAndPLSum;
    private VoucherInfoAndPLSum plCreVoucherInfoAndPLSum;
    private VoucherInfoAndPLSum plVoucherInfoAndPLSum;
    private Boolean isByPl;

    public void initVoucherInfoAndPLSums(boolean isByPl, VoucherInfo voucherInfo, boolean isMerge) {
        this.voucherInfoHeadTmp = voucherInfo;
        this.isByPl = isByPl;
        if (this.isByPl.booleanValue()) {
            this.plDebVoucherInfoAndPLSum = new VoucherInfoAndPLSum(voucherInfo.copy());
            this.plCreVoucherInfoAndPLSum = new VoucherInfoAndPLSum(voucherInfo.copy());
            if (isMerge) {
                this.plDebVoucherInfoAndPLSum.voucherInfo.setPK(voucherInfo.getPK());
                this.plCreVoucherInfoAndPLSum.voucherInfo.setPK(voucherInfo.getPK());
            }
        } else {
            this.plVoucherInfoAndPLSum = new VoucherInfoAndPLSum(voucherInfo.copy());
            if (isMerge) {
                this.plVoucherInfoAndPLSum.voucherInfo.setPK(voucherInfo.getPK());
            }
        }
    }

    public VoucherInfoAndPLSum getVoucherInfoAndPLSum(boolean isCreDC) {
        if (this.isByPl.booleanValue()) {
            if (isCreDC) {
                return this.plCreVoucherInfoAndPLSum;
            }
            return this.plDebVoucherInfoAndPLSum;
        }
        return this.plVoucherInfoAndPLSum;
    }

    public VoucherInfo resetVoucherInfo(VoucherInfo voucherInfo) {
        if (this.isByPl.booleanValue()) {
            if (voucherInfo == this.plDebVoucherInfoAndPLSum.voucherInfo) {
                this.plDebVoucherInfoAndPLSum.voucherInfo = this.voucherInfoHeadTmp.copy();
                this.plDebVoucherInfoAndPLSum.voucherInfo.setPK(voucherInfo.getPK());
                return this.plDebVoucherInfoAndPLSum.voucherInfo;
            }
            if (voucherInfo == this.plCreVoucherInfoAndPLSum.voucherInfo) {
                this.plCreVoucherInfoAndPLSum.voucherInfo = this.voucherInfoHeadTmp.copy();
                this.plCreVoucherInfoAndPLSum.voucherInfo.setPK(voucherInfo.getPK());
                return this.plCreVoucherInfoAndPLSum.voucherInfo;
            }
            throw new KDBizException(String.format("huge entries resetVoucherInfo error: pkValue[%s] not found VoucherInfo , isByPl: %s, plDebVoucherId: %s, plCreVoucherId: %s, plVoucherId: %s", voucherInfo.getPK(), this.isByPl, this.plDebVoucherInfoAndPLSum.voucherInfo.getPK(), this.plCreVoucherInfoAndPLSum.voucherInfo.getPK(), this.plVoucherInfoAndPLSum.voucherInfo.getPK()));
        }
        if (voucherInfo == this.plVoucherInfoAndPLSum.voucherInfo) {
            this.plVoucherInfoAndPLSum.voucherInfo = this.voucherInfoHeadTmp.copy();
            this.plVoucherInfoAndPLSum.voucherInfo.setPK(voucherInfo.getPK());
            return this.plVoucherInfoAndPLSum.voucherInfo;
        }
        throw new KDBizException(String.format("huge entries resetVoucherInfo error: pkValue[%s] not found VoucherInfo , isByPl: %s, plDebVoucherId: %s, plCreVoucherId: %s, plVoucherId: %s", voucherInfo.getPK(), this.isByPl, this.plDebVoucherInfoAndPLSum.voucherInfo.getPK(), this.plCreVoucherInfoAndPLSum.voucherInfo.getPK(), this.plVoucherInfoAndPLSum.voucherInfo.getPK()));
    }

    public List<VoucherInfoAndPLSum> getVoucherInfoAndPLSumList() {
        if (this.isByPl.booleanValue()) {
            return Arrays.asList(this.plDebVoucherInfoAndPLSum, this.plCreVoucherInfoAndPLSum);
        }
        return Collections.singletonList(this.plVoucherInfoAndPLSum);
    }

    public int getPLSumSize() {
        int totalPLSumSize = 0;
        List<VoucherInfoAndPLSum> voucherInfoAndPLSumList = this.getVoucherInfoAndPLSumList();
        for (VoucherInfoAndPLSum voucherInfoAndPLSum : voucherInfoAndPLSumList) {
            totalPLSumSize += voucherInfoAndPLSum.plSumMap.size();
        }
        return totalPLSumSize;
    }

    public static class VoucherInfoAndPLSum {
        VoucherInfo voucherInfo;
        HashMap<String, HashMap<String, BigDecimal>> plSumMap = new HashMap();

        public VoucherInfoAndPLSum(VoucherInfo voucherInfo) {
            this.voucherInfo = voucherInfo;
        }

        public static class PLSumValue {
            BigDecimal locSum;
            BigDecimal orgSum;
            BigDecimal qtySum;

            public PLSumValue(BigDecimal loc, BigDecimal org, BigDecimal qty) {
                this.locSum = loc;
                this.orgSum = org;
                this.qtySum = qty;
            }

            public void sum(BigDecimal loc, BigDecimal org, BigDecimal qty) {
                this.locSum = this.locSum.add(loc);
                this.orgSum = this.orgSum.add(org);
                this.qtySum = this.qtySum.add(qty);
            }
        }

        public static class PLSumKey {
            private long curId;
            private long grpId;
            private long measureunitId;

            public long getCurId() {
                return this.curId;
            }

            public void setCurId(long curId) {
                this.curId = curId;
            }

            public long getGrpId() {
                return this.grpId;
            }

            public void setGrpId(long grpId) {
                this.grpId = grpId;
            }

            public long getMeasureunitId() {
                return this.measureunitId;
            }

            public void setMeasureunitId(long measureunitId) {
                this.measureunitId = measureunitId;
            }

            public PLSumKey(long curId, long grpId, long measureunitId) {
                this.curId = curId;
                this.grpId = grpId;
                this.measureunitId = measureunitId;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PLSumKey plSumKey = (PLSumKey)o;
                return this.curId == plSumKey.curId && this.grpId == plSumKey.grpId && this.measureunitId == plSumKey.measureunitId;
            }

            public int hashCode() {
                return Objects.hash(this.curId, this.grpId, this.measureunitId);
            }
        }
    }
}

