/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.parser.autotrans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.autotrans.FinalProcessAssgrp;
import kd.fi.gl.finalprocessing.info.AutoTransGenVchInfo;
import kd.fi.gl.finalprocessing.parser.autotrans.AbstractAutoTransExpParser;
import kd.fi.gl.util.FinalProcessUtil;

public class AutoTransAssgrpExpParser
extends AbstractAutoTransExpParser<Map<String, FinalProcessAssgrp>> {
    private static final String Key_Entry = "entryentity";
    private static final String Key_AssgrpType = "assisttranstype";
    private static final String Key_AssgrpRowId = "assgrprow";
    private static final String Entity_Assgrp = "gl_finalprocess_assgrp";

    public AutoTransAssgrpExpParser(AutoTransGenVchInfo schemeInfo) {
        super(schemeInfo);
    }

    @Override
    public Map<String, FinalProcessAssgrp> parse() {
        HashMap<String, FinalProcessAssgrp> result = new HashMap<String, FinalProcessAssgrp>(this.entries.size());
        ArrayList<String> rowIds = new ArrayList<String>(this.entries.size());
        HashMap<String, DynamicObject> transInRowIds = new HashMap<String, DynamicObject>(this.entries.size());
        for (DynamicObject row : this.entries) {
            String rowId = row.getString("autorowid");
            rowIds.add(rowId);
            String dataType = row.getString("datasourcetype");
            if ("4".equals(dataType) || "3".equals(dataType) || "2".equals(dataType) || !"2".equals(row.getString(Key_AssgrpType))) continue;
            transInRowIds.put(rowId, row);
        }
        QFilter filter = new QFilter(Key_AssgrpRowId, "in", rowIds);
        Long orgId = this.scheme.getLong("org_id");
        filter = filter.and(new QFilter("org", "=", (Object)orgId));
        Map allAssgrpExps = BusinessDataServiceHelper.loadFromCache((String)Entity_Assgrp, (QFilter[])filter.toArray());
        for (DynamicObject assgrpExp : allAssgrpExps.values()) {
            String key = assgrpExp.getString(Key_AssgrpRowId);
            FinalProcessAssgrp value = FinalProcessAssgrp.create((DynamicObjectCollection)assgrpExp.getDynamicObjectCollection(Key_Entry));
            if (transInRowIds.containsKey(key)) {
                if (FinalProcessUtil.canGetHgIds(value.getFlex2values().values())) {
                    value.getHgIds();
                } else {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u4fe1\u606f\u4e2d\u81ea\u5b9a\u4e49\u6838\u7b97\u7ef4\u5ea6\u7ec4\u5408\u8fc7\u591a\uff0c\u8bf7\u51cf\u5c11\u7ef4\u5ea6\u503c\u914d\u7f6e\u3002", (String)"AutoTransGenVchOperateService_8", (String)"fi-gl-opplugin", (Object[])new Object[0]), ((DynamicObject)transInRowIds.get(key)).getString("seq")));
                }
            }
            result.put(key, value);
        }
        return result;
    }
}

