/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.parser.autotrans;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.enums.AutoTransQtyTypeEnum;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.finalprocess.constant.AutoTransConstant;
import kd.fi.gl.finalprocess.info.scheme.inittask.tasklibrary.autotrans.QtyInitTask;
import kd.fi.gl.finalprocessing.info.AutoTransGenVchInfo;
import kd.fi.gl.finalprocessing.parser.IParser;

public class AutoTransBcmFormulaParser
implements IParser<Map<String, BigDecimal>> {
    private static final Log logger = LogFactory.getLog(AutoTransBcmFormulaParser.class);
    private Map<String, BigDecimal> calculateInfoMap;
    private final AutoTransGenVchInfo schemeInfo;
    private final DynamicObject schemeDyo;
    private final HashMap<String, String> errorInfoMap;
    private final HashMap<String, String> seq2RowIDMap;
    private static final String Key_DataType = "datasourcetype";
    private static final String KEY_SEQ = "seq";
    private static final String Key_BCM_FORMULA = "bcmformulajson";
    private static final String KEY_Entry = "autotransentry";

    public AutoTransBcmFormulaParser(AutoTransGenVchInfo schemeInfo) {
        this.schemeInfo = schemeInfo;
        this.schemeDyo = schemeInfo.getDataEntity();
        this.errorInfoMap = new HashMap(4);
        this.seq2RowIDMap = new HashMap(4);
        this.calculateInfoMap = this.doParse();
    }

    @Override
    public Map<String, BigDecimal> parse() {
        if (!this.errorInfoMap.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            this.errorInfoMap.forEach((key, value) -> stringBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u516c\u5f0f\u8ba1\u7b97\u5931\u8d25\uff1a%2$s\u3002 ", (String)"AutoTransBcmFormulaParser_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), key, value)));
            throw new GLException(new ErrorCode("AutoTrans-bcm-formula-calculate-error", stringBuilder.toString()), new Object[0]);
        }
        return this.calculateInfoMap;
    }

    private Map<String, BigDecimal> doParse() {
        HashMap<String, String> bcmFormulaCalculateInfo = new HashMap<String, String>(12);
        Map<String, String> bcmCommonCalculateInfo = this.getCommonCalculateInfo();
        this.schemeDyo.getDynamicObjectCollection(KEY_Entry).stream().filter(entryRow -> "13".equals(entryRow.getString(Key_DataType)) || "12".equals(entryRow.getString(Key_DataType))).filter(entryRow -> !StringUtils.isEmpty((CharSequence)entryRow.getString(Key_BCM_FORMULA))).forEach(entryRow -> {
            String amountUUID = QtyInitTask.getUUID((DynamicObject)entryRow, (boolean)true);
            bcmFormulaCalculateInfo.put(amountUUID, entryRow.getString(Key_BCM_FORMULA));
            this.seq2RowIDMap.put(amountUUID, entryRow.getString(KEY_SEQ));
        });
        this.schemeDyo.getDynamicObjectCollection(KEY_Entry).stream().filter(entryRow -> AutoTransQtyTypeEnum.formula.valueEquals(AutoTransQtyTypeEnum.valueOfHash((String)entryRow.getString(AutoTransConstant.Entry_QTY_FROM.toString())))).filter(entryRow -> !StringUtils.isEmpty((CharSequence)entryRow.getString(AutoTransConstant.Entry_QTY_FORMULA.toString()))).forEach(entryRow -> {
            String amountUUID = QtyInitTask.getUUID((DynamicObject)entryRow, (boolean)false);
            bcmFormulaCalculateInfo.put(amountUUID, entryRow.getString(AutoTransConstant.Entry_QTY_FORMULA.toString()));
            this.seq2RowIDMap.put(amountUUID, entryRow.getString(KEY_SEQ));
        });
        Map<String, BigDecimal> calculateInfoMap = this.parse2BcmCalculateInfo(bcmFormulaCalculateInfo, bcmCommonCalculateInfo);
        this.calculateInfoMap = calculateInfoMap;
        return this.calculateInfoMap;
    }

    private Map<String, String> getCommonCalculateInfo() {
        HashMap<String, String> res = new HashMap<String, String>(12);
        res.put("fy", "FY" + this.schemeInfo.getPeriodDyn().getString("periodyear"));
        res.put("period", "M_M" + this.schemeInfo.getPeriodDyn().getString("periodnumber"));
        res.put("org", this.schemeDyo.getDynamicObject("org").getString("number"));
        return res;
    }

    private Map<String, BigDecimal> parse2BcmCalculateInfo(Map<String, String> bcmFormulaCalculateInfo, Map<String, String> bcmCommonCalculateInfo) {
        if (bcmFormulaCalculateInfo.isEmpty()) {
            return Collections.emptyMap();
        }
        String calculateResult = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cm", (String)"CalculateMsService", (String)"calculateFormulas", (Object[])new Object[]{SerializationUtils.toJsonString(bcmFormulaCalculateInfo), SerializationUtils.toJsonString(bcmCommonCalculateInfo)});
        Map<String, BigDecimal> res = this.doBcmResParse(calculateResult);
        if (DebugTrace.enable()) {
            logger.info(String.format("formula calculate for input:\nwith formula : %s \n with common info : %s \n and the result is : %s", SerializationUtils.toJsonString(bcmFormulaCalculateInfo), SerializationUtils.toJsonString(bcmCommonCalculateInfo), SerializationUtils.toJsonString(res)));
        }
        return res;
    }

    private Map<String, BigDecimal> doBcmResParse(String calculateResult) {
        HashMap<String, BigDecimal> res = new HashMap<String, BigDecimal>(4);
        ((Map)SerializationUtils.fromJsonString((String)calculateResult, Map.class)).forEach((key, value) -> {
            if (Boolean.TRUE.equals(value.get("failed"))) {
                this.errorInfoMap.put(this.seq2RowIDMap.get(key), value.get("v").toString());
            } else {
                res.put((String)key, StringUtils.isEmpty((CharSequence)value.get("v").toString()) ? BigDecimal.ZERO : new BigDecimal(value.get("v").toString()));
            }
        });
        return res;
    }
}

