/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.parser.autotrans;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.finalprocessing.info.AutoTransGenVchInfo;
import kd.fi.gl.finalprocessing.parser.autotrans.AbstractAutoTransExpParser;
import kd.fi.gl.util.GLUtil;

public class AutoTransCurrencyParser
extends AbstractAutoTransExpParser<Map<String, BigDecimal>> {
    private static final String Key_CurrencyId = "currencyid_id";

    public AutoTransCurrencyParser(AutoTransGenVchInfo schemeInfo) {
        super(schemeInfo);
    }

    @Override
    public Map<String, BigDecimal> parse() {
        long curPeriodId = this.schemeInfo.getCurPeriodId();
        DynamicObject endDateDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)curPeriodId).toArray());
        Date endDate = endDateDyn == null ? null : endDateDyn.getDate("enddate");
        HashMap<String, BigDecimal> row2rate = new HashMap<String, BigDecimal>(this.entries.size());
        for (DynamicObject row : this.entries) {
            long targetCurrencyId = row.getLong(Key_CurrencyId);
            BigDecimal rate = GLUtil.getExchangeRate((Long)this.accountBookInfo.getExrateTableId(), (Long)targetCurrencyId, (Long)this.accountBookInfo.getBaseCurrencyId(), (Date)endDate);
            if (rate == null) {
                rate = BigDecimal.ONE;
            }
            row2rate.put(row.getString("autorowid"), rate);
        }
        return row2rate;
    }
}

